/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.plexus;

import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.sisu.inject.BeanLocator;
import org.eclipse.sisu.plexus.DefaultPlexusBeans;
import org.eclipse.sisu.plexus.HintedPlexusBeans;
import org.eclipse.sisu.plexus.PlexusBean;
import org.eclipse.sisu.plexus.PlexusBeanLocator;
import org.eclipse.sisu.plexus.RealmFilteredBeans;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public final class DefaultPlexusBeanLocator
implements PlexusBeanLocator {
    private final BeanLocator beanLocator;
    private final String visibility;

    @Inject
    public DefaultPlexusBeanLocator(BeanLocator beanLocator) {
        this(beanLocator, null);
    }

    public DefaultPlexusBeanLocator(BeanLocator beanLocator, String visibility) {
        this.beanLocator = beanLocator;
        this.visibility = visibility;
    }

    @Override
    public <T> Iterable<PlexusBean<T>> locate(TypeLiteral<T> role, String ... hints) {
        Key<T> key = hints.length == 1 ? Key.get(role, (Annotation)Names.named(hints[0])) : Key.get(role, Named.class);
        Iterable beans = this.beanLocator.locate(key);
        if ("realm".equalsIgnoreCase(this.visibility)) {
            beans = new RealmFilteredBeans(beans);
        }
        return hints.length <= 1 ? new DefaultPlexusBeans(beans) : new HintedPlexusBeans(beans, role, hints);
    }
}

