/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.client.impl;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jms.ConnectionFactory;
import javax.jms.Queue;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.client.CredentialsProvider;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.KieServicesException;
import org.kie.server.client.balancer.LoadBalancer;
import org.kie.server.client.credentials.EnteredCredentialsProvider;
import org.kie.server.client.jms.RequestReplyResponseHandler;
import org.kie.server.client.jms.ResponseHandler;

public final class KieServicesConfigurationImpl
implements KieServicesConfiguration {
    public static final String SSL_CONNECTION_FACTORY_NAME = "jms/SslRemoteConnectionFactory";
    public static final String CONNECTION_FACTORY_NAME = "jms/RemoteConnectionFactory";
    public static final String REQUEST_QUEUE_NAME = "jms/queue/KIE.SERVER.REQUEST";
    public static final String RESPONSE_QUEUE_NAME = "jms/queue/KIE.SERVER.RESPONSE";
    private long timeoutInMillisecs = 10000L;
    private final KieServicesConfiguration.Transport transport;
    private String userName;
    private String password;
    private String serverUrl;
    private List<String> capabilities;
    private boolean useSsl = false;
    private ConnectionFactory connectionFactory;
    private Queue requestQueue;
    private Queue responseQueue;
    private ResponseHandler responseHandler = new RequestReplyResponseHandler();
    private boolean jmsTransactional = false;
    private MarshallingFormat format = MarshallingFormat.JAXB;
    private Set<Class<?>> extraClasses = new HashSet();
    private CredentialsProvider credentialsProvider;
    private LoadBalancer loadBalancer;
    private Map<String, String> headers;

    public KieServicesConfigurationImpl(String url, String username, String password) {
        this(url, username, password, 5000L);
    }

    public KieServicesConfigurationImpl(String url, String username, String password, long timeout) {
        this.transport = KieServicesConfiguration.Transport.REST;
        this.serverUrl = url;
        this.userName = username;
        this.password = password;
        this.timeoutInMillisecs = timeout;
        this.credentialsProvider = new EnteredCredentialsProvider(username, password);
    }

    public KieServicesConfigurationImpl(String url, CredentialsProvider credentialsProvider) {
        this(url, credentialsProvider, 5000L);
    }

    public KieServicesConfigurationImpl(String url, CredentialsProvider credentialsProvider, long timeout) {
        this.transport = KieServicesConfiguration.Transport.REST;
        this.serverUrl = url;
        this.timeoutInMillisecs = timeout;
        this.credentialsProvider = credentialsProvider;
    }

    @Override
    public void dispose() {
        if (this.extraClasses != null) {
            this.extraClasses.clear();
            this.extraClasses = null;
        }
        if (this.connectionFactory != null) {
            this.connectionFactory = null;
        }
        if (this.requestQueue != null) {
            this.requestQueue = null;
        }
        if (this.responseQueue != null) {
            this.responseQueue = null;
        }
    }

    public KieServicesConfigurationImpl(ConnectionFactory connectionFactory, Queue requestQueue, Queue responseQueue) {
        this.transport = KieServicesConfiguration.Transport.JMS;
        this.connectionFactory = connectionFactory;
        this.requestQueue = requestQueue;
        this.responseQueue = responseQueue;
        this.credentialsProvider = null;
        KieServicesConfigurationImpl.checkValidValues(this.connectionFactory, this.requestQueue, this.responseQueue);
    }

    public KieServicesConfigurationImpl(ConnectionFactory connectionFactory, Queue requestQueue, Queue responseQueue, String username, String password) {
        this(connectionFactory, requestQueue, responseQueue);
        this.setAndCheckUserNameAndPassword(username, password);
    }

    public KieServicesConfigurationImpl(InitialContext context, String username, String password) {
        this.transport = KieServicesConfiguration.Transport.JMS;
        this.setAndCheckUserNameAndPassword(username, password);
        this.setRemoteInitialContext(context);
        this.credentialsProvider = new EnteredCredentialsProvider(username, password);
    }

    public void checkValidJmsValues() {
        KieServicesConfigurationImpl.checkValidValues(this.connectionFactory, this.requestQueue, this.responseQueue);
    }

    private static void checkValidValues(ConnectionFactory connectionFactory, Queue requestQueue, Queue responseQueue) throws IllegalStateException {
        if (connectionFactory == null) {
            throw new IllegalStateException("The connection factory argument may not be null.");
        }
        if (requestQueue == null) {
            throw new IllegalStateException("At least a ksession queue or task queue is required.");
        }
        if (responseQueue == null) {
            throw new IllegalStateException("The response queue argument may not be null.");
        }
    }

    @Override
    public KieServicesConfiguration setRemoteInitialContext(InitialContext context) {
        String prop = CONNECTION_FACTORY_NAME;
        try {
            if (this.connectionFactory == null) {
                this.connectionFactory = (ConnectionFactory)context.lookup(prop);
            }
            prop = REQUEST_QUEUE_NAME;
            this.requestQueue = (Queue)context.lookup(prop);
            prop = RESPONSE_QUEUE_NAME;
            this.responseQueue = (Queue)context.lookup(prop);
        }
        catch (NamingException ne) {
            throw new KieServicesException("Unable to retrieve object for " + prop, ne);
        }
        KieServicesConfigurationImpl.checkValidValues(this.connectionFactory, this.requestQueue, this.responseQueue);
        return this;
    }

    private KieServicesConfiguration setAndCheckUserNameAndPassword(String username, String password) {
        if (username == null || username.trim().isEmpty()) {
            throw new IllegalArgumentException("The user name may not be empty or null.");
        }
        this.userName = username;
        if (password == null) {
            throw new IllegalArgumentException("The password may not be null.");
        }
        this.password = password;
        return this;
    }

    @Override
    public MarshallingFormat getMarshallingFormat() {
        return this.format;
    }

    @Override
    public KieServicesConfiguration setMarshallingFormat(MarshallingFormat format) {
        this.format = format;
        return this;
    }

    @Override
    public boolean isJms() {
        return this.transport == KieServicesConfiguration.Transport.JMS;
    }

    @Override
    public boolean isRest() {
        return this.transport == KieServicesConfiguration.Transport.REST;
    }

    @Override
    public String getServerUrl() {
        return this.serverUrl;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    @Override
    public Queue getRequestQueue() {
        return this.requestQueue;
    }

    @Override
    public Queue getResponseQueue() {
        return this.responseQueue;
    }

    @Override
    public boolean addExtraClasses(Set<Class<?>> extraClassList) {
        return this.extraClasses.addAll(extraClassList);
    }

    @Override
    public KieServicesConfiguration clearExtraClasses() {
        this.extraClasses.clear();
        return this;
    }

    @Override
    public Set<Class<?>> getExtraClasses() {
        return this.extraClasses;
    }

    @Override
    public KieServicesConfiguration.Transport getTransport() {
        return this.transport;
    }

    @Override
    public long getTimeout() {
        return this.timeoutInMillisecs;
    }

    @Override
    public boolean getUseUssl() {
        return this.useSsl;
    }

    @Override
    public KieServicesConfiguration setTimeout(long timeout) {
        this.timeoutInMillisecs = timeout;
        return this;
    }

    @Override
    public KieServicesConfiguration setServerUrl(String url) {
        this.serverUrl = url;
        return this;
    }

    @Override
    public KieServicesConfiguration setUserName(String userName) {
        this.userName = userName;
        if (this.credentialsProvider instanceof EnteredCredentialsProvider) {
            ((EnteredCredentialsProvider)this.credentialsProvider).setUsername(userName);
        }
        return this;
    }

    @Override
    public KieServicesConfiguration setPassword(String password) {
        this.password = password;
        if (this.credentialsProvider instanceof EnteredCredentialsProvider) {
            ((EnteredCredentialsProvider)this.credentialsProvider).setPassword(password);
        }
        return this;
    }

    @Override
    public KieServicesConfiguration setExtraClasses(Set<Class<?>> extraJaxbClasses) {
        this.extraClasses.clear();
        if (extraJaxbClasses != null) {
            this.extraClasses.addAll(extraJaxbClasses);
        }
        return this;
    }

    @Override
    public KieServicesConfiguration setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
        return this;
    }

    @Override
    public KieServicesConfiguration setRequestQueue(Queue requestQueue) {
        this.requestQueue = requestQueue;
        return this;
    }

    @Override
    public KieServicesConfiguration setResponseQueue(Queue responseQueue) {
        this.responseQueue = responseQueue;
        return this;
    }

    @Override
    public KieServicesConfiguration setUseSsl(boolean useSsl) {
        this.useSsl = useSsl;
        return this;
    }

    @Override
    public void setCapabilities(List<String> capabilities) {
        this.capabilities = capabilities;
    }

    @Override
    public List<String> getCapabilities() {
        return this.capabilities;
    }

    @Override
    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    @Override
    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    @Override
    public void setLoadBalancer(LoadBalancer loadBalancer) {
        this.loadBalancer = loadBalancer;
    }

    @Override
    public LoadBalancer getLoadBalancer() {
        return this.loadBalancer;
    }

    @Override
    public void setResponseHandler(ResponseHandler responseHandler) {
        this.responseHandler = responseHandler;
    }

    @Override
    public ResponseHandler getResponseHandler() {
        return this.responseHandler;
    }

    @Override
    public boolean isJmsTransactional() {
        return this.jmsTransactional;
    }

    @Override
    public void setJmsTransactional(boolean jmsTransactional) {
        this.jmsTransactional = jmsTransactional;
    }

    @Override
    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    private KieServicesConfigurationImpl(KieServicesConfigurationImpl config) {
        this.connectionFactory = config.connectionFactory;
        this.extraClasses = config.extraClasses;
        this.format = config.format;
        this.requestQueue = config.requestQueue;
        this.password = config.password;
        this.responseQueue = config.responseQueue;
        this.serverUrl = config.serverUrl;
        this.timeoutInMillisecs = config.timeoutInMillisecs;
        this.transport = config.transport;
        this.userName = config.userName;
        this.useSsl = config.useSsl;
        this.capabilities = config.capabilities;
        this.credentialsProvider = config.credentialsProvider;
        this.loadBalancer = config.loadBalancer;
        this.responseHandler = config.responseHandler;
        this.jmsTransactional = config.jmsTransactional;
        this.headers = config.headers;
    }

    @Override
    public KieServicesConfiguration clone() {
        return new KieServicesConfigurationImpl(this);
    }

    public String toString() {
        return "KieServicesConfiguration{transport=" + (Object)((Object)this.transport) + ", serverUrl='" + this.serverUrl + '\'' + '}';
    }

    @Override
    @Deprecated
    public Set<Class<?>> getExtraJaxbClasses() {
        return this.getExtraClasses();
    }

    @Override
    @Deprecated
    public boolean addJaxbClasses(Set<Class<?>> extraJaxbClassList) {
        return this.addExtraClasses(extraJaxbClassList);
    }

    @Override
    @Deprecated
    public KieServicesConfiguration setExtraJaxbClasses(Set<Class<?>> extraJaxbClasses) {
        return this.setExtraClasses(extraJaxbClasses);
    }

    @Override
    @Deprecated
    public KieServicesConfiguration clearJaxbClasses() {
        return this.clearExtraClasses();
    }
}

