/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.client.jms;

import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.kie.server.api.marshalling.Marshaller;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.api.model.ServiceResponsesList;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.KieServicesException;
import org.kie.server.client.impl.KieServicesClientImpl;
import org.kie.server.client.jms.ResponseCallback;
import org.kie.server.client.jms.ResponseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncResponseHandler
implements ResponseHandler {
    private static final Logger logger = LoggerFactory.getLogger(AsyncResponseHandler.class);
    private ResponseCallback callback;
    private ExecutorService executorService = Executors.newSingleThreadExecutor();

    public AsyncResponseHandler(ResponseCallback callback) {
        this.callback = callback;
    }

    @Override
    public int getInteractionPattern() {
        return 2;
    }

    @Override
    public ServiceResponsesList handleResponse(String selector, Connection connection, Session session, Queue responseQueue, KieServicesConfiguration config, Marshaller marshaller, KieServicesClient owner) {
        if (this.callback == null) {
            throw new IllegalStateException("There is no callback defined, can't continue...");
        }
        MessageConsumer consumer = null;
        try {
            consumer = session.createConsumer((Destination)responseQueue, selector);
            consumer.setMessageListener((MessageListener)new AsyncMessageListener(connection, session, selector, consumer, marshaller, owner));
            logger.debug("Message listener for async message retrieval successfully registered on consumer {}", (Object)consumer);
        }
        catch (JMSException jmse) {
            throw new KieServicesException("Unable to retrieve JMS response from queue " + responseQueue + " with selector " + selector, jmse);
        }
        ServiceResponse messageSentResponse = new ServiceResponse(ServiceResponse.ResponseType.NO_RESPONSE, "Message sent");
        return new ServiceResponsesList(Arrays.asList(messageSentResponse));
    }

    @Override
    public void dispose(Connection connection, Session session) {
    }

    private class AsyncMessageListener
    implements MessageListener {
        private String selector;
        private MessageConsumer consumer;
        private Marshaller marshaller;
        private KieServicesClient owner;
        private Connection connection;
        private Session session;

        public AsyncMessageListener(Connection connection, Session session, String selector, MessageConsumer consumer, Marshaller marshaller, KieServicesClient owner) {
            this.selector = selector;
            this.consumer = consumer;
            this.marshaller = marshaller;
            this.owner = owner;
            this.connection = connection;
            this.session = session;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void onMessage(Message message) {
            block13: {
                block11: {
                    ((KieServicesClientImpl)this.owner).setConversationId(message.getStringProperty("kie_conversation_id"));
                    String responseStr = ((TextMessage)message).getText();
                    logger.debug("Received response from server '{}'", (Object)responseStr);
                    ServiceResponsesList cmdResponse = (ServiceResponsesList)this.marshaller.unmarshall(responseStr, ServiceResponsesList.class);
                    logger.debug("Unmarshalled response from async delivery {} calling callback {}", (Object)cmdResponse, (Object)AsyncResponseHandler.this.callback);
                    AsyncResponseHandler.this.callback.onResponse(this.selector, cmdResponse);
                    logger.debug("Callback {} successfully invoked with response {}", (Object)AsyncResponseHandler.this.callback, (Object)cmdResponse);
                    if (this.consumer == null) break block11;
                    try {
                        this.consumer.close();
                    }
                    catch (JMSException e) {
                        logger.warn("Error when closing JMS consumer due to {}", (Object)e.getMessage());
                    }
                }
                AsyncResponseHandler.this.executorService.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (AsyncMessageListener.this.session != null) {
                                AsyncMessageListener.this.session.close();
                                logger.debug("Session closed via separate thread.");
                            }
                            if (AsyncMessageListener.this.connection != null) {
                                AsyncMessageListener.this.connection.close();
                                logger.debug("Connection closed via separate thread.");
                            }
                        }
                        catch (JMSException jmse) {
                            logger.warn("Unable to close connection or session!", (Throwable)jmse);
                        }
                    }
                });
                logger.debug("Cleanup of JMS resources requested via separate thread.");
                break block13;
                catch (Exception e) {
                    block12: {
                        try {
                            logger.error("Error while receiving message due to {}, this means response from the server won't be delivered to client", (Object)e.getMessage(), (Object)e);
                            if (this.consumer == null) break block12;
                        }
                        catch (Throwable throwable) {
                            if (this.consumer != null) {
                                try {
                                    this.consumer.close();
                                }
                                catch (JMSException e2) {
                                    logger.warn("Error when closing JMS consumer due to {}", (Object)e2.getMessage());
                                }
                            }
                            AsyncResponseHandler.this.executorService.submit(new /* invalid duplicate definition of identical inner class */);
                            logger.debug("Cleanup of JMS resources requested via separate thread.");
                            throw throwable;
                        }
                        try {
                            this.consumer.close();
                        }
                        catch (JMSException e3) {
                            logger.warn("Error when closing JMS consumer due to {}", (Object)e3.getMessage());
                        }
                    }
                    AsyncResponseHandler.this.executorService.submit(new /* invalid duplicate definition of identical inner class */);
                    logger.debug("Cleanup of JMS resources requested via separate thread.");
                }
            }
        }
    }
}

