/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.fluent.impl;

import org.drools.core.command.RequestContextImpl;
import org.drools.core.command.impl.ExecutableCommand;
import org.kie.internal.command.Context;
import org.kie.internal.fluent.Scope;

public class SetCommand<T>
implements ExecutableCommand<T> {
    private String name;
    private Scope scope = Scope.REQUEST;

    public SetCommand(String name) {
        this.name = name;
    }

    public SetCommand(String name, Scope scope) {
        this.name = name;
        this.scope = scope;
    }

    @Override
    public T execute(Context context) {
        RequestContextImpl reqContext = (RequestContextImpl)context;
        Object returned = reqContext.getLastReturned();
        if (this.scope == Scope.REQUEST) {
            reqContext.set(this.name, returned);
        } else if (this.scope == Scope.CONVERSATION) {
            if (reqContext.getConversationContext() == null) {
                throw new IllegalStateException("No Conversation Context Exists");
            }
            reqContext.getConversationContext().set(this.name, returned);
        } else if (this.scope == Scope.APPLICATION) {
            if (reqContext.getApplicationContext() == null) {
                throw new IllegalStateException("No Application Context Exists");
            }
            reqContext.getApplicationContext().set(this.name, returned);
        }
        ((RequestContextImpl)context).setLastSetOrGet(this.name);
        return (T)returned;
    }

    public String toString() {
        return "SetCommand{name='" + this.name + '\'' + ", scope=" + this.scope + '}';
    }
}

