/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.util.Arrays;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.phreak.ReactiveObjectUtil;
import org.drools.core.reteoo.FromNodeLeftTuple;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.Sink;

public class ReactiveFromNodeLeftTuple
extends FromNodeLeftTuple {
    private ReactiveObjectUtil.ModificationType modificationType = ReactiveObjectUtil.ModificationType.NONE;
    private final Object[] objects;
    private final int hash;

    public ReactiveFromNodeLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTuple currentLeftChild, LeftTuple currentRightChild, Sink sink, boolean leftTupleMemoryEnabled) {
        super(leftTuple, rightTuple, currentLeftChild, currentRightChild, sink, leftTupleMemoryEnabled);
        this.objects = new Object[leftTuple.getIndex() + 2];
        System.arraycopy(leftTuple.toObjects(), 0, this.objects, 0, leftTuple.getIndex());
        this.objects[leftTuple.getIndex() + 1] = rightTuple.getFactHandle().getObject();
        this.hash = Arrays.hashCode(this.objects);
    }

    public ReactiveFromNodeLeftTuple(InternalFactHandle factHandle, LeftTuple leftTuple, Sink sink) {
        super(factHandle, leftTuple, sink);
        this.objects = new Object[leftTuple.getIndex() + 2];
        System.arraycopy(leftTuple.toObjects(), 0, this.objects, 0, leftTuple.getIndex());
        this.objects[leftTuple.getIndex() + 1] = factHandle.getObject();
        this.hash = Arrays.hashCode(this.objects);
    }

    public ReactiveFromNodeLeftTuple(InternalFactHandle factHandle, Sink sink, boolean leftTupleMemoryEnabled) {
        super(factHandle, sink, leftTupleMemoryEnabled);
        this.objects = new Object[]{factHandle.getObject()};
        this.hash = Arrays.hashCode(this.objects);
    }

    @Override
    public int hashCode() {
        return this.hash;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof ReactiveFromNodeLeftTuple && Arrays.equals(this.objects, ((ReactiveFromNodeLeftTuple)other).objects);
    }

    public boolean updateModificationState(ReactiveObjectUtil.ModificationType newState) {
        switch (this.modificationType) {
            case NONE: {
                this.modificationType = newState;
                return true;
            }
            case ADD: {
                if (newState != ReactiveObjectUtil.ModificationType.REMOVE) break;
                this.modificationType = ReactiveObjectUtil.ModificationType.NONE;
                break;
            }
            case MODIFY: {
                if (newState != ReactiveObjectUtil.ModificationType.REMOVE) break;
                this.modificationType = ReactiveObjectUtil.ModificationType.REMOVE;
            }
        }
        return false;
    }

    public void resetModificationState() {
        this.modificationType = ReactiveObjectUtil.ModificationType.NONE;
    }

    public ReactiveObjectUtil.ModificationType getModificationType() {
        return this.modificationType;
    }
}

