/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.config.partitionedsearch;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.optaplanner.core.config.constructionheuristic.ConstructionHeuristicPhaseConfig;
import org.optaplanner.core.config.heuristic.policy.HeuristicConfigPolicy;
import org.optaplanner.core.config.localsearch.LocalSearchPhaseConfig;
import org.optaplanner.core.config.phase.PhaseConfig;
import org.optaplanner.core.config.solver.EnvironmentMode;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.partitionedsearch.DefaultPartitionedSearchPhase;
import org.optaplanner.core.impl.partitionedsearch.PartitionedSearchPhase;
import org.optaplanner.core.impl.partitionedsearch.partitioner.SolutionPartitioner;
import org.optaplanner.core.impl.solver.ChildThreadType;
import org.optaplanner.core.impl.solver.recaller.BestSolutionRecaller;
import org.optaplanner.core.impl.solver.termination.Termination;
import org.optaplanner.core.impl.solver.thread.DefaultSolverThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XStreamAlias(value="partitionedSearch")
public class PartitionedSearchPhaseConfig
extends PhaseConfig<PartitionedSearchPhaseConfig> {
    public static final String ACTIVE_THREAD_COUNT_AUTO = "AUTO";
    public static final String ACTIVE_THREAD_COUNT_UNLIMITED = "UNLIMITED";
    private static final Logger logger = LoggerFactory.getLogger(PartitionedSearchPhaseConfig.class);
    protected Class<? extends ThreadFactory> threadFactoryClass = null;
    protected String runnablePartThreadLimit = null;
    private Class<SolutionPartitioner> solutionPartitionerClass = null;
    @XStreamImplicit
    protected List<PhaseConfig> phaseConfigList = null;

    public Class<? extends ThreadFactory> getThreadFactoryClass() {
        return this.threadFactoryClass;
    }

    public void setThreadFactoryClass(Class<? extends ThreadFactory> threadFactoryClass) {
        this.threadFactoryClass = threadFactoryClass;
    }

    public String getRunnablePartThreadLimit() {
        return this.runnablePartThreadLimit;
    }

    public void setRunnablePartThreadLimit(String runnablePartThreadLimit) {
        this.runnablePartThreadLimit = runnablePartThreadLimit;
    }

    public Class<SolutionPartitioner> getSolutionPartitionerClass() {
        return this.solutionPartitionerClass;
    }

    public void setSolutionPartitionerClass(Class<SolutionPartitioner> solutionPartitionerClass) {
        this.solutionPartitionerClass = solutionPartitionerClass;
    }

    public List<PhaseConfig> getPhaseConfigList() {
        return this.phaseConfigList;
    }

    public void setPhaseConfigList(List<PhaseConfig> phaseConfigList) {
        this.phaseConfigList = phaseConfigList;
    }

    @Override
    public PartitionedSearchPhase buildPhase(int phaseIndex, HeuristicConfigPolicy solverConfigPolicy, BestSolutionRecaller bestSolutionRecaller, Termination solverTermination) {
        HeuristicConfigPolicy phaseConfigPolicy = solverConfigPolicy.createPhaseConfigPolicy();
        DefaultPartitionedSearchPhase phase = new DefaultPartitionedSearchPhase(phaseIndex, solverConfigPolicy.getLogIndentation(), bestSolutionRecaller, this.buildPhaseTermination(phaseConfigPolicy, solverTermination));
        phase.setThreadPoolExecutor(this.buildThreadPoolExecutor());
        phase.setRunnablePartThreadLimit(this.resolvedActiveThreadCount());
        phase.setSolutionPartitioner(this.buildSolutionPartitioner());
        List<PhaseConfig> phaseConfigList_ = this.phaseConfigList;
        if (ConfigUtils.isEmptyCollection(phaseConfigList_)) {
            phaseConfigList_ = Arrays.asList(new ConstructionHeuristicPhaseConfig(), new LocalSearchPhaseConfig());
        }
        phase.setPhaseConfigList(phaseConfigList_);
        phase.setConfigPolicy(phaseConfigPolicy.createChildThreadConfigPolicy(ChildThreadType.PART_THREAD));
        EnvironmentMode environmentMode = phaseConfigPolicy.getEnvironmentMode();
        if (environmentMode.isNonIntrusiveFullAsserted()) {
            phase.setAssertStepScoreFromScratch(true);
        }
        if (environmentMode.isIntrusiveFastAsserted()) {
            phase.setAssertExpectedStepScore(true);
            phase.setAssertShadowVariablesAreNotStaleAfterStep(true);
        }
        return phase;
    }

    private ThreadPoolExecutor buildThreadPoolExecutor() {
        ThreadFactory threadFactory = this.threadFactoryClass != null ? ConfigUtils.newInstance(this, "threadFactoryClass", this.threadFactoryClass) : new DefaultSolverThreadFactory("PartThread");
        return new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory);
    }

    private Integer resolvedActiveThreadCount() {
        Integer resolvedActiveThreadCount;
        int availableProcessorCount = Runtime.getRuntime().availableProcessors();
        if (this.runnablePartThreadLimit == null || this.runnablePartThreadLimit.equals(ACTIVE_THREAD_COUNT_AUTO)) {
            resolvedActiveThreadCount = availableProcessorCount <= 2 ? 1 : availableProcessorCount - 2;
        } else if (this.runnablePartThreadLimit.equals(ACTIVE_THREAD_COUNT_UNLIMITED)) {
            resolvedActiveThreadCount = null;
        } else {
            resolvedActiveThreadCount = ConfigUtils.resolveThreadPoolSizeScript("runnablePartThreadLimit", this.runnablePartThreadLimit, ACTIVE_THREAD_COUNT_AUTO, ACTIVE_THREAD_COUNT_UNLIMITED);
            if (resolvedActiveThreadCount < 1) {
                throw new IllegalArgumentException("The runnablePartThreadLimit (" + this.runnablePartThreadLimit + ") resulted in a resolvedActiveThreadCount (" + resolvedActiveThreadCount + ") that is lower than 1.");
            }
            if (resolvedActiveThreadCount > availableProcessorCount) {
                logger.debug("The resolvedActiveThreadCount (" + resolvedActiveThreadCount + ") is higher than the availableProcessorCount (" + availableProcessorCount + "), so the JVM will round-robin the CPU instead.");
            }
        }
        return resolvedActiveThreadCount;
    }

    private SolutionPartitioner buildSolutionPartitioner() {
        if (this.solutionPartitionerClass != null) {
            return ConfigUtils.newInstance(this, "solutionPartitionerClass", this.solutionPartitionerClass);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void inherit(PartitionedSearchPhaseConfig inheritedConfig) {
        super.inherit(inheritedConfig);
        this.threadFactoryClass = ConfigUtils.inheritOverwritableProperty(this.threadFactoryClass, inheritedConfig.getThreadFactoryClass());
        this.runnablePartThreadLimit = ConfigUtils.inheritOverwritableProperty(this.runnablePartThreadLimit, inheritedConfig.getRunnablePartThreadLimit());
        this.solutionPartitionerClass = ConfigUtils.inheritOverwritableProperty(this.solutionPartitionerClass, inheritedConfig.getSolutionPartitionerClass());
        this.phaseConfigList = ConfigUtils.inheritMergeableListConfig(this.phaseConfigList, inheritedConfig.getPhaseConfigList());
    }
}

