/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic.chained;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import org.optaplanner.core.impl.heuristic.move.AbstractMove;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.heuristic.selector.value.chained.SubChain;
import org.optaplanner.core.impl.score.director.ScoreDirector;

public class SubChainSwapMove
extends AbstractMove {
    protected final GenuineVariableDescriptor variableDescriptor;
    protected final SingletonInverseVariableSupply inverseVariableSupply;
    protected final SubChain leftSubChain;
    protected final SubChain rightSubChain;

    public SubChainSwapMove(GenuineVariableDescriptor variableDescriptor, SingletonInverseVariableSupply inverseVariableSupply, SubChain leftSubChain, SubChain rightSubChain) {
        this.variableDescriptor = variableDescriptor;
        this.inverseVariableSupply = inverseVariableSupply;
        this.leftSubChain = leftSubChain;
        this.rightSubChain = rightSubChain;
    }

    public String getVariableName() {
        return this.variableDescriptor.getVariableName();
    }

    public SubChain getLeftSubChain() {
        return this.leftSubChain;
    }

    public SubChain getRightSubChain() {
        return this.rightSubChain;
    }

    @Override
    public boolean isMoveDoable(ScoreDirector scoreDirector) {
        for (Object leftEntity : this.leftSubChain.getEntityList()) {
            if (!this.rightSubChain.getEntityList().contains(leftEntity)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Move createUndoMove(ScoreDirector scoreDirector) {
        return new SubChainSwapMove(this.variableDescriptor, this.inverseVariableSupply, this.rightSubChain, this.leftSubChain);
    }

    @Override
    protected void doMoveOnGenuineVariables(ScoreDirector scoreDirector) {
        Object leftFirstEntity = this.leftSubChain.getFirstEntity();
        Object leftFirstValue = this.variableDescriptor.getValue(leftFirstEntity);
        Object leftLastEntity = this.leftSubChain.getLastEntity();
        Object leftTrailingLastEntity = this.inverseVariableSupply.getInverseSingleton(leftLastEntity);
        Object rightFirstEntity = this.rightSubChain.getFirstEntity();
        Object rightFirstValue = this.variableDescriptor.getValue(rightFirstEntity);
        Object rightLastEntity = this.rightSubChain.getLastEntity();
        Object rightTrailingLastEntity = this.inverseVariableSupply.getInverseSingleton(rightLastEntity);
        if (leftLastEntity != rightFirstValue) {
            scoreDirector.changeVariableFacade(this.variableDescriptor, leftFirstEntity, rightFirstValue);
        }
        if (rightLastEntity != leftFirstValue) {
            scoreDirector.changeVariableFacade(this.variableDescriptor, rightFirstEntity, leftFirstValue);
        }
        if (leftTrailingLastEntity != null) {
            if (leftTrailingLastEntity != rightFirstEntity) {
                scoreDirector.changeVariableFacade(this.variableDescriptor, leftTrailingLastEntity, rightLastEntity);
            } else {
                scoreDirector.changeVariableFacade(this.variableDescriptor, leftFirstEntity, rightLastEntity);
            }
        }
        if (rightTrailingLastEntity != null) {
            if (rightTrailingLastEntity != leftFirstEntity) {
                scoreDirector.changeVariableFacade(this.variableDescriptor, rightTrailingLastEntity, leftLastEntity);
            } else {
                scoreDirector.changeVariableFacade(this.variableDescriptor, rightFirstEntity, leftLastEntity);
            }
        }
    }

    @Override
    public String getSimpleMoveTypeDescription() {
        return this.getClass().getSimpleName() + "(" + this.variableDescriptor.getSimpleEntityAndVariableName() + ")";
    }

    @Override
    public Collection<? extends Object> getPlanningEntities() {
        ArrayList<Object> entities = new ArrayList<Object>(this.leftSubChain.getSize() + this.rightSubChain.getSize());
        entities.addAll(this.leftSubChain.getEntityList());
        entities.addAll(this.rightSubChain.getEntityList());
        return entities;
    }

    @Override
    public Collection<? extends Object> getPlanningValues() {
        ArrayList<Object> values = new ArrayList<Object>(2);
        values.add(this.variableDescriptor.getValue(this.leftSubChain.getFirstEntity()));
        values.add(this.variableDescriptor.getValue(this.rightSubChain.getFirstEntity()));
        return values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SubChainSwapMove) {
            SubChainSwapMove other = (SubChainSwapMove)o;
            return new EqualsBuilder().append((Object)this.variableDescriptor, (Object)other.variableDescriptor).append((Object)this.leftSubChain, (Object)other.leftSubChain).append((Object)this.rightSubChain, (Object)other.rightSubChain).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.variableDescriptor).append((Object)this.leftSubChain).append((Object)this.rightSubChain).toHashCode();
    }

    public String toString() {
        Object oldLeftValue = this.variableDescriptor.getValue(this.leftSubChain.getFirstEntity());
        Object oldRightValue = this.variableDescriptor.getValue(this.rightSubChain.getFirstEntity());
        return this.leftSubChain.toDottedString() + " {" + oldLeftValue + "} <-> " + this.rightSubChain.toDottedString() + " {" + oldRightValue + "}";
    }
}

