/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.localsearch.decider;

import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.heuristic.selector.move.MoveSelector;
import org.optaplanner.core.impl.localsearch.decider.acceptor.Acceptor;
import org.optaplanner.core.impl.localsearch.decider.forager.Forager;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchMoveScope;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchPhaseScope;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchStepScope;
import org.optaplanner.core.impl.phase.scope.AbstractPhaseScope;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.solver.termination.Termination;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalSearchDecider<Solution_> {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final String logIndentation;
    protected final Termination termination;
    protected final MoveSelector moveSelector;
    protected final Acceptor acceptor;
    protected final Forager forager;
    protected boolean assertMoveScoreFromScratch = false;
    protected boolean assertExpectedUndoMoveScore = false;

    public LocalSearchDecider(String logIndentation, Termination termination, MoveSelector moveSelector, Acceptor acceptor, Forager forager) {
        this.logIndentation = logIndentation;
        this.termination = termination;
        this.moveSelector = moveSelector;
        this.acceptor = acceptor;
        this.forager = forager;
    }

    public Termination getTermination() {
        return this.termination;
    }

    public MoveSelector getMoveSelector() {
        return this.moveSelector;
    }

    public Acceptor getAcceptor() {
        return this.acceptor;
    }

    public Forager getForager() {
        return this.forager;
    }

    public void setAssertMoveScoreFromScratch(boolean assertMoveScoreFromScratch) {
        this.assertMoveScoreFromScratch = assertMoveScoreFromScratch;
    }

    public void setAssertExpectedUndoMoveScore(boolean assertExpectedUndoMoveScore) {
        this.assertExpectedUndoMoveScore = assertExpectedUndoMoveScore;
    }

    public void solvingStarted(DefaultSolverScope<Solution_> solverScope) {
        this.moveSelector.solvingStarted(solverScope);
        this.acceptor.solvingStarted(solverScope);
        this.forager.solvingStarted(solverScope);
    }

    public void phaseStarted(LocalSearchPhaseScope<Solution_> phaseScope) {
        this.moveSelector.phaseStarted(phaseScope);
        this.acceptor.phaseStarted(phaseScope);
        this.forager.phaseStarted(phaseScope);
    }

    public void stepStarted(LocalSearchStepScope<Solution_> stepScope) {
        this.moveSelector.stepStarted(stepScope);
        this.acceptor.stepStarted(stepScope);
        this.forager.stepStarted(stepScope);
    }

    public void decideNextStep(LocalSearchStepScope<Solution_> stepScope) {
        InnerScoreDirector scoreDirector = stepScope.getScoreDirector();
        scoreDirector.setAllChangesWillBeUndoneBeforeStepEnds(true);
        int moveIndex = 0;
        for (Move move : this.moveSelector) {
            LocalSearchMoveScope<Solution_> moveScope = new LocalSearchMoveScope<Solution_>(stepScope);
            moveScope.setMoveIndex(moveIndex);
            ++moveIndex;
            moveScope.setMove(move);
            if (!move.isMoveDoable(scoreDirector)) {
                this.logger.trace("{}        Move index ({}) not doable, ignoring move ({}).", new Object[]{this.logIndentation, moveScope.getMoveIndex(), move});
            } else {
                this.doMove(moveScope);
                if (this.forager.isQuitEarly()) break;
            }
            stepScope.getPhaseScope().getSolverScope().checkYielding();
            if (!this.termination.isPhaseTerminated(stepScope.getPhaseScope())) continue;
            break;
        }
        scoreDirector.setAllChangesWillBeUndoneBeforeStepEnds(false);
        LocalSearchMoveScope pickedMoveScope = this.forager.pickMove(stepScope);
        if (pickedMoveScope != null) {
            Move step = pickedMoveScope.getMove();
            stepScope.setStep(step);
            if (this.logger.isDebugEnabled()) {
                stepScope.setStepString(step.toString());
            }
            stepScope.setUndoStep(pickedMoveScope.getUndoMove());
            stepScope.setScore(pickedMoveScope.getScore());
        }
    }

    private void doMove(LocalSearchMoveScope<Solution_> moveScope) {
        ScoreDirector<Solution_> scoreDirector = moveScope.getScoreDirector();
        Move move = moveScope.getMove();
        Move undoMove = move.createUndoMove(scoreDirector);
        moveScope.setUndoMove(undoMove);
        move.doMove(scoreDirector);
        this.processMove(moveScope);
        undoMove.doMove(scoreDirector);
        if (this.assertExpectedUndoMoveScore) {
            AbstractPhaseScope phaseScope = moveScope.getStepScope().getPhaseScope();
            phaseScope.assertExpectedUndoMoveScore(move, undoMove, ((LocalSearchPhaseScope)phaseScope).getLastCompletedStepScope().getScore());
        }
        this.logger.trace("{}        Move index ({}), score ({}), accepted ({}), move ({}).", new Object[]{this.logIndentation, moveScope.getMoveIndex(), moveScope.getScore(), moveScope.getAccepted(), moveScope.getMove()});
    }

    private void processMove(LocalSearchMoveScope<Solution_> moveScope) {
        Score score = moveScope.getStepScope().getPhaseScope().calculateScore();
        if (this.assertMoveScoreFromScratch) {
            moveScope.getStepScope().getPhaseScope().assertWorkingScoreFromScratch(score, moveScope.getMove());
        }
        moveScope.setScore(score);
        boolean accepted = this.acceptor.isAccepted(moveScope);
        moveScope.setAccepted(accepted);
        this.forager.addMove(moveScope);
    }

    public void stepEnded(LocalSearchStepScope<Solution_> stepScope) {
        this.moveSelector.stepEnded(stepScope);
        this.acceptor.stepEnded(stepScope);
        this.forager.stepEnded(stepScope);
    }

    public void phaseEnded(LocalSearchPhaseScope<Solution_> phaseScope) {
        this.moveSelector.phaseEnded(phaseScope);
        this.acceptor.phaseEnded(phaseScope);
        this.forager.phaseEnded(phaseScope);
    }

    public void solvingEnded(DefaultSolverScope<Solution_> solverScope) {
        this.moveSelector.solvingEnded(solverScope);
        this.acceptor.solvingEnded(solverScope);
        this.forager.solvingEnded(solverScope);
    }
}

