/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.client.jms;

import java.util.Arrays;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.Session;
import org.kie.server.api.marshalling.Marshaller;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.api.model.ServiceResponsesList;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.jms.ResponseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FireAndForgetResponseHandler
implements ResponseHandler {
    private static final Logger logger = LoggerFactory.getLogger(FireAndForgetResponseHandler.class);

    @Override
    public int getInteractionPattern() {
        return 101;
    }

    @Override
    public ServiceResponsesList handleResponse(String selector, Connection connection, Session session, Queue responseQueue, KieServicesConfiguration config, Marshaller marshaller, KieServicesClient owner) {
        ServiceResponse messageSentResponse = new ServiceResponse(ServiceResponse.ResponseType.NO_RESPONSE, "Message sent");
        return new ServiceResponsesList(Arrays.asList(messageSentResponse));
    }

    @Override
    public void dispose(Connection connection, Session session) {
        try {
            if (session != null) {
                session.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
        catch (JMSException jmse) {
            logger.warn("Unable to close connection or session!", (Throwable)jmse);
        }
    }
}

