/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.factmodel.traits;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.drools.core.factmodel.traits.BitMaskKey;
import org.drools.core.factmodel.traits.LogicalTypeInconsistencyException;
import org.drools.core.factmodel.traits.NullTraitType;
import org.drools.core.factmodel.traits.Thing;
import org.drools.core.factmodel.traits.ThingProxyPlaceHolder;
import org.drools.core.factmodel.traits.TraitProxy;
import org.drools.core.factmodel.traits.TraitType;
import org.drools.core.factmodel.traits.TypeHierarchy;

public class TraitTypeMap<T extends String, K extends Thing<C>, C>
extends TypeHierarchy<K, BitMaskKey<K>>
implements Map<String, K>,
Externalizable {
    private Map<String, K> innerMap;
    private BitSet currentTypeCode = new BitSet();
    private transient Collection<K> mostSpecificTraits = new LinkedList<K>();
    private static final BitSet NO_STATIC = new BitSet();
    private BitSet staticTypeCode;
    private Map<String, BitSet> staticTypes;

    public TraitTypeMap() {
    }

    public TraitTypeMap(Map map) {
        this.innerMap = map;
        ThingProxyPlaceHolder thingPlaceHolder = ThingProxyPlaceHolder.getThingPlaceHolder();
        this.addMember(thingPlaceHolder, thingPlaceHolder._getTypeCode());
    }

    @Override
    public int size() {
        return this.innerMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.innerMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.innerMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.innerMap.containsValue(value);
    }

    @Override
    public K get(Object key) {
        return (K)((Thing)this.innerMap.get(key));
    }

    @Override
    public K put(String key, K value) {
        BitSet code = ((TraitType)value)._getTypeCode();
        this.addMember(value, code);
        this.innerMap.put(key, (String)value);
        this.currentTypeCode.or(code);
        this.mostSpecificTraits = null;
        return value;
    }

    @Override
    public void setBottomCode(BitSet code) {
        if (!this.hasKey(code)) {
            super.setBottomCode(code);
            this.addMember(new NullTraitType(code), code);
        }
    }

    @Override
    protected BitMaskKey<K> wrap(K value, BitSet key) {
        return new BitMaskKey<K>(System.identityHashCode(value), value);
    }

    public K putSafe(String key, K value) throws LogicalTypeInconsistencyException {
        BitSet code = ((TraitType)value)._getTypeCode();
        this.addMember(value, code);
        this.innerMap.put(key, (String)value);
        this.currentTypeCode.or(code);
        this.mostSpecificTraits = null;
        return value;
    }

    @Override
    public K remove(Object key) {
        Thing t = (Thing)this.innerMap.remove(key);
        if (t instanceof TraitProxy) {
            ((TraitProxy)((Object)t)).shed();
        }
        this.removeMember(((TraitProxy)((Object)t))._getTypeCode());
        this.mostSpecificTraits = null;
        this.resetCurrentCode();
        return (K)t;
    }

    public Collection<K> removeCascade(String traitName) {
        if (!this.innerMap.containsKey(traitName)) {
            BitSet staticCode;
            if (this.staticTypes != null && (staticCode = this.staticTypes.get(traitName)) != null) {
                return this.removeCascade(this.staticTypes.get(traitName));
            }
            return Collections.emptyList();
        }
        Thing thing = (Thing)this.innerMap.get(traitName);
        return this.removeCascade(((TraitType)((Object)thing))._getTypeCode());
    }

    public Collection<K> removeCascade(BitSet code) {
        Collection subs = this.lowerDescendants(code);
        ArrayList ret = new ArrayList(subs.size());
        for (Thing k : subs) {
            BitMaskKey<Thing> t = new BitMaskKey<Thing>(System.identityHashCode(k), k);
            TraitType tt = (TraitType)t.getValue();
            if (tt._isVirtual()) continue;
            ret.add(t.getValue());
            this.removeMember(tt._getTypeCode());
            Thing thing = (Thing)this.innerMap.remove(tt._getTraitName());
            if (!(thing instanceof TraitProxy)) continue;
            ((TraitProxy)((Object)thing)).shed();
        }
        this.mostSpecificTraits = null;
        this.resetCurrentCode();
        return ret;
    }

    private void resetCurrentCode() {
        this.currentTypeCode = new BitSet(this.currentTypeCode.length());
        if (this.staticTypeCode != null && this.staticTypeCode != NO_STATIC) {
            this.currentTypeCode.or(this.staticTypeCode);
        }
        if (!this.values().isEmpty()) {
            for (Thing x : this.values()) {
                this.currentTypeCode.or(((TraitType)((Object)x))._getTypeCode());
            }
        }
    }

    @Override
    public void putAll(Map<? extends String, ? extends K> m) {
        for (Thing proxy : m.values()) {
            this.addMember(proxy, ((TraitProxy)((Object)proxy))._getTypeCode());
        }
        this.resetCurrentCode();
        this.mostSpecificTraits = null;
        this.innerMap.putAll(m);
    }

    @Override
    public void clear() {
        this.innerMap.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.innerMap.keySet();
    }

    @Override
    public Collection<K> values() {
        return this.innerMap.values();
    }

    @Override
    public Set<Map.Entry<String, K>> entrySet() {
        return this.innerMap.entrySet();
    }

    @Override
    public String toString() {
        return "VetoableTypedMap{innerMap=" + this.innerMap + '}';
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeInt(this.innerMap.size());
        ArrayList<String> keys = new ArrayList<String>(this.innerMap.keySet());
        Collections.sort(keys);
        for (String k : keys) {
            objectOutput.writeObject(k);
            objectOutput.writeObject(this.innerMap.get(k));
        }
        objectOutput.writeObject(this.currentTypeCode);
        objectOutput.writeObject(this.staticTypeCode);
        objectOutput.writeObject(this.mostSpecificTraits);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.innerMap = new HashMap<String, K>();
        int n = objectInput.readInt();
        for (int j = 0; j < n; ++j) {
            String k = (String)objectInput.readObject();
            Thing tf = (Thing)objectInput.readObject();
            this.innerMap.put(k, (String)((Object)tf));
        }
        this.currentTypeCode = (BitSet)objectInput.readObject();
        this.staticTypeCode = (BitSet)objectInput.readObject();
        this.mostSpecificTraits = (Collection)objectInput.readObject();
    }

    public Collection<K> getMostSpecificTraits() {
        if (this.getBottomCode() == null) {
            return null;
        }
        if (this.mostSpecificTraits != null && !this.mostSpecificTraits.isEmpty()) {
            return this.mostSpecificTraits;
        }
        if (this.hasKey(this.getBottomCode())) {
            Thing b = (Thing)this.getMember(this.getBottomCode());
            if (((TraitType)((Object)b))._isVirtual()) {
                this.mostSpecificTraits = this.immediateParents(this.getBottomCode());
                return this.mostSpecificTraits;
            }
            this.mostSpecificTraits = Collections.singleton(b);
            return this.mostSpecificTraits;
        }
        this.mostSpecificTraits = this.immediateParents(this.getBottomCode());
        return this.mostSpecificTraits;
    }

    public BitSet getCurrentTypeCode() {
        return this.currentTypeCode;
    }

    public BitSet getStaticTypeCode() {
        return this.staticTypeCode;
    }

    public void setStaticTypeCode(BitSet staticTypeCode) {
        if (staticTypeCode != null) {
            this.staticTypeCode = staticTypeCode;
            this.currentTypeCode.or(staticTypeCode);
        } else {
            this.staticTypeCode = NO_STATIC;
        }
    }

    public void addStaticTrait(String name, BitSet code) {
        if (this.staticTypes == null) {
            this.staticTypes = new HashMap<String, BitSet>();
        }
        this.staticTypes.put(name, code);
    }
}

