/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.constraint;

import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.constraint.ConstraintMatch;

public class Indictment
implements Serializable,
Comparable<Indictment> {
    protected final Object justification;
    protected final Set<ConstraintMatch> constraintMatchSet;
    protected Score scoreTotal;

    public Indictment(Object justification, Score zeroScore) {
        this.justification = justification;
        this.constraintMatchSet = new LinkedHashSet<ConstraintMatch>();
        this.scoreTotal = zeroScore;
    }

    public Object getJustification() {
        return this.justification;
    }

    public Set<ConstraintMatch> getConstraintMatchSet() {
        return this.constraintMatchSet;
    }

    public int getConstraintMatchCount() {
        return this.getConstraintMatchSet().size();
    }

    public Score getScoreTotal() {
        return this.scoreTotal;
    }

    public boolean addConstraintMatch(ConstraintMatch constraintMatch) {
        boolean added = this.constraintMatchSet.add(constraintMatch);
        if (added) {
            this.scoreTotal = this.scoreTotal.add(constraintMatch.getScore());
        }
        return added;
    }

    public void removeConstraintMatch(ConstraintMatch constraintMatch) {
        boolean removed = this.constraintMatchSet.remove(constraintMatch);
        if (!removed) {
            throw new IllegalStateException("The indictment (" + this + ") could not remove constraintMatch (" + constraintMatch + ") from its constraintMatchSet (" + this.constraintMatchSet + ").");
        }
    }

    @Override
    public int compareTo(Indictment other) {
        return new CompareToBuilder().append((Object)this.getScoreTotal(), (Object)other.getScoreTotal()).toComparison();
    }

    public String toString() {
        return this.justification + "=" + this.getScoreTotal();
    }
}

