/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.client.jms;

import java.util.ArrayList;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.kie.server.api.exception.KieServicesException;
import org.kie.server.api.marshalling.Marshaller;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.api.model.ServiceResponsesList;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.impl.KieServicesClientImpl;
import org.kie.server.client.jms.ResponseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestReplyResponseHandler
implements ResponseHandler {
    private static final Logger logger = LoggerFactory.getLogger(RequestReplyResponseHandler.class);

    @Override
    public int getInteractionPattern() {
        return 1;
    }

    @Override
    public ServiceResponsesList handleResponse(String selector, Connection connection, Session session, Queue responseQueue, KieServicesConfiguration config, Marshaller marshaller, KieServicesClient owner) {
        MessageConsumer consumer = null;
        try {
            ServiceResponsesList cmdResponse;
            consumer = session.createConsumer((Destination)responseQueue, selector);
            Message response = consumer.receive(config.getTimeout());
            if (response == null) {
                logger.warn("Response is empty");
                ArrayList<ServiceResponse> responses = new ArrayList<ServiceResponse>();
                responses.add(new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Response is empty"));
                ServiceResponsesList serviceResponsesList = new ServiceResponsesList(responses);
                return serviceResponsesList;
            }
            ((KieServicesClientImpl)owner).setConversationId(response.getStringProperty("kie_conversation_id"));
            String responseStr = ((TextMessage)response).getText();
            logger.debug("Received response from server '{}'", (Object)responseStr);
            ServiceResponsesList serviceResponsesList = cmdResponse = (ServiceResponsesList)marshaller.unmarshall(responseStr, ServiceResponsesList.class);
            return serviceResponsesList;
        }
        catch (JMSException jmse) {
            throw new KieServicesException("Unable to retrieve JMS response from queue " + responseQueue + " with selector " + selector, (Throwable)jmse);
        }
        finally {
            if (consumer != null) {
                try {
                    consumer.close();
                }
                catch (JMSException e) {
                    logger.warn("Error when closing JMS consumer due to {}", (Object)e.getMessage());
                }
            }
        }
    }

    @Override
    public void dispose(Connection connection, Session session) {
        try {
            if (session != null) {
                session.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
        catch (JMSException jmse) {
            logger.warn("Unable to close connection or session!", (Throwable)jmse);
        }
    }
}

