/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.config.heuristic.selector.value;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.optaplanner.core.api.domain.valuerange.ValueRangeProvider;
import org.optaplanner.core.api.domain.variable.PlanningVariable;
import org.optaplanner.core.config.heuristic.policy.HeuristicConfigPolicy;
import org.optaplanner.core.config.heuristic.selector.SelectorConfig;
import org.optaplanner.core.config.heuristic.selector.common.SelectionCacheType;
import org.optaplanner.core.config.heuristic.selector.common.SelectionOrder;
import org.optaplanner.core.config.heuristic.selector.common.decorator.SelectionSorterOrder;
import org.optaplanner.core.config.heuristic.selector.common.nearby.NearbySelectionConfig;
import org.optaplanner.core.config.heuristic.selector.value.ValueSorterManner;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.domain.valuerange.descriptor.EntityIndependentValueRangeDescriptor;
import org.optaplanner.core.impl.domain.valuerange.descriptor.ValueRangeDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.ComparatorSelectionSorter;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionFilter;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionProbabilityWeightFactory;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorter;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorterWeightFactory;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.WeightFactorySelectionSorter;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.heuristic.selector.value.EntityIndependentValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.FromEntityPropertyValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.FromSolutionPropertyValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.ValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.decorator.CachingValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.decorator.DowncastingValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.decorator.EntityDependentSortingValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.decorator.FilteringValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.decorator.InitializedValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.decorator.ProbabilityValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.decorator.ReinitializeVariableValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.decorator.SelectedCountLimitValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.decorator.ShufflingValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.decorator.SortingValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.mimic.MimicRecordingValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.mimic.MimicReplayingValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.mimic.ValueMimicRecorder;

@XStreamAlias(value="valueSelector")
public class ValueSelectorConfig
extends SelectorConfig<ValueSelectorConfig> {
    @XStreamAsAttribute
    protected String id = null;
    @XStreamAsAttribute
    protected String mimicSelectorRef = null;
    protected Class<?> downcastEntityClass = null;
    protected String variableName = null;
    protected SelectionCacheType cacheType = null;
    protected SelectionOrder selectionOrder = null;
    @XStreamAlias(value="nearbySelection")
    protected NearbySelectionConfig nearbySelectionConfig = null;
    @XStreamImplicit(itemFieldName="filterClass")
    protected List<Class<? extends SelectionFilter>> filterClassList = null;
    protected ValueSorterManner sorterManner = null;
    protected Class<? extends Comparator> sorterComparatorClass = null;
    protected Class<? extends SelectionSorterWeightFactory> sorterWeightFactoryClass = null;
    protected SelectionSorterOrder sorterOrder = null;
    protected Class<? extends SelectionSorter> sorterClass = null;
    protected Class<? extends SelectionProbabilityWeightFactory> probabilityWeightFactoryClass = null;
    protected Long selectedCountLimit = null;

    public ValueSelectorConfig() {
    }

    public ValueSelectorConfig(String variableName) {
        this.variableName = variableName;
    }

    public ValueSelectorConfig(ValueSelectorConfig inheritedConfig) {
        if (inheritedConfig != null) {
            this.inherit(inheritedConfig);
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getMimicSelectorRef() {
        return this.mimicSelectorRef;
    }

    public void setMimicSelectorRef(String mimicSelectorRef) {
        this.mimicSelectorRef = mimicSelectorRef;
    }

    public Class<?> getDowncastEntityClass() {
        return this.downcastEntityClass;
    }

    public void setDowncastEntityClass(Class<?> downcastEntityClass) {
        this.downcastEntityClass = downcastEntityClass;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public SelectionCacheType getCacheType() {
        return this.cacheType;
    }

    public void setCacheType(SelectionCacheType cacheType) {
        this.cacheType = cacheType;
    }

    public SelectionOrder getSelectionOrder() {
        return this.selectionOrder;
    }

    public void setSelectionOrder(SelectionOrder selectionOrder) {
        this.selectionOrder = selectionOrder;
    }

    public NearbySelectionConfig getNearbySelectionConfig() {
        return this.nearbySelectionConfig;
    }

    public void setNearbySelectionConfig(NearbySelectionConfig nearbySelectionConfig) {
        this.nearbySelectionConfig = nearbySelectionConfig;
    }

    public List<Class<? extends SelectionFilter>> getFilterClassList() {
        return this.filterClassList;
    }

    public void setFilterClassList(List<Class<? extends SelectionFilter>> filterClassList) {
        this.filterClassList = filterClassList;
    }

    public ValueSorterManner getSorterManner() {
        return this.sorterManner;
    }

    public void setSorterManner(ValueSorterManner sorterManner) {
        this.sorterManner = sorterManner;
    }

    public Class<? extends Comparator> getSorterComparatorClass() {
        return this.sorterComparatorClass;
    }

    public void setSorterComparatorClass(Class<? extends Comparator> sorterComparatorClass) {
        this.sorterComparatorClass = sorterComparatorClass;
    }

    public Class<? extends SelectionSorterWeightFactory> getSorterWeightFactoryClass() {
        return this.sorterWeightFactoryClass;
    }

    public void setSorterWeightFactoryClass(Class<? extends SelectionSorterWeightFactory> sorterWeightFactoryClass) {
        this.sorterWeightFactoryClass = sorterWeightFactoryClass;
    }

    public SelectionSorterOrder getSorterOrder() {
        return this.sorterOrder;
    }

    public void setSorterOrder(SelectionSorterOrder sorterOrder) {
        this.sorterOrder = sorterOrder;
    }

    public Class<? extends SelectionSorter> getSorterClass() {
        return this.sorterClass;
    }

    public void setSorterClass(Class<? extends SelectionSorter> sorterClass) {
        this.sorterClass = sorterClass;
    }

    public Class<? extends SelectionProbabilityWeightFactory> getProbabilityWeightFactoryClass() {
        return this.probabilityWeightFactoryClass;
    }

    public void setProbabilityWeightFactoryClass(Class<? extends SelectionProbabilityWeightFactory> probabilityWeightFactoryClass) {
        this.probabilityWeightFactoryClass = probabilityWeightFactoryClass;
    }

    public Long getSelectedCountLimit() {
        return this.selectedCountLimit;
    }

    public void setSelectedCountLimit(Long selectedCountLimit) {
        this.selectedCountLimit = selectedCountLimit;
    }

    public GenuineVariableDescriptor extractVariableDescriptor(HeuristicConfigPolicy configPolicy, EntityDescriptor entityDescriptor) {
        entityDescriptor = this.downcastEntityDescriptor(configPolicy, entityDescriptor);
        if (this.variableName != null) {
            GenuineVariableDescriptor variableDescriptor = entityDescriptor.getGenuineVariableDescriptor(this.variableName);
            if (variableDescriptor == null) {
                throw new IllegalArgumentException("The selectorConfig (" + this + ") has a variableName (" + this.variableName + ") which is not a valid planning variable on entityClass (" + entityDescriptor.getEntityClass() + ").\n" + entityDescriptor.buildInvalidVariableNameExceptionMessage(this.variableName));
            }
            return variableDescriptor;
        }
        if (this.mimicSelectorRef != null) {
            return configPolicy.getValueMimicRecorder(this.mimicSelectorRef).getVariableDescriptor();
        }
        return null;
    }

    public ValueSelector buildValueSelector(HeuristicConfigPolicy configPolicy, EntityDescriptor entityDescriptor, SelectionCacheType minimumCacheType, SelectionOrder inheritedSelectionOrder) {
        if (this.mimicSelectorRef != null) {
            ValueSelector valueSelector = this.buildMimicReplaying(configPolicy);
            valueSelector = this.applyReinitializeVariableFiltering(configPolicy, valueSelector);
            valueSelector = this.applyDowncasting(configPolicy, valueSelector);
            return valueSelector;
        }
        entityDescriptor = this.downcastEntityDescriptor(configPolicy, entityDescriptor);
        GenuineVariableDescriptor variableDescriptor = this.deduceVariableDescriptor(entityDescriptor, this.variableName);
        SelectionCacheType resolvedCacheType = SelectionCacheType.resolve(this.cacheType, minimumCacheType);
        SelectionOrder resolvedSelectionOrder = SelectionOrder.resolve(this.selectionOrder, inheritedSelectionOrder);
        if (this.nearbySelectionConfig != null) {
            this.nearbySelectionConfig.validateNearby(resolvedCacheType, resolvedSelectionOrder);
        }
        this.validateCacheTypeVersusSelectionOrder(resolvedCacheType, resolvedSelectionOrder);
        this.validateSorting(resolvedSelectionOrder);
        this.validateProbability(resolvedSelectionOrder);
        this.validateSelectedLimit(minimumCacheType);
        ValueSelector valueSelector = this.buildBaseValueSelector(configPolicy, variableDescriptor, SelectionCacheType.max(minimumCacheType, resolvedCacheType), this.determineBaseRandomSelection(variableDescriptor, resolvedCacheType, resolvedSelectionOrder));
        if (this.nearbySelectionConfig != null) {
            valueSelector = this.nearbySelectionConfig.applyNearbyValueSelector(configPolicy, minimumCacheType, resolvedCacheType, resolvedSelectionOrder, valueSelector);
        }
        valueSelector = this.applyFiltering(resolvedCacheType, resolvedSelectionOrder, valueSelector);
        valueSelector = this.applyInitializedChainedValueFilter(configPolicy, variableDescriptor, resolvedCacheType, resolvedSelectionOrder, valueSelector);
        valueSelector = this.applySorting(resolvedCacheType, resolvedSelectionOrder, valueSelector);
        valueSelector = this.applyProbability(resolvedCacheType, resolvedSelectionOrder, valueSelector);
        valueSelector = this.applyShuffling(resolvedCacheType, resolvedSelectionOrder, valueSelector);
        valueSelector = this.applyCaching(resolvedCacheType, resolvedSelectionOrder, valueSelector);
        valueSelector = this.applySelectedLimit(resolvedCacheType, resolvedSelectionOrder, valueSelector);
        valueSelector = this.applyMimicRecording(configPolicy, valueSelector);
        valueSelector = this.applyReinitializeVariableFiltering(configPolicy, valueSelector);
        valueSelector = this.applyDowncasting(configPolicy, valueSelector);
        return valueSelector;
    }

    protected ValueSelector buildMimicReplaying(HeuristicConfigPolicy configPolicy) {
        if (this.id != null || this.variableName != null || this.cacheType != null || this.selectionOrder != null || this.nearbySelectionConfig != null || this.filterClassList != null || this.sorterManner != null || this.sorterComparatorClass != null || this.sorterWeightFactoryClass != null || this.sorterOrder != null || this.sorterClass != null || this.probabilityWeightFactoryClass != null || this.selectedCountLimit != null) {
            throw new IllegalArgumentException("The valueSelectorConfig (" + this + ") with mimicSelectorRef (" + this.mimicSelectorRef + ") has another property that is not null.");
        }
        ValueMimicRecorder valueMimicRecorder = configPolicy.getValueMimicRecorder(this.mimicSelectorRef);
        if (valueMimicRecorder == null) {
            throw new IllegalArgumentException("The valueSelectorConfig (" + this + ") has a mimicSelectorRef (" + this.mimicSelectorRef + ") for which no valueSelector with that id exists (in its solver phase).");
        }
        return new MimicReplayingValueSelector(valueMimicRecorder);
    }

    protected EntityDescriptor downcastEntityDescriptor(HeuristicConfigPolicy configPolicy, EntityDescriptor entityDescriptor) {
        if (this.downcastEntityClass != null) {
            Class<?> parentEntityClass = entityDescriptor.getEntityClass();
            if (!parentEntityClass.isAssignableFrom(this.downcastEntityClass)) {
                throw new IllegalStateException("The downcastEntityClass (" + this.downcastEntityClass + ") is not a subclass of the parentEntityClass (" + parentEntityClass + ") configured by the " + EntitySelector.class.getSimpleName() + ".");
            }
            SolutionDescriptor solutionDescriptor = configPolicy.getSolutionDescriptor();
            entityDescriptor = solutionDescriptor.getEntityDescriptorStrict(this.downcastEntityClass);
            if (entityDescriptor == null) {
                throw new IllegalArgumentException("The selectorConfig (" + this + ") has an downcastEntityClass (" + this.downcastEntityClass + ") that is not a known planning entity.\nCheck your solver configuration. If that class (" + this.downcastEntityClass.getSimpleName() + ") is not in the entityClassSet (" + solutionDescriptor.getEntityClassSet() + "), check your Solution implementation's annotated methods too.");
            }
        }
        return entityDescriptor;
    }

    protected boolean determineBaseRandomSelection(GenuineVariableDescriptor variableDescriptor, SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder) {
        switch (resolvedSelectionOrder) {
            case ORIGINAL: {
                return false;
            }
            case SORTED: 
            case SHUFFLED: 
            case PROBABILISTIC: {
                return false;
            }
            case RANDOM: {
                return resolvedCacheType.isNotCached() || this.isBaseInherentlyCached(variableDescriptor) && !this.hasFiltering(variableDescriptor);
            }
        }
        throw new IllegalStateException("The selectionOrder (" + (Object)((Object)resolvedSelectionOrder) + ") is not implemented.");
    }

    protected boolean isBaseInherentlyCached(GenuineVariableDescriptor variableDescriptor) {
        return variableDescriptor.isValueRangeEntityIndependent();
    }

    private ValueSelector buildBaseValueSelector(HeuristicConfigPolicy configPolicy, GenuineVariableDescriptor variableDescriptor, SelectionCacheType minimumCacheType, boolean randomSelection) {
        ValueRangeDescriptor valueRangeDescriptor = variableDescriptor.getValueRangeDescriptor();
        if (minimumCacheType == SelectionCacheType.SOLVER) {
            throw new IllegalArgumentException("The minimumCacheType (" + (Object)((Object)minimumCacheType) + ") is not yet supported. Please use " + (Object)((Object)SelectionCacheType.PHASE) + " instead.");
        }
        if (valueRangeDescriptor.isEntityIndependent()) {
            return new FromSolutionPropertyValueSelector((EntityIndependentValueRangeDescriptor)valueRangeDescriptor, minimumCacheType, randomSelection);
        }
        return new FromEntityPropertyValueSelector(valueRangeDescriptor, randomSelection);
    }

    private boolean hasFiltering(GenuineVariableDescriptor variableDescriptor) {
        return !ConfigUtils.isEmptyCollection(this.filterClassList) || variableDescriptor.hasMovableChainedTrailingValueFilter();
    }

    private ValueSelector applyFiltering(SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder, ValueSelector valueSelector) {
        GenuineVariableDescriptor variableDescriptor = valueSelector.getVariableDescriptor();
        if (this.hasFiltering(variableDescriptor)) {
            ArrayList<SelectionFilter> filterList = new ArrayList<SelectionFilter>(this.filterClassList == null ? 1 : this.filterClassList.size() + 1);
            if (this.filterClassList != null) {
                for (Class<? extends SelectionFilter> filterClass : this.filterClassList) {
                    filterList.add(ConfigUtils.newInstance(this, "filterClass", filterClass));
                }
            }
            if (variableDescriptor.hasMovableChainedTrailingValueFilter()) {
                filterList.add(variableDescriptor.getMovableChainedTrailingValueFilter());
            }
            valueSelector = FilteringValueSelector.create(valueSelector, filterList);
        }
        return valueSelector;
    }

    protected ValueSelector applyInitializedChainedValueFilter(HeuristicConfigPolicy configPolicy, GenuineVariableDescriptor variableDescriptor, SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder, ValueSelector valueSelector) {
        if (configPolicy.isInitializedChainedValueFilterEnabled() && variableDescriptor.isChained()) {
            valueSelector = InitializedValueSelector.create(valueSelector);
        }
        return valueSelector;
    }

    private void validateSorting(SelectionOrder resolvedSelectionOrder) {
        if ((this.sorterManner != null || this.sorterComparatorClass != null || this.sorterWeightFactoryClass != null || this.sorterOrder != null || this.sorterClass != null) && resolvedSelectionOrder != SelectionOrder.SORTED) {
            throw new IllegalArgumentException("The valueSelectorConfig (" + this + ") with sorterManner (" + (Object)((Object)this.sorterManner) + ") and sorterComparatorClass (" + this.sorterComparatorClass + ") and sorterWeightFactoryClass (" + this.sorterWeightFactoryClass + ") and sorterOrder (" + (Object)((Object)this.sorterOrder) + ") and sorterClass (" + this.sorterClass + ") has a resolvedSelectionOrder (" + (Object)((Object)resolvedSelectionOrder) + ") that is not " + (Object)((Object)SelectionOrder.SORTED) + ".");
        }
        if (this.sorterManner != null && this.sorterComparatorClass != null) {
            throw new IllegalArgumentException("The valueSelectorConfig (" + this + ") has both a sorterManner (" + (Object)((Object)this.sorterManner) + ") and a sorterComparatorClass (" + this.sorterComparatorClass + ").");
        }
        if (this.sorterManner != null && this.sorterWeightFactoryClass != null) {
            throw new IllegalArgumentException("The valueSelectorConfig (" + this + ") has both a sorterManner (" + (Object)((Object)this.sorterManner) + ") and a sorterWeightFactoryClass (" + this.sorterWeightFactoryClass + ").");
        }
        if (this.sorterManner != null && this.sorterClass != null) {
            throw new IllegalArgumentException("The valueSelectorConfig (" + this + ") has both a sorterManner (" + (Object)((Object)this.sorterManner) + ") and a sorterClass (" + this.sorterClass + ").");
        }
        if (this.sorterManner != null && this.sorterOrder != null) {
            throw new IllegalArgumentException("The valueSelectorConfig (" + this + ") with sorterManner (" + (Object)((Object)this.sorterManner) + ") has a non-null sorterOrder (" + (Object)((Object)this.sorterOrder) + ").");
        }
        if (this.sorterComparatorClass != null && this.sorterWeightFactoryClass != null) {
            throw new IllegalArgumentException("The valueSelectorConfig (" + this + ") has both a sorterComparatorClass (" + this.sorterComparatorClass + ") and a sorterWeightFactoryClass (" + this.sorterWeightFactoryClass + ").");
        }
        if (this.sorterComparatorClass != null && this.sorterClass != null) {
            throw new IllegalArgumentException("The valueSelectorConfig (" + this + ") has both a sorterComparatorClass (" + this.sorterComparatorClass + ") and a sorterClass (" + this.sorterClass + ").");
        }
        if (this.sorterWeightFactoryClass != null && this.sorterClass != null) {
            throw new IllegalArgumentException("The valueSelectorConfig (" + this + ") has both a sorterWeightFactoryClass (" + this.sorterWeightFactoryClass + ") and a sorterClass (" + this.sorterClass + ").");
        }
        if (this.sorterClass != null && this.sorterOrder != null) {
            throw new IllegalArgumentException("The valueSelectorConfig (" + this + ") with sorterClass (" + this.sorterClass + ") has a non-null sorterOrder (" + (Object)((Object)this.sorterOrder) + ").");
        }
    }

    private ValueSelector applySorting(SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder, ValueSelector valueSelector) {
        if (resolvedSelectionOrder == SelectionOrder.SORTED) {
            SelectionSorter sorter;
            if (this.sorterManner != null) {
                GenuineVariableDescriptor variableDescriptor = valueSelector.getVariableDescriptor();
                if (!ValueSelectorConfig.hasSorter(this.sorterManner, variableDescriptor)) {
                    return valueSelector;
                }
                sorter = ValueSelectorConfig.determineSorter(this.sorterManner, variableDescriptor);
            } else if (this.sorterComparatorClass != null) {
                Comparator sorterComparator = ConfigUtils.newInstance(this, "sorterComparatorClass", this.sorterComparatorClass);
                sorter = new ComparatorSelectionSorter(sorterComparator, SelectionSorterOrder.resolve(this.sorterOrder));
            } else if (this.sorterWeightFactoryClass != null) {
                SelectionSorterWeightFactory sorterWeightFactory = ConfigUtils.newInstance(this, "sorterWeightFactoryClass", this.sorterWeightFactoryClass);
                sorter = new WeightFactorySelectionSorter(sorterWeightFactory, SelectionSorterOrder.resolve(this.sorterOrder));
            } else if (this.sorterClass != null) {
                sorter = ConfigUtils.newInstance(this, "sorterClass", this.sorterClass);
            } else {
                throw new IllegalArgumentException("The valueSelectorConfig (" + this + ") with resolvedSelectionOrder (" + (Object)((Object)resolvedSelectionOrder) + ") needs a sorterManner (" + (Object)((Object)this.sorterManner) + ") or a sorterComparatorClass (" + this.sorterComparatorClass + ") or a sorterWeightFactoryClass (" + this.sorterWeightFactoryClass + ") or a sorterClass (" + this.sorterClass + ").");
            }
            if (!valueSelector.getVariableDescriptor().isValueRangeEntityIndependent() && resolvedCacheType == SelectionCacheType.STEP) {
                valueSelector = new EntityDependentSortingValueSelector(valueSelector, resolvedCacheType, sorter);
            } else {
                if (!(valueSelector instanceof EntityIndependentValueSelector)) {
                    throw new IllegalArgumentException("The valueSelectorConfig (" + this + ") with resolvedCacheType (" + (Object)((Object)resolvedCacheType) + ") and resolvedSelectionOrder (" + (Object)((Object)resolvedSelectionOrder) + ") needs to be based on an EntityIndependentValueSelector (" + valueSelector + "). Check your @" + ValueRangeProvider.class.getSimpleName() + " annotations.");
                }
                valueSelector = new SortingValueSelector((EntityIndependentValueSelector)valueSelector, resolvedCacheType, sorter);
            }
        }
        return valueSelector;
    }

    private void validateProbability(SelectionOrder resolvedSelectionOrder) {
        if (this.probabilityWeightFactoryClass != null && resolvedSelectionOrder != SelectionOrder.PROBABILISTIC) {
            throw new IllegalArgumentException("The valueSelectorConfig (" + this + ") with probabilityWeightFactoryClass (" + this.probabilityWeightFactoryClass + ") has a resolvedSelectionOrder (" + (Object)((Object)resolvedSelectionOrder) + ") that is not " + (Object)((Object)SelectionOrder.PROBABILISTIC) + ".");
        }
    }

    private ValueSelector applyProbability(SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder, ValueSelector valueSelector) {
        if (resolvedSelectionOrder == SelectionOrder.PROBABILISTIC) {
            if (this.probabilityWeightFactoryClass == null) {
                throw new IllegalArgumentException("The valueSelectorConfig (" + this + ") with resolvedSelectionOrder (" + (Object)((Object)resolvedSelectionOrder) + ") needs a probabilityWeightFactoryClass (" + this.probabilityWeightFactoryClass + ").");
            }
            SelectionProbabilityWeightFactory probabilityWeightFactory = ConfigUtils.newInstance(this, "probabilityWeightFactoryClass", this.probabilityWeightFactoryClass);
            if (!(valueSelector instanceof EntityIndependentValueSelector)) {
                throw new IllegalArgumentException("The valueSelectorConfig (" + this + ") with resolvedCacheType (" + (Object)((Object)resolvedCacheType) + ") and resolvedSelectionOrder (" + (Object)((Object)resolvedSelectionOrder) + ") needs to be based on an EntityIndependentValueSelector (" + valueSelector + "). Check your @" + ValueRangeProvider.class.getSimpleName() + " annotations.");
            }
            valueSelector = new ProbabilityValueSelector((EntityIndependentValueSelector)valueSelector, resolvedCacheType, probabilityWeightFactory);
        }
        return valueSelector;
    }

    private ValueSelector applyShuffling(SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder, ValueSelector valueSelector) {
        if (resolvedSelectionOrder == SelectionOrder.SHUFFLED) {
            if (!(valueSelector instanceof EntityIndependentValueSelector)) {
                throw new IllegalArgumentException("The valueSelectorConfig (" + this + ") with resolvedCacheType (" + (Object)((Object)resolvedCacheType) + ") and resolvedSelectionOrder (" + (Object)((Object)resolvedSelectionOrder) + ") needs to be based on an EntityIndependentValueSelector (" + valueSelector + "). Check your @" + ValueRangeProvider.class.getSimpleName() + " annotations.");
            }
            valueSelector = new ShufflingValueSelector((EntityIndependentValueSelector)valueSelector, resolvedCacheType);
        }
        return valueSelector;
    }

    private ValueSelector applyCaching(SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder, ValueSelector valueSelector) {
        if (resolvedCacheType.isCached() && resolvedCacheType.compareTo(valueSelector.getCacheType()) > 0) {
            if (!(valueSelector instanceof EntityIndependentValueSelector)) {
                throw new IllegalArgumentException("The valueSelectorConfig (" + this + ") with resolvedCacheType (" + (Object)((Object)resolvedCacheType) + ") and resolvedSelectionOrder (" + (Object)((Object)resolvedSelectionOrder) + ") needs to be based on an EntityIndependentValueSelector (" + valueSelector + "). Check your @" + ValueRangeProvider.class.getSimpleName() + " annotations.");
            }
            valueSelector = new CachingValueSelector((EntityIndependentValueSelector)valueSelector, resolvedCacheType, resolvedSelectionOrder.toRandomSelectionBoolean());
        }
        return valueSelector;
    }

    private void validateSelectedLimit(SelectionCacheType minimumCacheType) {
        if (this.selectedCountLimit != null && minimumCacheType.compareTo(SelectionCacheType.JUST_IN_TIME) > 0) {
            throw new IllegalArgumentException("The valueSelectorConfig (" + this + ") with selectedCountLimit (" + this.selectedCountLimit + ") has a minimumCacheType (" + (Object)((Object)minimumCacheType) + ") that is higher than " + (Object)((Object)SelectionCacheType.JUST_IN_TIME) + ".");
        }
    }

    private ValueSelector applySelectedLimit(SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder, ValueSelector valueSelector) {
        if (this.selectedCountLimit != null) {
            valueSelector = new SelectedCountLimitValueSelector(valueSelector, this.selectedCountLimit);
        }
        return valueSelector;
    }

    private ValueSelector applyMimicRecording(HeuristicConfigPolicy configPolicy, ValueSelector valueSelector) {
        if (this.id != null) {
            if (this.id.isEmpty()) {
                throw new IllegalArgumentException("The valueSelectorConfig (" + this + ") has an empty id (" + this.id + ").");
            }
            if (!(valueSelector instanceof EntityIndependentValueSelector)) {
                throw new IllegalArgumentException("The valueSelectorConfig (" + this + ") with id (" + this.id + ") needs to be based on an EntityIndependentValueSelector (" + valueSelector + "). Check your @" + ValueRangeProvider.class.getSimpleName() + " annotations.");
            }
            MimicRecordingValueSelector mimicRecordingValueSelector = new MimicRecordingValueSelector((EntityIndependentValueSelector)valueSelector);
            configPolicy.addValueMimicRecorder(this.id, mimicRecordingValueSelector);
            valueSelector = mimicRecordingValueSelector;
        }
        return valueSelector;
    }

    private ValueSelector applyReinitializeVariableFiltering(HeuristicConfigPolicy configPolicy, ValueSelector valueSelector) {
        if (configPolicy.isReinitializeVariableFilterEnabled()) {
            valueSelector = new ReinitializeVariableValueSelector(valueSelector);
        }
        return valueSelector;
    }

    private ValueSelector applyDowncasting(HeuristicConfigPolicy configPolicy, ValueSelector valueSelector) {
        if (this.downcastEntityClass != null) {
            valueSelector = new DowncastingValueSelector(valueSelector, this.downcastEntityClass);
        }
        return valueSelector;
    }

    @Override
    public void inherit(ValueSelectorConfig inheritedConfig) {
        super.inherit(inheritedConfig);
        this.id = ConfigUtils.inheritOverwritableProperty(this.id, inheritedConfig.getId());
        this.mimicSelectorRef = ConfigUtils.inheritOverwritableProperty(this.mimicSelectorRef, inheritedConfig.getMimicSelectorRef());
        this.downcastEntityClass = ConfigUtils.inheritOverwritableProperty(this.downcastEntityClass, inheritedConfig.getDowncastEntityClass());
        this.variableName = ConfigUtils.inheritOverwritableProperty(this.variableName, inheritedConfig.getVariableName());
        this.nearbySelectionConfig = ConfigUtils.inheritConfig(this.nearbySelectionConfig, inheritedConfig.getNearbySelectionConfig());
        this.cacheType = ConfigUtils.inheritOverwritableProperty(this.cacheType, inheritedConfig.getCacheType());
        this.selectionOrder = ConfigUtils.inheritOverwritableProperty(this.selectionOrder, inheritedConfig.getSelectionOrder());
        this.sorterManner = ConfigUtils.inheritOverwritableProperty(this.sorterManner, inheritedConfig.getSorterManner());
        this.sorterComparatorClass = ConfigUtils.inheritOverwritableProperty(this.sorterComparatorClass, inheritedConfig.getSorterComparatorClass());
        this.sorterWeightFactoryClass = ConfigUtils.inheritOverwritableProperty(this.sorterWeightFactoryClass, inheritedConfig.getSorterWeightFactoryClass());
        this.sorterOrder = ConfigUtils.inheritOverwritableProperty(this.sorterOrder, inheritedConfig.getSorterOrder());
        this.sorterClass = ConfigUtils.inheritOverwritableProperty(this.sorterClass, inheritedConfig.getSorterClass());
        this.probabilityWeightFactoryClass = ConfigUtils.inheritOverwritableProperty(this.probabilityWeightFactoryClass, inheritedConfig.getProbabilityWeightFactoryClass());
        this.selectedCountLimit = ConfigUtils.inheritOverwritableProperty(this.selectedCountLimit, inheritedConfig.getSelectedCountLimit());
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.variableName + ")";
    }

    public static boolean hasSorter(ValueSorterManner valueSorterManner, GenuineVariableDescriptor variableDescriptor) {
        switch (valueSorterManner) {
            case NONE: {
                return false;
            }
            case INCREASING_STRENGTH: 
            case DECREASING_STRENGTH: {
                return true;
            }
            case INCREASING_STRENGTH_IF_AVAILABLE: {
                return variableDescriptor.getIncreasingStrengthSorter() != null;
            }
            case DECREASING_STRENGTH_IF_AVAILABLE: {
                return variableDescriptor.getDecreasingStrengthSorter() != null;
            }
        }
        throw new IllegalStateException("The sorterManner (" + (Object)((Object)valueSorterManner) + ") is not implemented.");
    }

    public static SelectionSorter determineSorter(ValueSorterManner valueSorterManner, GenuineVariableDescriptor variableDescriptor) {
        SelectionSorter sorter;
        switch (valueSorterManner) {
            case NONE: {
                throw new IllegalStateException("Impossible state: hasSorter() should have returned null.");
            }
            case INCREASING_STRENGTH: 
            case INCREASING_STRENGTH_IF_AVAILABLE: {
                sorter = variableDescriptor.getIncreasingStrengthSorter();
                break;
            }
            case DECREASING_STRENGTH: 
            case DECREASING_STRENGTH_IF_AVAILABLE: {
                sorter = variableDescriptor.getDecreasingStrengthSorter();
                break;
            }
            default: {
                throw new IllegalStateException("The sorterManner (" + (Object)((Object)valueSorterManner) + ") is not implemented.");
            }
        }
        if (sorter == null) {
            throw new IllegalArgumentException("The sorterManner (" + (Object)((Object)valueSorterManner) + ") on entity class (" + variableDescriptor.getEntityDescriptor().getEntityClass() + ")'s variable (" + variableDescriptor.getVariableName() + ") fails because that variable getter's " + PlanningVariable.class.getSimpleName() + " annotation does not declare any strength comparison.");
        }
        return sorter;
    }
}

