/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.localsearch.decider.acceptor.lateacceptance;

import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.impl.localsearch.decider.acceptor.AbstractAcceptor;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchMoveScope;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchPhaseScope;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchStepScope;

public class LateAcceptanceAcceptor
extends AbstractAcceptor {
    protected int lateAcceptanceSize = -1;
    protected boolean hillClimbingEnabled = true;
    protected Score[] previousScores;
    protected int lateScoreIndex = -1;

    public void setLateAcceptanceSize(int lateAcceptanceSize) {
        this.lateAcceptanceSize = lateAcceptanceSize;
    }

    public void setHillClimbingEnabled(boolean hillClimbingEnabled) {
        this.hillClimbingEnabled = hillClimbingEnabled;
    }

    public void phaseStarted(LocalSearchPhaseScope phaseScope) {
        super.phaseStarted(phaseScope);
        this.validate();
        this.previousScores = new Score[this.lateAcceptanceSize];
        Score initialScore = phaseScope.getBestScore();
        for (int i = 0; i < this.previousScores.length; ++i) {
            this.previousScores[i] = initialScore;
        }
        this.lateScoreIndex = 0;
    }

    private void validate() {
        if (this.lateAcceptanceSize <= 0) {
            throw new IllegalArgumentException("The lateAcceptanceSize (" + this.lateAcceptanceSize + ") cannot be negative or zero.");
        }
    }

    @Override
    public boolean isAccepted(LocalSearchMoveScope moveScope) {
        Score lastStepScore;
        Score lateScore;
        Score moveScore = moveScope.getScore();
        if (moveScore.compareTo(lateScore = this.previousScores[this.lateScoreIndex]) >= 0) {
            return true;
        }
        return this.hillClimbingEnabled && moveScore.compareTo(lastStepScore = ((LocalSearchPhaseScope)moveScope.getStepScope().getPhaseScope()).getLastCompletedStepScope().getScore()) >= 0;
    }

    public void stepEnded(LocalSearchStepScope stepScope) {
        super.stepEnded(stepScope);
        this.previousScores[this.lateScoreIndex] = stepScope.getScore();
        this.lateScoreIndex = (this.lateScoreIndex + 1) % this.lateAcceptanceSize;
    }

    public void phaseEnded(LocalSearchPhaseScope phaseScope) {
        super.phaseEnded(phaseScope);
        this.previousScores = null;
        this.lateScoreIndex = -1;
    }
}

