/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.jpa;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import org.drools.core.command.impl.ExecutableCommand;
import org.drools.core.time.InternalSchedulerService;
import org.drools.core.time.Job;
import org.drools.core.time.JobContext;
import org.drools.core.time.JobHandle;
import org.drools.core.time.SelfRemovalJob;
import org.drools.core.time.SelfRemovalJobContext;
import org.drools.core.time.Trigger;
import org.drools.core.time.impl.DefaultTimerJobInstance;
import org.drools.core.time.impl.JDKTimerService;
import org.drools.core.time.impl.TimerJobInstance;
import org.drools.persistence.jpa.JpaTimerJobInstance;
import org.kie.api.command.Command;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.ExecutableRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JpaJDKTimerService
extends JDKTimerService {
    private static Logger logger = LoggerFactory.getLogger(JpaTimerJobInstance.class);
    private ExecutableRunner runner;
    private Map<Long, TimerJobInstance> timerInstances = new ConcurrentHashMap<Long, TimerJobInstance>();

    public void setCommandService(ExecutableRunner runner) {
        this.runner = runner;
    }

    public JpaJDKTimerService() {
        this(1);
        this.timerInstances = new ConcurrentHashMap<Long, TimerJobInstance>();
    }

    public JpaJDKTimerService(int size) {
        super(size);
    }

    protected Callable<Void> createCallableJob(Job job, JobContext ctx, Trigger trigger, JDKTimerService.JDKJobHandle handle, InternalSchedulerService scheduler) {
        JpaJDKCallableJob jobInstance = new JpaJDKCallableJob((Job)new SelfRemovalJob(job), (JobContext)new SelfRemovalJobContext(ctx, this.timerInstances), trigger, handle, scheduler);
        this.timerInstances.put(handle.getId(), (TimerJobInstance)jobInstance);
        return jobInstance;
    }

    public Collection<TimerJobInstance> getTimerJobInstances() {
        return this.timerInstances.values();
    }

    public static class JDKCallableJobCommand
    implements ExecutableCommand<Void> {
        private static final long serialVersionUID = 4L;
        private JpaJDKCallableJob job;

        public JDKCallableJobCommand(JpaJDKCallableJob job) {
            this.job = job;
        }

        public Void execute(Context context) {
            try {
                return this.job.internalCall();
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    public class JpaJDKCallableJob
    extends DefaultTimerJobInstance {
        public JpaJDKCallableJob(Job job, JobContext ctx, Trigger trigger, JDKTimerService.JDKJobHandle handle, InternalSchedulerService scheduler) {
            super(job, ctx, trigger, (JobHandle)handle, scheduler);
        }

        public Void call() throws Exception {
            try {
                JDKCallableJobCommand command = new JDKCallableJobCommand(this);
                JpaJDKTimerService.this.runner.execute((Command)command);
            }
            catch (Exception e) {
                logger.error("Unable to execute job!", (Throwable)e);
                throw e;
            }
            return null;
        }

        private Void internalCall() throws Exception {
            return super.call();
        }
    }
}

