/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.drools.core.BeliefSystemType;
import org.drools.core.ClockType;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.SessionConfiguration;
import org.drools.core.TimerJobFactoryType;
import org.drools.core.common.ProjectClassLoader;
import org.drools.core.process.instance.WorkItemManagerFactory;
import org.drools.core.time.TimerService;
import org.drools.core.util.ConfFileUtils;
import org.drools.core.util.MVELSafeHelper;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.ExecutableRunner;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.QueryListenerOption;
import org.kie.api.runtime.conf.TimedRuleExecutionFilter;
import org.kie.api.runtime.conf.TimedRuleExecutionOption;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.runtime.conf.ForceEagerActivationFilter;
import org.kie.internal.runtime.conf.ForceEagerActivationOption;
import org.kie.internal.utils.ChainedProperties;

public class SessionConfigurationImpl
extends SessionConfiguration {
    private static final long serialVersionUID = 510L;
    private ChainedProperties chainedProperties;
    private volatile boolean immutable;
    private boolean keepReference;
    private ForceEagerActivationFilter forceEagerActivationFilter;
    private TimedRuleExecutionFilter timedRuleExecutionFilter;
    private ClockType clockType;
    private BeliefSystemType beliefSystemType;
    private QueryListenerOption queryListener;
    private Map<String, WorkItemHandler> workItemHandlers;
    private WorkItemManagerFactory workItemManagerFactory;
    private ExecutableRunner runner;
    private transient ClassLoader classLoader;
    private TimerJobFactoryType timerJobFactoryType;

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.chainedProperties);
        out.writeBoolean(this.immutable);
        out.writeBoolean(this.keepReference);
        out.writeObject((Object)this.clockType);
        out.writeObject(this.queryListener);
        out.writeObject(this.timerJobFactoryType);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.chainedProperties = (ChainedProperties)in.readObject();
        this.immutable = in.readBoolean();
        this.keepReference = in.readBoolean();
        this.clockType = (ClockType)((Object)in.readObject());
        this.queryListener = (QueryListenerOption)in.readObject();
        try {
            this.timerJobFactoryType = (TimerJobFactoryType)in.readObject();
        }
        catch (InvalidObjectException e) {
            if (e.getMessage().contains("DEFUALT")) {
                this.timerJobFactoryType = TimerJobFactoryType.DEFAULT;
            }
            throw e;
        }
    }

    public SessionConfigurationImpl() {
        this.init(null, null);
    }

    public SessionConfigurationImpl(Properties properties) {
        this.init(properties, null);
    }

    public SessionConfigurationImpl(ClassLoader classLoader) {
        this.init(null, classLoader);
    }

    public SessionConfigurationImpl(Properties properties, ClassLoader classLoader) {
        this.init(properties, classLoader);
    }

    private void init(Properties properties, ClassLoader classLoader) {
        this.classLoader = ProjectClassLoader.getClassLoader(classLoader == null ? null : classLoader, this.getClass(), false);
        this.immutable = false;
        this.chainedProperties = new ChainedProperties("session.conf", this.classLoader);
        if (properties != null) {
            this.chainedProperties.addProperties(properties);
        }
        this.setKeepReference(Boolean.valueOf(this.chainedProperties.getProperty("drools.keepReference", "true")));
        this.setForceEagerActivationFilter(ForceEagerActivationOption.resolve((String)this.chainedProperties.getProperty("drools.forceEagerActivation", "false")).getFilter());
        this.setTimedRuleExecutionFilter(TimedRuleExecutionOption.resolve((String)this.chainedProperties.getProperty("drools.timedRuleExecution", "false")).getFilter());
        this.setBeliefSystemType(BeliefSystemType.resolveBeliefSystemType(this.chainedProperties.getProperty("drools.beliefSystem", BeliefSystemType.SIMPLE.getId())));
        this.setClockType(ClockType.resolveClockType(this.chainedProperties.getProperty("drools.clockType", ClockType.REALTIME_CLOCK.getId())));
        this.setQueryListenerOption(QueryListenerOption.determineQueryListenerClassOption((String)this.chainedProperties.getProperty("drools.queryListener", QueryListenerOption.STANDARD.getAsString())));
        this.setTimerJobFactoryType(TimerJobFactoryType.resolveTimerJobFactoryType(this.chainedProperties.getProperty("drools.timerJobFactory", TimerJobFactoryType.TRACKABLE.getId())));
    }

    @Override
    public SessionConfigurationImpl addDefaultProperties(Properties properties) {
        Properties defaultProperties = new Properties();
        for (Map.Entry<Object, Object> prop : properties.entrySet()) {
            if (this.chainedProperties.getProperty((String)prop.getKey(), null) != null) continue;
            defaultProperties.put(prop.getKey(), prop.getValue());
        }
        this.chainedProperties.addProperties(defaultProperties);
        return this;
    }

    public void makeImmutable() {
        this.immutable = true;
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    private void checkCanChange() {
        if (this.immutable) {
            throw new UnsupportedOperationException("Can't set a property after configuration becomes immutable");
        }
    }

    @Override
    public void setKeepReference(boolean keepReference) {
        this.checkCanChange();
        this.keepReference = keepReference;
    }

    @Override
    public boolean isKeepReference() {
        return this.keepReference;
    }

    @Override
    public void setForceEagerActivationFilter(ForceEagerActivationFilter forceEagerActivationFilter) {
        this.checkCanChange();
        this.forceEagerActivationFilter = forceEagerActivationFilter;
    }

    @Override
    public ForceEagerActivationFilter getForceEagerActivationFilter() {
        return this.forceEagerActivationFilter;
    }

    @Override
    public void setTimedRuleExecutionFilter(TimedRuleExecutionFilter timedRuleExecutionFilter) {
        this.checkCanChange();
        this.timedRuleExecutionFilter = timedRuleExecutionFilter;
    }

    @Override
    public TimedRuleExecutionFilter getTimedRuleExecutionFilter() {
        return this.timedRuleExecutionFilter;
    }

    @Override
    public BeliefSystemType getBeliefSystemType() {
        return this.beliefSystemType;
    }

    @Override
    public void setBeliefSystemType(BeliefSystemType beliefSystemType) {
        this.checkCanChange();
        this.beliefSystemType = beliefSystemType;
    }

    @Override
    public ClockType getClockType() {
        return this.clockType;
    }

    @Override
    public void setClockType(ClockType clockType) {
        this.checkCanChange();
        this.clockType = clockType;
    }

    @Override
    public TimerJobFactoryType getTimerJobFactoryType() {
        return this.timerJobFactoryType;
    }

    @Override
    public void setTimerJobFactoryType(TimerJobFactoryType timerJobFactoryType) {
        this.checkCanChange();
        this.timerJobFactoryType = timerJobFactoryType;
    }

    private void setQueryListenerClass(QueryListenerOption option) {
        this.checkCanChange();
        this.queryListener = option;
    }

    @Override
    public Map<String, WorkItemHandler> getWorkItemHandlers() {
        if (this.workItemHandlers == null) {
            this.initWorkItemHandlers(new HashMap<String, Object>());
        }
        return this.workItemHandlers;
    }

    @Override
    public Map<String, WorkItemHandler> getWorkItemHandlers(Map<String, Object> params) {
        if (this.workItemHandlers == null) {
            this.initWorkItemHandlers(params);
        }
        return this.workItemHandlers;
    }

    private void initWorkItemHandlers(Map<String, Object> params) {
        String[] locations;
        this.workItemHandlers = new HashMap<String, WorkItemHandler>();
        for (String factoryLocation : locations = this.chainedProperties.getProperty("drools.workItemHandlers", "").split("\\s")) {
            if ((factoryLocation = factoryLocation.trim()).startsWith("\"")) {
                factoryLocation = factoryLocation.substring(1);
            }
            if (factoryLocation.endsWith("\"")) {
                factoryLocation = factoryLocation.substring(0, factoryLocation.length() - 1);
            }
            if (factoryLocation.equals("")) continue;
            this.loadWorkItemHandlers(factoryLocation, params);
        }
    }

    private void loadWorkItemHandlers(String location, Map<String, Object> params) {
        String content = ConfFileUtils.URLContentsToString(ConfFileUtils.getURL(location, null, RuleBaseConfiguration.class));
        Map workItemHandlers = (Map)MVELSafeHelper.getEvaluator().eval(content, params);
        this.workItemHandlers.putAll(workItemHandlers);
    }

    @Override
    public WorkItemManagerFactory getWorkItemManagerFactory() {
        if (this.workItemManagerFactory == null) {
            this.initWorkItemManagerFactory();
        }
        return this.workItemManagerFactory;
    }

    private void initWorkItemManagerFactory() {
        String className = this.chainedProperties.getProperty("drools.workItemManagerFactory", "org.drools.core.process.instance.impl.DefaultWorkItemManagerFactory");
        Class<?> clazz = null;
        try {
            clazz = this.classLoader.loadClass(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (clazz != null) {
            try {
                this.workItemManagerFactory = (WorkItemManagerFactory)clazz.newInstance();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to instantiate work item manager factory '" + className + "'", e);
            }
        } else {
            throw new IllegalArgumentException("Work item manager factory '" + className + "' not found");
        }
    }

    @Override
    public String getProcessInstanceManagerFactory() {
        return this.chainedProperties.getProperty("drools.processInstanceManagerFactory", "org.jbpm.process.instance.impl.DefaultProcessInstanceManagerFactory");
    }

    @Override
    public String getSignalManagerFactory() {
        return this.chainedProperties.getProperty("drools.processSignalManagerFactory", "org.jbpm.process.instance.event.DefaultSignalManagerFactory");
    }

    @Override
    public ExecutableRunner getRunner(KnowledgeBase kbase, Environment environment) {
        if (this.runner == null) {
            this.initCommandService(kbase, environment);
        }
        return this.runner;
    }

    private void initCommandService(KnowledgeBase kbase, Environment environment) {
        String className = this.chainedProperties.getProperty("drools.commandService", null);
        if (className == null) {
            return;
        }
        Class<?> clazz = null;
        try {
            clazz = this.classLoader.loadClass(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (clazz != null) {
            try {
                this.runner = (ExecutableRunner)clazz.getConstructor(KnowledgeBase.class, KieSessionConfiguration.class, Environment.class).newInstance(kbase, this, environment);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to instantiate command service '" + className + "'", e);
            }
        } else {
            throw new IllegalArgumentException("Command service '" + className + "' not found");
        }
    }

    @Override
    public TimerService newTimerService() {
        String className = this.chainedProperties.getProperty("drools.timerService", "org.drools.core.time.impl.JDKTimerService");
        if (className == null) {
            return null;
        }
        Class<?> clazz = null;
        try {
            clazz = this.classLoader.loadClass(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (clazz != null) {
            try {
                return (TimerService)clazz.newInstance();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to instantiate timer service '" + className + "'", e);
            }
        }
        try {
            return (TimerService)MVELSafeHelper.getEvaluator().eval(className);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Timer service '" + className + "' not found", e);
        }
    }

    @Override
    public QueryListenerOption getQueryListenerOption() {
        return this.queryListener;
    }

    @Override
    public void setQueryListenerOption(QueryListenerOption queryListener) {
        this.checkCanChange();
        this.queryListener = queryListener;
    }
}

