/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.resource.common;

import bitronix.tm.BitronixTransaction;
import bitronix.tm.BitronixXid;
import bitronix.tm.TransactionManagerServices;
import bitronix.tm.internal.BitronixRuntimeException;
import bitronix.tm.internal.XAResourceHolderState;
import bitronix.tm.recovery.IncrementalRecoverer;
import bitronix.tm.recovery.RecoveryException;
import bitronix.tm.resource.common.ResourceBean;
import bitronix.tm.resource.common.StateChangeListener;
import bitronix.tm.resource.common.TransactionContextHelper;
import bitronix.tm.resource.common.XAResourceHolder;
import bitronix.tm.resource.common.XAResourceProducer;
import bitronix.tm.resource.common.XAStatefulHolder;
import bitronix.tm.utils.ClassLoaderUtils;
import bitronix.tm.utils.CryptoEngine;
import bitronix.tm.utils.Decoder;
import bitronix.tm.utils.MonotonicClock;
import bitronix.tm.utils.PropertyUtils;
import bitronix.tm.utils.Uid;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.transaction.Synchronization;
import javax.transaction.xa.XAResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XAPool
implements StateChangeListener {
    private static final Logger log = LoggerFactory.getLogger(XAPool.class);
    private static final String PASSWORD_PROPERTY_NAME = "password";
    private final Map<Uid, ThreadLocal<XAStatefulHolder>> statefulHolderTransactionMap = new HashMap<Uid, ThreadLocal<XAStatefulHolder>>();
    private final List<XAStatefulHolder> objects = new ArrayList<XAStatefulHolder>();
    private final ResourceBean bean;
    private final XAResourceProducer xaResourceProducer;
    private final Object xaFactory;
    private boolean failed = false;

    public XAPool(XAResourceProducer xaResourceProducer, ResourceBean bean) throws Exception {
        this.xaResourceProducer = xaResourceProducer;
        this.bean = bean;
        if (bean.getMaxPoolSize() < 1 || bean.getMinPoolSize() > bean.getMaxPoolSize()) {
            throw new IllegalArgumentException("cannot create a pool with min " + bean.getMinPoolSize() + " connection(s) and max " + bean.getMaxPoolSize() + " connection(s)");
        }
        if (bean.getAcquireIncrement() < 1) {
            throw new IllegalArgumentException("cannot create a pool with a connection acquisition increment less than 1, configured value is " + bean.getAcquireIncrement());
        }
        this.xaFactory = XAPool.createXAFactory(bean);
        this.init();
        if (bean.getIgnoreRecoveryFailures()) {
            log.warn("resource '" + bean.getUniqueName() + "' is configured to ignore recovery failures, make sure this setting is not enabled on a production system!");
        }
    }

    private synchronized void init() throws Exception {
        this.growUntilMinPoolSize();
        if (this.bean.getMaxIdleTime() > 0) {
            TransactionManagerServices.getTaskScheduler().schedulePoolShrinking(this);
        }
    }

    public Object getXAFactory() {
        return this.xaFactory;
    }

    public synchronized void setFailed(boolean failed) {
        this.failed = failed;
    }

    public synchronized boolean isFailed() {
        return this.failed;
    }

    public synchronized Object getConnectionHandle() throws Exception {
        return this.getConnectionHandle(true);
    }

    public synchronized Object getConnectionHandle(boolean recycle) throws Exception {
        if (this.failed) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug("resource '" + this.bean.getUniqueName() + "' is marked as failed, resetting and recovering it before trying connection acquisition");
                }
                this.close();
                this.init();
                IncrementalRecoverer.recover(this.xaResourceProducer);
            }
            catch (RecoveryException ex) {
                throw new BitronixRuntimeException("incremental recovery failed when trying to acquire a connection from failed resource '" + this.bean.getUniqueName() + "'", ex);
            }
            catch (Exception ex) {
                throw new BitronixRuntimeException("pool reset failed when trying to acquire a connection from failed resource '" + this.bean.getUniqueName() + "'", ex);
            }
        }
        long remainingTime = (long)this.bean.getAcquisitionTimeout() * 1000L;
        while (true) {
            long before = MonotonicClock.currentTimeMillis();
            XAStatefulHolder xaStatefulHolder = null;
            if (recycle) {
                xaStatefulHolder = this.bean.getShareTransactionConnections() ? this.getSharedXAStatefulHolder() : this.getNotAccessible();
            }
            if (xaStatefulHolder == null) {
                xaStatefulHolder = this.getInPool();
            }
            if (log.isDebugEnabled()) {
                log.debug("found " + Decoder.decodeXAStatefulHolderState(xaStatefulHolder.getState()) + " connection " + xaStatefulHolder + " from " + this);
            }
            try {
                Object connectionHandle = xaStatefulHolder.getConnectionHandle();
                if (this.bean.getShareTransactionConnections()) {
                    this.putSharedXAStatefulHolder(xaStatefulHolder);
                }
                this.growUntilMinPoolSize();
                return connectionHandle;
            }
            catch (Exception ex) {
                long now;
                long waitTime;
                block19: {
                    if (log.isDebugEnabled()) {
                        log.debug("connection is invalid, trying to close it", (Throwable)ex);
                    }
                    try {
                        xaStatefulHolder.close();
                    }
                    catch (Exception ex2) {
                        if (!log.isDebugEnabled()) break block19;
                        log.debug("exception while trying to close invalid connection, ignoring it", (Throwable)ex2);
                    }
                }
                this.objects.remove(xaStatefulHolder);
                if (log.isDebugEnabled()) {
                    log.debug("removed invalid connection " + xaStatefulHolder + " from " + this);
                }
                if (log.isDebugEnabled()) {
                    log.debug("waiting " + this.bean.getAcquisitionInterval() + "s before trying to acquire a connection again from " + this);
                }
                if ((waitTime = (long)this.bean.getAcquisitionInterval() * 1000L) <= 0L) continue;
                try {
                    this.wait(waitTime);
                    continue;
                }
                catch (InterruptedException ex2) {
                    // empty catch block
                }
                if ((remainingTime -= (now = MonotonicClock.currentTimeMillis()) - before) > 0L) continue;
                throw new BitronixRuntimeException("cannot get valid connection from " + this + " after trying for " + this.bean.getAcquisitionTimeout() + "s", ex);
            }
            break;
        }
    }

    public synchronized void close() {
        if (log.isDebugEnabled()) {
            log.debug("closing all connections of " + this);
        }
        for (XAStatefulHolder xaStatefulHolder : this.objects) {
            try {
                if (xaStatefulHolder.getState() == 0) continue;
                xaStatefulHolder.close();
            }
            catch (Exception ex) {
                if (!log.isDebugEnabled()) continue;
                log.debug("ignoring exception while closing connection " + xaStatefulHolder, (Throwable)ex);
            }
        }
        if (TransactionManagerServices.isTaskSchedulerRunning()) {
            TransactionManagerServices.getTaskScheduler().cancelPoolShrinking(this);
        }
        this.objects.clear();
        this.failed = false;
    }

    public synchronized long totalPoolSize() {
        return this.objects.size();
    }

    public synchronized long inPoolSize() {
        int count = 0;
        for (XAStatefulHolder xaStatefulHolder : this.objects) {
            if (xaStatefulHolder.getState() != 1) continue;
            ++count;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stateChanged(XAStatefulHolder source, int oldState, int newState) {
        if (newState == 1) {
            if (log.isDebugEnabled()) {
                log.debug("a connection's state changed to IN_POOL, notifying a thread eventually waiting for a connection");
            }
            XAPool xAPool = this;
            synchronized (xAPool) {
                this.notify();
            }
        }
    }

    @Override
    public void stateChanging(XAStatefulHolder source, int currentState, int futureState) {
    }

    public synchronized XAResourceHolder findXAResourceHolder(XAResource xaResource) {
        for (XAStatefulHolder xaStatefulHolder : this.objects) {
            List<XAResourceHolder> xaResourceHolders = xaStatefulHolder.getXAResourceHolders();
            for (XAResourceHolder holder : xaResourceHolders) {
                if (holder.getXAResource() != xaResource) continue;
                return holder;
            }
        }
        return null;
    }

    List<XAStatefulHolder> getXAResourceHolders() {
        return Collections.unmodifiableList(this.objects);
    }

    public Date getNextShrinkDate() {
        return new Date(MonotonicClock.currentTimeMillis() + (long)(this.bean.getMaxIdleTime() * 1000));
    }

    public synchronized void shrink() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("shrinking " + this);
        }
        ArrayList<XAStatefulHolder> toRemoveXaStatefulHolders = new ArrayList<XAStatefulHolder>();
        long now = MonotonicClock.currentTimeMillis();
        for (XAStatefulHolder xaStatefulHolder : this.objects) {
            if (xaStatefulHolder.getState() != 1) continue;
            long expirationTime = xaStatefulHolder.getLastReleaseDate().getTime() + (long)(this.bean.getMaxIdleTime() * 1000);
            if (log.isDebugEnabled()) {
                log.debug("checking if connection can be closed: " + xaStatefulHolder + " - closing time: " + expirationTime + ", now time: " + now);
            }
            if (expirationTime > now) continue;
            try {
                xaStatefulHolder.close();
            }
            catch (Exception ex) {
                log.warn("error closing " + xaStatefulHolder, (Throwable)ex);
            }
            toRemoveXaStatefulHolders.add(xaStatefulHolder);
        }
        if (log.isDebugEnabled()) {
            log.debug("closed " + toRemoveXaStatefulHolders.size() + " idle connection(s)");
        }
        this.objects.removeAll(toRemoveXaStatefulHolders);
        this.growUntilMinPoolSize();
        if (log.isDebugEnabled()) {
            log.debug("shrunk " + this);
        }
    }

    public synchronized void reset() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("resetting " + this);
        }
        ArrayList<XAStatefulHolder> toRemoveXaStatefulHolders = new ArrayList<XAStatefulHolder>();
        for (XAStatefulHolder xaStatefulHolder : this.objects) {
            if (xaStatefulHolder.getState() != 1) continue;
            try {
                xaStatefulHolder.close();
            }
            catch (Exception ex) {
                log.warn("error closing " + xaStatefulHolder, (Throwable)ex);
            }
            toRemoveXaStatefulHolders.add(xaStatefulHolder);
        }
        if (log.isDebugEnabled()) {
            log.debug("closed " + toRemoveXaStatefulHolders.size() + " connection(s)");
        }
        this.objects.removeAll(toRemoveXaStatefulHolders);
        this.growUntilMinPoolSize();
        if (log.isDebugEnabled()) {
            log.debug("reset " + this);
        }
    }

    public String toString() {
        return "an XAPool of resource " + this.bean.getUniqueName() + " with " + this.totalPoolSize() + " connection(s) (" + this.inPoolSize() + " still available)" + (this.failed ? " -failed-" : "");
    }

    private synchronized void createPooledObject(Object xaFactory) throws Exception {
        XAStatefulHolder xaStatefulHolder = this.xaResourceProducer.createPooledConnection(xaFactory, this.bean);
        xaStatefulHolder.addStateChangeEventListener(this);
        this.objects.add(xaStatefulHolder);
    }

    private static Object createXAFactory(ResourceBean bean) throws Exception {
        String className = bean.getClassName();
        if (className == null) {
            throw new IllegalArgumentException("className cannot be null");
        }
        Class xaFactoryClass = ClassLoaderUtils.loadClass(className);
        Object xaFactory = xaFactoryClass.newInstance();
        for (Map.Entry<Object, Object> entry : bean.getDriverProperties().entrySet()) {
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            if (name.endsWith(PASSWORD_PROPERTY_NAME)) {
                value = XAPool.decrypt((String)value);
            }
            if (log.isDebugEnabled()) {
                log.debug("setting vendor property '" + name + "' to '" + value + "'");
            }
            PropertyUtils.setProperty(xaFactory, name, value);
        }
        return xaFactory;
    }

    private static String decrypt(String resourcePassword) throws Exception {
        int startIdx = resourcePassword.indexOf("{");
        int endIdx = resourcePassword.indexOf("}");
        if (startIdx != 0 || endIdx == -1) {
            return resourcePassword;
        }
        String cipher = resourcePassword.substring(1, endIdx);
        if (log.isDebugEnabled()) {
            log.debug("resource password is encrypted, decrypting " + resourcePassword);
        }
        return CryptoEngine.decrypt(cipher, resourcePassword.substring(endIdx + 1));
    }

    private synchronized XAStatefulHolder getNotAccessible() {
        BitronixTransaction transaction;
        if (log.isDebugEnabled()) {
            log.debug("trying to recycle a NOT_ACCESSIBLE connection of " + this);
        }
        if ((transaction = TransactionContextHelper.currentTransaction()) == null) {
            if (log.isDebugEnabled()) {
                log.debug("no current transaction, no connection can be in state NOT_ACCESSIBLE when there is no global transaction context");
            }
            return null;
        }
        Uid currentTxGtrid = transaction.getResourceManager().getGtrid();
        if (log.isDebugEnabled()) {
            log.debug("current transaction GTRID is [" + currentTxGtrid + "]");
        }
        for (XAStatefulHolder xaStatefulHolder : this.objects) {
            if (xaStatefulHolder.getState() != 3) continue;
            if (log.isDebugEnabled()) {
                log.debug("found a connection in NOT_ACCESSIBLE state: " + xaStatefulHolder);
            }
            if (!XAPool.containsXAResourceHolderMatchingGtrid(xaStatefulHolder, currentTxGtrid)) continue;
            return xaStatefulHolder;
        }
        if (log.isDebugEnabled()) {
            log.debug("no NOT_ACCESSIBLE connection enlisted in this transaction");
        }
        return null;
    }

    private static boolean containsXAResourceHolderMatchingGtrid(XAStatefulHolder xaStatefulHolder, Uid currentTxGtrid) {
        List<XAResourceHolder> xaResourceHolders = xaStatefulHolder.getXAResourceHolders();
        if (log.isDebugEnabled()) {
            log.debug(xaResourceHolders.size() + " xa resource(s) created by connection in NOT_ACCESSIBLE state: " + xaStatefulHolder);
        }
        for (XAResourceHolder xaResourceHolder : xaResourceHolders) {
            Map<Uid, XAResourceHolderState> statesForGtrid = xaResourceHolder.getXAResourceHolderStatesForGtrid(currentTxGtrid);
            if (statesForGtrid == null) {
                return false;
            }
            for (XAResourceHolderState xaResourceHolderState : statesForGtrid.values()) {
                BitronixXid bitronixXid = xaResourceHolderState.getXid();
                Uid resourceGtrid = bitronixXid.getGlobalTransactionIdUid();
                if (log.isDebugEnabled()) {
                    log.debug("NOT_ACCESSIBLE xa resource GTRID: " + resourceGtrid);
                }
                if (!currentTxGtrid.equals(resourceGtrid)) continue;
                if (log.isDebugEnabled()) {
                    log.debug("NOT_ACCESSIBLE xa resource's GTRID matched this transaction's GTRID, recycling it");
                }
                return true;
            }
        }
        return false;
    }

    private synchronized XAStatefulHolder getInPool() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("getting a IN_POOL connection from " + this);
        }
        if (this.inPoolSize() == 0L) {
            if (log.isDebugEnabled()) {
                log.debug("no more free connection in " + this + ", trying to grow it");
            }
            this.grow();
        }
        this.waitForConnectionInPool();
        for (XAStatefulHolder xaStatefulHolder : this.objects) {
            if (xaStatefulHolder.getState() != 1) continue;
            return xaStatefulHolder;
        }
        throw new BitronixRuntimeException("pool does not contain IN_POOL connection while it should !");
    }

    private synchronized void grow() throws Exception {
        if (this.totalPoolSize() < (long)this.bean.getMaxPoolSize()) {
            long increment = this.bean.getAcquireIncrement();
            if (this.totalPoolSize() + increment > (long)this.bean.getMaxPoolSize()) {
                increment = (long)this.bean.getMaxPoolSize() - this.totalPoolSize();
            }
            if (log.isDebugEnabled()) {
                log.debug("incrementing " + this.bean.getUniqueName() + " pool size by " + increment + " unit(s) to reach " + (this.totalPoolSize() + increment) + " connection(s)");
            }
            int i = 0;
            while ((long)i < increment) {
                this.createPooledObject(this.xaFactory);
                ++i;
            }
        } else if (log.isDebugEnabled()) {
            log.debug("pool " + this.bean.getUniqueName() + " already at max size of " + this.totalPoolSize() + " connection(s), not growing it");
        }
    }

    private synchronized void growUntilMinPoolSize() throws Exception {
        for (int i = (int)this.totalPoolSize(); i < this.bean.getMinPoolSize(); ++i) {
            this.createPooledObject(this.xaFactory);
        }
    }

    private synchronized void waitForConnectionInPool() {
        long remainingTime = (long)this.bean.getAcquisitionTimeout() * 1000L;
        if (log.isDebugEnabled()) {
            log.debug("waiting for IN_POOL connections count to be > 0, currently is " + this.inPoolSize());
        }
        while (this.inPoolSize() == 0L) {
            long now;
            long before = MonotonicClock.currentTimeMillis();
            try {
                if (log.isDebugEnabled()) {
                    log.debug("waiting " + remainingTime + "ms");
                }
                this.wait(remainingTime);
                if (log.isDebugEnabled()) {
                    log.debug("waiting over, IN_POOL connections count is now " + this.inPoolSize());
                }
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            if ((remainingTime -= (now = MonotonicClock.currentTimeMillis()) - before) > 0L || this.inPoolSize() != 0L) continue;
            if (log.isDebugEnabled()) {
                log.debug("connection pool dequeue timed out");
            }
            if (TransactionManagerServices.isTransactionManagerRunning()) {
                TransactionManagerServices.getTransactionManager().dumpTransactionContexts();
            }
            throw new BitronixRuntimeException("XA pool of resource " + this.bean.getUniqueName() + " still empty after " + this.bean.getAcquisitionTimeout() + "s wait time");
        }
    }

    private synchronized XAStatefulHolder getSharedXAStatefulHolder() {
        XAStatefulHolder xaStatefulHolder;
        BitronixTransaction transaction = TransactionContextHelper.currentTransaction();
        if (transaction == null) {
            if (log.isDebugEnabled()) {
                log.debug("no current transaction, shared connection map will not be used");
            }
            return null;
        }
        Uid currentTxGtrid = transaction.getResourceManager().getGtrid();
        ThreadLocal<XAStatefulHolder> threadLocal = this.statefulHolderTransactionMap.get(currentTxGtrid);
        if (threadLocal != null && (xaStatefulHolder = threadLocal.get()) != null && xaStatefulHolder.getState() != 1 && xaStatefulHolder.getState() != 0) {
            if (log.isDebugEnabled()) {
                log.debug("sharing connection " + xaStatefulHolder + " in transaction " + currentTxGtrid);
            }
            return xaStatefulHolder;
        }
        return null;
    }

    private synchronized void putSharedXAStatefulHolder(XAStatefulHolder xaStatefulHolder) {
        BitronixTransaction transaction = TransactionContextHelper.currentTransaction();
        if (transaction == null) {
            if (log.isDebugEnabled()) {
                log.debug("no current transaction, not adding " + xaStatefulHolder + " to shared connection map");
            }
            return;
        }
        Uid currentTxGtrid = transaction.getResourceManager().getGtrid();
        ThreadLocal<XAStatefulHolder> threadLocal = this.statefulHolderTransactionMap.get(currentTxGtrid);
        if (threadLocal == null) {
            try {
                transaction.registerSynchronization(new SharedStatefulHolderCleanupSynchronization(currentTxGtrid));
            }
            catch (Exception e) {
                return;
            }
            threadLocal = new ThreadLocal();
            this.statefulHolderTransactionMap.put(currentTxGtrid, threadLocal);
            if (log.isDebugEnabled()) {
                log.debug("added shared connection mapping for " + currentTxGtrid + " holder " + xaStatefulHolder);
            }
        }
        threadLocal.set(xaStatefulHolder);
    }

    private final class SharedStatefulHolderCleanupSynchronization
    implements Synchronization {
        private final Uid gtrid;

        private SharedStatefulHolderCleanupSynchronization(Uid gtrid) {
            this.gtrid = gtrid;
        }

        public void beforeCompletion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterCompletion(int status) {
            XAPool xAPool = XAPool.this;
            synchronized (xAPool) {
                XAPool.this.statefulHolderTransactionMap.remove(this.gtrid);
                if (log.isDebugEnabled()) {
                    log.debug("deleted shared connection mappings for " + this.gtrid);
                }
            }
        }

        public String toString() {
            return "a SharedStatefulHolderCleanupSynchronization with GTRID [" + this.gtrid + "]";
        }
    }
}

