/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.twopc;

import bitronix.tm.TransactionManagerServices;
import bitronix.tm.internal.XAResourceHolderState;
import bitronix.tm.internal.XAResourceManager;
import bitronix.tm.twopc.PhaseException;
import bitronix.tm.twopc.executor.Executor;
import bitronix.tm.twopc.executor.Job;
import bitronix.tm.utils.CollectionUtils;
import bitronix.tm.utils.Decoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import javax.transaction.xa.XAException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPhaseEngine {
    private static final Logger log = LoggerFactory.getLogger(AbstractPhaseEngine.class);
    private final Executor executor;

    protected AbstractPhaseEngine(Executor executor) {
        this.executor = executor;
    }

    protected void executePhase(XAResourceManager resourceManager, boolean reverse) throws PhaseException {
        SortedSet<Integer> positions;
        if (reverse) {
            positions = resourceManager.getReverseOrderPositions();
            if (log.isDebugEnabled()) {
                log.debug("executing phase on " + resourceManager.size() + " resource(s) enlisted in " + positions.size() + " position(s) in reverse position order");
            }
        } else {
            positions = resourceManager.getNaturalOrderPositions();
            if (log.isDebugEnabled()) {
                log.debug("executing phase on " + resourceManager.size() + " resource(s) enlisted in " + positions.size() + " position(s) in natural position order");
            }
        }
        ArrayList<JobsExecutionReport> positionErrorReports = new ArrayList<JobsExecutionReport>();
        for (Integer positionKey : positions) {
            JobsExecutionReport report;
            List<XAResourceHolderState> resources = reverse ? resourceManager.getReverseOrderResourcesForPosition(positionKey) : resourceManager.getNaturalOrderResourcesForPosition(positionKey);
            if (log.isDebugEnabled()) {
                log.debug("running " + resources.size() + " job(s) for position '" + positionKey + "'");
            }
            if ((report = this.runJobsForPosition(resources)).getExceptions().size() > 0) {
                if (log.isDebugEnabled()) {
                    log.debug(report.getExceptions().size() + " error(s) happened during execution of position '" + positionKey + "'");
                }
                positionErrorReports.add(report);
                break;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("ran " + resources.size() + " job(s) for position '" + positionKey + "'");
        }
        if (positionErrorReports.size() > 0) {
            ArrayList<Exception> exceptions = new ArrayList<Exception>();
            ArrayList<XAResourceHolderState> resources = new ArrayList<XAResourceHolderState>();
            for (JobsExecutionReport report : positionErrorReports) {
                exceptions.addAll(report.getExceptions());
                resources.addAll(report.getResources());
            }
            throw new PhaseException(exceptions, resources);
        }
    }

    private JobsExecutionReport runJobsForPosition(List<XAResourceHolderState> resources) {
        ArrayList<Job> jobs = new ArrayList<Job>();
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        ArrayList<XAResourceHolderState> errorResources = new ArrayList<XAResourceHolderState>();
        for (XAResourceHolderState resource : resources) {
            if (!this.isParticipating(resource)) {
                if (!log.isDebugEnabled()) continue;
                log.debug("skipping not participating resource " + resource);
                continue;
            }
            Job job = this.createJob(resource);
            Object future = this.executor.submit(job);
            job.setFuture(future);
            jobs.add(job);
        }
        for (Job job : jobs) {
            Object future = job.getFuture();
            while (!this.executor.isDone(future)) {
                this.executor.waitFor(future, 1000L);
            }
            XAException xaException = job.getXAException();
            RuntimeException runtimeException = job.getRuntimeException();
            if (xaException != null) {
                String extraErrorDetails = TransactionManagerServices.getExceptionAnalyzer().extractExtraXAExceptionDetails(xaException);
                if (log.isDebugEnabled()) {
                    log.debug("error executing " + job + ", errorCode=" + Decoder.decodeXAExceptionErrorCode(xaException) + (extraErrorDetails == null ? "" : ", extra error=" + extraErrorDetails));
                }
                exceptions.add(xaException);
                errorResources.add(job.getResource());
                continue;
            }
            if (runtimeException == null) continue;
            if (log.isDebugEnabled()) {
                log.debug("error executing " + job);
            }
            exceptions.add(runtimeException);
            errorResources.add(job.getResource());
        }
        if (log.isDebugEnabled()) {
            log.debug("phase executed with " + exceptions.size() + " exception(s)");
        }
        return new JobsExecutionReport(exceptions, errorResources);
    }

    protected abstract boolean isParticipating(XAResourceHolderState var1);

    protected abstract Job createJob(XAResourceHolderState var1);

    protected void logFailedResources(PhaseException ex) {
        List<Exception> exceptions = ex.getExceptions();
        List<XAResourceHolderState> resources = ex.getResourceStates();
        for (int i = 0; i < exceptions.size(); ++i) {
            Exception e = exceptions.get(i);
            XAResourceHolderState holderState = resources.get(i);
            log.error("resource " + holderState.getUniqueName() + " failed on " + holderState.getXid(), (Throwable)e);
        }
    }

    protected static Set<String> collectResourcesUniqueNames(List<XAResourceHolderState> resources) {
        HashSet<String> uniqueNames = new HashSet<String>();
        for (XAResourceHolderState resourceHolderState : resources) {
            uniqueNames.add(resourceHolderState.getUniqueName());
        }
        return uniqueNames;
    }

    protected static List<XAResourceHolderState> collectNotInterestedResources(List<XAResourceHolderState> allResources, List<XAResourceHolderState> interestedResources) {
        ArrayList<XAResourceHolderState> result = new ArrayList<XAResourceHolderState>();
        for (XAResourceHolderState resourceHolderState : allResources) {
            if (CollectionUtils.containsByIdentity(interestedResources, resourceHolderState)) continue;
            result.add(resourceHolderState);
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class JobsExecutionReport {
        private final List<Exception> exceptions;
        private final List<XAResourceHolderState> resources;

        private JobsExecutionReport(List<Exception> exceptions, List<XAResourceHolderState> resources) {
            this.exceptions = Collections.unmodifiableList(exceptions);
            this.resources = Collections.unmodifiableList(resources);
        }

        public List<Exception> getExceptions() {
            return this.exceptions;
        }

        public List<XAResourceHolderState> getResources() {
            return this.resources;
        }
    }
}

