/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.jbpm.process.instance.context.variable.VariableScopeInstance;
import org.jbpm.process.instance.impl.ProcessInstanceImpl;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.process.ProcessInstance;

public class WorkflowRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = 8210449548783940188L;
    private long processInstanceId;
    private String processId;
    private long nodeInstanceId;
    private long nodeId;
    private String nodeName;
    private Map<String, Object> variables;

    public WorkflowRuntimeException(NodeInstance nodeInstance, ProcessInstance processInstance, String message) {
        super(message);
        this.initialize(nodeInstance, processInstance);
    }

    public WorkflowRuntimeException(NodeInstance nodeInstance, ProcessInstance processInstance, String message, Throwable e) {
        super(message, e);
        this.initialize(nodeInstance, processInstance);
    }

    public WorkflowRuntimeException(NodeInstance nodeInstance, ProcessInstance processInstance, Exception e) {
        super(e);
        this.initialize(nodeInstance, processInstance);
    }

    private void initialize(NodeInstance nodeInstance, ProcessInstance processInstance) {
        VariableScopeInstance variableScope;
        this.processInstanceId = processInstance.getId();
        this.processId = processInstance.getProcessId();
        if (nodeInstance != null) {
            this.nodeInstanceId = nodeInstance.getId();
            this.nodeId = nodeInstance.getNodeId();
            if (((ProcessInstanceImpl)processInstance).getKnowledgeRuntime() != null) {
                this.nodeName = nodeInstance.getNodeName();
            }
        }
        this.variables = (variableScope = (VariableScopeInstance)((org.jbpm.process.instance.ProcessInstance)processInstance).getContextInstance("VariableScope")) != null ? variableScope.getVariables() : new HashMap<String, Object>(0);
    }

    public long getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public String getProcessId() {
        return this.processId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public long getNodeInstanceId() {
        return this.nodeInstanceId;
    }

    public void setNodeInstanceId(long nodeInstanceId) {
        this.nodeInstanceId = nodeInstanceId;
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(long nodeId) {
        this.nodeId = nodeId;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    @Override
    public String getMessage() {
        return MessageFormat.format("[{0}:{4} - {1}:{2}] -- {3}", this.getProcessId(), this.getNodeName() == null ? "?" : this.getNodeName(), this.getNodeId() == 0L ? "?" : Long.valueOf(this.getNodeId()), this.getCause() == null ? this.getMessage() : this.getCause().getMessage(), this.getProcessInstanceId());
    }
}

