/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.compiler;

import org.drools.compiler.compiler.ProcessBuilder;
import org.drools.compiler.compiler.ProcessBuilderFactoryService;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.utils.ServiceRegistryImpl;

public class ProcessBuilderFactory {
    private static final String PROVIDER_CLASS = "org.jbpm.process.builder.ProcessBuilderFactoryServiceImpl";
    private static IllegalArgumentException initializationException;
    private static ProcessBuilderFactoryService provider;

    public static ProcessBuilder newProcessBuilder(KnowledgeBuilder kBuilder) {
        if (initializationException != null) {
            throw initializationException;
        }
        if (ProcessBuilderFactory.getProcessBuilderFactoryService() == null) {
            return null;
        }
        return ProcessBuilderFactory.getProcessBuilderFactoryService().newProcessBuilder(kBuilder);
    }

    public static void setProcessBuilderFactoryService(ProcessBuilderFactoryService provider) {
        ProcessBuilderFactory.provider = provider;
    }

    private static ProcessBuilderFactoryService initializeProvider() {
        ProcessBuilderFactoryService service = null;
        try {
            ServiceRegistryImpl.getInstance().addDefault(ProcessBuilderFactoryService.class, PROVIDER_CLASS);
            service = (ProcessBuilderFactoryService)ServiceRegistryImpl.getInstance().get(ProcessBuilderFactoryService.class);
            ProcessBuilderFactory.setProcessBuilderFactoryService((ProcessBuilderFactoryService)ServiceRegistryImpl.getInstance().get(ProcessBuilderFactoryService.class));
        }
        catch (IllegalArgumentException e) {
            initializationException = e;
        }
        return service;
    }

    public static synchronized void reInitializeProvider() {
        initializationException = null;
        provider = ProcessBuilderFactory.initializeProvider();
    }

    public static ProcessBuilderFactoryService getProcessBuilderFactoryService() {
        return provider;
    }

    public static synchronized void loadProvider(ClassLoader cl) {
        if (provider == null) {
            try {
                provider = (ProcessBuilderFactoryService)Class.forName(PROVIDER_CLASS, true, cl).newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static {
        provider = ProcessBuilderFactory.initializeProvider();
    }
}

