/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.hardsoftbigdecimal;

import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.kie.api.definition.rule.Rule;
import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.core.api.domain.constraintweight.ConstraintConfiguration;
import org.optaplanner.core.api.domain.constraintweight.ConstraintWeight;
import org.optaplanner.core.api.score.buildin.hardsoftbigdecimal.HardSoftBigDecimalScore;
import org.optaplanner.core.api.score.holder.AbstractScoreHolder;

public class HardSoftBigDecimalScoreHolder
extends AbstractScoreHolder<HardSoftBigDecimalScore> {
    protected final Map<Rule, BiConsumer<RuleContext, BigDecimal>> matchExecutorByNumberMap = new LinkedHashMap<Rule, BiConsumer<RuleContext, BigDecimal>>();
    protected final Map<Rule, BiConsumer<RuleContext, HardSoftBigDecimalScore>> matchExecutorByScoreMap = new LinkedHashMap<Rule, BiConsumer<RuleContext, HardSoftBigDecimalScore>>();
    protected BigDecimal hardScore = null;
    protected BigDecimal softScore = null;

    public HardSoftBigDecimalScoreHolder(boolean constraintMatchEnabled) {
        super(constraintMatchEnabled, HardSoftBigDecimalScore.ZERO);
    }

    public BigDecimal getHardScore() {
        return this.hardScore;
    }

    public BigDecimal getSoftScore() {
        return this.softScore;
    }

    @Override
    public void configureConstraintWeight(Rule rule, HardSoftBigDecimalScore constraintWeight) {
        super.configureConstraintWeight(rule, constraintWeight);
        BiConsumer<RuleContext, BigDecimal> matchExecutor = constraintWeight.equals(HardSoftBigDecimalScore.ZERO) ? (kcontext, matchWeight) -> {} : (constraintWeight.getSoftScore().equals(BigDecimal.ZERO) ? (kcontext, matchWeight) -> this.addHardConstraintMatch((RuleContext)kcontext, constraintWeight.getHardScore().multiply((BigDecimal)matchWeight)) : (constraintWeight.getHardScore().equals(BigDecimal.ZERO) ? (kcontext, matchWeight) -> this.addSoftConstraintMatch((RuleContext)kcontext, constraintWeight.getSoftScore().multiply((BigDecimal)matchWeight)) : (kcontext, matchWeight) -> this.addMultiConstraintMatch((RuleContext)kcontext, constraintWeight.getHardScore().multiply((BigDecimal)matchWeight), constraintWeight.getSoftScore().multiply((BigDecimal)matchWeight))));
        this.matchExecutorByNumberMap.put(rule, matchExecutor);
        this.matchExecutorByScoreMap.put(rule, (kcontext, weightMultiplier) -> this.addMultiConstraintMatch((RuleContext)kcontext, constraintWeight.getHardScore().multiply(weightMultiplier.getHardScore()), constraintWeight.getSoftScore().multiply(weightMultiplier.getSoftScore())));
    }

    public void penalize(RuleContext kcontext) {
        this.reward(kcontext, BigDecimal.ONE.negate());
    }

    public void penalize(RuleContext kcontext, BigDecimal weightMultiplier) {
        this.reward(kcontext, weightMultiplier.negate());
    }

    public void penalize(RuleContext kcontext, BigDecimal hardWeightMultiplier, BigDecimal softWeightMultiplier) {
        this.reward(kcontext, hardWeightMultiplier.negate(), softWeightMultiplier.negate());
    }

    public void reward(RuleContext kcontext) {
        this.reward(kcontext, BigDecimal.ONE);
    }

    public void reward(RuleContext kcontext, BigDecimal weightMultiplier) {
        Rule rule = kcontext.getRule();
        BiConsumer<RuleContext, BigDecimal> matchExecutor = this.matchExecutorByNumberMap.get(rule);
        if (matchExecutor == null) {
            throw new IllegalStateException("The DRL rule (" + rule.getPackageName() + ":" + rule.getName() + ") does not match a @" + ConstraintWeight.class.getSimpleName() + " on the @" + ConstraintConfiguration.class.getSimpleName() + " annotated class.");
        }
        matchExecutor.accept(kcontext, weightMultiplier);
    }

    public void reward(RuleContext kcontext, BigDecimal hardWeightMultiplier, BigDecimal softWeightMultiplier) {
        Rule rule = kcontext.getRule();
        BiConsumer<RuleContext, HardSoftBigDecimalScore> matchExecutor = this.matchExecutorByScoreMap.get(rule);
        if (matchExecutor == null) {
            throw new IllegalStateException("The DRL rule (" + rule.getPackageName() + ":" + rule.getName() + ") does not match a @" + ConstraintWeight.class.getSimpleName() + " on the @" + ConstraintConfiguration.class.getSimpleName() + " annotated class.");
        }
        matchExecutor.accept(kcontext, HardSoftBigDecimalScore.of(hardWeightMultiplier, softWeightMultiplier));
    }

    public void addHardConstraintMatch(RuleContext kcontext, BigDecimal hardWeight) {
        this.hardScore = this.hardScore == null ? hardWeight : this.hardScore.add(hardWeight);
        this.registerConstraintMatch(kcontext, () -> {
            this.hardScore = this.hardScore.subtract(hardWeight);
        }, () -> HardSoftBigDecimalScore.of(hardWeight, BigDecimal.ZERO));
    }

    public void addSoftConstraintMatch(RuleContext kcontext, BigDecimal softWeight) {
        this.softScore = this.softScore == null ? softWeight : this.softScore.add(softWeight);
        this.registerConstraintMatch(kcontext, () -> {
            this.softScore = this.softScore.subtract(softWeight);
        }, () -> HardSoftBigDecimalScore.of(BigDecimal.ZERO, softWeight));
    }

    public void addMultiConstraintMatch(RuleContext kcontext, BigDecimal hardWeight, BigDecimal softWeight) {
        this.hardScore = this.hardScore == null ? hardWeight : this.hardScore.add(hardWeight);
        this.softScore = this.softScore == null ? softWeight : this.softScore.add(softWeight);
        this.registerConstraintMatch(kcontext, () -> {
            this.hardScore = this.hardScore.subtract(hardWeight);
            this.softScore = this.softScore.subtract(softWeight);
        }, () -> HardSoftBigDecimalScore.of(hardWeight, softWeight));
    }

    @Override
    public HardSoftBigDecimalScore extractScore(int initScore) {
        return HardSoftBigDecimalScore.ofUninitialized(initScore, this.hardScore == null ? BigDecimal.ZERO : this.hardScore, this.softScore == null ? BigDecimal.ZERO : this.softScore);
    }
}

