/*
 * Decompiled with CFR 0.152.
 */
package org.kie.aries.blueprint.factorybeans;

import java.util.List;
import org.kie.api.KieServices;
import org.kie.api.command.Command;
import org.kie.api.event.KieRuntimeEventManager;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.RuleRuntimeEventListener;
import org.kie.api.logger.KieLoggers;
import org.kie.api.logger.KieRuntimeLogger;
import org.kie.api.runtime.KieSession;
import org.kie.aries.blueprint.factorybeans.KieListenerAdaptor;
import org.kie.aries.blueprint.factorybeans.KieLoggerAdaptor;

public class KieSessionFactoryBeanHelper {
    protected static void addListeners(KieRuntimeEventManager kieRuntimeEventManager, List<KieListenerAdaptor> listeners) {
        if (listeners == null || listeners.isEmpty()) {
            return;
        }
        for (KieListenerAdaptor listenerConfig : listeners) {
            String type = listenerConfig.getType();
            if (type.equalsIgnoreCase(RuleRuntimeEventListener.class.getName())) {
                kieRuntimeEventManager.addEventListener((RuleRuntimeEventListener)listenerConfig.getObjectRef());
                continue;
            }
            if (type.equalsIgnoreCase(ProcessEventListener.class.getName())) {
                kieRuntimeEventManager.addEventListener((ProcessEventListener)listenerConfig.getObjectRef());
                continue;
            }
            if (!type.equalsIgnoreCase(AgendaEventListener.class.getName())) continue;
            kieRuntimeEventManager.addEventListener((AgendaEventListener)listenerConfig.getObjectRef());
        }
    }

    protected static void attachLoggers(KieRuntimeEventManager ksession, List<KieLoggerAdaptor> loggerAdaptors) {
        if (loggerAdaptors != null && !loggerAdaptors.isEmpty()) {
            KieServices ks = KieServices.Factory.get();
            KieLoggers loggers = ks.getLoggers();
            for (KieLoggerAdaptor adaptor : loggerAdaptors) {
                switch (KieLoggerAdaptor.KNOWLEDGE_LOGGER_TYPE.valueOf(adaptor.getLoggerType())) {
                    case LOGGER_TYPE_FILE: {
                        KieRuntimeLogger runtimeLogger = loggers.newFileLogger(ksession, adaptor.getFile());
                        adaptor.setRuntimeLogger(runtimeLogger);
                        break;
                    }
                    case LOGGER_TYPE_THREADED_FILE: {
                        KieRuntimeLogger runtimeLogger = loggers.newThreadedFileLogger(ksession, adaptor.getFile(), adaptor.getInterval());
                        adaptor.setRuntimeLogger(runtimeLogger);
                        break;
                    }
                    case LOGGER_TYPE_CONSOLE: {
                        KieRuntimeLogger runtimeLogger = loggers.newConsoleLogger(ksession);
                        adaptor.setRuntimeLogger(runtimeLogger);
                    }
                }
            }
        }
    }

    public static void executeCommands(KieSession kieSession, List<?> commands) {
        if (commands != null && kieSession != null) {
            for (Object cmd : commands) {
                kieSession.execute((Command)cmd);
            }
        }
    }
}

