/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import java.util.concurrent.atomic.AtomicInteger;
import org.drools.core.WorkingMemoryEntryPoint;
import org.drools.core.common.DefaultFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.RuleBasePartitionId;
import org.drools.core.factmodel.traits.TraitTypeEnum;
import org.drools.core.rule.EntryPointId;
import org.drools.core.time.JobHandle;
import org.drools.core.time.TimerService;
import org.drools.core.util.LinkedList;

public class EventFactHandle
extends DefaultFactHandle
implements Comparable<EventFactHandle> {
    private static final long serialVersionUID = 510L;
    static final String EVENT_FORMAT_VERSION = "5";
    private long startTimestamp;
    private long duration;
    private boolean expired;
    private boolean pendingRemoveFromStore;
    private long activationsCount;
    private int otnCount;
    private EventFactHandle linkedFactHandle;
    private AtomicInteger notExpiredPartitions;
    private final transient LinkedList<JobHandle> jobs = new LinkedList();

    public EventFactHandle() {
        this.startTimestamp = 0L;
        this.duration = 0L;
    }

    public EventFactHandle(int id, Object object, long recency, long timestamp, long duration, WorkingMemoryEntryPoint wmEntryPoint) {
        this(id, object, recency, timestamp, duration, wmEntryPoint, false);
    }

    public EventFactHandle(int id, Object object, long recency, long timestamp, long duration, WorkingMemoryEntryPoint wmEntryPoint, boolean isTraitOrTraitable) {
        super(id, object, recency, wmEntryPoint, isTraitOrTraitable);
        this.startTimestamp = timestamp;
        this.duration = duration;
        if (wmEntryPoint.getKnowledgeBase() != null && wmEntryPoint.getKnowledgeBase().getConfiguration().isMultithreadEvaluation()) {
            this.notExpiredPartitions = new AtomicInteger(RuleBasePartitionId.PARALLEL_PARTITIONS_NUMBER);
        }
    }

    protected EventFactHandle(int id, int identityHashCode, Object object, long recency, long timestamp, long duration, EntryPointId entryPointId, TraitTypeEnum traitType) {
        super(id, identityHashCode, object, recency, entryPointId, traitType);
        this.startTimestamp = timestamp;
        this.duration = duration;
    }

    @Override
    protected String getFormatVersion() {
        return EVENT_FORMAT_VERSION;
    }

    @Override
    public String toString() {
        return this.toExternalForm();
    }

    @Override
    public boolean isEvent() {
        return true;
    }

    public long getStartTimestamp() {
        return this.startTimestamp;
    }

    public long getDuration() {
        return this.duration;
    }

    public long getEndTimestamp() {
        return this.startTimestamp + this.duration;
    }

    public EventFactHandle getLinkedFactHandle() {
        return this.linkedFactHandle;
    }

    @Override
    public void invalidate() {
        if (this.linkedFactHandle != null) {
            this.linkedFactHandle.invalidate();
        } else {
            super.invalidate();
        }
    }

    @Override
    public boolean isValid() {
        if (this.linkedFactHandle != null) {
            return this.linkedFactHandle.isValid();
        }
        return super.isValid();
    }

    @Override
    public boolean isExpired() {
        if (this.linkedFactHandle != null) {
            return this.linkedFactHandle.isExpired();
        }
        return this.expired;
    }

    public boolean expirePartition() {
        if (this.linkedFactHandle != null) {
            return this.linkedFactHandle.expirePartition();
        }
        return this.notExpiredPartitions == null || this.notExpiredPartitions.decrementAndGet() == 0;
    }

    public void setExpired(boolean expired) {
        if (this.linkedFactHandle != null) {
            this.linkedFactHandle.setExpired(expired);
        } else {
            this.expired = expired;
        }
    }

    @Override
    public boolean isPendingRemoveFromStore() {
        if (this.linkedFactHandle != null) {
            return this.linkedFactHandle.isPendingRemoveFromStore();
        }
        return this.pendingRemoveFromStore;
    }

    public void setPendingRemoveFromStore(boolean pendingRemove) {
        if (this.linkedFactHandle != null) {
            this.linkedFactHandle.setPendingRemoveFromStore(pendingRemove);
        } else {
            this.pendingRemoveFromStore = pendingRemove;
        }
    }

    public long getActivationsCount() {
        if (this.linkedFactHandle != null) {
            return this.linkedFactHandle.getActivationsCount();
        }
        return this.activationsCount;
    }

    public void setActivationsCount(long activationsCount) {
        if (this.linkedFactHandle != null) {
            this.linkedFactHandle.setActivationsCount(activationsCount);
        } else {
            this.activationsCount = activationsCount;
        }
    }

    public void increaseActivationsCount() {
        if (this.linkedFactHandle != null) {
            this.linkedFactHandle.increaseActivationsCount();
        } else {
            ++this.activationsCount;
        }
    }

    public void decreaseActivationsCount() {
        if (this.linkedFactHandle != null) {
            this.linkedFactHandle.decreaseActivationsCount();
        } else {
            --this.activationsCount;
        }
    }

    public void increaseOtnCount() {
        ++this.otnCount;
    }

    public void decreaseOtnCount() {
        --this.otnCount;
    }

    public int getOtnCount() {
        return this.otnCount;
    }

    public void setOtnCount(int otnCount) {
        this.otnCount = otnCount;
    }

    @Override
    public EventFactHandle clone() {
        EventFactHandle clone = new EventFactHandle(this.getId(), this.getIdentityHashCode(), this.getObject(), this.getRecency(), this.getStartTimestamp(), this.getDuration(), this.getEntryPointId(), this.getTraitType());
        clone.setActivationsCount(this.getActivationsCount());
        clone.setOtnCount(this.getOtnCount());
        clone.setExpired(this.isExpired());
        clone.setEqualityKey(this.getEqualityKey());
        clone.linkedTuples = this.linkedTuples.clone();
        clone.setObjectHashCode(this.getObjectHashCode());
        clone.wmEntryPoint = this.wmEntryPoint;
        return clone;
    }

    private EventFactHandle cloneWithoutTuples() {
        EventFactHandle clone = new EventFactHandle(this.getId(), this.getIdentityHashCode(), this.getObject(), this.getRecency(), this.getStartTimestamp(), this.getDuration(), this.getEntryPointId(), this.getTraitType());
        clone.setActivationsCount(this.getActivationsCount());
        clone.setOtnCount(this.getOtnCount());
        clone.setExpired(this.isExpired());
        clone.setEqualityKey(this.getEqualityKey());
        clone.linkedTuples = this.linkedTuples.newInstance();
        clone.setObjectHashCode(this.getObjectHashCode());
        clone.wmEntryPoint = this.wmEntryPoint;
        return clone;
    }

    public EventFactHandle cloneAndLink() {
        EventFactHandle clone = this.cloneWithoutTuples();
        clone.linkedFactHandle = this;
        return clone;
    }

    public void quickCloneUpdate(DefaultFactHandle clone) {
        clone.setObject(this.getObject());
        clone.setRecency(this.getRecency());
        clone.setEqualityKey(this.getEqualityKey());
        clone.setObjectHashCode(this.getObjectHashCode());
        clone.setIdentityHashCode(this.getIdentityHashCode());
        clone.setTraitType(this.getTraitType());
        clone.setDisconnected(this.isDisconnected());
        clone.setNegated(this.isNegated());
    }

    @Override
    public int compareTo(EventFactHandle e) {
        return this.getStartTimestamp() < e.getStartTimestamp() ? -1 : (this.getStartTimestamp() == e.getStartTimestamp() ? 0 : 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJob(JobHandle job) {
        LinkedList<JobHandle> linkedList = this.jobs;
        synchronized (linkedList) {
            this.jobs.add(job);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeJob(JobHandle job) {
        LinkedList<JobHandle> linkedList = this.jobs;
        synchronized (linkedList) {
            if (this.jobs.contains(job)) {
                this.jobs.remove(job);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unscheduleAllJobs(InternalWorkingMemory workingMemory) {
        if (!this.jobs.isEmpty()) {
            LinkedList<JobHandle> linkedList = this.jobs;
            synchronized (linkedList) {
                TimerService clock = workingMemory.getTimerService();
                while (!this.jobs.isEmpty()) {
                    JobHandle job = this.jobs.removeFirst();
                    clock.removeJob(job);
                }
            }
        }
    }
}

