/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.common;

import java.math.BigDecimal;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.impl.score.stream.InnerConstraintFactory;
import org.optaplanner.core.impl.score.stream.common.ScoreImpactType;

public abstract class AbstractConstraint<Solution_, ConstraintFactory extends InnerConstraintFactory<Solution_>>
implements Constraint {
    protected final ConstraintFactory constraintFactory;
    protected final String constraintPackage;
    protected final String constraintName;
    private final Function<Solution_, Score<?>> constraintWeightExtractor;
    protected final ScoreImpactType scoreImpactType;

    protected AbstractConstraint(ConstraintFactory constraintFactory, String constraintPackage, String constraintName, Function<Solution_, Score<?>> constraintWeightExtractor, ScoreImpactType scoreImpactType) {
        this.constraintFactory = constraintFactory;
        this.constraintPackage = constraintPackage;
        this.constraintName = constraintName;
        this.constraintWeightExtractor = constraintWeightExtractor;
        this.scoreImpactType = scoreImpactType;
    }

    public Score<?> extractConstraintWeight(Solution_ workingSolution) {
        Score<?> constraintWeight = this.constraintWeightExtractor.apply(workingSolution);
        this.constraintFactory.getSolutionDescriptor().validateConstraintWeight(this.constraintPackage, this.constraintName, constraintWeight);
        switch (this.scoreImpactType) {
            case PENALTY: {
                return constraintWeight.negate();
            }
            case REWARD: 
            case MIXED: {
                return constraintWeight;
            }
        }
        throw new IllegalStateException("Unknown score impact type: (" + (Object)((Object)this.scoreImpactType) + ")");
    }

    public void assertCorrectImpact(int impact) {
        this.assertCorrectImpact(impact, () -> impact < 0);
    }

    public void assertCorrectImpact(long impact) {
        this.assertCorrectImpact(impact, () -> impact < 0L);
    }

    public void assertCorrectImpact(BigDecimal impact) {
        this.assertCorrectImpact(impact, () -> impact.signum() < 0);
    }

    private void assertCorrectImpact(Object impact, BooleanSupplier lessThanZero) {
        switch (this.scoreImpactType) {
            case MIXED: {
                break;
            }
            case PENALTY: 
            case REWARD: {
                if (lessThanZero.getAsBoolean()) {
                    throw new IllegalStateException("Negative match weight (" + impact + ") for constraint (" + this.getConstraintId() + "). Check constraint provider implementation.");
                }
                return;
            }
            default: {
                throw new IllegalStateException("Unknown score impact type: (" + (Object)((Object)this.scoreImpactType) + ")");
            }
        }
    }

    public ConstraintFactory getConstraintFactory() {
        return this.constraintFactory;
    }

    @Override
    public String getConstraintPackage() {
        return this.constraintPackage;
    }

    @Override
    public String getConstraintName() {
        return this.constraintName;
    }

    public ScoreImpactType getScoreImpactType() {
        return this.scoreImpactType;
    }
}

