/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.drools.model.Model;
import org.drools.model.Rule;
import org.drools.model.impl.ModelImpl;
import org.drools.modelcompiler.builder.KieBaseBuilder;
import org.kie.api.KieBase;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.runtime.KieSession;
import org.kie.internal.event.rule.RuleEventListener;
import org.kie.internal.event.rule.RuleEventManager;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.holder.AbstractScoreHolder;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;
import org.optaplanner.core.impl.score.director.drools.OptaPlannerRuleEventListener;
import org.optaplanner.core.impl.score.stream.ConstraintSession;
import org.optaplanner.core.impl.score.stream.ConstraintSessionFactory;
import org.optaplanner.core.impl.score.stream.drools.DroolsConstraint;
import org.optaplanner.core.impl.score.stream.drools.DroolsConstraintSession;
import org.optaplanner.core.impl.score.stream.drools.common.FactTuple;

public class DroolsConstraintSessionFactory<Solution_>
implements ConstraintSessionFactory<Solution_> {
    private final SolutionDescriptor<Solution_> solutionDescriptor;
    private final Model originalModel;
    private KieBase originalKieBase;
    private KieBase currentKieBase;
    private Set<String> currentlyDisabledConstraintIdSet = null;
    private final Map<org.kie.api.definition.rule.Rule, DroolsConstraint<Solution_>> compiledRuleToConstraintMap;
    private final Map<String, Rule> constraintToModelRuleMap;

    public DroolsConstraintSessionFactory(SolutionDescriptor<Solution_> solutionDescriptor, Model model, List<DroolsConstraint<Solution_>> constraintList) {
        this.solutionDescriptor = solutionDescriptor;
        this.originalModel = model;
        this.currentKieBase = this.originalKieBase = KieBaseBuilder.createKieBaseFromModel((Model)model, (KieBaseOption[])new KieBaseOption[0]);
        this.compiledRuleToConstraintMap = constraintList.stream().collect(Collectors.toMap(constraint -> this.currentKieBase.getRule(constraint.getConstraintPackage(), constraint.getConstraintName()), Function.identity()));
        this.constraintToModelRuleMap = constraintList.stream().collect(Collectors.toMap(Constraint::getConstraintId, constraint -> model.getRules().stream().filter(rule -> Objects.equals(rule.getName(), constraint.getConstraintName())).filter(rule -> Objects.equals(rule.getPackage(), constraint.getConstraintPackage())).findFirst().orElseThrow(() -> new IllegalStateException("Programming error: Rule for constraint (" + constraint + ") not found."))));
    }

    @Override
    public ConstraintSession<Solution_> buildSession(boolean constraintMatchEnabled, Solution_ workingSolution) {
        ScoreDefinition scoreDefinition = this.solutionDescriptor.getScoreDefinition();
        AbstractScoreHolder scoreHolder = (AbstractScoreHolder)scoreDefinition.buildScoreHolder(constraintMatchEnabled);
        scoreHolder.setJustificationListConverter((justificationList, rule) -> DroolsConstraintSessionFactory.matchJustificationsToOutput((List)justificationList, this.compiledRuleToConstraintMap.get(rule).getExpectedJustificationTypes()));
        Object zero = scoreDefinition.getZeroScore();
        LinkedHashSet<String> disabledConstraintIdSet = new LinkedHashSet<String>(0);
        this.compiledRuleToConstraintMap.forEach((compiledRule, constraint) -> {
            Score<?> constraintWeight = constraint.extractConstraintWeight(workingSolution);
            scoreHolder.configureConstraintWeight((org.kie.api.definition.rule.Rule)compiledRule, constraintWeight);
            if (constraintWeight.equals(zero)) {
                disabledConstraintIdSet.add(constraint.getConstraintId());
            }
        });
        if (disabledConstraintIdSet.isEmpty()) {
            this.currentKieBase = this.originalKieBase;
            this.currentlyDisabledConstraintIdSet = null;
        } else if (!disabledConstraintIdSet.equals(this.currentlyDisabledConstraintIdSet)) {
            ModelImpl model = new ModelImpl().withGlobals(this.originalModel.getGlobals());
            this.constraintToModelRuleMap.forEach((constraintId, modelRule) -> {
                if (disabledConstraintIdSet.contains(constraintId)) {
                    return;
                }
                model.addRule(modelRule);
            });
            this.currentKieBase = KieBaseBuilder.createKieBaseFromModel((Model)model, (KieBaseOption[])new KieBaseOption[0]);
            this.currentlyDisabledConstraintIdSet = disabledConstraintIdSet;
        }
        KieSession kieSession = this.currentKieBase.newKieSession();
        ((RuleEventManager)kieSession).addEventListener((RuleEventListener)new OptaPlannerRuleEventListener());
        kieSession.setGlobal("scoreHolder", (Object)scoreHolder);
        return new DroolsConstraintSession(kieSession, scoreHolder);
    }

    private static List<Object> matchJustificationsToOutput(List<Object> justificationList, Class ... expectedTypes) {
        Class expectedType;
        int i;
        if (expectedTypes.length == 0) {
            throw new IllegalStateException("Impossible: there are no 0-cardinality constraint streams.");
        }
        Object[] matching = new Object[expectedTypes.length];
        for (i = 0; i < expectedTypes.length; ++i) {
            expectedType = expectedTypes[i];
            if (Objects.equals(expectedType, Object.class)) continue;
            Object match = justificationList.stream().filter(j -> expectedType.isAssignableFrom(j.getClass())).findFirst().orElseThrow(() -> new IllegalStateException("Impossible: no justification of type (" + expectedType + ")."));
            justificationList.remove(match);
            matching[i] = match;
        }
        for (i = 0; i < expectedTypes.length; ++i) {
            if (matching[i] != null) continue;
            Object match = justificationList.stream().findFirst().orElseThrow(() -> new IllegalStateException("Impossible: there are no more constraint matches."));
            justificationList.remove(match);
            matching[i] = match;
        }
        if (matching.length > 1) {
            return Arrays.asList(matching);
        }
        Object item = matching[0];
        expectedType = expectedTypes[0];
        if (FactTuple.class.isAssignableFrom(expectedType)) {
            return ((FactTuple)item).asList();
        }
        return Collections.singletonList(item);
    }
}

