/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.resource.jms;

import java.util.Hashtable;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;

public class JndiXAConnectionFactory
implements XAConnectionFactory {
    private volatile String initialContextFactory;
    private volatile String providerUrl;
    private volatile String urlPkgPrefixes;
    private volatile String name;
    private volatile String securityPrincipal;
    private volatile String securityCredentials;
    private volatile Properties extraJndiProperties = new Properties();
    private volatile boolean narrowJndiObject = false;
    private volatile XAConnectionFactory wrappedFactory;

    public String getInitialContextFactory() {
        return this.initialContextFactory;
    }

    public void setInitialContextFactory(String initialContextFactory) {
        this.initialContextFactory = initialContextFactory;
    }

    public String getProviderUrl() {
        return this.providerUrl;
    }

    public void setProviderUrl(String providerUrl) {
        this.providerUrl = providerUrl;
    }

    public String getUrlPkgPrefixes() {
        return this.urlPkgPrefixes;
    }

    public void setUrlPkgPrefixes(String urlPkgPrefixes) {
        this.urlPkgPrefixes = urlPkgPrefixes;
    }

    public String getSecurityPrincipal() {
        return this.securityPrincipal;
    }

    public void setSecurityPrincipal(String securityPrincipal) {
        this.securityPrincipal = securityPrincipal;
    }

    public String getSecurityCredentials() {
        return this.securityCredentials;
    }

    public void setSecurityCredentials(String securityCredentials) {
        this.securityCredentials = securityCredentials;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Properties getExtraJndiProperties() {
        return this.extraJndiProperties;
    }

    public void setExtraJndiProperties(Properties extraJndiProperties) {
        this.extraJndiProperties = extraJndiProperties;
    }

    public boolean isNarrowJndiObject() {
        return this.narrowJndiObject;
    }

    public void setNarrowJndiObject(boolean narrowJndiObject) {
        this.narrowJndiObject = narrowJndiObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() throws NamingException {
        InitialContext ctx;
        if (this.wrappedFactory != null) {
            return;
        }
        if (!JndiXAConnectionFactory.isEmpty(this.initialContextFactory)) {
            Hashtable<Object, Object> env = new Hashtable<Object, Object>();
            env.put("java.naming.factory.initial", this.initialContextFactory);
            if (!JndiXAConnectionFactory.isEmpty(this.providerUrl)) {
                env.put("java.naming.provider.url", this.providerUrl);
            }
            if (!JndiXAConnectionFactory.isEmpty(this.urlPkgPrefixes)) {
                env.put("java.naming.factory.url.pkgs", this.urlPkgPrefixes);
            }
            if (!JndiXAConnectionFactory.isEmpty(this.securityPrincipal)) {
                env.put("java.naming.security.principal", this.securityPrincipal);
            }
            if (!JndiXAConnectionFactory.isEmpty(this.securityCredentials)) {
                env.put("java.naming.security.credentials", this.securityCredentials);
            }
            if (!this.extraJndiProperties.isEmpty()) {
                env.putAll(this.extraJndiProperties);
            }
            ctx = new InitialContext(env);
        } else {
            ctx = new InitialContext();
        }
        try {
            Object lookedUpObject = ctx.lookup(this.name);
            this.wrappedFactory = this.narrowJndiObject ? (XAConnectionFactory)PortableRemoteObject.narrow((Object)lookedUpObject, XAConnectionFactory.class) : (XAConnectionFactory)lookedUpObject;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            ctx.close();
            throw throwable;
        }
        ctx.close();
    }

    public XAConnection createXAConnection() throws JMSException {
        try {
            this.init();
            return this.wrappedFactory.createXAConnection();
        }
        catch (NamingException ex) {
            throw (JMSException)new JMSException("error looking up wrapped XAConnectionFactory at " + this.name).initCause((Throwable)ex);
        }
    }

    public XAConnection createXAConnection(String userName, String password) throws JMSException {
        try {
            this.init();
            return this.wrappedFactory.createXAConnection(userName, password);
        }
        catch (NamingException ex) {
            throw (JMSException)new JMSException("error looking up wrapped XAConnectionFactory at " + this.name).initCause((Throwable)ex);
        }
    }

    private static boolean isEmpty(String str) {
        return str == null || str.trim().equals("");
    }
}

