/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.asm;

import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import org.drools.mvel.asm.DumpMethodVisitor;
import org.mvel2.asm.ClassReader;
import org.mvel2.asm.ClassVisitor;
import org.mvel2.asm.MethodVisitor;

public class LambdaIntrospector
implements Function<Object, String> {
    public static final String LAMBDA_INTROSPECTOR_CACHE_SIZE = "drools.lambda.introspector.cache.size";
    private static final int CACHE_SIZE = Integer.parseInt(System.getProperty("drools.lambda.introspector.cache.size", "32"));
    private static final Map<ClassLoader, Map<String, Map<String, String>>> methodFingerprintsMapPerClassLoader = new WeakHashMap<ClassLoader, Map<String, Map<String, String>>>();

    static Map<ClassLoader, Map<String, Map<String, String>>> getMethodFingerprintsMapPerClassLoader() {
        return methodFingerprintsMapPerClassLoader;
    }

    @Override
    public String apply(Object lambda) {
        SerializedLambda extracted;
        String result;
        if (lambda.toString().equals("INSTANCE")) {
            return LambdaIntrospector.getExpressionHash(lambda);
        }
        if (lambda instanceof Supplier) {
            lambda = ((Supplier)lambda).get();
        }
        if ((result = LambdaIntrospector.getFingerprintsForClass(lambda, extracted = LambdaIntrospector.extractLambda((Serializable)lambda)).get(extracted.getImplMethodName())) == null) {
            if (!extracted.getCapturingClass().equals(extracted.getImplClass())) {
                result = extracted.getCapturingClass().replace('/', '.') + "::" + extracted.getImplMethodName();
            } else {
                throw new UnsupportedOperationException("Unable to introspect lambda " + lambda);
            }
        }
        return result;
    }

    private static String getExpressionHash(Object lambda) {
        try {
            Field expressionHash = lambda.getClass().getDeclaredField("EXPRESSION_HASH");
            return (String)expressionHash.get(lambda);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private static SerializedLambda extractLambda(Serializable lambda) {
        try {
            Method method = lambda.getClass().getDeclaredMethod("writeReplace", new Class[0]);
            method.setAccessible(true);
            return (SerializedLambda)method.invoke((Object)lambda, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Map<String, String> getFingerprintsForClass(Object lambda, SerializedLambda extracted) {
        ClassLoader lambdaClassLoader = lambda.getClass().getClassLoader();
        String className = extracted.getCapturingClass();
        if (CACHE_SIZE <= 0) {
            return LambdaIntrospector.getFingerPrints(lambdaClassLoader, className);
        }
        Map methodFingerprintsMap = methodFingerprintsMapPerClassLoader.computeIfAbsent(lambdaClassLoader, k -> new LinkedHashMap<String, Map<String, String>>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, Map<String, String>> eldest) {
                return this.size() > CACHE_SIZE;
            }
        });
        return methodFingerprintsMap.computeIfAbsent(className, k -> LambdaIntrospector.getFingerPrints(lambdaClassLoader, className));
    }

    private static Map<String, String> getFingerPrints(ClassLoader lambdaClassLoader, String className) {
        LambdaClassVisitor visitor = new LambdaClassVisitor();
        try (InputStream classStream = lambdaClassLoader.getResourceAsStream(className.replace('.', '/') + ".class");){
            ClassReader reader = new ClassReader(classStream);
            reader.accept((ClassVisitor)visitor, 6);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Map<String, String> fingerprints = visitor.getMethodsMap();
        return fingerprints;
    }

    private static class LambdaClassVisitor
    extends ClassVisitor {
        private final Map<String, String> methodsMap = new HashMap<String, String>();

        LambdaClassVisitor() {
            super(458752);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            return name.startsWith("lambda$") ? new DumpMethodVisitor(s -> this.setMethodFingerprint(name, (String)s)) : super.visitMethod(access, name, desc, signature, exceptions);
        }

        void setMethodFingerprint(String methodname, String methodFingerprint) {
            this.methodsMap.put(methodname, methodFingerprint);
        }

        Map<String, String> getMethodsMap() {
            return this.methodsMap;
        }
    }
}

