/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.client.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.kie.internal.process.CorrelationKey;
import org.kie.server.api.commands.CommandScript;
import org.kie.server.api.commands.DescriptorCommand;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.api.model.Wrapped;
import org.kie.server.api.model.definition.AssociatedEntitiesDefinition;
import org.kie.server.api.model.definition.ProcessDefinition;
import org.kie.server.api.model.definition.ProcessStartSpec;
import org.kie.server.api.model.definition.ServiceTasksDefinition;
import org.kie.server.api.model.definition.SubProcessesDefinition;
import org.kie.server.api.model.definition.TaskInputsDefinition;
import org.kie.server.api.model.definition.TaskOutputsDefinition;
import org.kie.server.api.model.definition.UserTaskDefinitionList;
import org.kie.server.api.model.definition.VariablesDefinition;
import org.kie.server.api.model.instance.NodeInstance;
import org.kie.server.api.model.instance.NodeInstanceList;
import org.kie.server.api.model.instance.ProcessInstance;
import org.kie.server.api.model.instance.ProcessInstanceList;
import org.kie.server.api.model.instance.VariableInstance;
import org.kie.server.api.model.instance.VariableInstanceList;
import org.kie.server.api.model.instance.WorkItemInstance;
import org.kie.server.api.model.instance.WorkItemInstanceList;
import org.kie.server.api.rest.RestURI;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.ProcessServicesClient;
import org.kie.server.client.impl.AbstractKieServicesClientImpl;

public class ProcessServicesClientImpl
extends AbstractKieServicesClientImpl
implements ProcessServicesClient {
    public ProcessServicesClientImpl(KieServicesConfiguration config) {
        super(config);
    }

    public ProcessServicesClientImpl(KieServicesConfiguration config, ClassLoader classLoader) {
        super(config, classLoader);
    }

    @Override
    public ProcessDefinition getProcessDefinition(String containerId, String processId) {
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("processId", processId);
            return this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{containerId}/processes/definitions/{processId}", valuesMap), ProcessDefinition.class);
        }
        CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("DefinitionService", "getProcessDefinition", new Object[]{containerId, processId})));
        ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
        this.throwExceptionOnFailure(response);
        if (this.shouldReturnWithNullResponse(response)) {
            return null;
        }
        return (ProcessDefinition)response.getResult();
    }

    @Override
    public SubProcessesDefinition getReusableSubProcessDefinitions(String containerId, String processId) {
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("processId", processId);
            return this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{containerId}/processes/definitions/{processId}/subprocesses", valuesMap), SubProcessesDefinition.class);
        }
        CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("DefinitionService", "getReusableSubProcesses", new Object[]{containerId, processId})));
        ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
        this.throwExceptionOnFailure(response);
        if (this.shouldReturnWithNullResponse(response)) {
            return null;
        }
        return (SubProcessesDefinition)response.getResult();
    }

    @Override
    public VariablesDefinition getProcessVariableDefinitions(String containerId, String processId) {
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("processId", processId);
            return this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{containerId}/processes/definitions/{processId}/variables", valuesMap), VariablesDefinition.class);
        }
        CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("DefinitionService", "getProcessVariables", new Object[]{containerId, processId})));
        ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
        this.throwExceptionOnFailure(response);
        if (this.shouldReturnWithNullResponse(response)) {
            return null;
        }
        return (VariablesDefinition)response.getResult();
    }

    @Override
    public ServiceTasksDefinition getServiceTaskDefinitions(String containerId, String processId) {
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("processId", processId);
            return this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{containerId}/processes/definitions/{processId}/tasks/service", valuesMap), ServiceTasksDefinition.class);
        }
        CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("DefinitionService", "getServiceTasks", new Object[]{containerId, processId})));
        ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
        this.throwExceptionOnFailure(response);
        if (this.shouldReturnWithNullResponse(response)) {
            return null;
        }
        return (ServiceTasksDefinition)response.getResult();
    }

    @Override
    public AssociatedEntitiesDefinition getAssociatedEntityDefinitions(String containerId, String processId) {
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("processId", processId);
            return this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{containerId}/processes/definitions/{processId}/entities", valuesMap), AssociatedEntitiesDefinition.class);
        }
        CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("DefinitionService", "getAssociatedEntities", new Object[]{containerId, processId})));
        ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
        this.throwExceptionOnFailure(response);
        if (this.shouldReturnWithNullResponse(response)) {
            return null;
        }
        return (AssociatedEntitiesDefinition)response.getResult();
    }

    @Override
    public UserTaskDefinitionList getUserTaskDefinitions(String containerId, String processId) {
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("processId", processId);
            return this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{containerId}/processes/definitions/{processId}/tasks/users", valuesMap), UserTaskDefinitionList.class);
        }
        CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("DefinitionService", "getTasksDefinitions", new Object[]{containerId, processId})));
        ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
        this.throwExceptionOnFailure(response);
        if (this.shouldReturnWithNullResponse(response)) {
            return null;
        }
        return (UserTaskDefinitionList)response.getResult();
    }

    @Override
    public TaskInputsDefinition getUserTaskInputDefinitions(String containerId, String processId, String taskName) {
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("processId", processId);
            valuesMap.put("taskName", this.encode(taskName));
            return this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{containerId}/processes/definitions/{processId}/tasks/users/{taskName}/inputs", valuesMap), TaskInputsDefinition.class);
        }
        CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("DefinitionService", "getTaskInputMappings", new Object[]{containerId, processId, taskName})));
        ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
        this.throwExceptionOnFailure(response);
        if (this.shouldReturnWithNullResponse(response)) {
            return null;
        }
        return (TaskInputsDefinition)response.getResult();
    }

    @Override
    public TaskOutputsDefinition getUserTaskOutputDefinitions(String containerId, String processId, String taskName) {
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("processId", processId);
            valuesMap.put("taskName", this.encode(taskName));
            return this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{containerId}/processes/definitions/{processId}/tasks/users/{taskName}/outputs", valuesMap), TaskOutputsDefinition.class);
        }
        CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("DefinitionService", "getTaskOutputMappings", new Object[]{containerId, processId, taskName})));
        ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
        this.throwExceptionOnFailure(response);
        if (this.shouldReturnWithNullResponse(response)) {
            return null;
        }
        return (TaskOutputsDefinition)response.getResult();
    }

    @Override
    public Long startProcess(String containerId, String processId) {
        return this.startProcess(containerId, processId, new HashMap<String, Object>());
    }

    @Override
    public Long startProcess(String containerId, String processId, Map<String, Object> variables) {
        Object result = null;
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("processId", processId);
            result = this.makeHttpPostRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{containerId}/processes/{processId}/instances", valuesMap), variables, Object.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("ProcessService", "startProcess", this.serialize(this.safeMap(variables)), this.marshaller.getFormat().getType(), new Object[]{containerId, processId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            result = this.deserialize((String)response.getResult(), Object.class);
        }
        if (result instanceof Wrapped) {
            return (Long)((Wrapped)result).unwrap();
        }
        return ((Number)result).longValue();
    }

    @Override
    public Map<String, Object> startSynchronousProcess(String containerId, String processId, Map<String, Object> variables) {
        Object result = null;
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("processId", processId);
            result = this.makeHttpPostRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{containerId}/processes/{processId}/syncInstances", valuesMap), variables, Object.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("ProcessService", "startSynchronousProcess", this.serialize(this.safeMap(variables)), this.marshaller.getFormat().getType(), new Object[]{containerId, processId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            result = this.deserialize((String)response.getResult(), Map.class);
        }
        return (Map)result;
    }

    @Override
    public Long startProcessFromNodeIds(String containerId, String processId, Map<String, Object> variables, String ... nodes) {
        Object result = null;
        ProcessStartSpec spec = new ProcessStartSpec();
        spec.setVariables(variables);
        spec.setNodeIds(Arrays.asList(nodes));
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("processId", processId);
            result = this.makeHttpPostRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{containerId}/processes/{processId}/instances/fromNodes", valuesMap), spec, Object.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("ProcessService", "startProcessFromNodeIds", this.serialize(spec), this.marshaller.getFormat().getType(), new Object[]{containerId, processId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            result = this.deserialize((String)response.getResult(), Object.class);
        }
        if (result instanceof Wrapped) {
            return (Long)((Wrapped)result).unwrap();
        }
        return ((Number)result).longValue();
    }

    @Override
    public Long startProcessFromNodeIds(String containerId, String processId, CorrelationKey correlationKey, Map<String, Object> variables, String ... nodes) {
        Object result = null;
        ProcessStartSpec spec = new ProcessStartSpec();
        spec.setVariables(variables);
        spec.setNodeIds(Arrays.asList(nodes));
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("processId", processId);
            valuesMap.put("correlationKey", correlationKey.toExternalForm());
            result = this.makeHttpPostRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{containerId}/processes/{processId}/instances/correlation/{correlationKey}/fromNodes", valuesMap), spec, Object.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("ProcessService", "startProcessWithCorrelationKeyFromNodeIds", this.serialize(spec), this.marshaller.getFormat().getType(), new Object[]{containerId, processId, correlationKey.toExternalForm()})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            result = this.deserialize((String)response.getResult(), Object.class);
        }
        if (result instanceof Wrapped) {
            return (Long)((Wrapped)result).unwrap();
        }
        return ((Number)result).longValue();
    }

    @Override
    public Long startProcess(String containerId, String processId, CorrelationKey correlationKey) {
        return this.startProcess(containerId, processId, correlationKey, null);
    }

    @Override
    public Long startProcess(String containerId, String processId, CorrelationKey correlationKey, Map<String, Object> variables) {
        Object result = null;
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("processId", processId);
            valuesMap.put("correlationKey", correlationKey.toExternalForm());
            result = this.makeHttpPostRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{containerId}/processes/{processId}/instances/correlation/{correlationKey}", valuesMap), variables, Object.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("ProcessService", "startProcessWithCorrelation", this.serialize(this.safeMap(variables)), this.marshaller.getFormat().getType(), new Object[]{containerId, processId, correlationKey.toExternalForm()})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            result = this.deserialize((String)response.getResult(), Object.class);
        }
        if (result instanceof Wrapped) {
            return (Long)((Wrapped)result).unwrap();
        }
        return ((Number)result).longValue();
    }

    @Override
    public void abortProcessInstance(String containerId, Long processInstanceId) {
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("processInstanceId", processInstanceId);
            this.makeHttpDeleteRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{containerId}/processes/instances/{processInstanceId}", valuesMap), null);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("ProcessService", "abortProcessInstance", new Object[]{containerId, processInstanceId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    @Override
    public void abortProcessInstances(String containerId, List<Long> processInstanceIds) {
        if (this.config.isRest()) {
            String queryStr = this.buildQueryString("instanceId", processInstanceIds);
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("containerId", containerId);
            this.makeHttpDeleteRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{containerId}/processes/instances", valuesMap) + queryStr, null);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("ProcessService", "abortProcessInstances", new Object[]{containerId, processInstanceIds})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    @Override
    public Object getProcessInstanceVariable(String containerId, Long processInstanceId, String variableName) {
        return this.getProcessInstanceVariable(containerId, processInstanceId, variableName, Object.class);
    }

    @Override
    public <T> T getProcessInstanceVariable(String containerId, Long processInstanceId, String variableName, Class<T> type) {
        T result = null;
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("processInstanceId", processInstanceId);
            valuesMap.put("varName", variableName);
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{containerId}/processes/instances/{processInstanceId}/variable/{varName}", valuesMap), type);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("ProcessService", "getProcessInstanceVariable", this.marshaller.getFormat().getType(), new Object[]{containerId, processInstanceId, variableName})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            result = this.deserialize((String)response.getResult(), type);
        }
        if (result instanceof Wrapped) {
            return (T)((Wrapped)result).unwrap();
        }
        return result;
    }

    @Override
    public Map<String, Object> getProcessInstanceVariables(String containerId, Long processInstanceId) {
        Object variables = null;
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("processInstanceId", processInstanceId);
            variables = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{containerId}/processes/instances/{processInstanceId}/variables", valuesMap), Object.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("ProcessService", "getProcessInstanceVariables", this.marshaller.getFormat().getType(), new Object[]{containerId, processInstanceId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            variables = this.deserialize((String)response.getResult(), Object.class);
        }
        if (variables instanceof Wrapped) {
            return (Map)((Wrapped)variables).unwrap();
        }
        return (Map)variables;
    }

    @Override
    public void signalProcessInstance(String containerId, Long processInstanceId, String signalName, Object event) {
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("processInstanceId", processInstanceId);
            valuesMap.put("signalName", signalName);
            HashMap<String, String> headers = new HashMap<String, String>();
            this.makeHttpPostRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{containerId}/processes/instances/{processInstanceId}/signal/{signalName}", valuesMap), event, String.class, headers);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("ProcessService", "signalProcessInstance", this.serialize(event), this.marshaller.getFormat().getType(), new Object[]{containerId, processInstanceId, signalName})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    @Override
    public void signalProcessInstances(String containerId, List<Long> processInstanceIds, String signalName, Object event) {
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("signalName", signalName);
            String queryStr = this.buildQueryString("instanceId", processInstanceIds);
            HashMap<String, String> headers = new HashMap<String, String>();
            this.makeHttpPostRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{containerId}/processes/instances/signal/{signalName}", valuesMap) + queryStr, event, String.class, headers);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("ProcessService", "signalProcessInstances", this.serialize(event), this.marshaller.getFormat().getType(), new Object[]{containerId, processInstanceIds, signalName})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    @Override
    public void signalProcessInstanceByCorrelationKey(String containerId, CorrelationKey correlationKey, String signalName, Object event) {
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("correlationKey", correlationKey.toExternalForm());
            valuesMap.put("signalName", signalName);
            HashMap<String, String> headers = new HashMap<String, String>();
            this.makeHttpPostRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{containerId}/processes/instances/correlation/{correlationKey}/signal/{signalName}", valuesMap), event, String.class, headers);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("ProcessService", "signalProcessInstanceByCorrelationKey", this.serialize(event), this.marshaller.getFormat().getType(), new Object[]{containerId, correlationKey.toExternalForm(), signalName})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    @Override
    public void signalProcessInstancesByCorrelationKeys(String containerId, List<CorrelationKey> correlationKeys, String signalName, Object event) {
        List keys = correlationKeys.stream().map(CorrelationKey::toExternalForm).collect(Collectors.toList());
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("signalName", signalName);
            String queryStr = this.buildQueryString("correlationKeys", keys);
            HashMap<String, String> headers = new HashMap<String, String>();
            this.makeHttpPostRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{containerId}/processes/instances/signal/{signalName}", valuesMap) + queryStr, event, String.class, headers);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("ProcessService", "signalProcessInstancesByCorrelationKey", this.serialize(event), this.marshaller.getFormat().getType(), new Object[]{containerId, keys, signalName})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    @Override
    public void signal(String containerId, String signalName, Object event) {
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("signalName", signalName);
            HashMap<String, String> headers = new HashMap<String, String>();
            this.makeHttpPostRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{containerId}/processes/instances/signal/{signalName}", valuesMap), event, String.class, headers);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("ProcessService", "signal", this.serialize(event), this.marshaller.getFormat().getType(), new Object[]{containerId, signalName})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    @Override
    public List<String> getAvailableSignals(String containerId, Long processInstanceId) {
        Object signals = null;
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("processInstanceId", processInstanceId);
            signals = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{containerId}/processes/instances/{processInstanceId}/signals", valuesMap), Object.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("ProcessService", "getAvailableSignals", this.marshaller.getFormat().getType(), new Object[]{containerId, processInstanceId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            signals = this.deserialize((String)response.getResult(), Object.class);
        }
        if (signals instanceof Wrapped) {
            return (List)((Wrapped)signals).unwrap();
        }
        return (List)signals;
    }

    @Override
    public void setProcessVariable(String containerId, Long processInstanceId, String variableId, Object value) {
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("processInstanceId", processInstanceId);
            valuesMap.put("varName", variableId);
            this.makeHttpPutRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{containerId}/processes/instances/{processInstanceId}/variable/{varName}", valuesMap), value, String.class, this.getHeaders(null));
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("ProcessService", "setProcessVariable", this.serialize(value), this.marshaller.getFormat().getType(), new Object[]{containerId, processInstanceId, variableId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    @Override
    public void setProcessVariables(String containerId, Long processInstanceId, Map<String, Object> variables) {
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("processInstanceId", processInstanceId);
            this.makeHttpPostRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{containerId}/processes/instances/{processInstanceId}/variables", valuesMap), variables, String.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("ProcessService", "setProcessVariables", this.serialize(variables), this.marshaller.getFormat().getType(), new Object[]{containerId, processInstanceId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    @Override
    public ProcessInstance getProcessInstance(String containerId, Long processInstanceId) {
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("processInstanceId", processInstanceId);
            return this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{containerId}/processes/instances/{processInstanceId}", valuesMap), ProcessInstance.class);
        }
        CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("ProcessService", "getProcessInstance", this.marshaller.getFormat().getType(), new Object[]{containerId, processInstanceId, false})));
        ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
        this.throwExceptionOnFailure(response);
        if (this.shouldReturnWithNullResponse(response)) {
            return null;
        }
        return this.deserialize((String)response.getResult(), ProcessInstance.class);
    }

    @Override
    public ProcessInstance getProcessInstance(String containerId, Long processInstanceId, boolean withVars) {
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("processInstanceId", processInstanceId);
            return this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{containerId}/processes/instances/{processInstanceId}", valuesMap) + "?withVars=" + withVars, ProcessInstance.class);
        }
        CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("ProcessService", "getProcessInstance", this.marshaller.getFormat().getType(), new Object[]{containerId, processInstanceId, withVars})));
        ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
        this.throwExceptionOnFailure(response);
        if (this.shouldReturnWithNullResponse(response)) {
            return null;
        }
        return this.deserialize((String)response.getResult(), ProcessInstance.class);
    }

    @Override
    public void completeWorkItem(String containerId, Long processInstanceId, Long id, Map<String, Object> results) {
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("processInstanceId", processInstanceId);
            valuesMap.put("workItemId", id);
            this.makeHttpPutRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{containerId}/processes/instances/{processInstanceId}/workitems/{workItemId}/completed", valuesMap), results, String.class, this.getHeaders(null));
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("ProcessService", "completeWorkItem", this.serialize(this.safeMap(results)), this.marshaller.getFormat().getType(), new Object[]{containerId, processInstanceId, id})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    @Override
    public void abortWorkItem(String containerId, Long processInstanceId, Long id) {
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("processInstanceId", processInstanceId);
            valuesMap.put("workItemId", id);
            this.makeHttpPutRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{containerId}/processes/instances/{processInstanceId}/workitems/{workItemId}/aborted", valuesMap), null, String.class, this.getHeaders(null));
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("ProcessService", "abortWorkItem", new Object[]{containerId, processInstanceId, id})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    @Override
    public WorkItemInstance getWorkItem(String containerId, Long processInstanceId, Long id) {
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("processInstanceId", processInstanceId);
            valuesMap.put("workItemId", id);
            return this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{containerId}/processes/instances/{processInstanceId}/workitems/{workItemId}", valuesMap), WorkItemInstance.class);
        }
        CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("ProcessService", "getWorkItem", this.marshaller.getFormat().getType(), new Object[]{containerId, processInstanceId, id})));
        ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
        this.throwExceptionOnFailure(response);
        if (this.shouldReturnWithNullResponse(response)) {
            return null;
        }
        return this.deserialize((String)response.getResult(), WorkItemInstance.class);
    }

    @Override
    public List<WorkItemInstance> getWorkItemByProcessInstance(String containerId, Long processInstanceId) {
        WorkItemInstanceList list = null;
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("processInstanceId", processInstanceId);
            list = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{containerId}/processes/instances/{processInstanceId}/workitems", valuesMap), WorkItemInstanceList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("ProcessService", "getWorkItemByProcessInstance", this.marshaller.getFormat().getType(), new Object[]{containerId, processInstanceId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            list = this.deserialize((String)response.getResult(), WorkItemInstanceList.class);
        }
        if (list != null && list.getWorkItems() != null) {
            return Arrays.asList(list.getWorkItems());
        }
        return Collections.emptyList();
    }

    @Override
    public List<NodeInstance> findActiveNodeInstances(String containerId, Long processInstanceId, Integer page, Integer pageSize) {
        NodeInstanceList result = null;
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("processInstanceId", processInstanceId);
            String queryString = this.getPagingQueryString("?activeOnly=true", page, pageSize);
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{containerId}/processes/instances/{processInstanceId}/nodes/instances", valuesMap) + queryString, NodeInstanceList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryService", "getProcessInstanceHistory", new Object[]{processInstanceId, true, false, page, pageSize})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            result = (NodeInstanceList)response.getResult();
        }
        if (result != null && result.getNodeInstances() != null) {
            return Arrays.asList(result.getNodeInstances());
        }
        return Collections.emptyList();
    }

    @Override
    public List<NodeInstance> findCompletedNodeInstances(String containerId, Long processInstanceId, Integer page, Integer pageSize) {
        NodeInstanceList result = null;
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("processInstanceId", processInstanceId);
            String queryString = this.getPagingQueryString("?completedOnly=true", page, pageSize);
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{containerId}/processes/instances/{processInstanceId}/nodes/instances", valuesMap) + queryString, NodeInstanceList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryService", "getProcessInstanceHistory", new Object[]{processInstanceId, false, true, page, pageSize})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            result = (NodeInstanceList)response.getResult();
        }
        if (result != null && result.getNodeInstances() != null) {
            return Arrays.asList(result.getNodeInstances());
        }
        return Collections.emptyList();
    }

    @Override
    public List<NodeInstance> findNodeInstancesByType(String containerId, Long processInstanceId, String entryType, Integer page, Integer pageSize) {
        NodeInstanceList result = null;
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("processInstanceId", processInstanceId);
            String queryString = this.getPagingQueryString("?processInstanceHistoryType=" + entryType, page, pageSize);
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{containerId}/processes/instances/{processInstanceId}/nodes/instances", valuesMap) + queryString, NodeInstanceList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryService", "getProcessInstanceFullHistoryByType", new Object[]{processInstanceId, entryType, page, pageSize})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            result = (NodeInstanceList)response.getResult();
        }
        if (result != null && result.getNodeInstances() != null) {
            return Arrays.asList(result.getNodeInstances());
        }
        return Collections.emptyList();
    }

    @Override
    public List<NodeInstance> findNodeInstances(String containerId, Long processInstanceId, Integer page, Integer pageSize) {
        NodeInstanceList result = null;
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("processInstanceId", processInstanceId);
            String queryString = this.getPagingQueryString("", page, pageSize);
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{containerId}/processes/instances/{processInstanceId}/nodes/instances", valuesMap) + queryString, NodeInstanceList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryService", "getProcessInstanceHistory", new Object[]{processInstanceId, true, true, page, pageSize})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            result = (NodeInstanceList)response.getResult();
        }
        if (result != null && result.getNodeInstances() != null) {
            return Arrays.asList(result.getNodeInstances());
        }
        return Collections.emptyList();
    }

    @Override
    public List<VariableInstance> findVariablesCurrentState(String containerId, Long processInstanceId) {
        VariableInstanceList result = null;
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("processInstanceId", processInstanceId);
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{containerId}/processes/instances/{processInstanceId}/variables/instances", valuesMap), VariableInstanceList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryService", "getVariablesCurrentState", new Object[]{processInstanceId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            result = (VariableInstanceList)response.getResult();
        }
        if (result != null && result.getVariableInstances() != null) {
            return Arrays.asList(result.getVariableInstances());
        }
        return Collections.emptyList();
    }

    @Override
    public List<VariableInstance> findVariableHistory(String containerId, Long processInstanceId, String variableName, Integer page, Integer pageSize) {
        VariableInstanceList result = null;
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("processInstanceId", processInstanceId);
            valuesMap.put("varName", variableName);
            String queryString = this.getPagingQueryString("", page, pageSize);
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{containerId}/processes/instances/{processInstanceId}/variables/instances/{varName}", valuesMap) + queryString, VariableInstanceList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryService", "getVariableHistory", new Object[]{processInstanceId, variableName, page, pageSize})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            result = (VariableInstanceList)response.getResult();
        }
        if (result != null && result.getVariableInstances() != null) {
            return Arrays.asList(result.getVariableInstances());
        }
        return Collections.emptyList();
    }

    @Override
    public List<ProcessInstance> findProcessInstancesByParent(String containerId, Long parentProcessInstanceId, Integer page, Integer pageSize) {
        return this.findProcessInstancesByParent(containerId, parentProcessInstanceId, null, page, pageSize);
    }

    @Override
    public List<ProcessInstance> findProcessInstancesByParent(String containerId, Long parentProcessInstanceId, List<Integer> status, Integer page, Integer pageSize) {
        return this.findProcessInstancesByParent(containerId, parentProcessInstanceId, status, page, pageSize, "", true);
    }

    @Override
    public List<ProcessInstance> findProcessInstancesByParent(String containerId, Long parentProcessInstanceId, List<Integer> status, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        ProcessInstanceList result = null;
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("processInstanceId", parentProcessInstanceId);
            String statusQueryString = this.getAdditionalParams("?sort=" + sort + "&sortOrder=" + sortOrder, "status", status);
            String queryString = this.getPagingQueryString(statusQueryString, page, pageSize);
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{containerId}/processes/instances/{processInstanceId}/processes", valuesMap) + queryString, ProcessInstanceList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("ProcessService", "getProcessInstancesByParent", new Object[]{parentProcessInstanceId, this.safeList(status), page, pageSize, sort, sortOrder})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            result = (ProcessInstanceList)response.getResult();
        }
        if (result != null && result.getProcessInstances() != null) {
            return Arrays.asList(result.getProcessInstances());
        }
        return Collections.emptyList();
    }

    @Override
    public List<ProcessInstance> findProcessInstances(String containerId, Integer page, Integer pageSize) {
        return this.findProcessInstances(containerId, page, pageSize, "", true);
    }

    @Override
    public List<ProcessInstance> findProcessInstances(String containerId, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        ProcessInstanceList result = null;
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("containerId", containerId);
            String queryString = this.getPagingQueryString("?sort=" + sort + "&sortOrder=" + sortOrder, page, pageSize);
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{containerId}/processes/instances", valuesMap) + queryString, ProcessInstanceList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryService", "getProcessInstances", new Object[]{new ArrayList(), "", "", page, pageSize, sort, sortOrder})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            result = (ProcessInstanceList)response.getResult();
        }
        if (result != null && result.getProcessInstances() != null) {
            return Arrays.asList(result.getProcessInstances());
        }
        return Collections.emptyList();
    }
}

