/*
 * Decompiled with CFR 0.152.
 */
package ch.obermuhlner.math.big;

import ch.obermuhlner.math.big.BigDecimalMath;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;

public class BigFloat
implements Comparable<BigFloat> {
    private final BigDecimal value;
    private final Context context;

    private BigFloat(BigDecimal value, Context context) {
        this.value = value;
        this.context = context;
    }

    public BigFloat add(BigFloat x) {
        Context c = BigFloat.max(this.context, x.context);
        return c.valueOf(this.value.add(x.value, c.mathContext));
    }

    public BigFloat add(BigDecimal x) {
        return this.add(this.context.valueOf(x));
    }

    public BigFloat add(int x) {
        return this.add(this.context.valueOf(x));
    }

    public BigFloat add(long x) {
        return this.add(this.context.valueOf(x));
    }

    public BigFloat add(double x) {
        return this.add(this.context.valueOf(x));
    }

    public BigFloat subtract(BigFloat x) {
        Context c = BigFloat.max(this.context, x.context);
        return c.valueOf(this.value.subtract(x.value, c.mathContext));
    }

    public BigFloat subtract(BigDecimal x) {
        return this.subtract(this.context.valueOf(x));
    }

    public BigFloat subtract(int x) {
        return this.subtract(this.context.valueOf(x));
    }

    public BigFloat subtract(long x) {
        return this.subtract(this.context.valueOf(x));
    }

    public BigFloat subtract(double x) {
        return this.subtract(this.context.valueOf(x));
    }

    public BigFloat multiply(BigFloat x) {
        Context c = BigFloat.max(this.context, x.context);
        return c.valueOf(this.value.multiply(x.value, c.mathContext));
    }

    public BigFloat multiply(BigDecimal x) {
        return this.multiply(this.context.valueOf(x));
    }

    public BigFloat multiply(int x) {
        return this.multiply(this.context.valueOf(x));
    }

    public BigFloat multiply(long x) {
        return this.multiply(this.context.valueOf(x));
    }

    public BigFloat multiply(double x) {
        return this.multiply(this.context.valueOf(x));
    }

    public BigFloat divide(BigFloat x) {
        Context c = BigFloat.max(this.context, x.context);
        return c.valueOf(this.value.divide(x.value, c.mathContext));
    }

    public BigFloat divide(BigDecimal x) {
        return this.divide(this.context.valueOf(x));
    }

    public BigFloat divide(int x) {
        return this.divide(this.context.valueOf(x));
    }

    public BigFloat divide(long x) {
        return this.divide(this.context.valueOf(x));
    }

    public BigFloat divide(double x) {
        return this.divide(this.context.valueOf(x));
    }

    public BigFloat remainder(BigFloat x) {
        Context c = BigFloat.max(this.context, x.context);
        return c.valueOf(this.value.remainder(x.value, c.mathContext));
    }

    public BigFloat remainder(BigDecimal x) {
        return this.remainder(this.context.valueOf(x));
    }

    public BigFloat remainder(int x) {
        return this.remainder(this.context.valueOf(x));
    }

    public BigFloat remainder(long x) {
        return this.remainder(this.context.valueOf(x));
    }

    public BigFloat remainder(double x) {
        return this.remainder(this.context.valueOf(x));
    }

    public BigFloat pow(BigFloat y) {
        Context c = BigFloat.max(this.context, y.context);
        return c.valueOf(BigDecimalMath.pow(this.value, y.value, c.mathContext));
    }

    public BigFloat pow(BigDecimal y) {
        return this.pow(this.context.valueOf(y));
    }

    public BigFloat pow(int y) {
        return this.pow(this.context.valueOf(y));
    }

    public BigFloat pow(long y) {
        return this.pow(this.context.valueOf(y));
    }

    public BigFloat pow(double y) {
        return this.pow(this.context.valueOf(y));
    }

    public BigFloat root(BigFloat y) {
        Context c = BigFloat.max(this.context, y.context);
        return c.valueOf(BigDecimalMath.root(this.value, y.value, c.mathContext));
    }

    public BigFloat root(BigDecimal y) {
        return this.root(this.context.valueOf(y));
    }

    public BigFloat root(int y) {
        return this.root(this.context.valueOf(y));
    }

    public BigFloat root(long y) {
        return this.root(this.context.valueOf(y));
    }

    public BigFloat root(double y) {
        return this.root(this.context.valueOf(y));
    }

    public int hashCode() {
        return this.value.stripTrailingZeros().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BigFloat other = (BigFloat)obj;
        return this.value.compareTo(other.value) == 0;
    }

    public int signum() {
        return this.value.signum();
    }

    public boolean isNegative() {
        return this.value.signum() < 0;
    }

    public boolean isZero() {
        return this.value.signum() == 0;
    }

    public boolean isPositive() {
        return this.value.signum() > 0;
    }

    @Override
    public int compareTo(BigFloat other) {
        return this.value.compareTo(other.value);
    }

    public boolean isEqual(BigFloat other) {
        return this.compareTo(other) == 0;
    }

    public boolean isLessThan(BigFloat other) {
        return this.compareTo(other) < 0;
    }

    public boolean isGreaterThan(BigFloat other) {
        return this.compareTo(other) > 0;
    }

    public boolean isLessThanOrEqual(BigFloat other) {
        return this.compareTo(other) <= 0;
    }

    public boolean isGreaterThanOrEqual(BigFloat other) {
        return this.compareTo(other) >= 0;
    }

    public boolean isIntValue() {
        return BigDecimalMath.isIntValue(this.value);
    }

    public boolean isDoubleValue() {
        return BigDecimalMath.isDoubleValue(this.value);
    }

    public BigFloat getMantissa() {
        return this.context.valueOf(BigDecimalMath.mantissa(this.value));
    }

    public BigFloat getExponent() {
        return this.context.valueOf(BigDecimalMath.exponent(this.value));
    }

    public BigFloat getIntegralPart() {
        return this.context.valueOf(BigDecimalMath.integralPart(this.value));
    }

    public BigFloat getFractionalPart() {
        return this.context.valueOf(BigDecimalMath.fractionalPart(this.value));
    }

    public Context getContext() {
        return this.context;
    }

    public BigDecimal toBigDecimal() {
        return this.value;
    }

    public double toDouble() {
        return this.value.doubleValue();
    }

    public long toLong() {
        return this.value.longValue();
    }

    public int toInt() {
        return this.value.intValue();
    }

    public String toString() {
        return this.value.toString();
    }

    public static Context context(int precision) {
        return new Context(new MathContext(precision));
    }

    public static Context context(MathContext mathContext) {
        return new Context(mathContext);
    }

    public static BigFloat negate(BigFloat x) {
        return x.context.valueOf(x.value.negate());
    }

    public static BigFloat abs(BigFloat x) {
        return x.context.valueOf(x.value.abs());
    }

    public static BigFloat max(BigFloat value1, BigFloat value2) {
        return value1.compareTo(value2) >= 0 ? value1 : value2;
    }

    public static BigFloat max(BigFloat value1, BigFloat ... values) {
        BigFloat result = value1;
        for (BigFloat other : values) {
            result = BigFloat.max(result, other);
        }
        return result;
    }

    public static BigFloat min(BigFloat value1, BigFloat value2) {
        return value1.compareTo(value2) < 0 ? value1 : value2;
    }

    public static BigFloat min(BigFloat value1, BigFloat ... values) {
        BigFloat result = value1;
        for (BigFloat other : values) {
            result = BigFloat.min(result, other);
        }
        return result;
    }

    public static BigFloat log(BigFloat x) {
        return x.context.valueOf(BigDecimalMath.log(x.value, x.context.mathContext));
    }

    public static BigFloat log2(BigFloat x) {
        return x.context.valueOf(BigDecimalMath.log2(x.value, x.context.mathContext));
    }

    public static BigFloat log10(BigFloat x) {
        return x.context.valueOf(BigDecimalMath.log10(x.value, x.context.mathContext));
    }

    public static BigFloat exp(BigFloat x) {
        return x.context.valueOf(BigDecimalMath.exp(x.value, x.context.mathContext));
    }

    public static BigFloat sqrt(BigFloat x) {
        return x.context.valueOf(BigDecimalMath.sqrt(x.value, x.context.mathContext));
    }

    public static BigFloat pow(BigFloat x, BigFloat y) {
        Context c = BigFloat.max(x.context, y.context);
        return c.valueOf(BigDecimalMath.pow(x.value, y.value, c.mathContext));
    }

    public static BigFloat root(BigFloat x, BigFloat y) {
        Context c = BigFloat.max(x.context, y.context);
        return c.valueOf(BigDecimalMath.root(x.value, y.value, c.mathContext));
    }

    public static BigFloat sin(BigFloat x) {
        return x.context.valueOf(BigDecimalMath.sin(x.value, x.context.mathContext));
    }

    public static BigFloat cos(BigFloat x) {
        return x.context.valueOf(BigDecimalMath.cos(x.value, x.context.mathContext));
    }

    public static BigFloat tan(BigFloat x) {
        return x.context.valueOf(BigDecimalMath.tan(x.value, x.context.mathContext));
    }

    public static BigFloat cot(BigFloat x) {
        return x.context.valueOf(BigDecimalMath.cot(x.value, x.context.mathContext));
    }

    public static BigFloat asin(BigFloat x) {
        return x.context.valueOf(BigDecimalMath.asin(x.value, x.context.mathContext));
    }

    public static BigFloat acos(BigFloat x) {
        return x.context.valueOf(BigDecimalMath.acos(x.value, x.context.mathContext));
    }

    public static BigFloat atan(BigFloat x) {
        return x.context.valueOf(BigDecimalMath.atan(x.value, x.context.mathContext));
    }

    public static BigFloat acot(BigFloat x) {
        return x.context.valueOf(BigDecimalMath.acot(x.value, x.context.mathContext));
    }

    public static BigFloat sinh(BigFloat x) {
        return x.context.valueOf(BigDecimalMath.sinh(x.value, x.context.mathContext));
    }

    public static BigFloat cosh(BigFloat x) {
        return x.context.valueOf(BigDecimalMath.cosh(x.value, x.context.mathContext));
    }

    public static BigFloat tanh(BigFloat x) {
        return x.context.valueOf(BigDecimalMath.tanh(x.value, x.context.mathContext));
    }

    public static BigFloat coth(BigFloat x) {
        return x.context.valueOf(BigDecimalMath.coth(x.value, x.context.mathContext));
    }

    public static BigFloat asinh(BigFloat x) {
        return x.context.valueOf(BigDecimalMath.asinh(x.value, x.context.mathContext));
    }

    public static BigFloat acosh(BigFloat x) {
        return x.context.valueOf(BigDecimalMath.acosh(x.value, x.context.mathContext));
    }

    public static BigFloat atanh(BigFloat x) {
        return x.context.valueOf(BigDecimalMath.atanh(x.value, x.context.mathContext));
    }

    public static BigFloat acoth(BigFloat x) {
        return x.context.valueOf(BigDecimalMath.acoth(x.value, x.context.mathContext));
    }

    private static Context max(Context left, Context right) {
        return left.mathContext.getPrecision() > right.mathContext.getPrecision() ? left : right;
    }

    public static class Context {
        private final MathContext mathContext;

        private Context(MathContext mathContext) {
            this.mathContext = mathContext;
        }

        public MathContext getMathContext() {
            return this.mathContext;
        }

        public int getPrecision() {
            return this.mathContext.getPrecision();
        }

        public RoundingMode getRoundingMode() {
            return this.mathContext.getRoundingMode();
        }

        public BigFloat valueOf(BigFloat value) {
            return new BigFloat(value.value.round(this.mathContext), this);
        }

        public BigFloat valueOf(BigDecimal value) {
            return new BigFloat(value.round(this.mathContext), this);
        }

        public BigFloat valueOf(int value) {
            return new BigFloat(new BigDecimal(value, this.mathContext), this);
        }

        public BigFloat valueOf(long value) {
            return new BigFloat(new BigDecimal(value, this.mathContext), this);
        }

        public BigFloat valueOf(double value) {
            return new BigFloat(new BigDecimal(String.valueOf(value), this.mathContext), this);
        }

        public BigFloat valueOf(String value) {
            return new BigFloat(new BigDecimal(value, this.mathContext), this);
        }

        public BigFloat pi() {
            return this.valueOf(BigDecimalMath.pi(this.mathContext));
        }

        public BigFloat e() {
            return this.valueOf(BigDecimalMath.e(this.mathContext));
        }

        public BigFloat factorial(int n) {
            return this.valueOf(BigDecimalMath.factorial(n));
        }

        public int hashCode() {
            return this.mathContext.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Context other = (Context)obj;
            return this.mathContext.equals(other.mathContext);
        }

        public String toString() {
            return this.mathContext.toString();
        }
    }
}

