/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.constraint;

import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Set;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.constraint.ConstraintMatch;

public final class Indictment
implements Serializable,
Comparable<Indictment> {
    protected final Object justification;
    protected final Set<ConstraintMatch> constraintMatchSet;
    protected Score scoreTotal;

    public Indictment(Object justification, Score zeroScore) {
        this.justification = justification;
        this.constraintMatchSet = new LinkedHashSet<ConstraintMatch>();
        this.scoreTotal = zeroScore;
    }

    public Object getJustification() {
        return this.justification;
    }

    public Set<ConstraintMatch> getConstraintMatchSet() {
        return this.constraintMatchSet;
    }

    public int getConstraintMatchCount() {
        return this.getConstraintMatchSet().size();
    }

    public Score getScoreTotal() {
        return this.scoreTotal;
    }

    public void addConstraintMatch(ConstraintMatch constraintMatch) {
        this.scoreTotal = this.scoreTotal.add(constraintMatch.getScore());
        boolean added = this.constraintMatchSet.add(constraintMatch);
        if (!added) {
            throw new IllegalStateException("The indictment (" + this + ") could not add constraintMatch (" + constraintMatch + ") to its constraintMatchSet (" + this.constraintMatchSet + ").");
        }
    }

    public void removeConstraintMatch(ConstraintMatch constraintMatch) {
        this.scoreTotal = this.scoreTotal.subtract(constraintMatch.getScore());
        boolean removed = this.constraintMatchSet.remove(constraintMatch);
        if (!removed) {
            throw new IllegalStateException("The indictment (" + this + ") could not remove constraintMatch (" + constraintMatch + ") from its constraintMatchSet (" + this.constraintMatchSet + ").");
        }
    }

    @Override
    public int compareTo(Indictment other) {
        if (!(this.justification instanceof Comparable)) {
            throw new IllegalStateException("The justification (" + this.justification + ") does not implement " + Comparable.class.getSimpleName() + ", so it cannot be compared with otherJustification (" + other.justification + ").");
        }
        return ((Comparable)this.justification).compareTo(other.justification);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Indictment) {
            Indictment other = (Indictment)o;
            return this.justification.equals(other.justification);
        }
        return false;
    }

    public int hashCode() {
        return this.justification.hashCode();
    }

    public String toString() {
        return this.justification + "=" + this.scoreTotal;
    }
}

