/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.localsearch.decider.forager;

import java.util.List;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.config.localsearch.decider.forager.LocalSearchPickEarlyType;
import org.optaplanner.core.impl.localsearch.decider.forager.AbstractForager;
import org.optaplanner.core.impl.localsearch.decider.forager.finalist.FinalistPodium;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchMoveScope;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchPhaseScope;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchStepScope;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;

public class AcceptedForager
extends AbstractForager {
    protected final FinalistPodium finalistPodium;
    protected final LocalSearchPickEarlyType pickEarlyType;
    protected final int acceptedCountLimit;
    protected final boolean breakTieRandomly;
    protected long selectedMoveCount;
    protected long acceptedMoveCount;
    protected LocalSearchMoveScope earlyPickedMoveScope;

    public AcceptedForager(FinalistPodium finalistPodium, LocalSearchPickEarlyType pickEarlyType, int acceptedCountLimit, boolean breakTieRandomly) {
        this.finalistPodium = finalistPodium;
        this.pickEarlyType = pickEarlyType;
        this.acceptedCountLimit = acceptedCountLimit;
        if (acceptedCountLimit < 1) {
            throw new IllegalArgumentException("The acceptedCountLimit (" + acceptedCountLimit + ") cannot be negative or zero.");
        }
        this.breakTieRandomly = breakTieRandomly;
    }

    @Override
    public void solvingStarted(DefaultSolverScope solverScope) {
        super.solvingStarted(solverScope);
        this.finalistPodium.solvingStarted(solverScope);
    }

    public void phaseStarted(LocalSearchPhaseScope phaseScope) {
        super.phaseStarted(phaseScope);
        this.finalistPodium.phaseStarted(phaseScope);
    }

    public void stepStarted(LocalSearchStepScope stepScope) {
        super.stepStarted(stepScope);
        this.finalistPodium.stepStarted(stepScope);
        this.selectedMoveCount = 0L;
        this.acceptedMoveCount = 0L;
        this.earlyPickedMoveScope = null;
    }

    @Override
    public boolean supportsNeverEndingMoveSelector() {
        return this.acceptedCountLimit < Integer.MAX_VALUE;
    }

    @Override
    public void addMove(LocalSearchMoveScope moveScope) {
        ++this.selectedMoveCount;
        if (moveScope.getAccepted().booleanValue()) {
            ++this.acceptedMoveCount;
            this.checkPickEarly(moveScope);
        }
        this.finalistPodium.addMove(moveScope);
    }

    protected void checkPickEarly(LocalSearchMoveScope moveScope) {
        switch (this.pickEarlyType) {
            case NEVER: {
                break;
            }
            case FIRST_BEST_SCORE_IMPROVING: {
                Score bestScore = moveScope.getStepScope().getPhaseScope().getBestScore();
                if (moveScope.getScore().compareTo(bestScore) <= 0) break;
                this.earlyPickedMoveScope = moveScope;
                break;
            }
            case FIRST_LAST_STEP_SCORE_IMPROVING: {
                Score lastStepScore = ((LocalSearchPhaseScope)moveScope.getStepScope().getPhaseScope()).getLastCompletedStepScope().getScore();
                if (moveScope.getScore().compareTo(lastStepScore) <= 0) break;
                this.earlyPickedMoveScope = moveScope;
                break;
            }
            default: {
                throw new IllegalStateException("The pickEarlyType (" + (Object)((Object)this.pickEarlyType) + ") is not implemented.");
            }
        }
    }

    @Override
    public boolean isQuitEarly() {
        return this.earlyPickedMoveScope != null || this.acceptedMoveCount >= (long)this.acceptedCountLimit;
    }

    @Override
    public LocalSearchMoveScope pickMove(LocalSearchStepScope stepScope) {
        stepScope.setSelectedMoveCount(this.selectedMoveCount);
        stepScope.setAcceptedMoveCount(this.acceptedMoveCount);
        if (this.earlyPickedMoveScope != null) {
            return this.earlyPickedMoveScope;
        }
        List<LocalSearchMoveScope> finalistList = this.finalistPodium.getFinalistList();
        if (finalistList.isEmpty()) {
            return null;
        }
        if (finalistList.size() == 1 || !this.breakTieRandomly) {
            return finalistList.get(0);
        }
        int randomIndex = stepScope.getWorkingRandom().nextInt(finalistList.size());
        return finalistList.get(randomIndex);
    }

    public void stepEnded(LocalSearchStepScope stepScope) {
        super.stepEnded(stepScope);
        this.finalistPodium.stepEnded(stepScope);
    }

    public void phaseEnded(LocalSearchPhaseScope phaseScope) {
        super.phaseEnded(phaseScope);
        this.finalistPodium.phaseEnded(phaseScope);
        this.selectedMoveCount = 0L;
        this.acceptedMoveCount = 0L;
        this.earlyPickedMoveScope = null;
    }

    @Override
    public void solvingEnded(DefaultSolverScope solverScope) {
        super.solvingEnded(solverScope);
        this.finalistPodium.solvingEnded(solverScope);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + (Object)((Object)this.pickEarlyType) + ", " + this.acceptedCountLimit + ")";
    }
}

