/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.assistant;

import org.drools.ide.common.assistant.engine.DRLParserEngine;
import org.drools.ide.common.assistant.info.drl.DRLRuleRefactorInfo;
import org.drools.ide.common.assistant.info.drl.RuleBasicContentInfo;
import org.drools.ide.common.assistant.option.AssistantOption;
import org.drools.ide.common.assistant.option.RenameAssistantOption;
import org.drools.ide.common.assistant.refactor.drl.VariableRename;
import org.junit.Assert;
import org.junit.Test;

public class VariableRenameTest {
    private DRLParserEngine engine;
    private DRLRuleRefactorInfo info;

    @Test
    public void test() {
        String rule = "package com.sample\n\n";
        rule = rule + "import com.sample.DroolsTest.Message;\n\n";
        rule = rule + "rule \"Hello World\"\n";
        rule = rule + "    when\n";
        rule = rule + "        m : Message( $status : status == Message.HELLO, message :message )\n";
        rule = rule + "        $m2 : Message( message2 :message )";
        rule = rule + "    then\n";
        rule = rule + "        System.out.println( message ); \n";
        rule = rule + "        System.out.println(message ); \n";
        rule = rule + "        System.out.println( message); \n";
        rule = rule + "        System.out.println(message); \n";
        rule = rule + "        $m.setMessage( \"Goodbye cruel world\", message);\n";
        rule = rule + "        $m.setMessage( \"Goodbye cruel world\" +message);\n";
        rule = rule + "        $m.setMessage( \"Goodbye cruel world\" + message );\n";
        rule = rule + "        $m.setStatus( Message.GOODBYE );\n";
        rule = rule + "        update( $m ) ;\n";
        rule = rule + "end";
        this.engine = new DRLParserEngine(rule);
        this.info = (DRLRuleRefactorInfo)this.engine.parse();
        RuleBasicContentInfo content = this.info.getContentAt(87);
        RenameAssistantOption assistantOption = new RenameAssistantOption("rename variable", "message", content, Integer.valueOf(87));
        AssistantOption result = VariableRename.execute((RenameAssistantOption)assistantOption, (String)"msg");
        Assert.assertTrue((boolean)result.getContent().contains("m : Message( $status : status == Message.HELLO, msg :message )"));
        Assert.assertTrue((boolean)result.getContent().contains("System.out.println( msg );"));
        Assert.assertTrue((boolean)result.getContent().contains("System.out.println(msg );"));
        Assert.assertTrue((boolean)result.getContent().contains("System.out.println( msg);"));
        Assert.assertTrue((boolean)result.getContent().contains("$m.setMessage( \"Goodbye cruel world\" + msg );"));
    }
}

