/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.modeldriven;

import org.drools.ide.common.client.modeldriven.brl.DSLSentence;
import org.junit.Assert;
import org.junit.Test;

public class DSLSentenceTest {
    @Test
    public void testSentence() {
        DSLSentence sen = new DSLSentence();
        sen.sentence = "this is {something} here and {here}";
        Assert.assertEquals((Object)"this is something here and here", (Object)sen.toString());
        sen.sentence = "foo bar";
        Assert.assertEquals((Object)"foo bar", (Object)sen.toString());
        DSLSentence newOne = sen.copy();
        Assert.assertFalse((newOne == sen ? 1 : 0) != 0);
        Assert.assertEquals((Object)newOne.sentence, (Object)sen.sentence);
    }

    @Test
    public void testEnumSentence() {
        DSLSentence sen = new DSLSentence();
        sen.sentence = "this is {variable:ENUM:Value.test} here and {here}";
        Assert.assertEquals((Object)"this is variable here and here", (Object)sen.toString());
    }

    @Test
    public void testLogColonSentence() {
        DSLSentence sen = new DSLSentence();
        sen.sentence = "Log : \"{message}\"";
        Assert.assertEquals((Object)"Log : \"message\"", (Object)sen.toString());
    }

    @Test
    public void testWithNewLines() {
        DSLSentence sen = new DSLSentence();
        sen.sentence = "this is {variable}\\n here and {here}";
        Assert.assertEquals((Object)"this is variable\n here and here", (Object)sen.toString());
    }
}

