/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.server.util;

import java.math.BigDecimal;
import java.util.List;
import org.drools.ide.common.client.modeldriven.dt.ActionInsertFactCol;
import org.drools.ide.common.client.modeldriven.dt.ActionRetractFactCol;
import org.drools.ide.common.client.modeldriven.dt.ActionSetFieldCol;
import org.drools.ide.common.client.modeldriven.dt.AttributeCol;
import org.drools.ide.common.client.modeldriven.dt.ConditionCol;
import org.drools.ide.common.client.modeldriven.dt.DTCellValue;
import org.drools.ide.common.client.modeldriven.dt.GuidedDecisionTable;
import org.drools.ide.common.client.modeldriven.dt.MetadataCol;
import org.drools.ide.common.client.modeldriven.dt.TypeSafeGuidedDecisionTable;
import org.drools.ide.common.server.util.RepositoryUpgradeHelper;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuidedDTModelConversionTest {
    @Test
    public void testConversion() {
        GuidedDecisionTable dt = new GuidedDecisionTable();
        dt.setTableName("michael");
        MetadataCol md = new MetadataCol();
        md.setMetadata("legacy");
        md.setDefaultValue("yes");
        dt.getMetadataCols().add(md);
        AttributeCol attr = new AttributeCol();
        attr.setAttribute("salience");
        attr.setDefaultValue("66");
        dt.getAttributeCols().add(attr);
        ConditionCol con = new ConditionCol();
        con.setBoundName("f1");
        con.setConstraintValueType(1);
        con.setFactField("age");
        con.setFactType("Driver");
        con.setHeader("Driver f1 age");
        con.setOperator("==");
        dt.getConditionCols().add(con);
        ConditionCol con2 = new ConditionCol();
        con2.setBoundName("f1");
        con2.setConstraintValueType(1);
        con2.setFactField("name");
        con2.setFactType("Driver");
        con2.setHeader("Driver f1 name");
        con2.setOperator("==");
        dt.getConditionCols().add(con2);
        ConditionCol con3 = new ConditionCol();
        con3.setBoundName("f1");
        con3.setConstraintValueType(3);
        con3.setFactField("rating");
        con3.setFactType("Driver");
        con3.setHeader("Driver rating");
        con3.setOperator("==");
        dt.getConditionCols().add(con3);
        ConditionCol con4 = new ConditionCol();
        con4.setBoundName("f2");
        con4.setConstraintValueType(5);
        con4.setFactType("Driver");
        con4.setHeader("Driver 2 pimp");
        con4.setFactField("(not needed)");
        dt.getConditionCols().add(con4);
        ActionInsertFactCol ins = new ActionInsertFactCol();
        ins.setBoundName("ins");
        ins.setFactType("Cheese");
        ins.setFactField("price");
        ins.setType("Numeric");
        dt.getActionCols().add(ins);
        ActionRetractFactCol ret = new ActionRetractFactCol();
        ret.setBoundName("f2");
        dt.getActionCols().add(ret);
        ActionSetFieldCol set = new ActionSetFieldCol();
        set.setBoundName("f1");
        set.setFactField("goo1");
        set.setType("String");
        dt.getActionCols().add(set);
        ActionSetFieldCol set2 = new ActionSetFieldCol();
        set2.setBoundName("f1");
        set2.setFactField("goo2");
        set2.setDefaultValue("whee");
        set2.setType("String");
        dt.getActionCols().add(set2);
        dt.setData((String[][])new String[][]{{"1", "desc", "42", "33", "michael", "age * 0.2", "age > 7", "6.60", "true", "gooVal1", null}, {"2", "desc", "", "39", "bob", "age * 0.3", "age > 7", "6.60", "", "gooVal1", ""}});
        TypeSafeGuidedDecisionTable tsdt = RepositoryUpgradeHelper.convertGuidedDTModel((GuidedDecisionTable)dt);
        Assert.assertEquals((Object)"michael", (Object)tsdt.getTableName());
        Assert.assertEquals((long)1L, (long)tsdt.getMetadataCols().size());
        Assert.assertEquals((Object)"legacy", (Object)((MetadataCol)tsdt.getMetadataCols().get(0)).getMetadata());
        Assert.assertEquals((Object)"yes", (Object)((MetadataCol)tsdt.getMetadataCols().get(0)).getDefaultValue());
        Assert.assertEquals((long)1L, (long)tsdt.getAttributeCols().size());
        Assert.assertEquals((Object)"salience", (Object)((AttributeCol)tsdt.getAttributeCols().get(0)).getAttribute());
        Assert.assertEquals((Object)"66", (Object)((AttributeCol)tsdt.getAttributeCols().get(0)).getDefaultValue());
        Assert.assertEquals((long)4L, (long)tsdt.getConditionCols().size());
        Assert.assertEquals((Object)"f1", (Object)((ConditionCol)tsdt.getConditionCols().get(0)).getBoundName());
        Assert.assertEquals((long)1L, (long)((ConditionCol)tsdt.getConditionCols().get(0)).getConstraintValueType());
        Assert.assertEquals((Object)"age", (Object)((ConditionCol)tsdt.getConditionCols().get(0)).getFactField());
        Assert.assertEquals((Object)"Driver", (Object)((ConditionCol)tsdt.getConditionCols().get(0)).getFactType());
        Assert.assertEquals((Object)"Driver f1 age", (Object)((ConditionCol)tsdt.getConditionCols().get(0)).getHeader());
        Assert.assertEquals((Object)"==", (Object)((ConditionCol)tsdt.getConditionCols().get(0)).getOperator());
        Assert.assertEquals((Object)"f1", (Object)((ConditionCol)tsdt.getConditionCols().get(1)).getBoundName());
        Assert.assertEquals((long)1L, (long)((ConditionCol)tsdt.getConditionCols().get(1)).getConstraintValueType());
        Assert.assertEquals((Object)"name", (Object)((ConditionCol)tsdt.getConditionCols().get(1)).getFactField());
        Assert.assertEquals((Object)"Driver", (Object)((ConditionCol)tsdt.getConditionCols().get(1)).getFactType());
        Assert.assertEquals((Object)"Driver f1 name", (Object)((ConditionCol)tsdt.getConditionCols().get(1)).getHeader());
        Assert.assertEquals((Object)"==", (Object)((ConditionCol)tsdt.getConditionCols().get(1)).getOperator());
        Assert.assertEquals((Object)"f1", (Object)((ConditionCol)tsdt.getConditionCols().get(2)).getBoundName());
        Assert.assertEquals((long)3L, (long)((ConditionCol)tsdt.getConditionCols().get(2)).getConstraintValueType());
        Assert.assertEquals((Object)"rating", (Object)((ConditionCol)tsdt.getConditionCols().get(2)).getFactField());
        Assert.assertEquals((Object)"Driver", (Object)((ConditionCol)tsdt.getConditionCols().get(2)).getFactType());
        Assert.assertEquals((Object)"Driver rating", (Object)((ConditionCol)tsdt.getConditionCols().get(2)).getHeader());
        Assert.assertEquals((Object)"==", (Object)((ConditionCol)tsdt.getConditionCols().get(2)).getOperator());
        Assert.assertEquals((Object)"f2", (Object)((ConditionCol)tsdt.getConditionCols().get(3)).getBoundName());
        Assert.assertEquals((long)5L, (long)((ConditionCol)tsdt.getConditionCols().get(3)).getConstraintValueType());
        Assert.assertEquals((Object)"(not needed)", (Object)((ConditionCol)tsdt.getConditionCols().get(3)).getFactField());
        Assert.assertEquals((Object)"Driver", (Object)((ConditionCol)tsdt.getConditionCols().get(3)).getFactType());
        Assert.assertEquals((Object)"Driver 2 pimp", (Object)((ConditionCol)tsdt.getConditionCols().get(3)).getHeader());
        Assert.assertEquals((long)4L, (long)tsdt.getActionCols().size());
        ActionInsertFactCol a1 = (ActionInsertFactCol)tsdt.getActionCols().get(0);
        Assert.assertEquals((Object)"ins", (Object)a1.getBoundName());
        Assert.assertEquals((Object)"Cheese", (Object)a1.getFactType());
        Assert.assertEquals((Object)"price", (Object)a1.getFactField());
        Assert.assertEquals((Object)"Numeric", (Object)a1.getType());
        ActionRetractFactCol a2 = (ActionRetractFactCol)tsdt.getActionCols().get(1);
        Assert.assertEquals((Object)"f2", (Object)a2.getBoundName());
        ActionSetFieldCol a3 = (ActionSetFieldCol)tsdt.getActionCols().get(2);
        Assert.assertEquals((Object)"f1", (Object)a3.getBoundName());
        Assert.assertEquals((Object)"goo1", (Object)a3.getFactField());
        Assert.assertEquals((Object)"String", (Object)a3.getType());
        ActionSetFieldCol a4 = (ActionSetFieldCol)tsdt.getActionCols().get(3);
        Assert.assertEquals((Object)"f1", (Object)a4.getBoundName());
        Assert.assertEquals((Object)"goo2", (Object)a4.getFactField());
        Assert.assertEquals((Object)"whee", (Object)a4.getDefaultValue());
        Assert.assertEquals((Object)"String", (Object)a4.getType());
        Assert.assertEquals((long)2L, (long)tsdt.getData().size());
        this.isRowEquivalent((List)tsdt.getData().get(0), dt.getData()[0]);
        this.isRowEquivalent((List)tsdt.getData().get(1), dt.getData()[1]);
    }

    private void isRowEquivalent(List<DTCellValue> row, String[] array) {
        Assert.assertEquals((long)row.size(), (long)array.length);
        BigDecimal newRowNum = row.get(0).getNumericValue();
        BigDecimal oldRowNum = new BigDecimal(array[0]);
        Assert.assertEquals((Object)newRowNum, (Object)oldRowNum);
        for (int iCol = 1; iCol < row.size(); ++iCol) {
            DTCellValue cell = row.get(iCol);
            String v1 = cell.getStringValue();
            String v2 = array[iCol];
            Assert.assertTrue((boolean)this.isEqualOrNull(v1, v2));
            Assert.assertEquals((Object)v1, (Object)v2);
        }
    }

    private boolean isEqualOrNull(Object v1, Object v2) {
        if (v1 == null && v2 == null) {
            return true;
        }
        if (v1 != null && v2 == null) {
            return false;
        }
        if (v1 == null && v2 != null) {
            return false;
        }
        return v1.equals(v2);
    }
}

