/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.server.util;

import org.drools.ide.common.client.modeldriven.dt.ActionInsertFactCol;
import org.drools.ide.common.client.modeldriven.dt.ActionSetFieldCol;
import org.drools.ide.common.client.modeldriven.dt.AttributeCol;
import org.drools.ide.common.client.modeldriven.dt.ConditionCol;
import org.drools.ide.common.client.modeldriven.dt.MetadataCol;
import org.drools.ide.common.client.modeldriven.dt.TypeSafeGuidedDecisionTable;
import org.drools.ide.common.server.util.BRLPersistenceTest;
import org.drools.ide.common.server.util.GuidedDTXMLPersistence;
import org.drools.ide.common.server.util.RepositoryUpgradeHelper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GuidedDTXMLPersistenceTest {
    @Before
    public void setUp() throws Exception {
        GuidedDTXMLPersistence.getInstance();
    }

    @Test
    public void testRoundTrip() {
        TypeSafeGuidedDecisionTable dt = new TypeSafeGuidedDecisionTable();
        dt.getActionCols().add(new ActionInsertFactCol());
        ActionSetFieldCol set = new ActionSetFieldCol();
        set.setFactField("foo");
        dt.getActionCols().add(set);
        dt.getMetadataCols().add(new MetadataCol());
        dt.getAttributeCols().add(new AttributeCol());
        dt.getConditionCols().add(new ConditionCol());
        dt.setData(RepositoryUpgradeHelper.makeDataLists((String[][])new String[][]{{"1", "hola"}}));
        dt.setTableName("blah");
        String xml = GuidedDTXMLPersistence.getInstance().marshal(dt);
        System.out.println(xml);
        Assert.assertNotNull((Object)xml);
        Assert.assertEquals((long)-1L, (long)xml.indexOf("ActionSetField"));
        Assert.assertEquals((long)-1L, (long)xml.indexOf("ConditionCol"));
        Assert.assertEquals((long)-1L, (long)xml.indexOf("GuidedDecisionTable"));
        TypeSafeGuidedDecisionTable dt_ = GuidedDTXMLPersistence.getInstance().unmarshal(xml);
        Assert.assertNotNull((Object)dt_);
        Assert.assertEquals((Object)"blah", (Object)dt_.getTableName());
        Assert.assertEquals((long)1L, (long)dt_.getMetadataCols().size());
        Assert.assertEquals((long)1L, (long)dt_.getAttributeCols().size());
        Assert.assertEquals((long)2L, (long)dt_.getActionCols().size());
        Assert.assertEquals((long)1L, (long)dt_.getConditionCols().size());
    }

    @Test
    public void testBackwardsCompatability() throws Exception {
        String xml = BRLPersistenceTest.loadResource("ExistingDecisionTable.xml");
        TypeSafeGuidedDecisionTable dt_ = GuidedDTXMLPersistence.getInstance().unmarshal(xml);
        Assert.assertNotNull((Object)dt_);
        Assert.assertEquals((Object)"blah", (Object)dt_.getTableName());
        Assert.assertEquals((long)1L, (long)dt_.getMetadataCols().size());
        Assert.assertEquals((long)1L, (long)dt_.getAttributeCols().size());
        Assert.assertEquals((long)2L, (long)dt_.getActionCols().size());
        Assert.assertEquals((long)1L, (long)dt_.getConditionCols().size());
        Assert.assertTrue((boolean)(dt_.getActionCols().get(1) instanceof ActionSetFieldCol));
        ActionSetFieldCol asf = (ActionSetFieldCol)dt_.getActionCols().get(1);
        Assert.assertEquals((Object)"foo", (Object)asf.getFactField());
        Assert.assertEquals((Object)false, (Object)asf.isUpdate());
    }
}

