/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testframework;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.drools.Cheese;
import org.drools.CheeseType;
import org.drools.Cheesery;
import org.drools.OuterFact;
import org.drools.Person;
import org.drools.StatefulSession;
import org.drools.base.ClassTypeResolver;
import org.drools.base.TypeResolver;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalWorkingMemory;
import org.drools.ide.common.client.modeldriven.testing.ActivateRuleFlowGroup;
import org.drools.ide.common.client.modeldriven.testing.CallFieldValue;
import org.drools.ide.common.client.modeldriven.testing.CallMethod;
import org.drools.ide.common.client.modeldriven.testing.ExecutionTrace;
import org.drools.ide.common.client.modeldriven.testing.Expectation;
import org.drools.ide.common.client.modeldriven.testing.FactData;
import org.drools.ide.common.client.modeldriven.testing.FieldData;
import org.drools.ide.common.client.modeldriven.testing.Fixture;
import org.drools.ide.common.client.modeldriven.testing.RetractFact;
import org.drools.ide.common.client.modeldriven.testing.Scenario;
import org.drools.ide.common.client.modeldriven.testing.VerifyFact;
import org.drools.ide.common.client.modeldriven.testing.VerifyField;
import org.drools.ide.common.client.modeldriven.testing.VerifyRuleFired;
import org.drools.testframework.MockWorkingMemory;
import org.drools.testframework.RuleUnit;
import org.drools.testframework.ScenarioRunner;
import org.drools.testframework.TestingEventListener;
import org.drools.time.SessionClock;
import org.drools.time.impl.PseudoClockScheduler;
import org.drools.util.CompositeClassLoader;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScenarioRunnerTest
extends RuleUnit {
    @Test
    public void testPopulateFactsWithInterfaces() throws Exception {
        Scenario sc = new Scenario();
        List<FactData> facts = this.ls(new FactData("List", "ls", new ArrayList(), false));
        List<FactData> globals = this.ls(new FactData("List", "ls", new ArrayList(), false));
        sc.getFixtures().addAll(facts);
        sc.getGlobals().addAll(globals);
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        resolver.addImport("java.util.List");
        ScenarioRunner runner = new ScenarioRunner(sc, (TypeResolver)resolver, (InternalWorkingMemory)new MockWorkingMemory());
    }

    @Test
    public void testPopulateFacts() throws Exception {
        Scenario sc = new Scenario();
        List<FactData> facts = this.ls(new FactData("Cheese", "c1", this.ls(new FieldData("type", "cheddar"), new FieldData("price", "42")), false), new FactData("Person", "p1", this.ls(new FieldData("name", "mic"), new FieldData("age", "=30 + 3")), false));
        sc.getFixtures().addAll(facts);
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        resolver.addImport("org.drools.Cheese");
        resolver.addImport("org.drools.Person");
        ScenarioRunner runner = new ScenarioRunner(sc, (TypeResolver)resolver, (InternalWorkingMemory)new MockWorkingMemory());
        Assert.assertTrue((boolean)runner.getPopulatedData().containsKey("c1"));
        Assert.assertTrue((boolean)runner.getPopulatedData().containsKey("p1"));
        Cheese c = (Cheese)runner.getPopulatedData().get("c1");
        Assert.assertEquals((Object)"cheddar", (Object)c.getType());
        Assert.assertEquals((long)42L, (long)c.getPrice());
        Person p = (Person)runner.getPopulatedData().get("p1");
        Assert.assertEquals((Object)"mic", (Object)p.getName());
        Assert.assertEquals((long)33L, (long)p.getAge());
    }

    @Test
    public void testPopulateEnum() throws Exception {
        Scenario sc = new Scenario();
        FieldData fd = new FieldData("cheeseType", "CheeseType.CHEDDAR");
        fd.setNature(4L, null);
        List<FactData> facts = this.ls(new FactData("Cheese", "c1", this.ls(fd), false));
        sc.getFixtures().addAll(facts);
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        resolver.addImport("org.drools.Cheese");
        resolver.addImport("org.drools.CheeseType");
        try {
            ScenarioRunner runner = new ScenarioRunner(sc, (TypeResolver)resolver, (InternalWorkingMemory)new MockWorkingMemory());
            Assert.assertTrue((boolean)runner.getPopulatedData().containsKey("c1"));
            Cheese c = (Cheese)runner.getPopulatedData().get("c1");
            Assert.assertEquals((Object)((Object)CheeseType.CHEDDAR), (Object)((Object)c.getCheeseType()));
        }
        catch (Exception e) {
            Assert.fail((String)"Unexpected exception");
        }
    }

    @Test
    public void testPopulateNested() throws Exception {
        Scenario sc = new Scenario();
        List<FactData> facts = this.ls(new FactData("Cheese", "c1", this.ls(new FieldData("type", "cheddar"), new FieldData("price", "42")), false), new FactData("OuterFact", "p1", this.ls(new FieldData("name", "mic"), new FieldData("innerFact", "=c1")), false));
        sc.getFixtures().addAll(facts);
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        resolver.addImport("org.drools.Cheese");
        resolver.addImport("org.drools.OuterFact");
        ScenarioRunner runner = new ScenarioRunner(sc, (TypeResolver)resolver, (InternalWorkingMemory)new MockWorkingMemory());
        Assert.assertTrue((boolean)runner.getPopulatedData().containsKey("c1"));
        Assert.assertTrue((boolean)runner.getPopulatedData().containsKey("p1"));
        OuterFact o = (OuterFact)runner.getPopulatedData().get("p1");
        Assert.assertNotNull((Object)o.getInnerFact());
    }

    @Test
    public void testPopulateNestedWrongOrder() throws Exception {
        Scenario sc = new Scenario();
        List<FactData> facts = this.ls(new FactData("OuterFact", "p1", this.ls(new FieldData("name", "mic"), new FieldData("innerFact", "=c1")), false), new FactData("Cheese", "c1", this.ls(new FieldData("type", "cheddar"), new FieldData("price", "42")), false));
        sc.getFixtures().addAll(facts);
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        resolver.addImport("org.drools.Cheese");
        resolver.addImport("org.drools.OuterFact");
        ScenarioRunner runner = new ScenarioRunner(sc, (TypeResolver)resolver, (InternalWorkingMemory)new MockWorkingMemory());
        Assert.assertTrue((boolean)runner.getPopulatedData().containsKey("c1"));
        Assert.assertTrue((boolean)runner.getPopulatedData().containsKey("p1"));
        OuterFact o = (OuterFact)runner.getPopulatedData().get("p1");
        Assert.assertNotNull((Object)o.getInnerFact());
    }

    @Test
    public void testPopulateEmpty() throws Exception {
        Scenario sc = new Scenario();
        List<FactData> facts = this.ls(new FactData("Cheese", "c1", new ArrayList(), false));
        sc.getFixtures().addAll(facts);
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        sc.getFixtures().addAll(facts);
        resolver.addImport("org.drools.Cheese");
        ScenarioRunner runner = new ScenarioRunner(sc, (TypeResolver)resolver, (InternalWorkingMemory)new MockWorkingMemory());
        Assert.assertTrue((boolean)runner.getPopulatedData().containsKey("c1"));
        Assert.assertTrue((boolean)(runner.getPopulatedData().get("c1") instanceof Cheese));
    }

    @Test
    public void testDateField() throws Exception {
        Scenario sc = new Scenario();
        List<FactData> facts = this.ls(new FactData("Cheese", "c1", this.ls(new FieldData("type", "cheddar"), new FieldData("usedBy", "10-Jul-2008")), false), new FactData("OuterFact", "p1", this.ls(new FieldData("name", "mic"), new FieldData("innerFact", "=c1")), false));
        sc.getFixtures().addAll(facts);
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        resolver.addImport("org.drools.Cheese");
        resolver.addImport("org.drools.OuterFact");
        ScenarioRunner runner = new ScenarioRunner(sc, (TypeResolver)resolver, (InternalWorkingMemory)new MockWorkingMemory());
        Assert.assertTrue((boolean)runner.getPopulatedData().containsKey("c1"));
        Assert.assertTrue((boolean)runner.getPopulatedData().containsKey("p1"));
        Cheese c = (Cheese)runner.getPopulatedData().get("c1");
        Assert.assertNotNull((Object)c.getUsedBy());
    }

    @Test
    public void testPopulateFactsWithExpressions() throws Exception {
        Scenario sc = new Scenario();
        List<FactData> facts = this.ls(new FactData("Cheese", "c1", this.ls(new FieldData("type", "cheddar"), new FieldData("price", "42")), false), new FactData("Cheese", "c2", this.ls(new FieldData("type", "= c1.type")), false));
        sc.getFixtures().addAll(facts);
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        resolver.addImport("org.drools.Cheese");
        ScenarioRunner runner = new ScenarioRunner(sc, (TypeResolver)resolver, (InternalWorkingMemory)new MockWorkingMemory());
        Assert.assertTrue((boolean)runner.getPopulatedData().containsKey("c1"));
        Assert.assertTrue((boolean)runner.getPopulatedData().containsKey("c2"));
        Cheese c = (Cheese)runner.getPopulatedData().get("c1");
        Assert.assertEquals((Object)"cheddar", (Object)c.getType());
        Assert.assertEquals((long)42L, (long)c.getPrice());
        Cheese c2 = (Cheese)runner.getPopulatedData().get("c2");
        Assert.assertEquals((Object)c.getType(), (Object)c2.getType());
    }

    @Test
    public void testPopulateNoData() throws Exception {
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        resolver.addImport("org.drools.Cheese");
        ScenarioRunner run = new ScenarioRunner(new Scenario(), (TypeResolver)resolver, (InternalWorkingMemory)new MockWorkingMemory());
        run.getPopulatedData().clear();
        Cheese c = new Cheese();
        c.setType("whee");
        c.setPrice(1);
        run.getPopulatedData().put("x", c);
        Assert.assertEquals((long)1L, (long)c.getPrice());
        FactData fd = new FactData("Cheese", "x", this.ls(new FieldData("type", ""), new FieldData("price", "42")), false);
        run.populateFields(fd, (Object)c);
        Assert.assertEquals((Object)"whee", (Object)c.getType());
        Assert.assertEquals((long)42L, (long)c.getPrice());
    }

    @Test
    public void testVerifyFacts() throws Exception {
        int i;
        ScenarioRunner runner = new ScenarioRunner(new Scenario(), null, (InternalWorkingMemory)new MockWorkingMemory());
        Cheese f1 = new Cheese("cheddar", 42);
        runner.getPopulatedData().put("f1", f1);
        Person f2 = new Person("michael", 33);
        runner.getPopulatedData().put("f2", f2);
        VerifyFact vf = new VerifyFact();
        vf.setName("f1");
        vf.setFieldValues(this.ls(new VerifyField("type", "cheddar", "=="), new VerifyField("price", "42", "==")));
        runner.verify(vf);
        for (i = 0; i < vf.getFieldValues().size(); ++i) {
            Assert.assertTrue((boolean)((VerifyField)vf.getFieldValues().get(i)).getSuccessResult());
        }
        vf = new VerifyFact();
        vf.setName("f2");
        vf.setFieldValues(this.ls(new VerifyField("name", "michael", "=="), new VerifyField("age", "33", "==")));
        runner.verify(vf);
        for (i = 0; i < vf.getFieldValues().size(); ++i) {
            Assert.assertTrue((boolean)((VerifyField)vf.getFieldValues().get(i)).getSuccessResult());
        }
        vf = new VerifyFact();
        vf.setName("f2");
        vf.setFieldValues(this.ls(new VerifyField("name", "mark", "=="), new VerifyField("age", "33", "==")));
        runner.verify(vf);
        Assert.assertFalse((boolean)((VerifyField)vf.getFieldValues().get(0)).getSuccessResult());
        Assert.assertTrue((boolean)((VerifyField)vf.getFieldValues().get(1)).getSuccessResult());
        Assert.assertEquals((Object)"michael", (Object)((VerifyField)vf.getFieldValues().get(0)).getActualResult());
        Assert.assertEquals((Object)"mark", (Object)((VerifyField)vf.getFieldValues().get(0)).getExpected());
        vf = new VerifyFact();
        vf.setName("f2");
        vf.setFieldValues(this.ls(new VerifyField("name", "mark", "=="), new VerifyField("age", "32", "==")));
        runner.verify(vf);
        Assert.assertFalse((boolean)((VerifyField)vf.getFieldValues().get(0)).getSuccessResult());
        Assert.assertFalse((boolean)((VerifyField)vf.getFieldValues().get(1)).getSuccessResult());
        Assert.assertEquals((Object)"michael", (Object)((VerifyField)vf.getFieldValues().get(0)).getActualResult());
        Assert.assertEquals((Object)"mark", (Object)((VerifyField)vf.getFieldValues().get(0)).getExpected());
        Assert.assertEquals((Object)"33", (Object)((VerifyField)vf.getFieldValues().get(1)).getActualResult());
        Assert.assertEquals((Object)"32", (Object)((VerifyField)vf.getFieldValues().get(1)).getExpected());
    }

    @Test
    public void testVerifyFactsWithEnum() throws Exception {
        FieldData fd = new FieldData("cheeseType", "CheeseType.CHEDDAR");
        fd.setNature(4L, null);
        List<FactData> facts = this.ls(new FactData("Cheese", "c1", this.ls(fd), false));
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        resolver.addImport("org.drools.Cheese");
        resolver.addImport("org.drools.CheeseType");
        ScenarioRunner runner = new ScenarioRunner(new Scenario(), (TypeResolver)resolver, (InternalWorkingMemory)new MockWorkingMemory());
        Cheese f1 = new Cheese("othertype", 42);
        f1.setCheeseType(CheeseType.CHEDDAR);
        runner.getPopulatedData().put("f1", f1);
        VerifyFact vf = new VerifyFact();
        vf.setName("f1");
        VerifyField verifyField = new VerifyField("cheeseType", "CheeseType.CHEDDAR", "==");
        verifyField.setNature(4L);
        vf.setFieldValues(this.ls(verifyField));
        runner.verify(vf);
        for (int i = 0; i < vf.getFieldValues().size(); ++i) {
            Assert.assertTrue((boolean)((VerifyField)vf.getFieldValues().get(i)).getSuccessResult());
        }
    }

    @Test
    public void testVerifyAnonymousFacts() throws Exception {
        MockWorkingMemory wm = new MockWorkingMemory();
        ScenarioRunner runner = new ScenarioRunner(new Scenario(), null, (InternalWorkingMemory)wm);
        Cheese c = new Cheese();
        c.setPrice(42);
        c.setType("stilton");
        wm.facts.add(c);
        VerifyFact vf = new VerifyFact("Cheese", new ArrayList(), true);
        vf.getFieldValues().add(new VerifyField("price", "42", "=="));
        vf.getFieldValues().add(new VerifyField("type", "stilton", "=="));
        runner.verify(vf);
        Assert.assertTrue((boolean)vf.wasSuccessful());
        vf = new VerifyFact("Person", new ArrayList(), true);
        vf.getFieldValues().add(new VerifyField("age", "42", "=="));
        runner.verify(vf);
        Assert.assertFalse((boolean)vf.wasSuccessful());
        vf = new VerifyFact("Cheese", new ArrayList(), true);
        vf.getFieldValues().add(new VerifyField("price", "43", "=="));
        vf.getFieldValues().add(new VerifyField("type", "stilton", "=="));
        runner.verify(vf);
        Assert.assertFalse((boolean)vf.wasSuccessful());
        Assert.assertEquals((Object)Boolean.FALSE, (Object)((VerifyField)vf.getFieldValues().get(0)).getSuccessResult());
        vf = new VerifyFact("Cell", new ArrayList(), true);
        vf.getFieldValues().add(new VerifyField("value", "43", "=="));
        runner.verify(vf);
        Assert.assertFalse((boolean)vf.wasSuccessful());
        Assert.assertEquals((Object)Boolean.FALSE, (Object)((VerifyField)vf.getFieldValues().get(0)).getSuccessResult());
    }

    @Test
    public void testVerifyFactsWithOperator() throws Exception {
        ScenarioRunner runner = new ScenarioRunner(new Scenario(), null, (InternalWorkingMemory)new MockWorkingMemory());
        Cheese f1 = new Cheese("cheddar", 42);
        runner.getPopulatedData().put("f1", f1);
        VerifyFact vf = new VerifyFact();
        vf.setName("f1");
        vf.setFieldValues(this.ls(new VerifyField("type", "cheddar", "=="), new VerifyField("price", "4777", "!=")));
        runner.verify(vf);
        for (int i = 0; i < vf.getFieldValues().size(); ++i) {
            Assert.assertTrue((boolean)((VerifyField)vf.getFieldValues().get(i)).getSuccessResult());
        }
        vf = new VerifyFact();
        vf.setName("f1");
        vf.setFieldValues(this.ls(new VerifyField("type", "cheddar", "!=")));
        runner.verify(vf);
        Assert.assertFalse((boolean)((VerifyField)vf.getFieldValues().get(0)).getSuccessResult());
    }

    @Test
    public void testVerifyFactsWithExpression() throws Exception {
        ScenarioRunner runner = new ScenarioRunner(new Scenario(), null, (InternalWorkingMemory)new MockWorkingMemory());
        Cheese f1 = new Cheese("cheddar", 42);
        runner.getPopulatedData().put("f1", f1);
        f1.setPrice(42);
        VerifyFact vf = new VerifyFact();
        vf.setName("f1");
        vf.setFieldValues(this.ls(new VerifyField("price", "= 40 + 2", "==")));
        runner.verify(vf);
        Assert.assertTrue((boolean)((VerifyField)vf.getFieldValues().get(0)).getSuccessResult());
    }

    @Test
    public void testVerifyFactExplanation() throws Exception {
        ScenarioRunner runner = new ScenarioRunner(new Scenario(), null, (InternalWorkingMemory)new MockWorkingMemory());
        Cheese f1 = new Cheese();
        f1.setType(null);
        runner.getPopulatedData().put("f1", f1);
        VerifyFact vf = new VerifyFact();
        vf.setName("f1");
        vf.getFieldValues().add(new VerifyField("type", "boo", "!="));
        runner.verify(vf);
        VerifyField vfl = (VerifyField)vf.getFieldValues().get(0);
        Assert.assertEquals((Object)"[f1] field [type] was not [boo].", (Object)vfl.getExplanation());
    }

    @Test
    public void testVerifyFieldAndActualIsNull() throws Exception {
        ScenarioRunner runner = new ScenarioRunner(new Scenario(), null, (InternalWorkingMemory)new MockWorkingMemory());
        Cheese f1 = new Cheese();
        f1.setType(null);
        runner.getPopulatedData().put("f1", f1);
        VerifyFact vf = new VerifyFact();
        vf.setName("f1");
        vf.getFieldValues().add(new VerifyField("type", "boo", "=="));
        runner.verify(vf);
        VerifyField vfl = (VerifyField)vf.getFieldValues().get(0);
        Assert.assertEquals((Object)"[f1] field [type] was [] expected [boo].", (Object)vfl.getExplanation());
        Assert.assertEquals((Object)"boo", (Object)vfl.getExpected());
        Assert.assertEquals((Object)"", (Object)vfl.getActualResult());
    }

    @Test
    public void testDummyRunNoRules() throws Exception {
        Scenario sc = new Scenario();
        FactData[] facts = new FactData[]{new FactData("Cheese", "c1", this.ls(new FieldData("type", "cheddar"), new FieldData("price", "42")), false)};
        VerifyFact[] assertions = new VerifyFact[]{new VerifyFact("c1", this.ls(new VerifyField("type", "cheddar", "=="), new VerifyField("price", "42", "==")))};
        sc.getFixtures().addAll(Arrays.asList(facts));
        sc.getFixtures().addAll(Arrays.asList(assertions));
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        resolver.addImport("org.drools.Cheese");
        MockWorkingMemory wm = new MockWorkingMemory();
        ScenarioRunner runner = new ScenarioRunner(sc, (TypeResolver)resolver, (InternalWorkingMemory)wm);
        Assert.assertEquals((long)1L, (long)wm.facts.size());
        Assert.assertEquals(runner.getPopulatedData().get("c1"), (Object)wm.facts.get(0));
        Assert.assertTrue((boolean)runner.getPopulatedData().containsKey("c1"));
        VerifyFact vf = assertions[0];
        for (int i = 0; i < vf.getFieldValues().size(); ++i) {
            Assert.assertTrue((boolean)((VerifyField)vf.getFieldValues().get(i)).getSuccessResult());
        }
    }

    @Test
    public void testCountVerification() throws Exception {
        HashMap<String, Integer> firingCounts = new HashMap<String, Integer>();
        firingCounts.put("foo", 2);
        firingCounts.put("bar", 1);
        ScenarioRunner runner = new ScenarioRunner(new Scenario(), null, (InternalWorkingMemory)new MockWorkingMemory());
        VerifyRuleFired v = new VerifyRuleFired();
        v.setRuleName("foo");
        v.setExpectedFire(Boolean.valueOf(true));
        runner.verify(v, firingCounts);
        Assert.assertTrue((boolean)v.getSuccessResult());
        Assert.assertEquals((long)2L, (long)v.getActualResult().intValue());
        v = new VerifyRuleFired();
        v.setRuleName("foo");
        v.setExpectedFire(Boolean.valueOf(false));
        runner.verify(v, firingCounts);
        Assert.assertFalse((boolean)v.getSuccessResult());
        Assert.assertEquals((long)2L, (long)v.getActualResult().intValue());
        Assert.assertNotNull((Object)v.getExplanation());
        v = new VerifyRuleFired();
        v.setRuleName("foo");
        v.setExpectedCount(Integer.valueOf(2));
        runner.verify(v, firingCounts);
        Assert.assertTrue((boolean)v.getSuccessResult());
        Assert.assertEquals((long)2L, (long)v.getActualResult().intValue());
    }

    @Test
    public void testRuleFiredWithEnum() throws Exception {
        HashMap<String, Integer> firingCounts = new HashMap<String, Integer>();
        firingCounts.put("foo", 2);
        firingCounts.put("bar", 1);
        ScenarioRunner runner = new ScenarioRunner(new Scenario(), null, (InternalWorkingMemory)new MockWorkingMemory());
        VerifyRuleFired v = new VerifyRuleFired();
        v.setRuleName("foo");
        v.setExpectedFire(Boolean.valueOf(true));
        runner.verify(v, firingCounts);
        Assert.assertTrue((boolean)v.getSuccessResult());
        Assert.assertEquals((long)2L, (long)v.getActualResult().intValue());
    }

    @Test
    public void testTestingEventListener() throws Exception {
        Scenario sc = new Scenario();
        sc.getRules().add("foo");
        sc.getRules().add("bar");
        ExecutionTrace ext = new ExecutionTrace();
        sc.getFixtures().add(ext);
        MockWorkingMemory wm = new MockWorkingMemory();
        PseudoClockScheduler clock = new PseudoClockScheduler();
        long time = new Date().getTime();
        clock.setStartupTime(time);
        clock.setSession((InternalWorkingMemory)wm);
        wm.setSessionClock((SessionClock)clock);
        ScenarioRunner run = new ScenarioRunner(sc, null, (InternalWorkingMemory)wm);
        Assert.assertEquals((Object)wm, (Object)run.getWorkingMemory());
        Assert.assertNotNull((Object)wm.agendaEventListener);
        Assert.assertTrue((boolean)(wm.agendaEventListener instanceof TestingEventListener));
        TestingEventListener lnr = (TestingEventListener)wm.agendaEventListener;
        Assert.assertEquals((long)2L, (long)sc.getRules().size());
        Assert.assertTrue((boolean)sc.getRules().contains("foo"));
        Assert.assertTrue((boolean)sc.getRules().contains("bar"));
    }

    @Test
    public void testWithGlobals() throws Exception {
        Scenario sc = new Scenario();
        FactData[] facts = new FactData[]{new FactData("Cheese", "c2", this.ls(new FieldData("type", "stilton")), false)};
        sc.getGlobals().add(new FactData("Cheese", "c", this.ls(new FieldData("type", "cheddar")), false));
        sc.getFixtures().addAll(Arrays.asList(facts));
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        resolver.addImport("org.drools.Cheese");
        MockWorkingMemory wm = new MockWorkingMemory();
        ScenarioRunner run = new ScenarioRunner(sc, (TypeResolver)resolver, (InternalWorkingMemory)wm);
        Assert.assertEquals((long)1L, (long)wm.globals.size());
        Assert.assertEquals((long)1L, (long)run.getGlobalData().size());
        Assert.assertEquals((long)1L, (long)run.getPopulatedData().size());
        Assert.assertEquals((long)1L, (long)wm.facts.size());
        Cheese c = (Cheese)wm.globals.get("c");
        Assert.assertEquals((Object)"cheddar", (Object)c.getType());
        Cheese c2 = (Cheese)wm.facts.get(0);
        Assert.assertEquals((Object)"stilton", (Object)c2.getType());
    }

    @Test
    public void testWithGlobalList() throws Exception {
        Scenario sc = new Scenario();
        sc.getGlobals().add(new FactData("List", "testList", new ArrayList(), false));
        Expectation[] assertions = new Expectation[]{new VerifyFact("testList", this.ls(new VerifyField("empty", "true", "=="))), new VerifyFact("testList", this.ls(new VerifyField("size", "0", "==")))};
        sc.getFixtures().addAll(Arrays.asList(assertions));
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        resolver.addImport("java.util.List");
        MockWorkingMemory wm = new MockWorkingMemory();
        ScenarioRunner run = new ScenarioRunner(sc, (TypeResolver)resolver, (InternalWorkingMemory)wm);
        List testList = (List)wm.globals.get("testList");
        Assert.assertTrue((boolean)testList.isEmpty());
        Assert.assertEquals((long)0L, (long)testList.size());
    }

    @Test
    public void testSimulatedDate() throws Exception {
        Scenario sc = new Scenario();
        MockWorkingMemory wm = new MockWorkingMemory();
        PseudoClockScheduler clock = new PseudoClockScheduler();
        long time = new Date().getTime();
        clock.setStartupTime(time);
        clock.setSession((InternalWorkingMemory)wm);
        wm.setSessionClock((SessionClock)clock);
        ScenarioRunner run = new ScenarioRunner(sc, null, (InternalWorkingMemory)wm);
        Assert.assertEquals((long)time, (long)wm.getSessionClock().getCurrentTime());
        ExecutionTrace ext = new ExecutionTrace();
        ext.setScenarioSimulatedDate(new Date("10-Jul-1974"));
        sc.getFixtures().add(ext);
        run = new ScenarioRunner(sc, null, (InternalWorkingMemory)wm);
        long expected = ext.getScenarioSimulatedDate().getTime();
        Assert.assertEquals((long)expected, (long)wm.getSessionClock().getCurrentTime());
    }

    @Test
    public void testVerifyRuleFired() throws Exception {
        ScenarioRunner runner = new ScenarioRunner(new Scenario(), null, (InternalWorkingMemory)new MockWorkingMemory());
        VerifyRuleFired vr = new VerifyRuleFired("qqq", Integer.valueOf(42), null);
        HashMap<String, Integer> f = new HashMap<String, Integer>();
        f.put("qqq", 42);
        f.put("qaz", 1);
        runner.verify(vr, f);
        Assert.assertTrue((boolean)vr.wasSuccessful());
        Assert.assertEquals((long)42L, (long)vr.getActualResult().intValue());
        vr = new VerifyRuleFired("qqq", Integer.valueOf(41), null);
        runner.verify(vr, f);
        Assert.assertFalse((boolean)vr.wasSuccessful());
        Assert.assertEquals((long)42L, (long)vr.getActualResult().intValue());
        vr = new VerifyRuleFired("qaz", Integer.valueOf(1), null);
        runner.verify(vr, f);
        Assert.assertTrue((boolean)vr.wasSuccessful());
        Assert.assertEquals((long)1L, (long)vr.getActualResult().intValue());
        vr = new VerifyRuleFired("XXX", null, Boolean.valueOf(false));
        runner.verify(vr, f);
        Assert.assertTrue((boolean)vr.wasSuccessful());
        Assert.assertEquals((long)0L, (long)vr.getActualResult().intValue());
        vr = new VerifyRuleFired("qqq", null, Boolean.valueOf(true));
        runner.verify(vr, f);
        Assert.assertTrue((boolean)vr.wasSuccessful());
        Assert.assertEquals((long)42L, (long)vr.getActualResult().intValue());
        vr = new VerifyRuleFired("qqq", null, Boolean.valueOf(false));
        runner.verify(vr, f);
        Assert.assertFalse((boolean)vr.wasSuccessful());
        Assert.assertEquals((long)42L, (long)vr.getActualResult().intValue());
    }

    @Test
    public void testIntegrationWithSuccess() throws Exception {
        Scenario sc = new Scenario();
        FactData[] facts = new FactData[]{new FactData("Cheese", "c1", this.ls(new FieldData("type", "cheddar"), new FieldData("price", "42")), false)};
        sc.getGlobals().add(new FactData("Person", "p", new ArrayList(), false));
        sc.getFixtures().addAll(Arrays.asList(facts));
        ExecutionTrace executionTrace = new ExecutionTrace();
        sc.getRules().add("rule1");
        sc.getRules().add("rule2");
        sc.setInclusive(true);
        sc.getFixtures().add(executionTrace);
        Expectation[] assertions = new Expectation[]{new VerifyFact("c1", this.ls(new VerifyField("type", "cheddar", "=="))), new VerifyFact("p", this.ls(new VerifyField("name", "rule1", "=="), new VerifyField("status", "rule2", "=="))), new VerifyRuleFired("rule1", Integer.valueOf(1), null), new VerifyRuleFired("rule2", Integer.valueOf(1), null), new VerifyRuleFired("rule3", Integer.valueOf(0), null)};
        sc.getFixtures().addAll(Arrays.asList(assertions));
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        resolver.addImport("org.drools.Cheese");
        resolver.addImport("org.drools.Person");
        StatefulSession wm = this.getWorkingMemory("test_rules2.drl");
        ScenarioRunner run = new ScenarioRunner(sc, (TypeResolver)resolver, (InternalWorkingMemory)wm);
        Assert.assertEquals((long)2L, (long)executionTrace.getNumberOfRulesFired().intValue());
        Assert.assertSame((Object)run.getScenario(), (Object)sc);
        Assert.assertTrue((boolean)sc.wasSuccessful());
        Person p = (Person)run.getGlobalData().get("p");
        Assert.assertEquals((Object)"rule1", (Object)p.getName());
        Assert.assertEquals((Object)"rule2", (Object)p.getStatus());
        Assert.assertEquals((long)0L, (long)p.getAge());
        Thread.sleep(50L);
        Assert.assertTrue((boolean)new Date().after(sc.getLastRunResult()));
        Assert.assertTrue((executionTrace.getExecutionTimeResult() != null ? 1 : 0) != 0);
        Assert.assertTrue((executionTrace.getRulesFired().length > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testIntegrationInfiniteLoop() throws Exception {
        Scenario sc = new Scenario();
        FactData[] facts = new FactData[]{new FactData("Cheese", "c1", this.ls(new FieldData("type", "cheddar"), new FieldData("price", "42")), false)};
        sc.getGlobals().add(new FactData("Person", "p", new ArrayList(), false));
        sc.getFixtures().addAll(Arrays.asList(facts));
        ExecutionTrace executionTrace = new ExecutionTrace();
        sc.getRules().add("rule1");
        sc.getRules().add("rule2");
        sc.setInclusive(true);
        sc.getFixtures().add(executionTrace);
        Expectation[] assertions = new Expectation[]{new VerifyFact("c1", this.ls(new VerifyField("type", "cheddar", "=="))), new VerifyFact("p", this.ls(new VerifyField("name", "rule1", "=="), new VerifyField("status", "rule2", "=="))), new VerifyRuleFired("rule1", Integer.valueOf(1), null), new VerifyRuleFired("rule2", Integer.valueOf(1), null), new VerifyRuleFired("rule3", Integer.valueOf(0), null)};
        sc.getFixtures().addAll(Arrays.asList(assertions));
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        resolver.addImport("org.drools.Cheese");
        resolver.addImport("org.drools.Person");
        StatefulSession wm = this.getWorkingMemory("test_rules_infinite_loop.drl");
        ScenarioRunner run = new ScenarioRunner(sc, (TypeResolver)resolver, (InternalWorkingMemory)wm);
        Assert.assertEquals((long)sc.getMaxRuleFirings(), (long)executionTrace.getNumberOfRulesFired().intValue());
    }

    @Test
    public void testIntegrationWithDeclaredTypes() throws Exception {
        Scenario sc = new Scenario();
        FactData[] facts = new FactData[]{new FactData("Coolness", "c", this.ls(new FieldData("num", "42"), new FieldData("name", "mic")), false)};
        sc.getFixtures().addAll(Arrays.asList(facts));
        ExecutionTrace executionTrace = new ExecutionTrace();
        sc.getRules().add("rule1");
        sc.setInclusive(true);
        sc.getFixtures().add(executionTrace);
        Expectation[] assertions = new Expectation[]{new VerifyFact("c", this.ls(new VerifyField("num", "42", "=="))), new VerifyRuleFired("rule1", Integer.valueOf(1), null)};
        sc.getFixtures().addAll(Arrays.asList(assertions));
        StatefulSession wm = this.getWorkingMemory("test_rules3.drl");
        CompositeClassLoader cl = ((InternalRuleBase)wm.getRuleBase()).getRootClassLoader();
        HashSet<String> imports = new HashSet<String>();
        imports.add("foo.bar.*");
        ClassTypeResolver resolver = new ClassTypeResolver(imports, (ClassLoader)cl);
        Class<?> cls = cl.loadClass("foo.bar.Coolness");
        Assert.assertNotNull(cls);
        ClassLoader cl_ = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader((ClassLoader)cl);
        ScenarioRunner run = new ScenarioRunner(sc, (TypeResolver)resolver, (InternalWorkingMemory)wm);
        Assert.assertEquals((long)1L, (long)executionTrace.getNumberOfRulesFired().intValue());
        Assert.assertSame((Object)run.getScenario(), (Object)sc);
        Assert.assertTrue((boolean)sc.wasSuccessful());
        Thread.currentThread().setContextClassLoader(cl_);
    }

    @Test
    public void testRuleFlowGroupActivation() throws Exception {
        Scenario scenario = new Scenario();
        Fixture[] given = new Fixture[]{new FactData("Coolness", "c", this.ls(new FieldData("num", "42"), new FieldData("name", "mic")), false)};
        scenario.getFixtures().addAll(Arrays.asList(given));
        ExecutionTrace executionTrace = new ExecutionTrace();
        scenario.getRules().add("rule1");
        scenario.setInclusive(true);
        scenario.getFixtures().add(executionTrace);
        Expectation[] assertions = new Expectation[]{new VerifyFact("c", this.ls(new VerifyField("num", "42", "=="))), new VerifyRuleFired("rule1", Integer.valueOf(1), null)};
        scenario.getFixtures().addAll(Arrays.asList(assertions));
        StatefulSession workingMemory = this.getWorkingMemory("rule_flow_actication.drl");
        CompositeClassLoader classLoader = ((InternalRuleBase)workingMemory.getRuleBase()).getRootClassLoader();
        HashSet<String> imports = new HashSet<String>();
        imports.add("foo.bar.*");
        ClassTypeResolver resolver = new ClassTypeResolver(imports, (ClassLoader)classLoader);
        Class<?> coolnessClass = classLoader.loadClass("foo.bar.Coolness");
        Assert.assertNotNull(coolnessClass);
        ClassLoader cl_ = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader((ClassLoader)classLoader);
        ScenarioRunner scenarioRunner = new ScenarioRunner(scenario, (TypeResolver)resolver, (InternalWorkingMemory)workingMemory);
        Assert.assertEquals((long)0L, (long)executionTrace.getNumberOfRulesFired().intValue());
        Assert.assertSame((Object)scenarioRunner.getScenario(), (Object)scenario);
        Assert.assertFalse((boolean)scenario.wasSuccessful());
        scenario.getFixtures().clear();
        given = new Fixture[]{new FactData("Coolness", "c", this.ls(new FieldData("num", "42"), new FieldData("name", "mic")), false), new ActivateRuleFlowGroup("asdf")};
        workingMemory.clearAgenda();
        scenario.getFixtures().addAll(Arrays.asList(given));
        scenario.getFixtures().add(executionTrace);
        workingMemory.getAgenda().getRuleFlowGroup("asdf").setAutoDeactivate(false);
        scenarioRunner = new ScenarioRunner(scenario, (TypeResolver)resolver, (InternalWorkingMemory)workingMemory);
        Assert.assertEquals((long)1L, (long)executionTrace.getNumberOfRulesFired().intValue());
        Assert.assertSame((Object)scenarioRunner.getScenario(), (Object)scenario);
        Assert.assertTrue((boolean)scenario.wasSuccessful());
        Thread.currentThread().setContextClassLoader(cl_);
    }

    @Test
    public void testIntgerationStateful() throws Exception {
        Scenario sc = new Scenario();
        sc.getFixtures().add(new FactData("Cheese", "c1", this.ls(new FieldData("price", "1")), false));
        ExecutionTrace ex = new ExecutionTrace();
        sc.getFixtures().add(ex);
        sc.getFixtures().add(new FactData("Cheese", "c2", this.ls(new FieldData("price", "2")), false));
        sc.getFixtures().add(new VerifyFact("c1", this.ls(new VerifyField("type", "rule1", "=="))));
        ex = new ExecutionTrace();
        sc.getFixtures().add(ex);
        sc.getFixtures().add(new VerifyFact("c1", this.ls(new VerifyField("type", "rule2", "=="))));
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        resolver.addImport("org.drools.Cheese");
        StatefulSession wm = this.getWorkingMemory("test_stateful.drl");
        ScenarioRunner run = new ScenarioRunner(sc, (TypeResolver)resolver, (InternalWorkingMemory)wm);
        Cheese c1 = (Cheese)run.getPopulatedData().get("c1");
        Cheese c2 = (Cheese)run.getPopulatedData().get("c2");
        Assert.assertEquals((Object)"rule2", (Object)c1.getType());
        Assert.assertEquals((Object)"rule2", (Object)c2.getType());
        Assert.assertTrue((boolean)sc.wasSuccessful());
    }

    @Test
    public void testIntegrationWithModify() throws Exception {
        Scenario sc = new Scenario();
        sc.getFixtures().add(new FactData("Cheese", "c1", this.ls(new FieldData("price", "1")), false));
        sc.getFixtures().add(new ExecutionTrace());
        sc.getFixtures().add(new VerifyFact("c1", this.ls(new VerifyField("type", "rule1", "=="))));
        sc.getFixtures().add(new FactData("Cheese", "c1", this.ls(new FieldData("price", "42")), true));
        sc.getFixtures().add(new ExecutionTrace());
        sc.getFixtures().add(new VerifyFact("c1", this.ls(new VerifyField("type", "rule3", "=="))));
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        resolver.addImport("org.drools.Cheese");
        StatefulSession wm = this.getWorkingMemory("test_stateful.drl");
        ScenarioRunner run = new ScenarioRunner(sc, (TypeResolver)resolver, (InternalWorkingMemory)wm);
        Cheese c1 = (Cheese)run.getPopulatedData().get("c1");
        Assert.assertEquals((Object)"rule3", (Object)c1.getType());
        Assert.assertTrue((boolean)sc.wasSuccessful());
    }

    @Test
    public void testIntegrationWithRetract() throws Exception {
        Scenario sc = new Scenario();
        sc.getFixtures().add(new FactData("Cheese", "c1", this.ls(new FieldData("price", "46"), new FieldData("type", "XXX")), false));
        sc.getFixtures().add(new FactData("Cheese", "c2", this.ls(new FieldData("price", "42")), false));
        sc.getFixtures().add(new ExecutionTrace());
        sc.getFixtures().add(new VerifyFact("c1", this.ls(new VerifyField("type", "XXX", "=="))));
        sc.getFixtures().add(new RetractFact("c2"));
        sc.getFixtures().add(new ExecutionTrace());
        sc.getFixtures().add(new VerifyFact("c1", this.ls(new VerifyField("type", "rule4", "=="))));
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        resolver.addImport("org.drools.Cheese");
        StatefulSession wm = this.getWorkingMemory("test_stateful.drl");
        ScenarioRunner run = new ScenarioRunner(sc, (TypeResolver)resolver, (InternalWorkingMemory)wm);
        Cheese c1 = (Cheese)run.getPopulatedData().get("c1");
        Assert.assertEquals((Object)"rule4", (Object)c1.getType());
        Assert.assertFalse((boolean)run.getPopulatedData().containsKey("c2"));
        Assert.assertTrue((boolean)sc.wasSuccessful());
    }

    @Test
    public void testIntegrationWithFailure() throws Exception {
        Scenario sc = new Scenario();
        Expectation[] assertions = this.populateScenarioForFailure(sc);
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        resolver.addImport("org.drools.Cheese");
        resolver.addImport("org.drools.Person");
        StatefulSession wm = this.getWorkingMemory("test_rules2.drl");
        ScenarioRunner run = new ScenarioRunner(sc, (TypeResolver)resolver, (InternalWorkingMemory)wm);
        Assert.assertSame((Object)run.getScenario(), (Object)sc);
        Assert.assertFalse((boolean)sc.wasSuccessful());
        VerifyFact vf = (VerifyFact)assertions[1];
        Assert.assertFalse((boolean)((VerifyField)vf.getFieldValues().get(0)).getSuccessResult());
        Assert.assertEquals((Object)"XXX", (Object)((VerifyField)vf.getFieldValues().get(0)).getExpected());
        Assert.assertEquals((Object)"rule1", (Object)((VerifyField)vf.getFieldValues().get(0)).getActualResult());
        Assert.assertNotNull((Object)((VerifyField)vf.getFieldValues().get(0)).getExplanation());
        VerifyRuleFired vr = (VerifyRuleFired)assertions[4];
        Assert.assertFalse((boolean)vr.getSuccessResult());
        Assert.assertEquals((long)2L, (long)vr.getExpectedCount().intValue());
        Assert.assertEquals((long)0L, (long)vr.getActualResult().intValue());
    }

    private Expectation[] populateScenarioForFailure(Scenario sc) {
        FactData[] facts = new FactData[]{new FactData("Cheese", "c1", this.ls(new FieldData("type", "cheddar"), new FieldData("price", "42")), false)};
        sc.getFixtures().addAll(Arrays.asList(facts));
        sc.getGlobals().add(new FactData("Person", "p", new ArrayList(), false));
        ExecutionTrace executionTrace = new ExecutionTrace();
        sc.getRules().add("rule1");
        sc.getRules().add("rule2");
        sc.setInclusive(true);
        sc.getFixtures().add(executionTrace);
        Expectation[] assertions = new Expectation[]{new VerifyFact("c1", this.ls(new VerifyField("type", "cheddar", "=="))), new VerifyFact("p", this.ls(new VerifyField("name", "XXX", "=="), new VerifyField("status", "rule2", "=="))), new VerifyRuleFired("rule1", Integer.valueOf(1), null), new VerifyRuleFired("rule2", Integer.valueOf(1), null), new VerifyRuleFired("rule3", Integer.valueOf(2), null)};
        sc.getFixtures().addAll(Arrays.asList(assertions));
        return assertions;
    }

    private <T> List<T> ls(T ... objects) {
        return Arrays.asList(objects);
    }

    @Test
    public void testCollectionFieldInFacts() throws Exception {
        ScenarioRunner runner = new ScenarioRunner(new Scenario(), null, (InternalWorkingMemory)new MockWorkingMemory());
        Cheesery listChesse = new Cheesery();
        Cheese f1 = new Cheese("cheddar", 42);
        Cheese f2 = new Cheese("Camembert", 43);
        Cheese f3 = new Cheese("Emmental", 45);
        runner.getPopulatedData().put("f1", f1);
        runner.getPopulatedData().put("f2", f2);
        runner.getPopulatedData().put("f3", f3);
        FactData fd1 = new FactData("Cheese", "f1", this.ls(new FieldData("type", ""), new FieldData("price", "42")), false);
        FactData fd2 = new FactData("Cheese", "f2", this.ls(new FieldData("type", ""), new FieldData("price", "43")), false);
        FactData fd3 = new FactData("Cheese", "f3", this.ls(new FieldData("type", ""), new FieldData("price", "45")), false);
        runner.getPopulatedData().put("ACheesery", listChesse);
        FieldData field = new FieldData();
        field.setName("cheeses");
        field.collectionType = "Cheese";
        field.setNature(6L);
        field.setValue("=[f1,f2,f3]");
        ArrayList<FieldData> lstField = new ArrayList<FieldData>();
        lstField.add(field);
        FactData lst = new FactData("Cheesery", "listChesse", lstField, false);
        runner.populateFields(lst, (Object)listChesse);
        Assert.assertTrue((listChesse.getCheeses().size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)listChesse.getCheeses().contains(f1));
        Assert.assertTrue((boolean)listChesse.getCheeses().contains(f3));
        Assert.assertTrue((boolean)listChesse.getCheeses().contains(f3));
    }

    @Test
    public void testCallMethodNoArgumentOnFact() throws Exception {
        ScenarioRunner runner = new ScenarioRunner(new Scenario(), null, (InternalWorkingMemory)new MockWorkingMemory());
        Cheesery listChesse = new Cheesery();
        listChesse.setTotalAmount(1000);
        runner.getPopulatedData().put("cheese", listChesse);
        CallMethod mCall = new CallMethod();
        mCall.setVariable("cheese");
        mCall.setMethodName("setTotalAmountToZero");
        runner.executeMethodOnObject(mCall, (Object)listChesse);
        Assert.assertTrue((listChesse.getTotalAmount() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCallMethodOnStandardArgumentOnFact() throws Exception {
        ScenarioRunner runner = new ScenarioRunner(new Scenario(), null, (InternalWorkingMemory)new MockWorkingMemory());
        Cheesery listChesse = new Cheesery();
        listChesse.setTotalAmount(1000);
        runner.getPopulatedData().put("cheese", listChesse);
        CallMethod mCall = new CallMethod();
        mCall.setVariable("cheese");
        mCall.setMethodName("addToTotalAmount");
        CallFieldValue field = new CallFieldValue();
        field.value = "5";
        mCall.addFieldValue(field);
        runner.executeMethodOnObject(mCall, (Object)listChesse);
        Assert.assertTrue((listChesse.getTotalAmount() == 1005 ? 1 : 0) != 0);
    }

    @Test
    public void testCallMethodOnClassArgumentOnFact() throws Exception {
        ScenarioRunner runner = new ScenarioRunner(new Scenario(), null, (InternalWorkingMemory)new MockWorkingMemory());
        Cheesery listChesse = new Cheesery();
        listChesse.setTotalAmount(1000);
        runner.getPopulatedData().put("cheese", listChesse);
        Cheesery.Maturity m = new Cheesery.Maturity();
        runner.getPopulatedData().put("m", m);
        CallMethod mCall = new CallMethod();
        mCall.setVariable("cheese");
        mCall.setMethodName("setGoodMaturity");
        CallFieldValue field = new CallFieldValue();
        field.value = "=m";
        mCall.addFieldValue(field);
        runner.executeMethodOnObject(mCall, (Object)listChesse);
        Assert.assertTrue((boolean)listChesse.getMaturity().equals(m));
        Assert.assertTrue((listChesse.getMaturity() == m ? 1 : 0) != 0);
    }

    @Test
    public void testCallMethodOnClassArgumentAndOnArgumentStandardOnFact() throws Exception {
        ScenarioRunner runner = new ScenarioRunner(new Scenario(), null, (InternalWorkingMemory)new MockWorkingMemory());
        Cheesery listChesse = new Cheesery();
        listChesse.setTotalAmount(1000);
        runner.getPopulatedData().put("cheese", listChesse);
        Cheesery.Maturity m = new Cheesery.Maturity("veryYoung");
        runner.getPopulatedData().put("m", m);
        CallMethod mCall = new CallMethod();
        mCall.setVariable("cheese");
        mCall.setMethodName("setAgeToMaturity");
        CallFieldValue field = new CallFieldValue();
        field.value = "=m";
        mCall.addFieldValue(field);
        CallFieldValue field2 = new CallFieldValue();
        field2.value = "veryold";
        mCall.addFieldValue(field2);
        runner.executeMethodOnObject(mCall, (Object)listChesse);
        Assert.assertTrue((boolean)m.getAge().equals("veryold"));
    }

    static {
        try {
            Class.forName("org.drools.base.mvel.MVELCompilationUnit");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }
}

