/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.client.modeldriven.dt;

import java.util.ArrayList;
import java.util.List;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.brl.PortableObject;
import org.drools.ide.common.client.modeldriven.dt.ActionCol;
import org.drools.ide.common.client.modeldriven.dt.ActionInsertFactCol;
import org.drools.ide.common.client.modeldriven.dt.ActionSetFieldCol;
import org.drools.ide.common.client.modeldriven.dt.AttributeCol;
import org.drools.ide.common.client.modeldriven.dt.ConditionCol;
import org.drools.ide.common.client.modeldriven.dt.DTCellValue;
import org.drools.ide.common.client.modeldriven.dt.DTColumnConfig;
import org.drools.ide.common.client.modeldriven.dt.DescriptionCol;
import org.drools.ide.common.client.modeldriven.dt.MetadataCol;
import org.drools.ide.common.client.modeldriven.dt.RowNumberCol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeSafeGuidedDecisionTable
implements PortableObject {
    private static final long serialVersionUID = 510L;
    public static final int INTERNAL_ELEMENTS = 2;
    public static final String SALIENCE_ATTR = "salience";
    public static final String ENABLED_ATTR = "enabled";
    public static final String DATE_EFFECTIVE_ATTR = "date-effective";
    public static final String DATE_EXPIRES_ATTR = "date-expires";
    public static final String NO_LOOP_ATTR = "no-loop";
    public static final String AGENDA_GROUP_ATTR = "agenda-group";
    public static final String ACTIVATION_GROUP_ATTR = "activation-group";
    public static final String DURATION_ATTR = "duration";
    public static final String AUTO_FOCUS_ATTR = "auto-focus";
    public static final String LOCK_ON_ACTIVE_ATTR = "lock-on-active";
    public static final String RULEFLOW_GROUP_ATTR = "ruleflow-group";
    public static final String DIALECT_ATTR = "dialect";
    public static final String NEGATE_RULE_ATTR = "negate";
    private String tableName;
    private String parentName;
    private RowNumberCol rowNumberCol = new RowNumberCol();
    private DescriptionCol descriptionCol = new DescriptionCol();
    private List<MetadataCol> metadataCols = new ArrayList<MetadataCol>();
    private List<AttributeCol> attributeCols = new ArrayList<AttributeCol>();
    private List<ConditionCol> conditionCols = new ArrayList<ConditionCol>();
    private List<ActionCol> actionCols = new ArrayList<ActionCol>();
    private List<List<DTCellValue>> data = new ArrayList<List<DTCellValue>>();

    public List<ActionCol> getActionCols() {
        return this.actionCols;
    }

    public List<AttributeCol> getAttributeCols() {
        return this.attributeCols;
    }

    public List<ConditionCol> getConditionCols() {
        return this.conditionCols;
    }

    public List<List<DTCellValue>> getData() {
        return this.data;
    }

    public List<DTColumnConfig> getAllColumns() {
        ArrayList<DTColumnConfig> columns = new ArrayList<DTColumnConfig>();
        columns.add(this.rowNumberCol);
        columns.add(this.descriptionCol);
        columns.addAll(this.metadataCols);
        columns.addAll(this.attributeCols);
        columns.addAll(this.conditionCols);
        columns.addAll(this.actionCols);
        return columns;
    }

    public DescriptionCol getDescriptionCol() {
        if (this.descriptionCol == null) {
            this.descriptionCol = new DescriptionCol();
        }
        return this.descriptionCol;
    }

    public List<MetadataCol> getMetadataCols() {
        if (null == this.metadataCols) {
            this.metadataCols = new ArrayList<MetadataCol>();
        }
        return this.metadataCols;
    }

    public String getParentName() {
        return this.parentName;
    }

    public RowNumberCol getRowNumberCol() {
        if (this.rowNumberCol == null) {
            this.rowNumberCol = new RowNumberCol();
        }
        return this.rowNumberCol;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getType(DTColumnConfig col, SuggestionCompletionEngine sce) {
        String type = null;
        if (col instanceof RowNumberCol) {
            type = "Numeric";
        } else if (col instanceof DescriptionCol) {
            type = "String";
        } else if (col instanceof AttributeCol) {
            AttributeCol attrCol = (AttributeCol)col;
            String attrName = attrCol.getAttribute();
            if (attrName.equals(SALIENCE_ATTR)) {
                type = "Numeric";
            } else if (attrName.equals(ENABLED_ATTR)) {
                type = "Boolean";
            } else if (attrName.equals(NO_LOOP_ATTR)) {
                type = "Boolean";
            } else if (attrName.equals(DURATION_ATTR)) {
                type = "Numeric";
            } else if (attrName.equals(AUTO_FOCUS_ATTR)) {
                type = "Boolean";
            } else if (attrName.equals(LOCK_ON_ACTIVE_ATTR)) {
                type = "Boolean";
            } else if (attrName.equals(DATE_EFFECTIVE_ATTR)) {
                type = "Date";
            } else if (attrName.equals(DATE_EXPIRES_ATTR)) {
                type = "Date";
            } else if (attrName.equals(DIALECT_ATTR)) {
                type = "String";
            }
        } else if (col instanceof ConditionCol) {
            ConditionCol c = (ConditionCol)col;
            type = sce.getFieldType(c.getFactType(), c.getFactField());
            type = this.assertDataType(c, sce, type) ? type : null;
        } else if (col instanceof ActionSetFieldCol) {
            ActionSetFieldCol c = (ActionSetFieldCol)col;
            type = sce.getFieldType(this.getBoundFactType(c.getBoundName()), c.getFactField());
            type = this.assertDataType(c, sce, type) ? type : null;
        } else if (col instanceof ActionInsertFactCol) {
            ActionInsertFactCol c = (ActionInsertFactCol)col;
            type = sce.getFieldType(c.getFactType(), c.getFactField());
            type = this.assertDataType(c, sce, type) ? type : null;
        }
        return type;
    }

    public String[] getValueList(DTColumnConfig col, SuggestionCompletionEngine sce) {
        if (col instanceof AttributeCol) {
            AttributeCol at = (AttributeCol)col;
            if (NO_LOOP_ATTR.equals(at.getAttribute()) || ENABLED_ATTR.equals(at.getAttribute())) {
                return new String[]{"true", "false"};
            }
        } else {
            if (col instanceof ConditionCol) {
                ConditionCol c = (ConditionCol)col;
                if (c.getConstraintValueType() == 3 || c.getConstraintValueType() == 5) {
                    return new String[0];
                }
                if (c.getValueList() != null && !"".equals(c.getValueList())) {
                    return c.getValueList().split(",");
                }
                String[] r = sce.getEnumValues(c.getFactType(), c.getFactField());
                return r != null ? r : new String[]{};
            }
            if (col instanceof ActionSetFieldCol) {
                ActionSetFieldCol c = (ActionSetFieldCol)col;
                if (c.getValueList() != null && !"".equals(c.getValueList())) {
                    return c.getValueList().split(",");
                }
                String[] r = sce.getEnumValues(this.getBoundFactType(c.getBoundName()), c.getFactField());
                return r != null ? r : new String[]{};
            }
            if (col instanceof ActionInsertFactCol) {
                ActionInsertFactCol c = (ActionInsertFactCol)col;
                if (c.getValueList() != null && !"".equals(c.getValueList())) {
                    return c.getValueList().split(",");
                }
                String[] r = sce.getEnumValues(c.getFactType(), c.getFactField());
                return r != null ? r : new String[]{};
            }
        }
        return new String[0];
    }

    public boolean isConstraintValid(DTColumnConfig col, SuggestionCompletionEngine sce) {
        if (col instanceof RowNumberCol) {
            return true;
        }
        if (col instanceof DescriptionCol) {
            return true;
        }
        if (col instanceof MetadataCol) {
            return true;
        }
        if (col instanceof AttributeCol) {
            return true;
        }
        if (col instanceof ConditionCol) {
            ConditionCol c = (ConditionCol)col;
            if (c.getConstraintValueType() == 1) {
                if (c.getFactField() == null || c.getFactField().equals("")) {
                    return false;
                }
                return c.getOperator() != null && !c.getOperator().equals("");
            }
            return true;
        }
        return col instanceof ActionCol;
    }

    public void setData(List<List<DTCellValue>> data) {
        this.data = data;
    }

    public void setDescriptionCol(DescriptionCol descriptionCol) {
        this.descriptionCol = descriptionCol;
    }

    public void setParentName(String parentName) {
        this.parentName = parentName;
    }

    public void setRowNumberCol(RowNumberCol rowNumberCol) {
        this.rowNumberCol = rowNumberCol;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    private String getBoundFactType(String boundName) {
        for (ConditionCol c : this.getConditionCols()) {
            if (!c.getBoundName().equals(boundName)) continue;
            return c.getFactType();
        }
        return null;
    }

    private boolean assertDataType(ConditionCol col, SuggestionCompletionEngine sce, String dataType) {
        if (col.getConstraintValueType() == 1) {
            if (col.getOperator() == null || "".equals(col.getOperator())) {
                return false;
            }
            String ft = sce.getFieldType(col.getFactType(), col.getFactField());
            if (ft != null && ft.equals(dataType)) {
                return true;
            }
        }
        return false;
    }

    private boolean assertDataType(ActionSetFieldCol col, SuggestionCompletionEngine sce, String dataType) {
        String ft = sce.getFieldType(this.getBoundFactType(col.getBoundName()), col.getFactField());
        return ft != null && ft.equals(dataType);
    }

    private boolean assertDataType(ActionInsertFactCol col, SuggestionCompletionEngine sce, String dataType) {
        String ft = sce.getFieldType(col.getFactType(), col.getFactField());
        return ft != null && ft.equals(dataType);
    }
}

