/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.server.factconstraints.factory;

import org.drools.ide.common.client.factconstraints.ConstraintConfiguration;
import org.drools.ide.common.server.factconstraints.Constraint;
import org.drools.ide.common.server.factconstraints.predefined.IntegerConstraint;
import org.drools.ide.common.server.factconstraints.predefined.InvalidFieldConstraint;
import org.drools.ide.common.server.factconstraints.predefined.MatchesConstraint;
import org.drools.ide.common.server.factconstraints.predefined.NotMatchesConstraint;
import org.drools.ide.common.server.factconstraints.predefined.NotNullConstraint;
import org.drools.ide.common.server.factconstraints.predefined.RangeConstraint;

public class ConstraintsFactory {
    private static final ConstraintsFactory INSTANCE = new ConstraintsFactory();

    public static ConstraintsFactory getInstance() {
        return INSTANCE;
    }

    private ConstraintsFactory() {
    }

    public Constraint buildConstraint(ConstraintConfiguration config) {
        if ("NotNull".equals(config.getConstraintName())) {
            return new NotNullConstraint();
        }
        if ("IntegerConstraint".equals(config.getConstraintName())) {
            return new IntegerConstraint();
        }
        if ("RangeConstraint".equals(config.getConstraintName())) {
            return new RangeConstraint();
        }
        if ("NotMatches".equals(config.getConstraintName())) {
            return new NotMatchesConstraint();
        }
        if ("Matches".equals(config.getConstraintName())) {
            return new MatchesConstraint();
        }
        if ("IvalidFieldConstraint".equals(config.getConstraintName())) {
            return new InvalidFieldConstraint();
        }
        throw new IllegalArgumentException("Constraint unknown: " + config.getConstraintName());
    }

    public String getVerifierRule(ConstraintConfiguration config) {
        return this.buildConstraint(config).getVerifierRule(config);
    }
}

