/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.server.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.drools.ide.common.client.modeldriven.brl.ActionFieldValue;
import org.drools.ide.common.client.modeldriven.brl.ActionInsertFact;
import org.drools.ide.common.client.modeldriven.brl.ActionInsertLogicalFact;
import org.drools.ide.common.client.modeldriven.brl.ActionRetractFact;
import org.drools.ide.common.client.modeldriven.brl.ActionSetField;
import org.drools.ide.common.client.modeldriven.brl.ActionUpdateField;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;
import org.drools.ide.common.client.modeldriven.brl.FieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.IAction;
import org.drools.ide.common.client.modeldriven.brl.IPattern;
import org.drools.ide.common.client.modeldriven.brl.RuleAttribute;
import org.drools.ide.common.client.modeldriven.brl.RuleMetadata;
import org.drools.ide.common.client.modeldriven.brl.RuleModel;
import org.drools.ide.common.client.modeldriven.brl.SingleFieldConstraint;
import org.drools.ide.common.client.modeldriven.dt.ActionCol;
import org.drools.ide.common.client.modeldriven.dt.ActionInsertFactCol;
import org.drools.ide.common.client.modeldriven.dt.ActionRetractFactCol;
import org.drools.ide.common.client.modeldriven.dt.ActionSetFieldCol;
import org.drools.ide.common.client.modeldriven.dt.AttributeCol;
import org.drools.ide.common.client.modeldriven.dt.ConditionCol;
import org.drools.ide.common.client.modeldriven.dt.DTCellValue;
import org.drools.ide.common.client.modeldriven.dt.DTColumnConfig;
import org.drools.ide.common.client.modeldriven.dt.MetadataCol;
import org.drools.ide.common.client.modeldriven.dt.TypeSafeGuidedDecisionTable;
import org.drools.ide.common.server.util.BRDRLPersistence;
import org.drools.ide.common.server.util.GuidedDTDRLOtherwiseHelper;
import org.drools.ide.common.server.util.GuidedDTDRLUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuidedDTDRLPersistence {
    public static GuidedDTDRLPersistence getInstance() {
        return new GuidedDTDRLPersistence();
    }

    public String marshal(TypeSafeGuidedDecisionTable dt) {
        StringBuilder sb = new StringBuilder();
        List<List<DTCellValue>> data = dt.getData();
        List<DTColumnConfig> allColumns = dt.getAllColumns();
        for (int i = 0; i < data.size(); ++i) {
            List<DTCellValue> row = data.get(i);
            BigDecimal num = row.get(0).getNumericValue();
            String desc = row.get(1).getStringValue();
            RuleModel rm = new RuleModel();
            rm.name = this.getName(dt.getTableName(), num);
            this.doMetadata(allColumns, dt.getMetadataCols(), row, rm);
            this.doAttribs(allColumns, dt.getAttributeCols(), row, rm);
            this.doConditions(allColumns, dt.getConditionCols(), row, data, rm);
            this.doActions(allColumns, dt.getActionCols(), row, rm);
            if (dt.getParentName() != null) {
                rm.parentName = dt.getParentName();
            }
            sb.append("#from row number: " + (i + 1) + "\n");
            if (desc != null && desc.length() > 0) {
                sb.append("#" + desc + "\n");
            }
            String rule = BRDRLPersistence.getInstance().marshal(rm);
            sb.append(rule);
            sb.append("\n");
        }
        return sb.toString();
    }

    void doActions(List<DTColumnConfig> allColumns, List<ActionCol> actionCols, List<DTCellValue> row, RuleModel rm) {
        int i;
        ArrayList<LabelledAction> actions = new ArrayList<LabelledAction>();
        for (i = 0; i < actionCols.size(); ++i) {
            ActionFieldValue val;
            LabelledAction a;
            ActionCol c = actionCols.get(i);
            int index = allColumns.indexOf(c);
            String cell = GuidedDTDRLUtilities.convertDTCellValueToString(row.get(index));
            if (!this.validCell(cell)) {
                cell = c.getDefaultValue();
            }
            if (!this.validCell(cell)) continue;
            if (c instanceof ActionInsertFactCol) {
                ActionInsertFact ins;
                ActionInsertFactCol ac = (ActionInsertFactCol)c;
                a = this.findByLabelledAction(actions, ac.getBoundName());
                if (a == null) {
                    a = new LabelledAction();
                    a.boundName = ac.getBoundName();
                    if (!ac.isInsertLogical()) {
                        ins = new ActionInsertFact(ac.getFactType());
                        ins.setBoundName(ac.getBoundName());
                        a.action = ins;
                    } else {
                        ins = new ActionInsertLogicalFact(ac.getFactType());
                        ins.setBoundName(ac.getBoundName());
                        a.action = ins;
                    }
                    actions.add(a);
                }
                ins = (ActionInsertFact)a.action;
                val = new ActionFieldValue(ac.getFactField(), cell, ac.getType());
                ins.addFieldValue(val);
                continue;
            }
            if (c instanceof ActionRetractFactCol) {
                ActionRetractFactCol rf = (ActionRetractFactCol)c;
                a = this.findByLabelledAction(actions, rf.getBoundName());
                if (a != null) continue;
                a = new LabelledAction();
                a.action = new ActionRetractFact(rf.getBoundName());
                a.boundName = rf.getBoundName();
                actions.add(a);
                continue;
            }
            if (!(c instanceof ActionSetFieldCol)) continue;
            ActionSetFieldCol sf = (ActionSetFieldCol)c;
            a = this.findByLabelledAction(actions, sf.getBoundName());
            if (a == null) {
                a = new LabelledAction();
                a.boundName = sf.getBoundName();
                a.action = !sf.isUpdate() ? new ActionSetField(sf.getBoundName()) : new ActionUpdateField(sf.getBoundName());
                actions.add(a);
            } else if (sf.isUpdate() && !(a.action instanceof ActionUpdateField)) {
                ActionSetField old = (ActionSetField)a.action;
                ActionUpdateField update = new ActionUpdateField(sf.getBoundName());
                update.fieldValues = old.fieldValues;
                a.action = update;
            }
            ActionSetField asf = (ActionSetField)a.action;
            val = new ActionFieldValue(sf.getFactField(), cell, sf.getType());
            asf.addFieldValue(val);
        }
        rm.rhs = new IAction[actions.size()];
        for (i = 0; i < rm.rhs.length; ++i) {
            rm.rhs[i] = ((LabelledAction)actions.get((int)i)).action;
        }
    }

    private LabelledAction findByLabelledAction(List<LabelledAction> actions, String boundName) {
        for (LabelledAction labelledAction : actions) {
            if (!labelledAction.boundName.equals(boundName)) continue;
            return labelledAction;
        }
        return null;
    }

    void doConditions(List<DTColumnConfig> allColumns, List<ConditionCol> conditionCols, List<DTCellValue> row, List<List<DTCellValue>> data, RuleModel rm) {
        ArrayList<FactPattern> patterns = new ArrayList<FactPattern>();
        block4: for (int i = 0; i < conditionCols.size(); ++i) {
            boolean isOtherwise;
            ConditionCol c = conditionCols.get(i);
            int index = allColumns.indexOf(c);
            DTCellValue dcv = row.get(index);
            String cell = GuidedDTDRLUtilities.convertDTCellValueToString(dcv);
            boolean isValid = isOtherwise = dcv.isOtherwise();
            if (!isOtherwise && !(isValid = this.validCell(cell))) {
                cell = c.getDefaultValue();
                isValid = this.validCell(cell);
            }
            if (c.getOperator() != null && (c.getOperator().equals("== null") || c.getOperator().equals("!= null"))) {
                isValid = true;
            }
            if (!isValid) continue;
            FactPattern fp = this.findByFactPattern(patterns, c.getBoundName());
            if (fp == null) {
                fp = new FactPattern(c.getFactType());
                fp.setBoundName(c.getBoundName());
                fp.setNegated(c.isNegated());
                patterns.add(fp);
            }
            switch (c.getConstraintValueType()) {
                case 1: 
                case 3: {
                    FieldConstraint fc;
                    if (!isOtherwise) {
                        fc = this.makeSingleFieldConstraint(c, cell);
                        fp.addConstraint(fc);
                        continue block4;
                    }
                    fc = this.makeSingleFieldConstraint(c, allColumns, data);
                    fp.addConstraint(fc);
                    continue block4;
                }
                case 5: {
                    SingleFieldConstraint pred = new SingleFieldConstraint();
                    pred.setConstraintValueType(c.getConstraintValueType());
                    if (c.getFactField() != null && c.getFactField().indexOf("$param") > -1) {
                        pred.setValue(c.getFactField().replace("$param", cell));
                    } else {
                        pred.setValue(cell);
                    }
                    fp.addConstraint(pred);
                    continue block4;
                }
                default: {
                    throw new IllegalArgumentException("Unknown constraintValueType: " + c.getConstraintValueType());
                }
            }
        }
        rm.lhs = patterns.toArray(new IPattern[patterns.size()]);
    }

    String makeInList(String cell) {
        if (cell.startsWith("(")) {
            return cell;
        }
        String res = "";
        StringTokenizer st = new StringTokenizer(cell, ",");
        while (st.hasMoreTokens()) {
            String t = st.nextToken().trim();
            res = t.startsWith("\"") ? res + t : res + "\"" + t + "\"";
            if (!st.hasMoreTokens()) continue;
            res = res + ", ";
        }
        return "(" + res + ")";
    }

    private boolean no(String operator) {
        return operator == null || "".equals(operator);
    }

    private FactPattern findByFactPattern(List<FactPattern> patterns, String boundName) {
        for (FactPattern factPattern : patterns) {
            if (!factPattern.getBoundName().equals(boundName)) continue;
            return factPattern;
        }
        return null;
    }

    void doAttribs(List<DTColumnConfig> allColumns, List<AttributeCol> attributeCols, List<DTCellValue> row, RuleModel rm) {
        ArrayList<RuleAttribute> attribs = new ArrayList<RuleAttribute>();
        for (int j = 0; j < attributeCols.size(); ++j) {
            AttributeCol at = attributeCols.get(j);
            int index = allColumns.indexOf(at);
            String cell = GuidedDTDRLUtilities.convertDTCellValueToString(row.get(index));
            if (this.validCell(cell)) {
                if (at.getAttribute().equals("negate")) {
                    rm.setNegated(Boolean.valueOf(cell));
                    continue;
                }
                attribs.add(new RuleAttribute(at.getAttribute(), cell));
                continue;
            }
            if (at.getDefaultValue() == null) continue;
            attribs.add(new RuleAttribute(at.getAttribute(), at.getDefaultValue()));
        }
        if (attribs.size() > 0) {
            rm.attributes = attribs.toArray(new RuleAttribute[attribs.size()]);
        }
    }

    void doMetadata(List<DTColumnConfig> allColumns, List<MetadataCol> metadataCols, List<DTCellValue> row, RuleModel rm) {
        ArrayList<RuleMetadata> metadataList = new ArrayList<RuleMetadata>();
        for (int j = 0; j < metadataCols.size(); ++j) {
            MetadataCol meta = metadataCols.get(j);
            int index = allColumns.indexOf(meta);
            String cell = GuidedDTDRLUtilities.convertDTCellValueToString(row.get(index));
            if (!this.validCell(cell)) continue;
            metadataList.add(new RuleMetadata(meta.getMetadata(), cell));
        }
        if (metadataList.size() > 0) {
            rm.metadataList = metadataList.toArray(new RuleMetadata[metadataList.size()]);
        }
    }

    String getName(String tableName, Number num) {
        return "Row " + num.longValue() + " " + tableName;
    }

    boolean validCell(String c) {
        return c != null && !c.trim().equals("");
    }

    private FieldConstraint makeSingleFieldConstraint(ConditionCol c, String cell) {
        SingleFieldConstraint sfc = new SingleFieldConstraint(c.getFactField());
        if (this.no(c.getOperator())) {
            String[] a = cell.split("\\s");
            if (a.length > 1) {
                sfc.setOperator(a[0]);
                sfc.setValue(a[1]);
            } else {
                sfc.setValue(cell);
            }
        } else {
            sfc.setOperator(c.getOperator());
            if (c.getOperator().equals("in")) {
                sfc.setValue(this.makeInList(cell));
            } else if (!c.getOperator().equals("== null") && !c.getOperator().equals("!= null")) {
                sfc.setValue(cell);
            }
        }
        sfc.setParameters(c.getParameters());
        sfc.setConstraintValueType(c.getConstraintValueType());
        sfc.setFieldType(c.getFieldType());
        return sfc;
    }

    private FieldConstraint makeSingleFieldConstraint(ConditionCol c, List<DTColumnConfig> allColumns, List<List<DTCellValue>> data) {
        GuidedDTDRLOtherwiseHelper.OtherwiseBuilder builder = GuidedDTDRLOtherwiseHelper.getBuilder(c);
        return builder.makeFieldConstraint(c, allColumns, data);
    }

    private class LabelledAction {
        String boundName;
        IAction action;

        private LabelledAction() {
        }
    }
}

