/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.server.util;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import org.drools.ide.common.client.modeldriven.dt.ActionInsertFactCol;
import org.drools.ide.common.client.modeldriven.dt.ActionRetractFactCol;
import org.drools.ide.common.client.modeldriven.dt.ActionSetFieldCol;
import org.drools.ide.common.client.modeldriven.dt.AttributeCol;
import org.drools.ide.common.client.modeldriven.dt.ConditionCol;
import org.drools.ide.common.client.modeldriven.dt.DTCellValue;
import org.drools.ide.common.client.modeldriven.dt.GuidedDecisionTable;
import org.drools.ide.common.client.modeldriven.dt.MetadataCol;
import org.drools.ide.common.client.modeldriven.dt.TypeSafeGuidedDecisionTable;
import org.drools.ide.common.server.util.RepositoryUpgradeHelper;

public class GuidedDTXMLPersistence {
    private XStream xt = new XStream((HierarchicalStreamDriver)new DomDriver());
    private static GuidedDTXMLPersistence INSTANCE = new GuidedDTXMLPersistence();

    private GuidedDTXMLPersistence() {
        this.xt.alias("decision-table", GuidedDecisionTable.class);
        this.xt.alias("metadata-column", MetadataCol.class);
        this.xt.alias("attribute-column", AttributeCol.class);
        this.xt.alias("condition-column", ConditionCol.class);
        this.xt.alias("set-field-col", ActionSetFieldCol.class);
        this.xt.alias("retract-fact-column", ActionRetractFactCol.class);
        this.xt.alias("insert-fact-column", ActionInsertFactCol.class);
        this.xt.aliasField("attr", AttributeCol.class, "attribute");
        this.xt.aliasPackage("org.drools.guvnor.client", "org.drools.ide.common.client");
        this.xt.alias("dtable", TypeSafeGuidedDecisionTable.class);
        this.xt.alias("value", DTCellValue.class);
    }

    public static GuidedDTXMLPersistence getInstance() {
        return INSTANCE;
    }

    public String marshal(TypeSafeGuidedDecisionTable dt) {
        return this.xt.toXML((Object)dt);
    }

    public TypeSafeGuidedDecisionTable unmarshal(String xml) {
        TypeSafeGuidedDecisionTable newDTModel;
        if (xml == null || xml.trim().equals("")) {
            return new TypeSafeGuidedDecisionTable();
        }
        Object model = this.xt.fromXML(xml);
        if (model instanceof GuidedDecisionTable) {
            GuidedDecisionTable legacyDTModel = (GuidedDecisionTable)model;
            newDTModel = RepositoryUpgradeHelper.convertGuidedDTModel(legacyDTModel);
        } else {
            newDTModel = (TypeSafeGuidedDecisionTable)model;
        }
        return newDTModel;
    }
}

