/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.modeldriven.dt;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.drools.ide.common.client.modeldriven.ModelField;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.dt52.ActionInsertFactCol52;
import org.drools.ide.common.client.modeldriven.dt52.ActionSetFieldCol52;
import org.drools.ide.common.client.modeldriven.dt52.AttributeCol52;
import org.drools.ide.common.client.modeldriven.dt52.ConditionCol52;
import org.drools.ide.common.client.modeldriven.dt52.DTColumnConfig52;
import org.drools.ide.common.client.modeldriven.dt52.DescriptionCol52;
import org.drools.ide.common.client.modeldriven.dt52.GuidedDecisionTable52;
import org.drools.ide.common.client.modeldriven.dt52.MetadataCol52;
import org.drools.ide.common.client.modeldriven.dt52.Pattern52;
import org.drools.ide.common.client.modeldriven.dt52.RowNumberCol52;
import org.junit.Assert;
import org.junit.Test;

public class GuidedDecisionTableTest {
    @Test
    public void testValueLists() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        ConditionCol52 c1 = new ConditionCol52();
        Pattern52 p1 = new Pattern52();
        p1.setBoundName("c1");
        p1.setFactType("Driver");
        c1.setFactField("name");
        c1.setConstraintValueType(1);
        p1.getConditions().add(c1);
        dt.getConditionPatterns().add(p1);
        ConditionCol52 c1_ = new ConditionCol52();
        Pattern52 p1_ = new Pattern52();
        p1_.setBoundName("c1");
        p1_.setFactType("Driver");
        c1_.setFactField("name");
        p1_.getConditions().add(c1_);
        c1_.setConstraintValueType(3);
        dt.getConditionPatterns().add(p1_);
        ConditionCol52 c1__ = new ConditionCol52();
        Pattern52 p1__ = new Pattern52();
        p1__.setBoundName("c1");
        p1__.setFactType("Driver");
        c1__.setFactField("name");
        c1__.setConstraintValueType(1);
        c1__.setValueList("one,two,three");
        p1__.getConditions().add(c1__);
        dt.getConditionPatterns().add(p1__);
        ConditionCol52 c2 = new ConditionCol52();
        Pattern52 p2 = new Pattern52();
        p2.setBoundName("c2");
        p2.setFactType("Driver");
        c2.setFactField("nothing");
        c2.setConstraintValueType(1);
        p2.getConditions().add(c2);
        dt.getConditionPatterns().add(p2);
        ActionSetFieldCol52 asf = new ActionSetFieldCol52();
        asf.setBoundName("c1");
        asf.setFactField("name");
        dt.getActionCols().add(asf);
        ActionInsertFactCol52 ins = new ActionInsertFactCol52();
        ins.setBoundName("x");
        ins.setFactField("rating");
        ins.setFactType("Person");
        dt.getActionCols().add(ins);
        ActionInsertFactCol52 ins_ = new ActionInsertFactCol52();
        ins_.setBoundName("x");
        ins_.setFactField("rating");
        ins_.setFactType("Person");
        ins_.setValueList("one,two,three");
        dt.getActionCols().add(ins_);
        ActionSetFieldCol52 asf_ = new ActionSetFieldCol52();
        asf_.setBoundName("c1");
        asf_.setFactField("goo");
        dt.getActionCols().add(asf_);
        ActionSetFieldCol52 asf__ = new ActionSetFieldCol52();
        asf__.setBoundName("c1");
        asf__.setFactField("goo");
        asf__.setValueList("one,two,three");
        dt.getActionCols().add(asf__);
        SuggestionCompletionEngine sce = new SuggestionCompletionEngine();
        sce.putDataEnumList("Driver.name", new String[]{"bob", "michael"});
        sce.putDataEnumList("Person.rating", new String[]{"1", "2"});
        String[] r = dt.getValueList((DTColumnConfig52)c1, sce);
        Assert.assertEquals((long)2L, (long)r.length);
        Assert.assertEquals((Object)"bob", (Object)r[0]);
        Assert.assertEquals((Object)"michael", (Object)r[1]);
        Assert.assertEquals((long)0L, (long)dt.getValueList((DTColumnConfig52)c1_, sce).length);
        r = dt.getValueList((DTColumnConfig52)c1__, sce);
        Assert.assertEquals((long)3L, (long)r.length);
        Assert.assertEquals((Object)"one", (Object)r[0]);
        Assert.assertEquals((Object)"two", (Object)r[1]);
        Assert.assertEquals((Object)"three", (Object)r[2]);
        Assert.assertEquals((long)0L, (long)dt.getValueList((DTColumnConfig52)c2, sce).length);
        r = dt.getValueList((DTColumnConfig52)asf, sce);
        Assert.assertEquals((long)2L, (long)r.length);
        Assert.assertEquals((Object)"bob", (Object)r[0]);
        Assert.assertEquals((Object)"michael", (Object)r[1]);
        r = dt.getValueList((DTColumnConfig52)ins, sce);
        Assert.assertEquals((long)2L, (long)r.length);
        Assert.assertEquals((Object)"1", (Object)r[0]);
        Assert.assertEquals((Object)"2", (Object)r[1]);
        r = dt.getValueList((DTColumnConfig52)ins_, sce);
        Assert.assertEquals((long)3L, (long)r.length);
        Assert.assertEquals((Object)"one", (Object)r[0]);
        Assert.assertEquals((Object)"two", (Object)r[1]);
        Assert.assertEquals((Object)"three", (Object)r[2]);
        Assert.assertEquals((long)0L, (long)dt.getValueList((DTColumnConfig52)asf_, sce).length);
        r = dt.getValueList((DTColumnConfig52)asf__, sce);
        Assert.assertEquals((long)3L, (long)r.length);
        Assert.assertEquals((Object)"one", (Object)r[0]);
        Assert.assertEquals((Object)"two", (Object)r[1]);
        Assert.assertEquals((Object)"three", (Object)r[2]);
        AttributeCol52 at = new AttributeCol52();
        at.setAttribute("no-loop");
        dt.getAttributeCols().add(at);
        r = dt.getValueList((DTColumnConfig52)at, sce);
        Assert.assertEquals((long)2L, (long)r.length);
        Assert.assertEquals((Object)"true", (Object)r[0]);
        Assert.assertEquals((Object)"false", (Object)r[1]);
        at.setAttribute("enabled");
        Assert.assertEquals((long)2L, (long)dt.getValueList((DTColumnConfig52)at, sce).length);
        at.setAttribute("salience");
        Assert.assertEquals((long)0L, (long)dt.getValueList((DTColumnConfig52)at, sce).length);
    }

    @Test
    public void testNumeric() {
        SuggestionCompletionEngine sce = new SuggestionCompletionEngine();
        sce.setFieldsForTypes((Map)new HashMap<String, ModelField[]>(){
            {
                this.put("Driver", new ModelField[]{new ModelField("age", Integer.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, "Numeric"), new ModelField("name", String.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, "String")});
            }
        });
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        AttributeCol52 at = new AttributeCol52();
        at.setAttribute("salience");
        AttributeCol52 at_ = new AttributeCol52();
        at_.setAttribute("enabled");
        dt.getAttributeCols().add(at);
        dt.getAttributeCols().add(at_);
        ConditionCol52 c1 = new ConditionCol52();
        Pattern52 p1 = new Pattern52();
        p1.setBoundName("c1");
        p1.setFactType("Driver");
        c1.setFactField("name");
        c1.setOperator("==");
        c1.setConstraintValueType(1);
        p1.getConditions().add(c1);
        dt.getConditionPatterns().add(p1);
        ConditionCol52 c1_ = new ConditionCol52();
        Pattern52 p1_ = new Pattern52();
        p1_.setBoundName("c1");
        p1_.setFactType("Driver");
        c1_.setFactField("age");
        c1_.setOperator("==");
        c1_.setConstraintValueType(1);
        p1_.getConditions().add(c1_);
        dt.getConditionPatterns().add(p1_);
        ConditionCol52 c2 = new ConditionCol52();
        Pattern52 p2 = new Pattern52();
        p2.setBoundName("c1");
        p2.setFactType("Driver");
        c2.setFactField("age");
        c2.setConstraintValueType(1);
        p2.getConditions().add(c2);
        dt.getConditionPatterns().add(p2);
        ActionSetFieldCol52 a = new ActionSetFieldCol52();
        a.setBoundName("c1");
        a.setFactField("name");
        dt.getActionCols().add(a);
        ActionSetFieldCol52 a2 = new ActionSetFieldCol52();
        a2.setBoundName("c1");
        a2.setFactField("age");
        dt.getActionCols().add(a2);
        ActionInsertFactCol52 ins = new ActionInsertFactCol52();
        ins.setBoundName("x");
        ins.setFactType("Driver");
        ins.setFactField("name");
        dt.getActionCols().add(ins);
        ActionInsertFactCol52 ins_ = new ActionInsertFactCol52();
        ins_.setBoundName("x");
        ins_.setFactType("Driver");
        ins_.setFactField("age");
        dt.getActionCols().add(ins_);
        Assert.assertEquals((Object)"Numeric", (Object)dt.getType((DTColumnConfig52)at, sce));
        Assert.assertEquals((Object)"Numeric", (Object)dt.getType((DTColumnConfig52)c1_, sce));
        Assert.assertEquals((Object)"Numeric", (Object)dt.getType((DTColumnConfig52)a2, sce));
        Assert.assertEquals((Object)"Numeric", (Object)dt.getType((DTColumnConfig52)ins_, sce));
        Assert.assertEquals((Object)"Boolean", (Object)dt.getType((DTColumnConfig52)at_, sce));
        Assert.assertEquals((Object)"String", (Object)dt.getType((DTColumnConfig52)c1, sce));
        Assert.assertEquals((Object)"String", (Object)dt.getType((DTColumnConfig52)a, sce));
        Assert.assertEquals((Object)"String", (Object)dt.getType((DTColumnConfig52)ins, sce));
        Assert.assertEquals(null, (Object)dt.getType((DTColumnConfig52)c2, sce));
    }

    @Test
    public void testGetType() {
        SuggestionCompletionEngine sce = new SuggestionCompletionEngine();
        sce.setFieldsForTypes((Map)new HashMap<String, ModelField[]>(){
            {
                this.put("Driver", new ModelField[]{new ModelField("age", Integer.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, "Numeric"), new ModelField("name", String.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, "String"), new ModelField("date", Date.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, "Date"), new ModelField("approved", Boolean.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, "Boolean")});
            }
        });
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        AttributeCol52 salienceAttribute = new AttributeCol52();
        salienceAttribute.setAttribute("salience");
        AttributeCol52 enabledAttribute = new AttributeCol52();
        enabledAttribute.setAttribute("enabled");
        dt.getAttributeCols().add(salienceAttribute);
        dt.getAttributeCols().add(enabledAttribute);
        Pattern52 p1 = new Pattern52();
        ConditionCol52 conditionColName = new ConditionCol52();
        p1.setBoundName("c1");
        p1.setFactType("Driver");
        conditionColName.setFactField("name");
        conditionColName.setOperator("==");
        conditionColName.setConstraintValueType(1);
        p1.getConditions().add(conditionColName);
        ConditionCol52 conditionColAge = new ConditionCol52();
        conditionColAge.setFactField("age");
        conditionColAge.setOperator("==");
        conditionColAge.setConstraintValueType(1);
        p1.getConditions().add(conditionColAge);
        ConditionCol52 conditionColDate = new ConditionCol52();
        conditionColDate.setFactField("date");
        conditionColDate.setOperator("==");
        conditionColDate.setConstraintValueType(1);
        p1.getConditions().add(conditionColDate);
        ConditionCol52 conditionColApproved = new ConditionCol52();
        conditionColApproved.setFactField("approved");
        conditionColApproved.setOperator("==");
        conditionColApproved.setConstraintValueType(1);
        p1.getConditions().add(conditionColApproved);
        ConditionCol52 conditionColAge2 = new ConditionCol52();
        conditionColAge2.setFactField("age");
        conditionColAge2.setConstraintValueType(1);
        p1.getConditions().add(conditionColAge2);
        dt.getConditionPatterns().add(p1);
        ActionSetFieldCol52 a = new ActionSetFieldCol52();
        a.setBoundName("c1");
        a.setFactField("name");
        dt.getActionCols().add(a);
        ActionSetFieldCol52 a2 = new ActionSetFieldCol52();
        a2.setBoundName("c1");
        a2.setFactField("age");
        dt.getActionCols().add(a2);
        ActionInsertFactCol52 ins = new ActionInsertFactCol52();
        ins.setBoundName("x");
        ins.setFactType("Driver");
        ins.setFactField("name");
        dt.getActionCols().add(ins);
        ActionInsertFactCol52 ins_ = new ActionInsertFactCol52();
        ins_.setBoundName("x");
        ins_.setFactType("Driver");
        ins_.setFactField("age");
        dt.getActionCols().add(ins_);
        Assert.assertEquals((Object)"Numeric", (Object)dt.getType((DTColumnConfig52)salienceAttribute, sce));
        Assert.assertEquals((Object)"Boolean", (Object)dt.getType((DTColumnConfig52)enabledAttribute, sce));
        Assert.assertEquals((Object)"String", (Object)dt.getType((DTColumnConfig52)conditionColName, sce));
        Assert.assertEquals((Object)"Numeric", (Object)dt.getType((DTColumnConfig52)conditionColAge, sce));
        Assert.assertEquals((Object)"Date", (Object)dt.getType((DTColumnConfig52)conditionColDate, sce));
        Assert.assertEquals((Object)"Boolean", (Object)dt.getType((DTColumnConfig52)conditionColApproved, sce));
        Assert.assertEquals((Object)"String", (Object)dt.getType((DTColumnConfig52)a, sce));
        Assert.assertEquals((Object)"Numeric", (Object)dt.getType((DTColumnConfig52)a2, sce));
        Assert.assertEquals((Object)"String", (Object)dt.getType((DTColumnConfig52)ins, sce));
        Assert.assertEquals((Object)"Numeric", (Object)dt.getType((DTColumnConfig52)ins_, sce));
        Assert.assertEquals(null, (Object)dt.getType((DTColumnConfig52)conditionColAge2, sce));
    }

    @Test
    public void testNoConstraintLists() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        ConditionCol52 c1 = new ConditionCol52();
        Pattern52 p1 = new Pattern52();
        p1.setBoundName("c1");
        p1.setFactType("Driver");
        c1.setConstraintValueType(1);
        p1.getConditions().add(c1);
        dt.getConditionPatterns().add(p1);
        ConditionCol52 c2 = new ConditionCol52();
        Pattern52 p2 = new Pattern52();
        p2.setBoundName("c2");
        p2.setFactType("Driver");
        c2.setConstraintValueType(1);
        c2.setValueList("a,b,c");
        p2.getConditions().add(c2);
        dt.getConditionPatterns().add(p1);
        SuggestionCompletionEngine sce = new SuggestionCompletionEngine();
        sce.putDataEnumList("Driver.name", new String[]{"bob", "michael"});
        Assert.assertEquals((long)0L, (long)dt.getValueList((DTColumnConfig52)c1, sce).length);
        Assert.assertEquals((long)3L, (long)dt.getValueList((DTColumnConfig52)c2, sce).length);
    }

    @Test
    public void testNoConstraints() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        RowNumberCol52 rnc = new RowNumberCol52();
        DescriptionCol52 dc = new DescriptionCol52();
        MetadataCol52 mdc = new MetadataCol52();
        mdc.setMetadata("cheese");
        AttributeCol52 ac = new AttributeCol52();
        ac.setAttribute("salience");
        ActionSetFieldCol52 asfc = new ActionSetFieldCol52();
        asfc.setBoundName("d1");
        asfc.setFactField("age");
        ActionInsertFactCol52 aifc = new ActionInsertFactCol52();
        aifc.setBoundName("d2");
        aifc.setFactType("Driver");
        aifc.setFactField("age");
        ConditionCol52 c1 = new ConditionCol52();
        Pattern52 p1 = new Pattern52();
        p1.setBoundName("c1");
        p1.setFactType("Driver");
        c1.setConstraintValueType(1);
        p1.getConditions().add(c1);
        dt.getConditionPatterns().add(p1);
        ConditionCol52 c2 = new ConditionCol52();
        Pattern52 p2 = new Pattern52();
        p2.setBoundName("c2");
        p2.setFactType("Driver");
        c2.setFactField("age");
        c2.setConstraintValueType(1);
        p2.getConditions().add(c2);
        dt.getConditionPatterns().add(p2);
        ConditionCol52 c3 = new ConditionCol52();
        Pattern52 p3 = new Pattern52();
        p3.setBoundName("c3");
        p3.setFactType("Driver");
        c3.setOperator("==");
        c3.setConstraintValueType(1);
        p3.getConditions().add(c3);
        dt.getConditionPatterns().add(p3);
        ConditionCol52 c4 = new ConditionCol52();
        Pattern52 p4 = new Pattern52();
        p4.setBoundName("c4");
        p4.setFactType("Driver");
        c4.setFactField("age");
        c4.setOperator("==");
        c4.setConstraintValueType(1);
        p4.getConditions().add(c4);
        dt.getConditionPatterns().add(p4);
        ConditionCol52 c5 = new ConditionCol52();
        Pattern52 p5 = new Pattern52();
        p5.setBoundName("c5");
        p5.setFactType("Driver");
        c5.setConstraintValueType(5);
        p5.getConditions().add(c5);
        dt.getConditionPatterns().add(p5);
        ConditionCol52 c6 = new ConditionCol52();
        Pattern52 p6 = new Pattern52();
        p6.setBoundName("c6");
        p6.setFactType("Driver");
        c6.setConstraintValueType(3);
        p6.getConditions().add(c6);
        dt.getConditionPatterns().add(p6);
        SuggestionCompletionEngine sce = new SuggestionCompletionEngine();
        sce.setFieldsForTypes((Map)new HashMap<String, ModelField[]>(){
            {
                this.put("Driver", new ModelField[]{new ModelField("age", Integer.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, "Numeric"), new ModelField("name", String.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, "String")});
            }
        });
        Assert.assertTrue((boolean)dt.isConstraintValid((DTColumnConfig52)rnc, sce));
        Assert.assertTrue((boolean)dt.isConstraintValid((DTColumnConfig52)dc, sce));
        Assert.assertTrue((boolean)dt.isConstraintValid((DTColumnConfig52)mdc, sce));
        Assert.assertTrue((boolean)dt.isConstraintValid((DTColumnConfig52)ac, sce));
        Assert.assertTrue((boolean)dt.isConstraintValid((DTColumnConfig52)asfc, sce));
        Assert.assertTrue((boolean)dt.isConstraintValid((DTColumnConfig52)aifc, sce));
        Assert.assertFalse((boolean)dt.isConstraintValid((DTColumnConfig52)c1, sce));
        Assert.assertFalse((boolean)dt.isConstraintValid((DTColumnConfig52)c2, sce));
        Assert.assertFalse((boolean)dt.isConstraintValid((DTColumnConfig52)c3, sce));
        Assert.assertTrue((boolean)dt.isConstraintValid((DTColumnConfig52)c4, sce));
        Assert.assertTrue((boolean)dt.isConstraintValid((DTColumnConfig52)c5, sce));
        Assert.assertTrue((boolean)dt.isConstraintValid((DTColumnConfig52)c6, sce));
    }
}

