/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.server.factconstraints.predefined;

import java.util.Collection;
import org.drools.builder.ResourceType;
import org.drools.ide.common.client.factconstraints.ConstraintConfiguration;
import org.drools.ide.common.client.factconstraints.config.SimpleConstraintConfigurationImpl;
import org.drools.ide.common.server.factconstraints.Constraint;
import org.drools.ide.common.server.factconstraints.predefined.RangeConstraint;
import org.drools.io.ResourceFactory;
import org.drools.verifier.Verifier;
import org.drools.verifier.VerifierConfiguration;
import org.drools.verifier.VerifierConfigurationImpl;
import org.drools.verifier.VerifierError;
import org.drools.verifier.builder.VerifierBuilder;
import org.drools.verifier.builder.VerifierBuilderFactory;
import org.drools.verifier.data.VerifierReport;
import org.drools.verifier.report.components.Severity;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RangeConstraintMultipleOperatorsTest {
    private Verifier verifier;
    private Constraint cons;
    private ConstraintConfiguration conf;

    @Before
    public void setup() {
        this.cons = new RangeConstraint();
        this.conf = new SimpleConstraintConfigurationImpl();
        this.conf.setFactType("Person");
        this.conf.setFieldName("age");
        this.conf.setArgumentValue("Min.value", "0");
        this.conf.setArgumentValue("Max.value", "120");
        System.out.println("Validation Rule:\n" + this.cons.getVerifierRule(this.conf) + "\n\n");
    }

    @After
    public void dispose() {
        if (this.verifier != null) {
            this.verifier.dispose();
        }
    }

    @Test
    public void test1() {
        String rulesToVerify = "";
        int fail = 0;
        int warn = 0;
        rulesToVerify = rulesToVerify + "package org.drools.factconstraint.test\n\n";
        rulesToVerify = rulesToVerify + "import org.drools.factconstraint.model.*\n";
        rulesToVerify = rulesToVerify + "rule \"rule1\"\n";
        rulesToVerify = rulesToVerify + "   when\n";
        rulesToVerify = rulesToVerify + "       Person(age > 1, age < 100)\n";
        rulesToVerify = rulesToVerify + "   then\n";
        rulesToVerify = rulesToVerify + "       System.out.println(\"Rule fired\");\n";
        rulesToVerify = rulesToVerify + "end\n\n";
        rulesToVerify = rulesToVerify + "rule \"rule2\"\n";
        rulesToVerify = rulesToVerify + "   when\n";
        rulesToVerify = rulesToVerify + "       Person(age > -1,  age < 60)\n";
        rulesToVerify = rulesToVerify + "   then\n";
        rulesToVerify = rulesToVerify + "       System.out.println(\"Rule fired\");\n";
        rulesToVerify = rulesToVerify + "end\n\n";
        ++warn;
        rulesToVerify = rulesToVerify + "rule \"rule3\"\n";
        rulesToVerify = rulesToVerify + "   when\n";
        rulesToVerify = rulesToVerify + "       Person(age > -1,  age < 150)\n";
        rulesToVerify = rulesToVerify + "   then\n";
        rulesToVerify = rulesToVerify + "       System.out.println(\"Rule fired\");\n";
        rulesToVerify = rulesToVerify + "end\n\n";
        ++warn;
        rulesToVerify = rulesToVerify + "rule \"rule4\"\n";
        rulesToVerify = rulesToVerify + "   when\n";
        rulesToVerify = rulesToVerify + "       Person(age > 150,  age < -1)\n";
        rulesToVerify = rulesToVerify + "   then\n";
        rulesToVerify = rulesToVerify + "       System.out.println(\"Rule fired\");\n";
        rulesToVerify = rulesToVerify + "end\n\n";
        ++fail;
        rulesToVerify = rulesToVerify + "rule \"rule5\"\n";
        rulesToVerify = rulesToVerify + "   when\n";
        rulesToVerify = rulesToVerify + "       Person(age > -10,  age < -1)\n";
        rulesToVerify = rulesToVerify + "   then\n";
        rulesToVerify = rulesToVerify + "       System.out.println(\"Rule fired\");\n";
        rulesToVerify = rulesToVerify + "end\n\n";
        ++warn;
        rulesToVerify = rulesToVerify + "rule \"rule6\"\n";
        rulesToVerify = rulesToVerify + "   when\n";
        rulesToVerify = rulesToVerify + "       Person(age > 18,  age < 150)\n";
        rulesToVerify = rulesToVerify + "   then\n";
        rulesToVerify = rulesToVerify + "       System.out.println(\"Rule fired\");\n";
        rulesToVerify = rulesToVerify + "end\n\n";
        ++warn;
        rulesToVerify = rulesToVerify + "rule \"rule7\"\n";
        rulesToVerify = rulesToVerify + "   when\n";
        rulesToVerify = rulesToVerify + "       Person(age > 18,  age < -1)\n";
        rulesToVerify = rulesToVerify + "   then\n";
        rulesToVerify = rulesToVerify + "       System.out.println(\"Rule fired\");\n";
        rulesToVerify = rulesToVerify + "end\n\n";
        ++fail;
        rulesToVerify = rulesToVerify + "rule \"rule8\"\n";
        rulesToVerify = rulesToVerify + "   when\n";
        rulesToVerify = rulesToVerify + "       Person(age > 130,  age < 150)\n";
        rulesToVerify = rulesToVerify + "   then\n";
        rulesToVerify = rulesToVerify + "       System.out.println(\"Rule fired\");\n";
        rulesToVerify = rulesToVerify + "end\n\n";
        ++warn;
        rulesToVerify = rulesToVerify + "rule \"rule9\"\n";
        rulesToVerify = rulesToVerify + "   when\n";
        rulesToVerify = rulesToVerify + "       Person(age > 130,  age < 18)\n";
        rulesToVerify = rulesToVerify + "   then\n";
        rulesToVerify = rulesToVerify + "       System.out.println(\"Rule fired\");\n";
        rulesToVerify = rulesToVerify + "end\n\n";
        ++fail;
        VerifierReport result = this.verify(rulesToVerify);
        Collection errors = result.getBySeverity(Severity.ERROR);
        Collection warnings = result.getBySeverity(Severity.WARNING);
        System.out.println(warnings);
        System.out.println(errors);
        Assert.assertEquals((long)warn, (long)warnings.size());
        Assert.assertEquals((long)fail, (long)errors.size());
    }

    @Test
    public void test2() {
        String rulesToVerify = "";
        int fail = 0;
        int warn = 0;
        rulesToVerify = rulesToVerify + "package org.drools.factconstraint.test\n\n";
        rulesToVerify = rulesToVerify + "import org.drools.factconstraint.model.*\n";
        rulesToVerify = rulesToVerify + "rule \"rule1\"\n";
        rulesToVerify = rulesToVerify + "   when\n";
        rulesToVerify = rulesToVerify + "       Person(age >= 0, age <= 120)\n";
        rulesToVerify = rulesToVerify + "   then\n";
        rulesToVerify = rulesToVerify + "       System.out.println(\"Rule fired\");\n";
        rulesToVerify = rulesToVerify + "end\n\n";
        rulesToVerify = rulesToVerify + "rule \"rule2\"\n";
        rulesToVerify = rulesToVerify + "   when\n";
        rulesToVerify = rulesToVerify + "       Person(age >= 0, age <= 121)\n";
        rulesToVerify = rulesToVerify + "   then\n";
        rulesToVerify = rulesToVerify + "       System.out.println(\"Rule fired\");\n";
        rulesToVerify = rulesToVerify + "end\n\n";
        ++warn;
        rulesToVerify = rulesToVerify + "rule \"rule3\"\n";
        rulesToVerify = rulesToVerify + "   when\n";
        rulesToVerify = rulesToVerify + "       Person(age >= 0, age <= 121.1)\n";
        rulesToVerify = rulesToVerify + "   then\n";
        rulesToVerify = rulesToVerify + "       System.out.println(\"Rule fired\");\n";
        rulesToVerify = rulesToVerify + "end\n\n";
        ++warn;
        VerifierReport result = this.verify(rulesToVerify);
        Collection errors = result.getBySeverity(Severity.ERROR);
        Collection warnings = result.getBySeverity(Severity.WARNING);
        System.out.println(warnings);
        System.out.println(errors);
        Assert.assertEquals((long)warn, (long)warnings.size());
        Assert.assertEquals((long)fail, (long)errors.size());
    }

    private VerifierReport verify(String rulesToVerify) {
        VerifierBuilder vBuilder = VerifierBuilderFactory.newVerifierBuilder();
        VerifierConfigurationImpl conf = new VerifierConfigurationImpl();
        conf.getVerifyingResources().put(ResourceFactory.newByteArrayResource((byte[])this.cons.getVerifierRule(this.conf).getBytes()), ResourceType.DRL);
        this.verifier = vBuilder.newVerifier((VerifierConfiguration)conf);
        this.verifier.addResourcesToVerify(ResourceFactory.newByteArrayResource((byte[])rulesToVerify.getBytes()), ResourceType.DRL);
        if (this.verifier.hasErrors()) {
            for (VerifierError error : this.verifier.getErrors()) {
                System.out.println(error.getMessage());
            }
            throw new RuntimeException("Error building verifier");
        }
        Assert.assertFalse((boolean)this.verifier.hasErrors());
        boolean noProblems = this.verifier.fireAnalysis();
        Assert.assertTrue((boolean)noProblems);
        return this.verifier.getResult();
    }
}

