/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.server.util;

import java.io.InputStream;
import java.io.InputStreamReader;
import org.drools.ide.common.client.modeldriven.brl.ActionFieldValue;
import org.drools.ide.common.client.modeldriven.brl.ActionGlobalCollectionAdd;
import org.drools.ide.common.client.modeldriven.brl.ActionInsertFact;
import org.drools.ide.common.client.modeldriven.brl.ActionRetractFact;
import org.drools.ide.common.client.modeldriven.brl.ActionUpdateField;
import org.drools.ide.common.client.modeldriven.brl.CompositeFactPattern;
import org.drools.ide.common.client.modeldriven.brl.CompositeFieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.ConnectiveConstraint;
import org.drools.ide.common.client.modeldriven.brl.DSLSentence;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;
import org.drools.ide.common.client.modeldriven.brl.FieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.FreeFormLine;
import org.drools.ide.common.client.modeldriven.brl.IAction;
import org.drools.ide.common.client.modeldriven.brl.IFactPattern;
import org.drools.ide.common.client.modeldriven.brl.IPattern;
import org.drools.ide.common.client.modeldriven.brl.RuleAttribute;
import org.drools.ide.common.client.modeldriven.brl.RuleModel;
import org.drools.ide.common.client.modeldriven.brl.SingleFieldConstraint;
import org.drools.ide.common.server.util.BRLPersistence;
import org.drools.ide.common.server.util.BRXMLPersistence;
import org.junit.Assert;
import org.junit.Test;

public class BRLPersistenceTest {
    @Test
    public void testGenerateEmptyXML() {
        BRLPersistence p = BRXMLPersistence.getInstance();
        String xml = p.marshal(new RuleModel());
        Assert.assertNotNull((Object)xml);
        Assert.assertFalse((boolean)xml.equals(""));
        Assert.assertTrue((boolean)xml.startsWith("<rule>"));
        Assert.assertTrue((boolean)xml.endsWith("</rule>"));
    }

    @Test
    public void testBasics() {
        BRLPersistence p = BRXMLPersistence.getInstance();
        RuleModel m = new RuleModel();
        m.addLhsItem((IPattern)new FactPattern("Person"));
        m.addLhsItem((IPattern)new FactPattern("Accident"));
        m.addAttribute(new RuleAttribute("no-loop", "true"));
        m.addRhsItem((IAction)new ActionInsertFact("Report"));
        ActionGlobalCollectionAdd ag = new ActionGlobalCollectionAdd();
        ag.factName = "x";
        ag.globalName = "g";
        m.addRhsItem((IAction)ag);
        m.name = "my rule";
        String xml = p.marshal(m);
        System.out.println(xml);
        Assert.assertTrue((xml.indexOf("Person") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((xml.indexOf("Accident") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((xml.indexOf("no-loop") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((xml.indexOf("org.drools") == -1 ? 1 : 0) != 0);
        Assert.assertTrue((xml.indexOf("addToGlobal") > -1 ? 1 : 0) != 0);
        RuleModel rm_ = BRXMLPersistence.getInstance().unmarshal(xml);
        Assert.assertEquals((long)2L, (long)rm_.rhs.length);
    }

    @Test
    public void testMoreComplexRendering() {
        BRLPersistence p = BRXMLPersistence.getInstance();
        RuleModel m = this.getComplexModel();
        String xml = p.marshal(m);
        System.out.println(xml);
        Assert.assertTrue((xml.indexOf("org.drools") == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testRoundTrip() {
        RuleModel m = this.getComplexModel();
        String xml = BRXMLPersistence.getInstance().marshal(m);
        RuleModel m2 = BRXMLPersistence.getInstance().unmarshal(xml);
        Assert.assertNotNull((Object)m2);
        Assert.assertEquals((Object)m.name, (Object)m2.name);
        Assert.assertEquals((long)m.lhs.length, (long)m2.lhs.length);
        Assert.assertEquals((long)m.rhs.length, (long)m2.rhs.length);
        Assert.assertEquals((long)1L, (long)m.attributes.length);
        RuleAttribute at = m.attributes[0];
        Assert.assertEquals((Object)"no-loop", (Object)at.attributeName);
        Assert.assertEquals((Object)"true", (Object)at.value);
        String newXML = BRXMLPersistence.getInstance().marshal(m2);
        Assert.assertEquals((Object)xml, (Object)newXML);
    }

    @Test
    public void testCompositeConstraintsRoundTrip() throws Exception {
        RuleModel m = new RuleModel();
        m.name = "with composite";
        FactPattern p1 = new FactPattern("Person");
        p1.setBoundName("p1");
        m.addLhsItem((IPattern)p1);
        FactPattern p = new FactPattern("Goober");
        m.addLhsItem((IPattern)p);
        CompositeFieldConstraint comp = new CompositeFieldConstraint();
        comp.compositeJunctionType = "||";
        p.addConstraint((FieldConstraint)comp);
        SingleFieldConstraint X = new SingleFieldConstraint();
        X.setFieldName("goo");
        X.setConstraintValueType(1);
        X.setValue("foo");
        X.setOperator("==");
        X.connectives = new ConnectiveConstraint[1];
        X.connectives[0] = new ConnectiveConstraint();
        X.connectives[0].setConstraintValueType(1);
        X.connectives[0].setOperator("|| ==");
        X.connectives[0].setValue("bar");
        comp.addConstraint((FieldConstraint)X);
        SingleFieldConstraint Y = new SingleFieldConstraint();
        Y.setFieldName("goo2");
        Y.setConstraintValueType(1);
        Y.setValue("foo");
        Y.setOperator("==");
        comp.addConstraint((FieldConstraint)Y);
        CompositeFieldConstraint comp2 = new CompositeFieldConstraint();
        comp2.compositeJunctionType = "&&";
        SingleFieldConstraint Q1 = new SingleFieldConstraint();
        Q1.setFieldName("goo");
        Q1.setOperator("==");
        Q1.setValue("whee");
        Q1.setConstraintValueType(1);
        comp2.addConstraint((FieldConstraint)Q1);
        SingleFieldConstraint Q2 = new SingleFieldConstraint();
        Q2.setFieldName("gabba");
        Q2.setOperator("==");
        Q2.setValue("whee");
        Q2.setConstraintValueType(1);
        comp2.addConstraint((FieldConstraint)Q2);
        comp.addConstraint((FieldConstraint)comp2);
        SingleFieldConstraint Z = new SingleFieldConstraint();
        Z.setFieldName("goo3");
        Z.setConstraintValueType(1);
        Z.setValue("foo");
        Z.setOperator("==");
        p.addConstraint((FieldConstraint)Z);
        ActionInsertFact ass = new ActionInsertFact("Whee");
        m.addRhsItem((IAction)ass);
        String xml = BRXMLPersistence.getInstance().marshal(m);
        RuleModel m2 = BRXMLPersistence.getInstance().unmarshal(xml);
        Assert.assertNotNull((Object)m2);
        Assert.assertEquals((Object)"with composite", (Object)m2.name);
        Assert.assertEquals((long)m2.lhs.length, (long)m.lhs.length);
        Assert.assertEquals((long)m2.rhs.length, (long)m.rhs.length);
    }

    @Test
    public void testFreeFormLine() {
        RuleModel m = new RuleModel();
        m.name = "with composite";
        m.lhs = new IPattern[1];
        m.rhs = new IAction[1];
        FreeFormLine fl = new FreeFormLine();
        fl.text = "Person()";
        m.lhs[0] = fl;
        FreeFormLine fr = new FreeFormLine();
        fr.text = "fun()";
        m.rhs[0] = fr;
        String xml = BRXMLPersistence.getInstance().marshal(m);
        Assert.assertNotNull((Object)xml);
        RuleModel m_ = BRXMLPersistence.getInstance().unmarshal(xml);
        Assert.assertEquals((long)1L, (long)m_.lhs.length);
        Assert.assertEquals((long)1L, (long)m_.rhs.length);
        Assert.assertEquals((Object)"Person()", (Object)((FreeFormLine)m_.lhs[0]).text);
        Assert.assertEquals((Object)"fun()", (Object)((FreeFormLine)m_.rhs[0]).text);
    }

    @Test
    public void testBackwardsCompat() throws Exception {
        RuleModel m2 = BRXMLPersistence.getInstance().unmarshal(BRLPersistenceTest.loadResource("existing_brl.xml"));
        Assert.assertNotNull((Object)m2);
        Assert.assertEquals((long)3L, (long)m2.rhs.length);
    }

    public static String loadResource(String name) throws Exception {
        InputStream in = BRLPersistenceTest.class.getResourceAsStream(name);
        InputStreamReader reader = new InputStreamReader(in);
        StringBuilder text = new StringBuilder();
        char[] buf = new char[1024];
        int len = 0;
        while ((len = reader.read(buf)) >= 0) {
            text.append(buf, 0, len);
        }
        return text.toString();
    }

    private RuleModel getComplexModel() {
        RuleModel m = new RuleModel();
        m.addAttribute(new RuleAttribute("no-loop", "true"));
        FactPattern pat = new FactPattern("Person");
        pat.setBoundName("p1");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldBinding("f1");
        con.setFieldName("age");
        con.setOperator("<");
        con.setValue("42");
        pat.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)pat);
        CompositeFactPattern comp = new CompositeFactPattern("not");
        comp.addFactPattern((IFactPattern)new FactPattern("Cancel"));
        m.addLhsItem((IPattern)comp);
        ActionUpdateField set = new ActionUpdateField();
        set.variable = "p1";
        set.addFieldValue(new ActionFieldValue("status", "rejected", "String"));
        m.addRhsItem((IAction)set);
        ActionRetractFact ret = new ActionRetractFact("p1");
        m.addRhsItem((IAction)ret);
        DSLSentence sen = new DSLSentence();
        sen.sentence = "Send an email to {administrator}";
        m.addRhsItem((IAction)sen);
        return m;
    }

    @Test
    public void testLoadEmpty() {
        RuleModel m = BRXMLPersistence.getInstance().unmarshal(null);
        Assert.assertNotNull((Object)m);
        m = BRXMLPersistence.getInstance().unmarshal("");
        Assert.assertNotNull((Object)m);
    }
}

