/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.server.util;

import java.util.ArrayList;
import java.util.List;
import org.drools.ide.common.client.modeldriven.testing.ExecutionTrace;
import org.drools.ide.common.client.modeldriven.testing.FactData;
import org.drools.ide.common.client.modeldriven.testing.FieldData;
import org.drools.ide.common.client.modeldriven.testing.Scenario;
import org.drools.ide.common.client.modeldriven.testing.VerifyFact;
import org.drools.ide.common.client.modeldriven.testing.VerifyField;
import org.drools.ide.common.client.modeldriven.testing.VerifyRuleFired;
import org.drools.ide.common.server.util.ScenarioXMLPersistence;
import org.junit.Assert;
import org.junit.Test;

public class ScenarioXMLPersistenceTest {
    @Test
    public void testToXML() {
        ScenarioXMLPersistence p = ScenarioXMLPersistence.getInstance();
        Scenario sc = new Scenario();
        String s = p.marshal(sc);
        Assert.assertNotNull((Object)s);
        sc = this.getDemo();
        s = p.marshal(sc);
        Assert.assertTrue((s.indexOf("<ruleName>Life unverse and everything</ruleName>") > 0 ? 1 : 0) != 0);
        Scenario sc_ = p.unmarshal(s);
        Assert.assertEquals((long)sc.getGlobals().size(), (long)sc_.getGlobals().size());
        Assert.assertEquals((long)sc.getFixtures().size(), (long)sc_.getFixtures().size());
        Assert.assertTrue((s.indexOf("org.drools") == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testTrimUneededSection() {
        Scenario sc = this.getDemo();
        Scenario orig = this.getDemo();
        sc.getFixtures().add(new ExecutionTrace());
        int origSize = orig.getFixtures().size();
        Assert.assertEquals((long)(origSize + 1), (long)sc.getFixtures().size());
        String xml = ScenarioXMLPersistence.getInstance().marshal(sc);
        Scenario sc_ = ScenarioXMLPersistence.getInstance().unmarshal(xml);
        Assert.assertEquals((long)origSize, (long)sc_.getFixtures().size());
    }

    @Test
    public void testNewScenario() {
        FactData d1 = new FactData("Driver", "d1", this.ls(new FieldData[]{new FieldData("age", "42"), new FieldData("name", "david")}), false);
        Scenario sc = new Scenario();
        sc.getFixtures().add(d1);
        sc.getFixtures().add(new ExecutionTrace());
        int size = sc.getFixtures().size();
        String xml = ScenarioXMLPersistence.getInstance().marshal(sc);
        Scenario sc_ = ScenarioXMLPersistence.getInstance().unmarshal(xml);
        Assert.assertEquals((long)size, (long)sc_.getFixtures().size());
        sc = new Scenario();
        sc.getFixtures().add(new ExecutionTrace());
        xml = ScenarioXMLPersistence.getInstance().marshal(sc);
        sc_ = ScenarioXMLPersistence.getInstance().unmarshal(xml);
        Assert.assertEquals((long)1L, (long)sc_.getFixtures().size());
    }

    private Scenario getDemo() {
        FactData d1 = new FactData("Driver", "d1", this.ls(new FieldData[]{new FieldData("age", "42"), new FieldData("name", "david")}), false);
        FactData d2 = new FactData("Driver", "d2", this.ls(new FieldData[]{new FieldData("name", "michael")}), false);
        FactData d3 = new FactData("Driver", "d3", this.ls(new FieldData[]{new FieldData("name", "michael2")}), false);
        FactData d4 = new FactData("Accident", "a1", this.ls(new FieldData[]{new FieldData("name", "michael2")}), false);
        Scenario sc = new Scenario();
        sc.getFixtures().add(d1);
        sc.getFixtures().add(d2);
        sc.getGlobals().add(d3);
        sc.getGlobals().add(d4);
        sc.getRules().add("rule1");
        sc.getRules().add("rule2");
        sc.getFixtures().add(new ExecutionTrace());
        ArrayList<VerifyField> fields = new ArrayList<VerifyField>();
        VerifyField vfl = new VerifyField("age", "42", "==");
        vfl.setActualResult("43");
        vfl.setSuccessResult(new Boolean(false));
        vfl.setExplanation("Not cool jimmy.");
        fields.add(vfl);
        vfl = new VerifyField("name", "michael", "!=");
        vfl.setActualResult("bob");
        vfl.setSuccessResult(new Boolean(true));
        vfl.setExplanation("Yeah !");
        fields.add(vfl);
        VerifyFact vf = new VerifyFact("d1", fields);
        sc.getFixtures().add(vf);
        VerifyRuleFired vf1 = new VerifyRuleFired("Life unverse and everything", new Integer(42), null);
        vf1.setActualResult(new Integer(42));
        vf1.setSuccessResult(new Boolean(true));
        vf1.setExplanation("All good here.");
        VerifyRuleFired vf2 = new VerifyRuleFired("Everything else", null, new Boolean(true));
        vf2.setActualResult(new Integer(0));
        vf2.setSuccessResult(new Boolean(false));
        vf2.setExplanation("Not so good here.");
        sc.getFixtures().add(vf1);
        sc.getFixtures().add(vf2);
        return sc;
    }

    private List ls(FieldData[] fieldDatas) {
        ArrayList<FieldData> ls = new ArrayList<FieldData>();
        for (int i = 0; i < fieldDatas.length; ++i) {
            ls.add(fieldDatas[i]);
        }
        return ls;
    }
}

