/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.server.util;

import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.server.util.SuggestionCompletionEngineBuilder;
import org.drools.lang.dsl.DSLMappingEntry;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class SuggestionCompletionEngineBuilderTest {
    SuggestionCompletionEngineBuilder builder = new SuggestionCompletionEngineBuilder();

    @Before
    public void setUp() throws Exception {
        this.builder.newCompletionEngine();
    }

    @Test
    public void testAddDSLSentence() {
        String input = "{This} is a {pattern} considered pretty \\{{easy}\\} by most \\{people\\}. What do you {say}?";
        this.builder.addDSLActionSentence("{This} is a {pattern} considered pretty \\{{easy}\\} by most \\{people\\}. What do you {say}?");
        this.builder.addDSLConditionSentence("foo bar");
        SuggestionCompletionEngine engine = this.builder.getInstance();
        Assert.assertEquals((long)1L, (long)engine.actionDSLSentences.length);
        Assert.assertEquals((long)1L, (long)engine.conditionDSLSentences.length);
    }

    @Test
    public void testAddSentenceMultipleTypes() {
        DSLMappingEntry mapping1 = (DSLMappingEntry)Mockito.mock(DSLMappingEntry.class, (String)"mapping1");
        DSLMappingEntry mapping2 = (DSLMappingEntry)Mockito.mock(DSLMappingEntry.class, (String)"mapping2");
        DSLMappingEntry mapping3 = (DSLMappingEntry)Mockito.mock(DSLMappingEntry.class, (String)"mapping3");
        DSLMappingEntry mapping4 = (DSLMappingEntry)Mockito.mock(DSLMappingEntry.class, (String)"mapping4");
        Mockito.when((Object)mapping1.getSection()).thenReturn((Object)DSLMappingEntry.CONDITION);
        Mockito.when((Object)mapping1.getMappingKey()).thenReturn((Object)"cond");
        Mockito.when((Object)mapping2.getSection()).thenReturn((Object)DSLMappingEntry.CONSEQUENCE);
        Mockito.when((Object)mapping2.getMappingKey()).thenReturn((Object)"cons");
        Mockito.when((Object)mapping3.getSection()).thenReturn((Object)DSLMappingEntry.ANY);
        Mockito.when((Object)mapping3.getMappingKey()).thenReturn((Object)"any");
        Mockito.when((Object)mapping4.getSection()).thenReturn((Object)DSLMappingEntry.KEYWORD);
        Mockito.when((Object)mapping4.getMappingKey()).thenReturn((Object)"key");
        this.builder.addDSLMapping(mapping1);
        this.builder.addDSLMapping(mapping2);
        this.builder.addDSLMapping(mapping3);
        this.builder.addDSLMapping(mapping4);
        SuggestionCompletionEngine engine = this.builder.getInstance();
        Assert.assertEquals((long)1L, (long)engine.actionDSLSentences.length);
        Assert.assertEquals((long)1L, (long)engine.conditionDSLSentences.length);
        Assert.assertEquals((long)1L, (long)engine.keywordDSLItems.length);
        Assert.assertEquals((long)1L, (long)engine.anyScopeDSLItems.length);
        Assert.assertEquals((Object)"cond", (Object)engine.conditionDSLSentences[0].sentence);
    }
}

