/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.client.modeldriven.dt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.drools.ide.common.client.modeldriven.brl.ActionFieldValue;
import org.drools.ide.common.client.modeldriven.brl.ActionInsertFact;
import org.drools.ide.common.client.modeldriven.brl.ActionSetField;
import org.drools.ide.common.client.modeldriven.brl.ActionUpdateField;
import org.drools.ide.common.client.modeldriven.brl.CompositeFactPattern;
import org.drools.ide.common.client.modeldriven.brl.CompositeFieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.ConnectiveConstraint;
import org.drools.ide.common.client.modeldriven.brl.DSLSentence;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;
import org.drools.ide.common.client.modeldriven.brl.FieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.FreeFormLine;
import org.drools.ide.common.client.modeldriven.brl.FromAccumulateCompositeFactPattern;
import org.drools.ide.common.client.modeldriven.brl.FromCollectCompositeFactPattern;
import org.drools.ide.common.client.modeldriven.brl.FromCompositeFactPattern;
import org.drools.ide.common.client.modeldriven.brl.IFactPattern;
import org.drools.ide.common.client.modeldriven.brl.PortableObject;
import org.drools.ide.common.client.modeldriven.brl.RuleModel;
import org.drools.ide.common.client.modeldriven.brl.SingleFieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.SingleFieldConstraintEBLeftSide;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateModel
extends RuleModel
implements PortableObject {
    public static final String ID_COLUMN_NAME = "__ID_KOL_NAME__";
    private long idCol = 0L;
    private Map<String, List<String>> table = new HashMap<String, List<String>>();
    private int rowsCount = 0;

    public String addRow(String rowId, String[] row) {
        Map<InterpolationVariable, Integer> vars = this.getInterpolationVariables();
        if (row.length != vars.size() - 1) {
            throw new IllegalArgumentException("Invalid numbers of columns: " + row.length + " expected: " + vars.size());
        }
        if (rowId == null || rowId.length() == 0) {
            rowId = this.getNewIdColValue();
        }
        for (Map.Entry<InterpolationVariable, Integer> entry : vars.entrySet()) {
            List<String> list = this.table.get(entry.getKey().getVarName());
            if (list == null) {
                list = new ArrayList<String>();
                this.table.put(entry.getKey().getVarName(), list);
            }
            if (this.rowsCount != list.size()) {
                throw new IllegalArgumentException("invalid list size for " + entry.getKey() + ", expected: " + this.rowsCount + " was: " + list.size());
            }
            if (ID_COLUMN_NAME.equals(entry.getKey().getVarName())) {
                list.add(rowId);
                continue;
            }
            list.add(row[entry.getValue()]);
        }
        ++this.rowsCount;
        return rowId;
    }

    public String addRow(String[] row) {
        return this.addRow(null, row);
    }

    public void clearRows() {
        if (this.rowsCount > 0) {
            for (List<String> col : this.table.values()) {
                col.clear();
            }
            this.rowsCount = 0;
        }
    }

    public int getColsCount() {
        return this.getInterpolationVariables().size() - 1;
    }

    private Map<InterpolationVariable, Integer> getInterpolationVariables() {
        HashMap<InterpolationVariable, Integer> result = new HashMap<InterpolationVariable, Integer>();
        new RuleModelVisitor(this, result).visit(this);
        InterpolationVariable id = new InterpolationVariable(ID_COLUMN_NAME, "Numeric");
        result.put(id, result.size());
        return result;
    }

    public InterpolationVariable[] getInterpolationVariablesList() {
        Map<InterpolationVariable, Integer> vars = this.getInterpolationVariables();
        InterpolationVariable[] ret = new InterpolationVariable[vars.size() - 1];
        for (Map.Entry<InterpolationVariable, Integer> entry : vars.entrySet()) {
            if (ID_COLUMN_NAME.equals(entry.getKey().varName)) continue;
            ret[entry.getValue().intValue()] = entry.getKey();
        }
        return ret;
    }

    private String getNewIdColValue() {
        ++this.idCol;
        return String.valueOf(this.idCol);
    }

    public int getRowsCount() {
        return this.rowsCount;
    }

    public Map<String, List<String>> getTable() {
        return this.table;
    }

    public String[][] getTableAsArray() {
        if (this.rowsCount <= 0) {
            return new String[0][0];
        }
        this.putInSync();
        String[][] ret = new String[this.rowsCount][this.table.size() - 1];
        Map<InterpolationVariable, Integer> vars = this.getInterpolationVariables();
        for (Map.Entry<InterpolationVariable, Integer> entry : vars.entrySet()) {
            InterpolationVariable var = entry.getKey();
            String varName = var.varName;
            if (ID_COLUMN_NAME.equals(varName)) continue;
            int idx = entry.getValue();
            for (int row = 0; row < this.rowsCount; ++row) {
                ret[row][idx] = this.table.get(varName).get(row);
            }
        }
        return ret;
    }

    public void putInSync() {
        Map<InterpolationVariable, Integer> vars = this.getInterpolationVariables();
        HashSet<String> requiredVars = new HashSet<String>();
        for (InterpolationVariable var : vars.keySet()) {
            if (!this.table.containsKey(var.varName)) continue;
            requiredVars.add(var.varName);
        }
        this.table.keySet().retainAll(requiredVars);
        ArrayList<String> aux = new ArrayList<String>(this.rowsCount);
        for (int i = 0; i < this.rowsCount; ++i) {
            aux.add("");
        }
        for (InterpolationVariable var : vars.keySet()) {
            if (requiredVars.contains(var.varName)) continue;
            this.table.put(var.varName, new ArrayList(aux));
        }
    }

    public void removeRow(int row) {
        if (row >= 0 && row < this.rowsCount) {
            for (List<String> col : this.table.values()) {
                col.remove(row);
            }
            --this.rowsCount;
        } else {
            throw new ArrayIndexOutOfBoundsException(row);
        }
    }

    public boolean removeRowById(String rowId) {
        int idx = this.table.get(ID_COLUMN_NAME).indexOf(rowId);
        if (idx != -1) {
            for (List<String> col : this.table.values()) {
                col.remove(idx);
            }
            --this.rowsCount;
        }
        return idx != -1;
    }

    public void setValue(String varName, int rowIndex, String newValue) {
        this.getTable().get(varName).set(rowIndex, newValue);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RuleModelVisitor {
        private IFactPattern factPattern;
        private Map<InterpolationVariable, Integer> vars;
        private RuleModel model;

        public RuleModelVisitor(RuleModel model, Map<InterpolationVariable, Integer> vars) {
            this.vars = vars;
            this.model = model;
        }

        private void parseStringPattern(String text) {
            if (text == null || text.length() == 0) {
                return;
            }
            int pos = 0;
            while ((pos = text.indexOf("@{", pos)) != -1) {
                int end = text.indexOf(125, pos + 2);
                if (end == -1) continue;
                String varName = text.substring(pos + 2, end);
                pos = end + 1;
                InterpolationVariable var = new InterpolationVariable(varName, "Object");
                if (this.vars.containsKey(var)) continue;
                this.vars.put(var, this.vars.size());
            }
        }

        public void visit(Object o) {
            if (o == null) {
                return;
            }
            if (o instanceof RuleModel) {
                this.visitRuleModel((RuleModel)o);
            } else if (o instanceof FactPattern) {
                this.visitFactPattern((FactPattern)o);
            } else if (o instanceof CompositeFieldConstraint) {
                this.visitCompositeFieldConstraint((CompositeFieldConstraint)o);
            } else if (o instanceof SingleFieldConstraintEBLeftSide) {
                this.visitSingleFieldConstraint((SingleFieldConstraintEBLeftSide)o);
            } else if (o instanceof SingleFieldConstraint) {
                this.visitSingleFieldConstraint((SingleFieldConstraint)o);
            } else if (o instanceof CompositeFactPattern) {
                this.visitCompositeFactPattern((CompositeFactPattern)o);
            } else if (o instanceof FreeFormLine) {
                this.visitFreeFormLine((FreeFormLine)o);
            } else if (o instanceof FromAccumulateCompositeFactPattern) {
                this.visitFromAccumulateCompositeFactPattern((FromAccumulateCompositeFactPattern)o);
            } else if (o instanceof FromCollectCompositeFactPattern) {
                this.visitFromCollectCompositeFactPattern((FromCollectCompositeFactPattern)o);
            } else if (o instanceof FromCompositeFactPattern) {
                this.visitFromCompositeFactPattern((FromCompositeFactPattern)o);
            } else if (o instanceof DSLSentence) {
                this.visitDSLSentence((DSLSentence)o);
            } else if (o instanceof ActionInsertFact) {
                this.visitActionFieldList((ActionInsertFact)o);
            } else if (o instanceof ActionSetField) {
                this.visitActionFieldList((ActionSetField)o);
            } else if (o instanceof ActionUpdateField) {
                this.visitActionFieldList((ActionUpdateField)o);
            }
        }

        private void visitActionFieldList(ActionInsertFact afl) {
            String factType = afl.factType;
            for (ActionFieldValue afv : afl.fieldValues) {
                if (afv.nature != 7L || this.vars.containsKey(afv.value)) continue;
                InterpolationVariable var = new InterpolationVariable(afv.getValue(), afv.getType(), factType, afv.getField());
                this.vars.put(var, this.vars.size());
            }
        }

        private void visitActionFieldList(ActionSetField afl) {
            String factType = this.model.getBindingType(afl.variable);
            for (ActionFieldValue afv : afl.fieldValues) {
                if (afv.nature != 7L || this.vars.containsKey(afv.value)) continue;
                InterpolationVariable var = new InterpolationVariable(afv.getValue(), afv.getType(), factType, afv.getField());
                this.vars.put(var, this.vars.size());
            }
        }

        private void visitActionFieldList(ActionUpdateField afl) {
            String factType = this.model.getBindingType(afl.variable);
            for (ActionFieldValue afv : afl.fieldValues) {
                if (afv.nature != 7L || this.vars.containsKey(afv.value)) continue;
                InterpolationVariable var = new InterpolationVariable(afv.getValue(), afv.getType(), factType, afv.getField());
                this.vars.put(var, this.vars.size());
            }
        }

        private void visitCompositeFactPattern(CompositeFactPattern pattern) {
            if (pattern.getPatterns() != null) {
                for (IFactPattern fp : pattern.getPatterns()) {
                    this.visit(fp);
                }
            }
        }

        private void visitCompositeFieldConstraint(CompositeFieldConstraint cfc) {
            if (cfc.constraints != null) {
                for (FieldConstraint fc : cfc.constraints) {
                    this.visit(fc);
                }
            }
        }

        private void visitDSLSentence(DSLSentence sentence) {
            this.parseStringPattern(sentence.sentence);
        }

        private void visitFactPattern(FactPattern pattern) {
            this.factPattern = pattern;
            for (FieldConstraint fc : pattern.getFieldConstraints()) {
                this.visit(fc);
            }
        }

        private void visitFreeFormLine(FreeFormLine ffl) {
            this.parseStringPattern(ffl.text);
        }

        private void visitFromAccumulateCompositeFactPattern(FromAccumulateCompositeFactPattern pattern) {
            this.visit(pattern.getFactPattern());
            this.visit(pattern.getSourcePattern());
            this.parseStringPattern(pattern.getActionCode());
            this.parseStringPattern(pattern.getInitCode());
            this.parseStringPattern(pattern.getReverseCode());
        }

        private void visitFromCollectCompositeFactPattern(FromCollectCompositeFactPattern pattern) {
            this.visit(pattern.getFactPattern());
            this.visit(pattern.getRightPattern());
        }

        private void visitFromCompositeFactPattern(FromCompositeFactPattern pattern) {
            this.visit(pattern.getFactPattern());
            this.parseStringPattern(pattern.getExpression().getText());
        }

        public void visitRuleModel(RuleModel model) {
            if (model.lhs != null) {
                for (PortableObject portableObject : model.lhs) {
                    this.visit(portableObject);
                }
            }
            if (model.rhs != null) {
                for (PortableObject portableObject : model.rhs) {
                    this.visit(portableObject);
                }
            }
        }

        private void visitSingleFieldConstraint(SingleFieldConstraint sfc) {
            if (7 == sfc.getConstraintValueType() && !this.vars.containsKey(sfc.getValue())) {
                InterpolationVariable var = new InterpolationVariable(sfc.getValue(), sfc.getFieldType(), this.factPattern.getFactType(), sfc.getFieldName());
                this.vars.put(var, this.vars.size());
            }
            if (sfc.connectives != null) {
                for (int i = 0; i < sfc.connectives.length; ++i) {
                    ConnectiveConstraint cc = sfc.connectives[i];
                    if (7 != cc.getConstraintValueType() || this.vars.containsKey(cc.getValue())) continue;
                    InterpolationVariable var = new InterpolationVariable(cc.getValue(), cc.getFieldType(), this.factPattern.getFactType(), cc.getFieldName());
                    this.vars.put(var, this.vars.size());
                }
            }
        }

        private void visitSingleFieldConstraint(SingleFieldConstraintEBLeftSide sfexp) {
            if (7 == sfexp.getConstraintValueType() && !this.vars.containsKey(sfexp.getValue())) {
                InterpolationVariable var = new InterpolationVariable(sfexp.getValue(), sfexp.getExpressionLeftSide().getGenericType(), this.factPattern.getFactType(), sfexp.getFieldName());
                this.vars.put(var, this.vars.size());
            }
            if (sfexp.connectives != null) {
                for (int i = 0; i < sfexp.connectives.length; ++i) {
                    ConnectiveConstraint cc = sfexp.connectives[i];
                    if (7 != cc.getConstraintValueType() || this.vars.containsKey(cc.getValue())) continue;
                    InterpolationVariable var = new InterpolationVariable(cc.getValue(), sfexp.getExpressionLeftSide().getGenericType(), this.factPattern.getFactType(), cc.getFieldName());
                    this.vars.put(var, this.vars.size());
                }
            }
        }
    }

    public static class InterpolationVariable {
        private String varName;
        private String dataType;
        private String factType;
        private String factField;

        public InterpolationVariable(String varName, String dataType) {
            this.varName = varName;
            this.dataType = dataType;
        }

        public InterpolationVariable(String varName, String dataType, String factType, String factField) {
            this.varName = varName;
            this.dataType = dataType;
            this.factType = factType;
            this.factField = factField;
        }

        private boolean equalOrNull(Object lhs, Object rhs) {
            if (lhs == null && rhs == null) {
                return true;
            }
            if (lhs != null && rhs == null) {
                return false;
            }
            if (lhs == null && rhs != null) {
                return false;
            }
            return lhs.equals(rhs);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof InterpolationVariable)) {
                return false;
            }
            InterpolationVariable that = (InterpolationVariable)obj;
            return this.equalOrNull(this.varName, that.varName) && this.equalOrNull(this.dataType, that.dataType) && this.equalOrNull(this.factType, that.factType) && this.equalOrNull(this.factField, that.factField);
        }

        public String getDataType() {
            return this.dataType;
        }

        public String getFactField() {
            return this.factField;
        }

        public String getFactType() {
            return this.factType;
        }

        public String getVarName() {
            return this.varName;
        }

        public int hashCode() {
            int hashCode = this.varName == null ? 1 : this.varName.hashCode();
            hashCode += 31 * (this.dataType == null ? 7 : this.dataType.hashCode());
            hashCode += 31 * (this.factType == null ? 7 : this.factType.hashCode());
            return hashCode += 31 * (this.factField == null ? 7 : this.factField.hashCode());
        }

        public void setFactField(String factField) {
            this.factField = factField;
        }

        public void setFactType(String factType) {
            this.factType = factType;
        }

        public void setVarName(String varName) {
            this.varName = varName;
        }
    }
}

