/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.client.modeldriven;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.jar.JarInputStream;
import org.drools.ide.common.client.modeldriven.FieldAccessorsAndMutators;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.server.rules.SuggestionCompletionLoader;
import org.junit.Assert;
import org.junit.Test;

public class SuggestionCompletionEngine2Test {
    @Test
    public void testAccessorsAndMutatorsDeclaredModel() throws Exception {
        String pkg = "package org.test\n";
        pkg = pkg + "declare Test\n";
        pkg = pkg + "number: Integer\n";
        pkg = pkg + "end\n";
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader();
        SuggestionCompletionEngine engine = loader.getSuggestionEngine(pkg, new ArrayList(), new ArrayList(), new ArrayList());
        String[] accessors = engine.getFieldCompletions(FieldAccessorsAndMutators.ACCESSOR, "Test");
        Assert.assertEquals((long)2L, (long)accessors.length);
        String[] mutators = engine.getFieldCompletions(FieldAccessorsAndMutators.MUTATOR, "Test");
        Assert.assertEquals((long)2L, (long)mutators.length);
    }

    @Test
    public void testAccessorsAndMutatorsJavaClass() throws Exception {
        String pkg = "package org.test\n import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine2Test.Person\n";
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader();
        SuggestionCompletionEngine engine = loader.getSuggestionEngine(pkg, new ArrayList(), new ArrayList(), new ArrayList());
        String[] accessors = engine.getFieldCompletions(FieldAccessorsAndMutators.ACCESSOR, "SuggestionCompletionEngine2Test$Person");
        Assert.assertEquals((long)3L, (long)accessors.length);
        String[] mutators = engine.getFieldCompletions(FieldAccessorsAndMutators.MUTATOR, "SuggestionCompletionEngine2Test$Person");
        Assert.assertEquals((long)3L, (long)mutators.length);
    }

    @Test
    public void testArrayList() {
        String pkg = "package org.test\n global java.util.ArrayList testList";
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader();
        SuggestionCompletionEngine engine = loader.getSuggestionEngine(pkg, new ArrayList(), new ArrayList(), new ArrayList());
        List methodNames = engine.getMethodNames("ArrayList");
        Assert.assertNotNull((Object)methodNames);
        Assert.assertFalse((boolean)methodNames.isEmpty());
        for (String s : methodNames) {
            Assert.assertFalse((String)("Method " + s + " is not allowed."), (boolean)this.allowedMethod(s));
        }
    }

    @Test
    public void testJarFileWithSourceFiles() {
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader();
        String header = "package foo \n import org.test.Person \n import org.test.Banana \n ";
        ArrayList<JarInputStream> jars = new ArrayList<JarInputStream>();
        JarInputStream jis = null;
        SuggestionCompletionEngine suggestionCompletionEngine = null;
        try {
            jis = new JarInputStream(this.getClass().getResourceAsStream("/JarWithSourceFiles.jar"));
            jars.add(jis);
        }
        catch (IOException e) {
            Assert.fail((String)"Could not load jar");
        }
        try {
            suggestionCompletionEngine = loader.getSuggestionEngine(header, jars, new ArrayList());
        }
        catch (ClassFormatError e) {
            Assert.fail((String)("Can not load suggestions " + e));
        }
        Assert.assertNotNull((Object)jis);
        Assert.assertNotNull((Object)suggestionCompletionEngine);
        Assert.assertEquals((long)2L, (long)suggestionCompletionEngine.getFactTypes().length);
        List<String> list = Arrays.asList(suggestionCompletionEngine.getFactTypes());
        Assert.assertTrue((boolean)list.contains("Person"));
        Assert.assertTrue((boolean)list.contains("Banana"));
        Assert.assertEquals((Object)"java.util.Collection", (Object)suggestionCompletionEngine.getFieldClassName("Person", "bananas"));
        Assert.assertEquals((Object)"Collection", (Object)suggestionCompletionEngine.getFieldType("Person", "bananas"));
        Assert.assertEquals((Object)"Banana", (Object)suggestionCompletionEngine.getParametricFieldType("Person", "bananas"));
    }

    private boolean allowedMethod(String methodName) {
        return "hashCode".equals(methodName) || "equals".equals(methodName) || "listIterator".equals(methodName) || "lastIndexOf".equals(methodName) || "indexOf".equals(methodName) || "subList".equals(methodName) || "get".equals(methodName) || "isEmpty".equals(methodName) || "containsKey".equals(methodName) || "values".equals(methodName) || "entrySet".equals(methodName) || "containsValue".equals(methodName) || "keySet".equals(methodName) || "size".equals(methodName) || "toArray".equals(methodName) || "iterator".equals(methodName) || "contains".equals(methodName) || "isEmpty".equals(methodName) || "containsAll".equals(methodName) || "size".equals(methodName);
    }

    public static class Person {
        private String name;
        private int age;
        private String something;

        public String getSomething() {
            return this.something;
        }

        public void setSomething(String something) {
            this.something = something;
        }

        public int getAge() {
            return this.age;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void addPet(String petName) {
        }
    }
}

