/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.server.factconstraints.predefined;

import java.util.Collection;
import org.drools.builder.ResourceType;
import org.drools.ide.common.client.factconstraints.ConstraintConfiguration;
import org.drools.ide.common.client.factconstraints.ValidationResult;
import org.drools.ide.common.client.factconstraints.config.SimpleConstraintConfigurationImpl;
import org.drools.ide.common.server.factconstraints.predefined.IntegerConstraint;
import org.drools.io.ResourceFactory;
import org.drools.verifier.Verifier;
import org.drools.verifier.VerifierConfiguration;
import org.drools.verifier.VerifierConfigurationImpl;
import org.drools.verifier.VerifierError;
import org.drools.verifier.builder.VerifierBuilder;
import org.drools.verifier.builder.VerifierBuilderFactory;
import org.drools.verifier.data.VerifierReport;
import org.drools.verifier.report.components.Severity;
import org.drools.verifier.report.components.VerifierMessageBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IntegerConstraintTest {
    private ConstraintConfiguration conf;

    @Before
    public void setup() {
        this.conf = new SimpleConstraintConfigurationImpl();
        this.conf.setFactType("Person");
        this.conf.setFieldName("age");
    }

    @Test
    public void testValidConstraint() {
        IntegerConstraint cons = new IntegerConstraint();
        ValidationResult result = cons.validate((Object)12, this.conf);
        Assert.assertTrue((boolean)result.isSuccess());
        result = cons.validate((Object)new Integer("12"), this.conf);
        Assert.assertTrue((boolean)result.isSuccess());
        result = cons.validate((Object)"12", this.conf);
        Assert.assertTrue((boolean)result.isSuccess());
    }

    @Test
    public void testInvalidConstraint() {
        IntegerConstraint cons = new IntegerConstraint();
        ValidationResult result = cons.validate(new Object(), this.conf);
        Assert.assertFalse((boolean)result.isSuccess());
        System.out.println("Message: " + result.getMessage());
        result = cons.validate((Object)"", this.conf);
        Assert.assertFalse((boolean)result.isSuccess());
        System.out.println("Message: " + result.getMessage());
        result = cons.validate((Object)"ABC", this.conf);
        Assert.assertFalse((boolean)result.isSuccess());
        System.out.println("Message: " + result.getMessage());
        result = cons.validate(null, this.conf);
        Assert.assertFalse((boolean)result.isSuccess());
        System.out.println("Message: " + result.getMessage());
        result = cons.validate((Object)new Long("12"), this.conf);
        Assert.assertFalse((boolean)result.isSuccess());
        System.out.println("Message: " + result.getMessage());
        result = cons.validate((Object)12L, this.conf);
        Assert.assertFalse((boolean)result.isSuccess());
        System.out.println("Message: " + result.getMessage());
        result = cons.validate((Object)12.8, this.conf);
        Assert.assertFalse((boolean)result.isSuccess());
        System.out.println("Message: " + result.getMessage());
    }

    @Test
    public void testUsingVerifier() {
        String ruleToVerify = "";
        ruleToVerify = ruleToVerify + "package org.drools.factconstraint.test\n\n";
        ruleToVerify = ruleToVerify + "import org.drools.factconstraint.model.*\n";
        ruleToVerify = ruleToVerify + "rule \"rule1\"\n";
        ruleToVerify = ruleToVerify + "   when\n";
        ruleToVerify = ruleToVerify + "       Person(age == 'abc')\n";
        ruleToVerify = ruleToVerify + "   then\n";
        ruleToVerify = ruleToVerify + "       System.out.println(\"Rule fired\");\n";
        ruleToVerify = ruleToVerify + "end\n\n";
        ruleToVerify = ruleToVerify + "rule \"rule2\"\n";
        ruleToVerify = ruleToVerify + "   when\n";
        ruleToVerify = ruleToVerify + "       Person(age == 12)\n";
        ruleToVerify = ruleToVerify + "   then\n";
        ruleToVerify = ruleToVerify + "       System.out.println(\"Rule fired\");\n";
        ruleToVerify = ruleToVerify + "end\n\n";
        ruleToVerify = ruleToVerify + "rule \"rule3\"\n";
        ruleToVerify = ruleToVerify + "   when\n";
        ruleToVerify = ruleToVerify + "       Person(age == '')\n";
        ruleToVerify = ruleToVerify + "   then\n";
        ruleToVerify = ruleToVerify + "       System.out.println(\"Rule fired\");\n";
        ruleToVerify = ruleToVerify + "end\n";
        VerifierBuilder vBuilder = VerifierBuilderFactory.newVerifierBuilder();
        VerifierConfigurationImpl vconf = new VerifierConfigurationImpl();
        IntegerConstraint cons = new IntegerConstraint();
        vconf.getVerifyingResources().put(ResourceFactory.newByteArrayResource((byte[])cons.getVerifierRule(this.conf).getBytes()), ResourceType.DRL);
        Verifier verifier = vBuilder.newVerifier((VerifierConfiguration)vconf);
        verifier.addResourcesToVerify(ResourceFactory.newByteArrayResource((byte[])ruleToVerify.getBytes()), ResourceType.DRL);
        if (verifier.hasErrors()) {
            for (VerifierError error : verifier.getErrors()) {
                System.out.println(error.getMessage());
            }
            throw new RuntimeException("Error building verifier");
        }
        Assert.assertFalse((boolean)verifier.hasErrors());
        boolean noProblems = verifier.fireAnalysis();
        Assert.assertTrue((boolean)noProblems);
        VerifierReport result = verifier.getResult();
        Collection warnings = result.getBySeverity(Severity.ERROR);
        int counter = 0;
        for (VerifierMessageBase message : warnings) {
            System.out.println(message);
            ++counter;
        }
        Assert.assertEquals((long)2L, (long)counter);
        verifier.dispose();
    }
}

