/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.server.util;

import org.drools.ide.common.client.modeldriven.brl.ActionFieldValue;
import org.drools.ide.common.client.modeldriven.brl.ActionGlobalCollectionAdd;
import org.drools.ide.common.client.modeldriven.brl.ActionInsertFact;
import org.drools.ide.common.client.modeldriven.brl.ActionInsertLogicalFact;
import org.drools.ide.common.client.modeldriven.brl.ActionRetractFact;
import org.drools.ide.common.client.modeldriven.brl.ActionUpdateField;
import org.drools.ide.common.client.modeldriven.brl.CompositeFactPattern;
import org.drools.ide.common.client.modeldriven.brl.CompositeFieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.ConnectiveConstraint;
import org.drools.ide.common.client.modeldriven.brl.DSLSentence;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;
import org.drools.ide.common.client.modeldriven.brl.FieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.FreeFormLine;
import org.drools.ide.common.client.modeldriven.brl.IAction;
import org.drools.ide.common.client.modeldriven.brl.IFactPattern;
import org.drools.ide.common.client.modeldriven.brl.IPattern;
import org.drools.ide.common.client.modeldriven.brl.RuleAttribute;
import org.drools.ide.common.client.modeldriven.brl.RuleModel;
import org.drools.ide.common.client.modeldriven.brl.SingleFieldConstraint;
import org.drools.ide.common.server.util.BRDRLPersistence;
import org.drools.ide.common.server.util.BRLPersistence;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BRDRLPersistenceTest {
    private BRLPersistence brlPersistence;

    @Before
    public void setUp() throws Exception {
        this.brlPersistence = BRDRLPersistence.getInstance();
    }

    @Test
    public void testGenerateEmptyDRL() {
        String expected = "rule \"null\"\n\tdialect \"mvel\"\n\twhen\n\tthen\nend\n";
        String drl = this.brlPersistence.marshal(new RuleModel());
        Assert.assertNotNull((Object)drl);
        Assert.assertEquals((Object)expected, (Object)drl);
    }

    @Test
    public void testFreeForm() {
        RuleModel m = new RuleModel();
        m.name = "with composite";
        m.lhs = new IPattern[1];
        m.rhs = new IAction[1];
        FreeFormLine fl = new FreeFormLine();
        fl.text = "Person()";
        m.lhs[0] = fl;
        FreeFormLine fr = new FreeFormLine();
        fr.text = "fun()";
        m.rhs[0] = fr;
        String drl = this.brlPersistence.marshal(m);
        Assert.assertNotNull((Object)drl);
        Assert.assertTrue((drl.indexOf("Person()") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("fun()") > drl.indexOf("Person()") ? 1 : 0) != 0);
    }

    @Test
    public void testBasics() {
        String expected = "rule \"my rule\"\n\tno-loop true\n\tdialect \"mvel\"\n\twhen\n\t\tPerson( )\n\t\tAccident( )\n\tthen\n\t\tinsert( new Report() );\nend\n";
        RuleModel m = new RuleModel();
        m.addLhsItem((IPattern)new FactPattern("Person"));
        m.addLhsItem((IPattern)new FactPattern("Accident"));
        m.addAttribute(new RuleAttribute("no-loop", "true"));
        m.addRhsItem((IAction)new ActionInsertFact("Report"));
        m.name = "my rule";
        String drl = this.brlPersistence.marshal(m);
        Assert.assertEquals((Object)expected, (Object)drl);
    }

    @Test
    public void testInsertLogical() {
        String expected = "rule \"my rule\"\n\tno-loop true\n\tdialect \"mvel\"\n\twhen\n\t\tPerson( )\n\t\tAccident( )\n\tthen\n\t\tinsertLogical( new Report() );\nend\n";
        RuleModel m = new RuleModel();
        m.addLhsItem((IPattern)new FactPattern("Person"));
        m.addLhsItem((IPattern)new FactPattern("Accident"));
        m.addAttribute(new RuleAttribute("no-loop", "true"));
        m.addRhsItem((IAction)new ActionInsertLogicalFact("Report"));
        m.name = "my rule";
        String drl = this.brlPersistence.marshal(m);
        Assert.assertEquals((Object)expected, (Object)drl);
    }

    @Test
    public void testAttr() {
        RuleModel m = new RuleModel();
        m.attributes = new RuleAttribute[1];
        m.attributes[0] = new RuleAttribute("enabled", "true");
        String drl = this.brlPersistence.marshal(m);
        Assert.assertTrue((drl.indexOf("enabled true") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testEnum() {
        String expected = "rule \"my rule\"\n\tdialect \"mvel\"\n\twhen\n\t\tCheese( type = CheeseType.CHEDDAR )\n\tthen\n\t\tinsert( new Report() );\nend\n";
        RuleModel m = new RuleModel();
        FactPattern pat = new FactPattern("Cheese");
        m.addLhsItem((IPattern)pat);
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldName("type");
        con.setOperator("=");
        con.setValue("CheeseType.CHEDDAR");
        con.setConstraintValueType(4);
        pat.addConstraint((FieldConstraint)con);
        m.addRhsItem((IAction)new ActionInsertFact("Report"));
        m.name = "my rule";
        String drl = this.brlPersistence.marshal(m);
        Assert.assertEquals((Object)expected, (Object)drl);
    }

    @Test
    public void testMoreComplexRendering() {
        RuleModel m = this.getComplexModel();
        String expected = "rule \"Complex Rule\"\n\tno-loop true\n\tsalience -10\n\tagenda-group \"aGroup\"\n\tdialect \"mvel\"\n\twhen\n\t\t>p1 : Person( f1 : age < 42 )\n\t\t>not (Cancel( )) \n\tthen\n\t\t>p1.setStatus( \"rejected\" );\n\t\t>update( p1 );\n\t\t>retract( p1 );\n\t\tSend an email to administrator\nend\n";
        String drl = this.brlPersistence.marshal(m);
        Assert.assertEquals((Object)expected, (Object)drl);
    }

    @Test
    public void testFieldBindingWithNoConstraints() {
        RuleModel m = this.getModelWithNoConstraints();
        String s = BRDRLPersistence.getInstance().marshal(m);
        Assert.assertTrue((s.indexOf("Person( f1 : age)") != -1 ? 1 : 0) != 0);
    }

    private RuleModel getModelWithNoConstraints() {
        RuleModel m = new RuleModel();
        m.name = "Complex Rule";
        FactPattern pat = new FactPattern("Person");
        pat.setBoundName("p1");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldBinding("f1");
        con.setFieldName("age");
        pat.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)pat);
        return m;
    }

    private RuleModel getComplexModel() {
        RuleModel m = new RuleModel();
        m.name = "Complex Rule";
        m.addAttribute(new RuleAttribute("no-loop", "true"));
        m.addAttribute(new RuleAttribute("salience", "-10"));
        m.addAttribute(new RuleAttribute("agenda-group", "aGroup"));
        FactPattern pat = new FactPattern("Person");
        pat.setBoundName("p1");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldBinding("f1");
        con.setFieldName("age");
        con.setOperator("<");
        con.setValue("42");
        pat.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)pat);
        CompositeFactPattern comp = new CompositeFactPattern("not");
        comp.addFactPattern((IFactPattern)new FactPattern("Cancel"));
        m.addLhsItem((IPattern)comp);
        ActionUpdateField set = new ActionUpdateField();
        set.variable = "p1";
        set.addFieldValue(new ActionFieldValue("status", "rejected", "String"));
        m.addRhsItem((IAction)set);
        ActionRetractFact ret = new ActionRetractFact("p1");
        m.addRhsItem((IAction)ret);
        DSLSentence sen = new DSLSentence();
        sen.sentence = "Send an email to {administrator}";
        m.addRhsItem((IAction)sen);
        return m;
    }

    @Test
    public void testOrComposite() throws Exception {
        RuleModel m = new RuleModel();
        m.name = "or";
        CompositeFactPattern cp = new CompositeFactPattern("or");
        FactPattern p1 = new FactPattern("Person");
        SingleFieldConstraint sf1 = new SingleFieldConstraint("age");
        sf1.setOperator("==");
        sf1.setValue("42");
        p1.addConstraint((FieldConstraint)sf1);
        cp.addFactPattern((IFactPattern)p1);
        FactPattern p2 = new FactPattern("Person");
        SingleFieldConstraint sf2 = new SingleFieldConstraint("age");
        sf2.setOperator("==");
        sf2.setValue("43");
        p2.addConstraint((FieldConstraint)sf2);
        cp.addFactPattern((IFactPattern)p2);
        m.addLhsItem((IPattern)cp);
        String result = BRDRLPersistence.getInstance().marshal(m);
        Assert.assertTrue((result.indexOf("( Person( age == 42 ) or Person( age == 43 ) )") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testExistsMultiPatterns() throws Exception {
        String result = this.getCompositeFOL("exists");
        Assert.assertTrue((result.indexOf("exists (Person( age == 42 ) and Person( age == 43 ))") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testNotMultiPatterns() throws Exception {
        String result = this.getCompositeFOL("not");
        Assert.assertTrue((result.indexOf("not (Person( age == 42 ) and Person( age == 43 ))") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSingleExists() throws Exception {
        RuleModel m = new RuleModel();
        m.name = "or";
        CompositeFactPattern cp = new CompositeFactPattern("exists");
        FactPattern p1 = new FactPattern("Person");
        SingleFieldConstraint sf1 = new SingleFieldConstraint("age");
        sf1.setOperator("==");
        sf1.setValue("42");
        p1.addConstraint((FieldConstraint)sf1);
        cp.addFactPattern((IFactPattern)p1);
        m.addLhsItem((IPattern)cp);
        String result = BRDRLPersistence.getInstance().marshal(m);
        Assert.assertTrue((result.indexOf("exists (Person( age == 42 )) ") > 0 ? 1 : 0) != 0);
    }

    private String getCompositeFOL(String type) {
        RuleModel m = new RuleModel();
        m.name = "or";
        CompositeFactPattern cp = new CompositeFactPattern(type);
        FactPattern p1 = new FactPattern("Person");
        SingleFieldConstraint sf1 = new SingleFieldConstraint("age");
        sf1.setOperator("==");
        sf1.setValue("42");
        p1.addConstraint((FieldConstraint)sf1);
        cp.addFactPattern((IFactPattern)p1);
        FactPattern p2 = new FactPattern("Person");
        SingleFieldConstraint sf2 = new SingleFieldConstraint("age");
        sf2.setOperator("==");
        sf2.setValue("43");
        p2.addConstraint((FieldConstraint)sf2);
        cp.addFactPattern((IFactPattern)p2);
        m.addLhsItem((IPattern)cp);
        String result = BRDRLPersistence.getInstance().marshal(m);
        return result;
    }

    @Test
    public void testCompositeConstraints() {
        RuleModel m = new RuleModel();
        m.name = "with composite";
        FactPattern p1 = new FactPattern("Person");
        p1.setBoundName("p1");
        m.addLhsItem((IPattern)p1);
        FactPattern p = new FactPattern("Goober");
        m.addLhsItem((IPattern)p);
        CompositeFieldConstraint comp = new CompositeFieldConstraint();
        comp.compositeJunctionType = "||";
        p.addConstraint((FieldConstraint)comp);
        SingleFieldConstraint X = new SingleFieldConstraint();
        X.setFieldName("goo");
        X.setConstraintValueType(1);
        X.setValue("foo");
        X.setOperator("==");
        X.connectives = new ConnectiveConstraint[1];
        X.connectives[0] = new ConnectiveConstraint();
        X.connectives[0].setConstraintValueType(1);
        X.connectives[0].operator = "|| ==";
        X.connectives[0].setValue("bar");
        comp.addConstraint((FieldConstraint)X);
        SingleFieldConstraint Y = new SingleFieldConstraint();
        Y.setFieldName("goo2");
        Y.setConstraintValueType(1);
        Y.setValue("foo");
        Y.setOperator("==");
        comp.addConstraint((FieldConstraint)Y);
        CompositeFieldConstraint comp2 = new CompositeFieldConstraint();
        comp2.compositeJunctionType = "&&";
        SingleFieldConstraint Q1 = new SingleFieldConstraint();
        Q1.setFieldName("goo");
        Q1.setOperator("==");
        Q1.setValue("whee");
        Q1.setConstraintValueType(1);
        comp2.addConstraint((FieldConstraint)Q1);
        SingleFieldConstraint Q2 = new SingleFieldConstraint();
        Q2.setFieldName("gabba");
        Q2.setOperator("==");
        Q2.setValue("whee");
        Q2.setConstraintValueType(1);
        comp2.addConstraint((FieldConstraint)Q2);
        comp.addConstraint((FieldConstraint)comp2);
        SingleFieldConstraint Z = new SingleFieldConstraint();
        Z.setFieldName("goo3");
        Z.setConstraintValueType(1);
        Z.setValue("foo");
        Z.setOperator("==");
        p.addConstraint((FieldConstraint)Z);
        ActionInsertFact ass = new ActionInsertFact("Whee");
        m.addRhsItem((IAction)ass);
        String actual = BRDRLPersistence.getInstance().marshal(m);
        String expected = "rule \"with composite\"  \tdialect \"mvel\"\n when p1 : Person( ) Goober( goo == \"foo\"  || == \"bar\" || goo2 == \"foo\" || ( goo == \"whee\" && gabba == \"whee\" ), goo3 == \"foo\" ) then insert( new Whee() );end";
        this.assertEqualsIgnoreWhitespace(expected, actual);
    }

    @Test
    public void testFieldsDeclaredButNoConstraints() {
        RuleModel m = new RuleModel();
        m.name = "boo";
        FactPattern p = new FactPattern("Person");
        p.addConstraint((FieldConstraint)new SingleFieldConstraint("field1"));
        m.addLhsItem((IPattern)p);
        String actual = BRDRLPersistence.getInstance().marshal(m);
        String expected = "rule \"boo\" \tdialect \"mvel\"\n when Person() then end";
        this.assertEqualsIgnoreWhitespace(expected, actual);
        SingleFieldConstraint con = (SingleFieldConstraint)p.constraintList.constraints[0];
        con.setFieldBinding("q");
        actual = BRDRLPersistence.getInstance().marshal(m);
        expected = "rule \"boo\" dialect \"mvel\" when Person(q : field1) then end";
        this.assertEqualsIgnoreWhitespace(expected, actual);
    }

    @Test
    public void testLiteralStrings() {
        RuleModel m = new RuleModel();
        m.name = "test literal strings";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldName("field1");
        con.setOperator("==");
        con.setValue("goo");
        con.setConstraintValueType(1);
        p.addConstraint((FieldConstraint)con);
        SingleFieldConstraint con2 = new SingleFieldConstraint();
        con2.setFieldName("field2");
        con2.setOperator("==");
        con2.setValue("variableHere");
        con2.setConstraintValueType(2);
        p.addConstraint((FieldConstraint)con2);
        m.addLhsItem((IPattern)p);
        String result = BRDRLPersistence.getInstance().marshal(m);
        this.assertEqualsIgnoreWhitespace("rule \"test literal strings\"\tdialect \"mvel\"\n when      Person(field1 == \"goo\", field2 == variableHere) then end", result);
    }

    @Test
    public void testSubConstraints() {
        RuleModel m = new RuleModel();
        m.name = "test sub constraints";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldName("field1");
        p.addConstraint((FieldConstraint)con);
        SingleFieldConstraint con2 = new SingleFieldConstraint();
        con2.setFieldName("field2");
        con2.setOperator("==");
        con2.setValue("variableHere");
        con2.setConstraintValueType(2);
        con2.setParent((FieldConstraint)con);
        p.addConstraint((FieldConstraint)con2);
        m.addLhsItem((IPattern)p);
        String result = BRDRLPersistence.getInstance().marshal(m);
        this.assertEqualsIgnoreWhitespace("rule \"test sub constraints\"\tdialect \"mvel\"\n when      Person(field1.field2 == variableHere) then end", result);
    }

    private void assertEqualsIgnoreWhitespace(String expected, String actual) {
        String cleanExpected = expected.replaceAll("\\s+", "");
        String cleanActual = actual.replaceAll("\\s+", "");
        Assert.assertEquals((Object)cleanExpected, (Object)cleanActual);
    }

    @Test
    public void testReturnValueConstraint() {
        RuleModel m = new RuleModel();
        m.name = "yeah";
        FactPattern p = new FactPattern("Goober");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setConstraintValueType(3);
        con.setValue("someFunc(x)");
        con.setOperator("==");
        con.setFieldName("goo");
        p.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)p);
        String actual = BRDRLPersistence.getInstance().marshal(m);
        String expected = "rule \"yeah\" \tdialect \"mvel\"\n when Goober( goo == ( someFunc(x) ) ) then end";
        this.assertEqualsIgnoreWhitespace(expected, actual);
    }

    @Test
    public void testPredicateConstraint() {
        RuleModel m = new RuleModel();
        m.name = "yeah";
        FactPattern p = new FactPattern("Goober");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setConstraintValueType(5);
        con.setValue("field soundslike 'poo'");
        p.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)p);
        String actual = BRDRLPersistence.getInstance().marshal(m);
        String expected = "rule \"yeah\" \tdialect \"mvel\"\n when Goober( eval( field soundslike 'poo' ) ) then end";
        this.assertEqualsIgnoreWhitespace(expected, actual);
    }

    @Test
    public void testConnective() {
        RuleModel m = new RuleModel();
        m.name = "test literal strings";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldName("field1");
        con.setOperator("==");
        con.setValue("goo");
        con.setConstraintValueType(2);
        p.addConstraint((FieldConstraint)con);
        ConnectiveConstraint connective = new ConnectiveConstraint();
        connective.setConstraintValueType(1);
        connective.operator = "|| ==";
        connective.setValue("blah");
        con.connectives = new ConnectiveConstraint[1];
        con.connectives[0] = connective;
        m.addLhsItem((IPattern)p);
        String result = BRDRLPersistence.getInstance().marshal(m);
        String expected = "rule \"test literal strings\" \tdialect \"mvel\"\n when Person( field1 == goo  || == \"blah\" ) then end";
        this.assertEqualsIgnoreWhitespace(expected, result);
    }

    @Test
    public void testInvalidComposite() throws Exception {
        RuleModel m = new RuleModel();
        CompositeFactPattern com = new CompositeFactPattern("not");
        m.addLhsItem((IPattern)com);
        String s = BRDRLPersistence.getInstance().marshal(m);
        Assert.assertNotNull((Object)s);
        m.addLhsItem((IPattern)new CompositeFactPattern("or"));
        m.addLhsItem((IPattern)new CompositeFactPattern("exists"));
        s = BRDRLPersistence.getInstance().marshal(m);
        Assert.assertNotNull((Object)s);
    }

    @Test
    public void testAssertWithDSL() throws Exception {
        RuleModel m = new RuleModel();
        DSLSentence sen = new DSLSentence();
        sen.sentence = "I CAN HAS DSL";
        m.addRhsItem((IAction)sen);
        ActionInsertFact ins = new ActionInsertFact("Shizzle");
        ActionFieldValue val = new ActionFieldValue("goo", "42", "Numeric");
        ins.fieldValues = new ActionFieldValue[1];
        ins.fieldValues[0] = val;
        m.addRhsItem((IAction)ins);
        ActionInsertLogicalFact insL = new ActionInsertLogicalFact("Shizzle");
        ActionFieldValue valL = new ActionFieldValue("goo", "42", "Numeric");
        insL.fieldValues = new ActionFieldValue[1];
        insL.fieldValues[0] = valL;
        m.addRhsItem((IAction)insL);
        String result = BRDRLPersistence.getInstance().marshal(m);
        Assert.assertTrue((result.indexOf(">insert") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf(">insertLogical") > -1 ? 1 : 0) != 0);
    }

    @Test
    public void testDefaultMVEL() {
        RuleModel m = new RuleModel();
        String s = BRDRLPersistence.getInstance().marshal(m);
        Assert.assertTrue((s.indexOf("mvel") > -1 ? 1 : 0) != 0);
        m.addAttribute(new RuleAttribute("dialect", "goober"));
        s = BRDRLPersistence.getInstance().marshal(m);
        Assert.assertFalse((s.indexOf("mvel") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((s.indexOf("goober") > -1 ? 1 : 0) != 0);
    }

    @Test
    public void testLockOnActive() {
        RuleModel m = new RuleModel();
        m.addAttribute(new RuleAttribute("lock-on-active", "true"));
        m.addAttribute(new RuleAttribute("auto-focus", "true"));
        m.addAttribute(new RuleAttribute("duration", "42"));
        String s = BRDRLPersistence.getInstance().marshal(m);
        Assert.assertTrue((s.indexOf("lock-on-active true") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((s.indexOf("auto-focus true") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((s.indexOf("duration 42") > -1 ? 1 : 0) != 0);
    }

    @Test
    public void testAddGlobal() {
        String expected = "rule \"my rule\"\n\tno-loop true\n\tdialect \"mvel\"\n\twhen\n\t\tPerson( )\n\t\tAccident( )\n\tthen\n\t\tinsert( new Report() );\n\t\tresults.add(f);\nend\n";
        RuleModel m = new RuleModel();
        m.addLhsItem((IPattern)new FactPattern("Person"));
        m.addLhsItem((IPattern)new FactPattern("Accident"));
        m.addAttribute(new RuleAttribute("no-loop", "true"));
        m.addRhsItem((IAction)new ActionInsertFact("Report"));
        ActionGlobalCollectionAdd add = new ActionGlobalCollectionAdd();
        add.globalName = "results";
        add.factName = "f";
        m.addRhsItem((IAction)add);
        m.name = "my rule";
        String drl = this.brlPersistence.marshal(m);
        Assert.assertEquals((Object)expected, (Object)drl);
    }
}

