/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.client.modeldriven;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.ide.common.client.modeldriven.DropDownData;
import org.drools.ide.common.client.modeldriven.FactTypeFilter;
import org.drools.ide.common.client.modeldriven.FieldAccessorsAndMutators;
import org.drools.ide.common.client.modeldriven.FieldNature;
import org.drools.ide.common.client.modeldriven.MethodInfo;
import org.drools.ide.common.client.modeldriven.ModelField;
import org.drools.ide.common.client.modeldriven.brl.DSLSentence;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;
import org.drools.ide.common.client.modeldriven.brl.FieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.PortableObject;
import org.drools.ide.common.client.modeldriven.brl.SingleFieldConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuggestionCompletionEngine
implements PortableObject {
    public static final String TYPE_COLLECTION = "Collection";
    public static final String TYPE_COMPARABLE = "Comparable";
    public static final String TYPE_STRING = "String";
    public static final String TYPE_NUMERIC = "Numeric";
    public static final String TYPE_BOOLEAN = "Boolean";
    public static final String TYPE_DATE = "Date";
    public static final String TYPE_OBJECT = "Object";
    public static final String TYPE_FINAL_OBJECT = "FinalObject";
    private static final String[] STANDARD_CONNECTIVES = new String[]{"|| ==", "|| !=", "&& !="};
    private static final String[] STRING_CONNECTIVES = new String[]{"|| ==", "|| !=", "&& !=", "&& matches", "|| matches"};
    private static final String[] COMPARABLE_CONNECTIVES = new String[]{"|| ==", "|| !=", "&& !=", "&& >", "&& <", "|| >", "|| <", "&& >=", "&& <=", "|| <=", "|| >="};
    private static final String[] COLLECTION_CONNECTIVES = new String[]{"|| ==", "|| !=", "&& !=", "|| contains", "&& contains", "|| excludes", "&& excludes"};
    private static final String[] STANDARD_OPERATORS = new String[]{"==", "!=", "== null", "!= null"};
    private static final String[] COMPARABLE_OPERATORS = new String[]{"==", "!=", "<", ">", "<=", ">=", "== null", "!= null"};
    private static final String[] STRING_OPERATORS = new String[]{"==", "!=", "matches", "soundslike", "== null", "!= null"};
    private static final String[] COLLECTION_OPERATORS = new String[]{"contains", "excludes", "==", "!=", "== null", "!= null"};
    private static final String[] CONDITIONAL_ELEMENTS = new String[]{"not", "exists", "or"};
    private Map<String, String> fieldParametersType = new HashMap<String, String>();
    private Map<String, String> globalTypes = new HashMap<String, String>();
    private Map<String, String[]> modifiers;
    private Map<String, String[]> dataEnumLists = new HashMap<String, String[]>();
    private String[] globalCollections;
    public DSLSentence[] conditionDSLSentences = new DSLSentence[0];
    public DSLSentence[] actionDSLSentences = new DSLSentence[0];
    public DSLSentence[] keywordDSLItems = new DSLSentence[0];
    public DSLSentence[] anyScopeDSLItems = new DSLSentence[0];
    private transient Map<String, Object> dataEnumLookupFields;
    private Map<String, List<MethodInfo>> methodInfos = new HashMap<String, List<MethodInfo>>();
    private Map<String, ModelField[]> modelFields = new HashMap<String, ModelField[]>();
    private Map<String, ModelField[]> filterModelFields = null;
    private Map<String, FieldAccessorsAndMutators> accessorsAndMutators = new HashMap<String, FieldAccessorsAndMutators>();
    private FactTypeFilter factFilter = null;
    private boolean filteringFacts = true;

    public String[] getConditionalElements() {
        return CONDITIONAL_ELEMENTS;
    }

    public DSLSentence[] getDSLConditions() {
        return this.conditionDSLSentences;
    }

    public DSLSentence[] getDSLActions() {
        return this.actionDSLSentences;
    }

    public String[] getConnectiveOperatorCompletions(String factType, String fieldName) {
        String type = this.getFieldType(factType + "." + fieldName);
        if (type == null) {
            return STANDARD_CONNECTIVES;
        }
        if (type.equals(TYPE_STRING)) {
            return STRING_CONNECTIVES;
        }
        if (type.equals(TYPE_COMPARABLE) || type.equals(TYPE_DATE) || type.equals(TYPE_NUMERIC)) {
            return COMPARABLE_CONNECTIVES;
        }
        if (type.equals(TYPE_COLLECTION)) {
            return COLLECTION_CONNECTIVES;
        }
        return STANDARD_CONNECTIVES;
    }

    public String[] getFieldCompletions(String factType) {
        return this.getModelFields(factType);
    }

    public String[] getFieldCompletions(FieldAccessorsAndMutators accessorOrMutator, String factType) {
        return this.getModelFields(accessorOrMutator, factType);
    }

    public String[] getOperatorCompletions(String factType, String fieldName) {
        return this.getOperatorCompletions(this.getFieldType(factType, fieldName));
    }

    public String[] getOperatorCompletions(String type) {
        if (type == null) {
            return STANDARD_OPERATORS;
        }
        if (type.equals(TYPE_STRING)) {
            return STRING_OPERATORS;
        }
        if (type.equals(TYPE_COMPARABLE) || type.equals(TYPE_DATE) || type.equals(TYPE_NUMERIC)) {
            return COMPARABLE_OPERATORS;
        }
        if (type.equals(TYPE_COLLECTION)) {
            return COLLECTION_OPERATORS;
        }
        return STANDARD_OPERATORS;
    }

    public String[] getFieldCompletionsForGlobalVariable(String varName) {
        String type = this.getGlobalVariable(varName);
        return this.getModelFields(type);
    }

    public List<MethodInfo> getMethodInfosForGlobalVariable(String varName) {
        String type = this.getGlobalVariable(varName);
        return this.methodInfos.get(type);
    }

    private String[] toStringArray(Set<?> set) {
        String[] f = new String[set.size()];
        int i = 0;
        Iterator<?> iter = set.iterator();
        while (iter.hasNext()) {
            f[i] = iter.next().toString();
            ++i;
        }
        return f;
    }

    public DropDownData getEnums(FactPattern pat, String field) {
        if (field == null) {
            return null;
        }
        Map<String, Object> dataEnumLookupFields = this.loadDataEnumLookupFields();
        if (pat.constraintList != null && pat.constraintList.constraints != null) {
            Object _typeFields = dataEnumLookupFields.get(pat.getFactType() + "." + field);
            if (_typeFields instanceof String) {
                DropDownData data;
                String typeFields = (String)_typeFields;
                FieldConstraint[] cons = pat.constraintList.constraints;
                String key = pat.getFactType() + "." + field;
                boolean addOpeninColumn = true;
                String[] splitTypeFields = typeFields.split(",");
                for (int j = 0; j < splitTypeFields.length; ++j) {
                    String typeField = splitTypeFields[j];
                    for (int i = 0; i < cons.length; ++i) {
                        SingleFieldConstraint sfc;
                        FieldConstraint con = cons[i];
                        if (!(con instanceof SingleFieldConstraint) || !(sfc = (SingleFieldConstraint)con).getFieldName().trim().equals(typeField.trim())) continue;
                        if (addOpeninColumn) {
                            key = key + "[";
                            addOpeninColumn = false;
                        }
                        key = key + typeField + "=" + sfc.getValue();
                        if (j == splitTypeFields.length - 1) continue;
                        key = key + ",";
                    }
                }
                if (!addOpeninColumn) {
                    key = key + "]";
                }
                if ((data = DropDownData.create(this.dataEnumLists.get(key))) != null) {
                    return DropDownData.create(this.dataEnumLists.get(key));
                }
            } else if (_typeFields != null) {
                String[] fieldsNeeded = (String[])_typeFields;
                String queryString = this.getQueryString(pat.getFactType(), field, fieldsNeeded, this.dataEnumLists);
                String[] valuePairs = new String[fieldsNeeded.length];
                for (int i = 0; i < fieldsNeeded.length; ++i) {
                    for (int j = 0; j < pat.constraintList.constraints.length; ++j) {
                        SingleFieldConstraint sfc;
                        FieldConstraint con = pat.constraintList.constraints[j];
                        if (!(con instanceof SingleFieldConstraint) || !(sfc = (SingleFieldConstraint)con).getFieldName().equals(fieldsNeeded[i])) continue;
                        valuePairs[i] = fieldsNeeded[i] + "=" + sfc.getValue();
                    }
                }
                if (valuePairs.length > 0 && valuePairs[0] != null) {
                    return DropDownData.create(queryString, valuePairs);
                }
            }
        }
        return DropDownData.create(this.getEnumValues(pat.getFactType(), field));
    }

    public DropDownData getEnums(String type, FieldNature[] currentValues, String field) {
        if (currentValues != null) {
            Map<String, Object> dataEnumLookupFields = this.loadDataEnumLookupFields();
            Object _typeField = dataEnumLookupFields.get(type + "." + field);
            if (_typeField instanceof String) {
                String typeField = (String)dataEnumLookupFields.get(type + "." + field);
                for (int i = 0; i < currentValues.length; ++i) {
                    FieldNature val = currentValues[i];
                    if (!val.getField().equals(typeField)) continue;
                    String key = type + "." + field + "[" + typeField + "=" + val.getValue() + "]";
                    return DropDownData.create(this.getDataEnumList(key));
                }
            } else if (_typeField != null) {
                String[] fieldsNeeded = (String[])_typeField;
                String queryString = this.getQueryString(type, field, fieldsNeeded, this.dataEnumLists);
                String[] valuePairs = new String[fieldsNeeded.length];
                for (int i = 0; i < fieldsNeeded.length; ++i) {
                    for (int j = 0; j < currentValues.length; ++j) {
                        FieldNature con = currentValues[j];
                        if (!con.getField().equals(fieldsNeeded[i])) continue;
                        valuePairs[i] = fieldsNeeded[i] + "=" + con.getValue();
                    }
                }
                return DropDownData.create(queryString, valuePairs);
            }
        }
        String[] vals = this.getDataEnumList(type + "." + field);
        return DropDownData.create(vals);
    }

    String getQueryString(String factType, String field, String[] fieldsNeeded, Map<String, String[]> dataEnumLists) {
        for (String key : dataEnumLists.keySet()) {
            if (key.startsWith(factType + "." + field) && fieldsNeeded != null && key.contains("[")) {
                String[] values = key.substring(key.indexOf(91) + 1, key.lastIndexOf(93)).split(",");
                if (values.length != fieldsNeeded.length) continue;
                boolean fail = false;
                for (int i = 0; i < values.length; ++i) {
                    String b;
                    String a = values[i].trim();
                    if (a.equals(b = fieldsNeeded[i].trim())) continue;
                    fail = true;
                    break;
                }
                if (fail) continue;
                String[] qry = this.getDataEnumList(key);
                return qry[0];
            }
            if (!key.startsWith(factType + "." + field) || fieldsNeeded != null && fieldsNeeded.length != 0) continue;
            String[] qry = this.getDataEnumList(key);
            return qry[0];
        }
        throw new IllegalStateException();
    }

    public String[] getEnumValues(String factType, String field) {
        return this.getDataEnumList(factType + "." + field);
    }

    Map<String, Object> loadDataEnumLookupFields() {
        if (this.dataEnumLookupFields == null) {
            this.dataEnumLookupFields = new HashMap<String, Object>();
            Set<String> keys = this.dataEnumLists.keySet();
            for (String key : keys) {
                if (key.indexOf(91) == -1) continue;
                int ix = key.indexOf(91);
                String factField = key.substring(0, ix);
                String predicate = key.substring(ix + 1, key.indexOf(93));
                if (predicate.indexOf(61) > -1) {
                    String[] bits = predicate.split(",");
                    String typeField = "";
                    for (int i = 0; i < bits.length; ++i) {
                        typeField = typeField + bits[i].substring(0, bits[i].indexOf(61));
                        if (i == bits.length - 1) continue;
                        typeField = typeField + ",";
                    }
                    this.dataEnumLookupFields.put(factField, typeField);
                    continue;
                }
                String[] fields = predicate.split(",");
                for (int i = 0; i < fields.length; ++i) {
                    fields[i] = fields[i].trim();
                }
                this.dataEnumLookupFields.put(factField, fields);
            }
        }
        return this.dataEnumLookupFields;
    }

    public void addMethodInfo(String factName, List<MethodInfo> methodInfos) {
        this.methodInfos.put(factName, methodInfos);
    }

    public List<String> getMethodParams(String factName, String methodNameWithParams) {
        if (this.methodInfos.get(factName) != null) {
            List<MethodInfo> infos = this.methodInfos.get(factName);
            for (MethodInfo info : infos) {
                if (!info.getNameWithParameters().startsWith(methodNameWithParams)) continue;
                return info.getParams();
            }
        }
        return null;
    }

    public List<String> getMethodNames(String factName) {
        List<MethodInfo> infos = this.methodInfos.get(factName);
        ArrayList<String> methodList = new ArrayList<String>();
        if (infos != null) {
            for (MethodInfo info : infos) {
                methodList.add(info.getName());
            }
        }
        return methodList;
    }

    public MethodInfo getMethodinfo(String factName, String methodFullName) {
        List<MethodInfo> infos = this.methodInfos.get(factName);
        if (infos != null) {
            for (MethodInfo info : infos) {
                if (!info.getNameWithParameters().equals(methodFullName)) continue;
                return info;
            }
        }
        return null;
    }

    public String getMethodClassType(String factName, String methodFullName) {
        List<MethodInfo> infos = this.methodInfos.get(factName);
        if (infos != null) {
            for (MethodInfo info : infos) {
                if (!info.getNameWithParameters().equals(methodFullName)) continue;
                return info.getReturnClassType();
            }
        }
        return null;
    }

    public List<String> getMethodFullNames(String factName) {
        return this.getMethodFullNames(factName, -1);
    }

    public List<String> getMethodFullNames(String factName, int paramCount) {
        List<MethodInfo> infos = this.methodInfos.get(factName);
        ArrayList<String> methodList = new ArrayList<String>();
        if (infos != null) {
            for (MethodInfo info : infos) {
                if (paramCount != -1 && info.getParams().size() > paramCount) continue;
                methodList.add(info.getNameWithParameters());
            }
        }
        return methodList;
    }

    public String getFactNameFromType(String type) {
        if (type == null) {
            return null;
        }
        if (this.getModelFields().containsKey(type)) {
            return type;
        }
        for (Map.Entry<String, ModelField[]> entry : this.getModelFields().entrySet()) {
            for (ModelField mf : entry.getValue()) {
                if (!"this".equals(mf.getName()) || !type.equals(mf.getClassName())) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    public String getParametricFieldType(String factType, String fieldName) {
        return this.getParametricFieldType(factType + "." + fieldName);
    }

    public String getParametricFieldType(String fieldName) {
        return this.fieldParametersType.get(fieldName);
    }

    public void putParametricFieldType(String fieldName, String type) {
        this.fieldParametersType.put(fieldName, type);
    }

    public String getGlobalVariable(String name) {
        return this.globalTypes.get(name);
    }

    public boolean isGlobalVariable(String name) {
        return this.globalTypes.containsKey(name);
    }

    public void setGlobalVariables(Map<String, String> globalTypes) {
        this.globalTypes = globalTypes;
    }

    public String[] getGlobalVariables() {
        return this.toStringArray(this.globalTypes.keySet());
    }

    public void setModifiers(Map<String, String[]> map) {
        this.modifiers = map;
    }

    public String[] getModifiers(String name) {
        return this.modifiers.get(name);
    }

    public void setGlobalCollections(String[] globalCollections) {
        this.globalCollections = globalCollections;
    }

    public String[] getGlobalCollections() {
        return this.globalCollections;
    }

    public String[] getDataEnumList(String type) {
        return this.dataEnumLists.get(type);
    }

    public void setDataEnumLists(Map<String, String[]> data) {
        this.dataEnumLists = data;
    }

    public void putDataEnumList(String name, String[] value) {
        this.dataEnumLists.put(name, value);
    }

    public void putAllDataEnumLists(Map<String, String[]> value) {
        this.dataEnumLists.putAll(value);
    }

    public int getDataEnumListsSize() {
        return this.dataEnumLists.size();
    }

    public boolean hasDataEnumLists() {
        return this.dataEnumLists != null && this.dataEnumLists.size() > 0;
    }

    public void setFactTypes(String[] factTypes) {
        for (String factType : factTypes) {
            this.getModelFields().put(factType, new ModelField[0]);
        }
    }

    public void setFactTypeFilter(FactTypeFilter filter) {
        this.factFilter = filter;
        this.filterModelFields();
    }

    public void setFieldsForTypes(Map<String, ModelField[]> fieldsForType) {
        this.getModelFields().clear();
        this.getModelFields().putAll(fieldsForType);
    }

    public String[] getFactTypes() {
        Object[] types = this.getModelFields().keySet().toArray(new String[this.getModelFields().size()]);
        Arrays.sort(types);
        return types;
    }

    public boolean containsFactType(String modelClassName) {
        if (modelClassName.contains(".")) {
            modelClassName = modelClassName.substring(modelClassName.lastIndexOf(".") + 1);
        }
        return this.getModelFields().containsKey(modelClassName);
    }

    private ModelField getField(String modelClassName, String fieldName) {
        String shortName = this.getFactNameFromType(modelClassName);
        ModelField[] fields = this.getModelFields().get(shortName);
        if (fields == null) {
            return null;
        }
        for (ModelField modelField : fields) {
            if (!modelField.getName().equals(fieldName)) continue;
            return modelField;
        }
        return null;
    }

    public String[] getModelFields(FieldAccessorsAndMutators accessorOrMutator, String modelClassName) {
        String shortName = this.getFactNameFromType(modelClassName);
        if (!this.getModelFields().containsKey(shortName)) {
            return new String[0];
        }
        ModelField[] fields = this.getModelFields().get(shortName);
        ArrayList<String> fieldNames = new ArrayList<String>();
        fieldNames.add("this");
        for (int i = 0; i < fields.length; ++i) {
            String fieldName = fields[i].getName();
            if (fields[i].getClassType() == ModelField.FIELD_CLASS_TYPE.TYPE_DECLARATION_CLASS) {
                fieldNames.add(fieldName);
                continue;
            }
            if (!FieldAccessorsAndMutators.compare(accessorOrMutator, this.accessorsAndMutators.get(shortName + "." + fieldName))) continue;
            fieldNames.add(fieldName);
        }
        return fieldNames.toArray(new String[fieldNames.size()]);
    }

    public String[] getModelFields(String modelClassName) {
        String shortName = this.getFactNameFromType(modelClassName);
        if (!this.getModelFields().containsKey(shortName)) {
            return new String[0];
        }
        ModelField[] fields = this.getModelFields().get(shortName);
        String[] fieldNames = new String[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            fieldNames[i] = fields[i].getName();
        }
        return fieldNames;
    }

    public String getFieldClassName(String propertyName) {
        String[] split = propertyName.split("\\.");
        if (split.length != 2) {
            throw new IllegalArgumentException("Invalid format '" + propertyName + "'. It must be of type className.propertyName");
        }
        return this.getFieldClassName(split[0], split[1]);
    }

    public String getFieldClassName(String modelClassName, String fieldName) {
        ModelField field = this.getField(modelClassName, fieldName);
        return field == null ? null : field.getClassName();
    }

    public ModelField.FIELD_CLASS_TYPE getFieldClassType(String modelClassName, String fieldName) {
        ModelField field = this.getField(modelClassName, fieldName);
        return field == null ? null : field.getClassType();
    }

    public String getFieldType(String propertyName) {
        String[] split = propertyName.split("\\.", 3);
        if (split.length != 2) {
            throw new IllegalArgumentException("Invalid format '" + propertyName + "'. It must be of type className.propertyName");
        }
        return this.getFieldType(split[0], split[1]);
    }

    public String getFieldType(String modelClassName, String fieldName) {
        ModelField field = this.getField(modelClassName, fieldName);
        return field == null ? null : field.getType();
    }

    public void setAccessorsAndMutators(Map<String, FieldAccessorsAndMutators> accessorsAndMutators) {
        this.accessorsAndMutators = accessorsAndMutators;
    }

    public void setModelFields(Map<String, ModelField[]> modelFields) {
        this.modelFields = modelFields;
        this.filterModelFields();
    }

    private void filterModelFields() {
        if (this.factFilter != null) {
            this.filterModelFields = new HashMap<String, ModelField[]>();
            for (Map.Entry<String, ModelField[]> entry : this.modelFields.entrySet()) {
                if (this.factFilter.filter(entry.getKey())) continue;
                this.filterModelFields.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public Map<String, ModelField[]> getModelFields() {
        if (this.factFilter != null && this.isFilteringFacts()) {
            return this.filterModelFields;
        }
        return this.modelFields;
    }

    public boolean isFilteringFacts() {
        return this.filteringFacts;
    }

    public void setFilteringFacts(boolean filterFacts) {
        this.filteringFacts = filterFacts;
    }
}

